/*
 * Decompiled with CFR 0.152.
 */
package quicktime.qd;

import quicktime.QTException;
import quicktime.QTObject;
import quicktime.QTSession;
import quicktime.jdirect.QTNative;
import quicktime.jdirect.QTStreamingLib;
import quicktime.jdirect.QuickTimeLib;
import quicktime.qd.ColorTable;
import quicktime.qd.GDevice;
import quicktime.qd.MacNativeGraphics;
import quicktime.qd.NativeGraphicsException;
import quicktime.qd.Pict;
import quicktime.qd.PixMap;
import quicktime.qd.Polygon;
import quicktime.qd.QDColor;
import quicktime.qd.QDDrawer;
import quicktime.qd.QDException;
import quicktime.qd.QDPoint;
import quicktime.qd.QDRect;
import quicktime.qd.Region;
import quicktime.qd.WinNativeGraphics;
import quicktime.std.StdQTException;
import quicktime.std.image.CSequence;
import quicktime.std.image.DSequence;
import quicktime.std.image.GraphicsExporter;
import quicktime.std.image.GraphicsImporter;
import quicktime.std.image.ImageDescription;
import quicktime.std.movies.Movie;
import quicktime.std.movies.MovieController;
import quicktime.std.qtcomponents.ImageCompressionDialog;
import quicktime.std.sg.SequenceGrabber;
import quicktime.streaming.Presentation;
import quicktime.streaming.Stream;
import quicktime.util.QTPointerRef;
import quicktime.util.QTUtils;

public final class QDGraphics
extends QTPointerRef
implements QuickTimeLib,
QTStreamingLib {
    private static Object linkage = QTNative.linkNativeMethods(class$quicktime$qd$QDGraphics == null ? (class$quicktime$qd$QDGraphics = QDGraphics.class$("quicktime.qd.QDGraphics")) : class$quicktime$qd$QDGraphics);
    public static final int kNativeSize = 108;
    public static QDGraphics scratch;
    public static QDGraphics validScratch;
    public static final int kDefaultPixelFormat;
    private static final int[] savedPort;
    private static final int[] savedDevice;
    private static final int kFontInfoSz = 4;
    static /* synthetic */ Class class$quicktime$qd$QDGraphics;

    public static QDGraphics fromGraphicsExporter(GraphicsExporter graphicsExporter) throws StdQTException {
        int[] nArray = new int[1];
        int n = QDGraphics.GraphicsExportGetInputGWorld(QTObject.ID(graphicsExporter), nArray);
        StdQTException.checkError(n);
        return nArray[0] == 0 ? scratch : new QDGraphics(nArray[0], graphicsExporter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static QDGraphics getPort() {
        int[] nArray = new int[]{0};
        Object object = QTNative.globalsLock;
        synchronized (object) {
            QDGraphics.GetPort(nArray);
        }
        return new QDGraphics(nArray[0], new Object());
    }

    public static int getPixelSize(int n) throws StdQTException {
        return QDGraphics.QTGetPixelSize(n);
    }

    public static QDGraphics fromGraphicsImporter(GraphicsImporter graphicsImporter) throws StdQTException {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int n = QDGraphics.GraphicsImportGetGWorld(QTObject.ID(graphicsImporter), nArray, nArray2);
        StdQTException.checkError(n);
        return nArray[0] == 0 ? scratch : new QDGraphics(nArray[0], graphicsImporter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static QDGraphics fromMovie(Movie movie) throws StdQTException {
        int[] nArray = new int[1];
        Object object = QTNative.globalsLock;
        synchronized (object) {
            QDGraphics.GetMovieGWorld(QTObject.ID(movie), nArray, null);
            StdQTException.checkError(QDGraphics.GetMoviesError());
            return nArray[0] == 0 ? scratch : new QDGraphics(nArray[0], movie);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static QDGraphics fromPresentation(Presentation presentation, Stream stream) throws StdQTException {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        Object object = QTNative.globalsLock;
        synchronized (object) {
            StdQTException.checkError(QDGraphics.QTSPresGetGWorld(QTObject.ID(presentation), QTObject.ID(stream), nArray, nArray2));
            return nArray[0] == 0 ? scratch : new QDGraphics(nArray[0], presentation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static QDGraphics fromMovieController(MovieController movieController) throws StdQTException {
        Object object = QTNative.globalsLock;
        synchronized (object) {
            int n = QDGraphics.MCGetControllerPort(QTObject.ID(movieController));
            StdQTException.checkError(QDGraphics.GetMoviesError());
            return n == 0 ? scratch : new QDGraphics(n, movieController);
        }
    }

    public static QDGraphics fromSequenceGrabber(SequenceGrabber sequenceGrabber) throws StdQTException {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int n = QDGraphics.SGGetGWorld(QTObject.ID(sequenceGrabber), nArray, nArray2);
        StdQTException.checkError(n);
        return nArray[0] == 0 ? scratch : new QDGraphics(nArray[0], sequenceGrabber);
    }

    public static QDGraphics fromCSequence(CSequence cSequence) throws StdQTException {
        int[] nArray = new int[1];
        StdQTException.checkError(QDGraphics.GetCSequencePrevBuffer(QTObject.ID(cSequence), nArray));
        return nArray[0] == 0 ? scratch : new QDGraphics(nArray[0], cSequence);
    }

    public static QDGraphics fromDSequenceImage(DSequence dSequence) throws StdQTException {
        int[] nArray = new int[1];
        StdQTException.checkError(QDGraphics.GetDSequenceImageBuffer(QTObject.ID(dSequence), nArray));
        return nArray[0] == 0 ? scratch : new QDGraphics(nArray[0], dSequence);
    }

    public static QDGraphics fromDSequenceScreen(DSequence dSequence) throws StdQTException {
        int[] nArray = new int[1];
        StdQTException.checkError(QDGraphics.GetDSequenceScreenBuffer(QTObject.ID(dSequence), nArray));
        return nArray[0] == 0 ? scratch : new QDGraphics(nArray[0], dSequence);
    }

    public static QDGraphics fromNativeGraphics(WinNativeGraphics winNativeGraphics) throws NativeGraphicsException {
        if (winNativeGraphics.hWnd == 0) {
            throw new NativeGraphicsException("invalid HWnd");
        }
        int n = QDGraphics.GetNativeWindowPort(winNativeGraphics.hWnd);
        if (n == 0) {
            throw new NativeGraphicsException("invalid Port");
        }
        return new QDGraphics(n, winNativeGraphics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static QDGraphics fromNativeGraphics(MacNativeGraphics macNativeGraphics) throws NativeGraphicsException {
        Object object = QTNative.globalsLock;
        synchronized (object) {
            QDGraphics qDGraphics;
            try {
                if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                    QDGraphics.GetGWorld(savedPort, savedDevice);
                }
                macNativeGraphics.dsi.lock();
                int n = macNativeGraphics.nd.getPort();
                if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                    QDGraphics.SetGWorld(savedPort[0], savedDevice[0]);
                }
                if (n == 0) {
                    throw new NativeGraphicsException("invalid Port");
                }
                qDGraphics = new QDGraphics(n, macNativeGraphics);
                {
                    Object var5_4 = null;
                }
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                macNativeGraphics.dsi.unlock();
                throw throwable;
            }
            {
                macNativeGraphics.dsi.unlock();
            }
            return qDGraphics;
        }
    }

    private QDGraphics(int n) throws QTException {
        super(n, 108, null);
        if (this.isOffscreen()) {
            QDGraphics.LockPixels(QDGraphics.GetGWorldPixMap(this._ID()));
        }
    }

    private QDGraphics(int n, Object object) {
        super(n, 108, object);
        if (this.isOffscreen()) {
            QDGraphics.LockPixels(QDGraphics.GetGWorldPixMap(this._ID()));
        }
    }

    public QDGraphics(ImageCompressionDialog imageCompressionDialog, QDRect qDRect, int n) throws QTException {
        this(QDGraphics.allocate(imageCompressionDialog, qDRect, n));
    }

    public QDGraphics(ImageDescription imageDescription, int n) throws QTException {
        this(QDGraphics.allocate(imageDescription, n));
    }

    public QDGraphics(QDRect qDRect) throws QTException {
        this(kDefaultPixelFormat, qDRect, null, null, 4096);
    }

    public QDGraphics(int n, QDRect qDRect) throws QTException {
        this(n, qDRect, null, null, 4096);
    }

    public QDGraphics(int n, QDRect qDRect, int n2) throws QTException {
        this(n, qDRect, null, null, n2);
    }

    public QDGraphics(int n, QDRect qDRect, ColorTable colorTable, GDevice gDevice, int n2) throws QTException {
        this(QDGraphics.allocate(n, qDRect, colorTable, gDevice, n2));
    }

    private static int allocate(int n, QDRect qDRect, ColorTable colorTable, GDevice gDevice, int n2) throws QDException {
        int[] nArray = new int[]{0};
        short s = QDGraphics.QTNewGWorld(nArray, n, qDRect.getRect(), QTObject.ID(colorTable), QTObject.ID(gDevice), n2);
        QDException.checkError(s);
        return nArray[0];
    }

    private static int allocate(ImageCompressionDialog imageCompressionDialog, QDRect qDRect, int n) throws QTException {
        int[] nArray = new int[1];
        StdQTException.checkError(QDGraphics.SCNewGWorld(QTObject.ID(imageCompressionDialog), nArray, qDRect != null ? qDRect.getRect() : null, n));
        if (nArray[0] == 0) {
            throw new StdQTException(-50);
        }
        return nArray[0];
    }

    private static int allocate(ImageDescription imageDescription, int n) throws QTException {
        int[] nArray = new int[1];
        StdQTException.checkError(QDGraphics.NewImageGWorld(nArray, QTObject.ID(imageDescription), n));
        return nArray[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginDraw(QDDrawer qDDrawer) throws QTException {
        Object object = QTNative.globalsLock;
        synchronized (object) {
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QDGraphics.GetGWorld(savedPort, savedDevice);
            }
            QDGraphics.SetGWorld(this._ID(), 0);
            qDDrawer.draw(this);
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QDGraphics.SetGWorld(savedPort[0], savedDevice[0]);
            }
        }
    }

    public boolean isOffscreen() {
        if (QTSession.isCurrentOS(4)) {
            byte by = QDGraphics.IsPortOffscreen(this._ID());
            return by == 1;
        }
        return (QDGraphics.getShortFromPointer(this._ID(), 6) & 0xC001) == 49153;
    }

    public PixMap getPixMap() {
        return PixMap.fromQDGraphics(this);
    }

    public QDRect getPortRect() {
        if (QTSession.isCurrentOS(4)) {
            QDRect qDRect = new QDRect();
            QDGraphics.GetPortBounds(this._ID(), qDRect.getBytes());
            return qDRect;
        }
        byte[] byArray = new byte[8];
        this.getBytesAt(16, 8, byArray, 0);
        return QDRect.fromArray(byArray, 8);
    }

    public Pict makeThumbnail(QDRect qDRect, int n) throws QTException {
        return Pict.thumbnailFromQDGraphics(this, qDRect, n);
    }

    public QDRect getBounds() {
        QDRect qDRect = new QDRect();
        if (QTSession.isCurrentOS(4)) {
            QDGraphics.GetPortBounds(this._ID(), qDRect.getBytes());
            return qDRect;
        }
        return this.getPortRect();
    }

    public Region getVisClipRgn() throws QTException {
        Region region = new Region();
        if (QTSession.isCurrentOS(4)) {
            Region region2 = new Region();
            Region region3 = new Region();
            QDGraphics.GetPortClipRegion(this._ID(), QTObject.ID(region2));
            QDGraphics.GetPortVisibleRegion(this._ID(), QTObject.ID(region3));
            QDGraphics.SectRgn(QTObject.ID(region2), QTObject.ID(region3), QTObject.ID(region));
        } else {
            int n = QDGraphics.getIntFromPointer(this._ID(), 28);
            int n2 = QDGraphics.getIntFromPointer(this._ID(), 24);
            QDGraphics.SectRgn(n, n2, QTObject.ID(region));
        }
        return region;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Region getClip() throws QTException {
        Region region = new Region();
        Object object = QTNative.globalsLock;
        synchronized (object) {
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QDGraphics.GetGWorld(savedPort, savedDevice);
            }
            QDGraphics.SetGWorld(this._ID(), 0);
            QDGraphics.GetClip(QTObject.ID(region));
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QDGraphics.SetGWorld(savedPort[0], savedDevice[0]);
            }
        }
        return region;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClip(Region region) {
        Object object = QTNative.globalsLock;
        synchronized (object) {
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QDGraphics.GetGWorld(savedPort, savedDevice);
            }
            QDGraphics.SetGWorld(this._ID(), 0);
            QDGraphics.SetClip(QTObject.ID(region));
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QDGraphics.SetGWorld(savedPort[0], savedDevice[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clipRect() {
        Object object = QTNative.globalsLock;
        synchronized (object) {
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QDGraphics.GetGWorld(savedPort, savedDevice);
            }
            QDGraphics.SetGWorld(this._ID(), 0);
            QDGraphics.ClipRect(this._ID() + 16);
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QDGraphics.SetGWorld(savedPort[0], savedDevice[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clipRect(QDRect qDRect) {
        Object object = QTNative.globalsLock;
        synchronized (object) {
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QDGraphics.GetGWorld(savedPort, savedDevice);
            }
            QDGraphics.SetGWorld(this._ID(), 0);
            QDGraphics.ClipRect(qDRect.getRect());
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QDGraphics.SetGWorld(savedPort[0], savedDevice[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QDColor getBackColor() {
        byte[] byArray = new byte[6];
        Object object = QTNative.globalsLock;
        synchronized (object) {
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QDGraphics.GetGWorld(savedPort, savedDevice);
            }
            QDGraphics.SetGWorld(this._ID(), 0);
            QDGraphics.GetBackColor(byArray);
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QDGraphics.SetGWorld(savedPort[0], savedDevice[0]);
            }
        }
        return QDColor.fromArray(byArray, 6);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBackColor(QDColor qDColor) {
        Object object = QTNative.globalsLock;
        synchronized (object) {
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QDGraphics.GetGWorld(savedPort, savedDevice);
            }
            QDGraphics.SetGWorld(this._ID(), 0);
            QDGraphics.RGBBackColor(qDColor.getRGBColor());
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QDGraphics.SetGWorld(savedPort[0], savedDevice[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void frameArc(QDRect qDRect, int n, int n2) throws QDException {
        if (qDRect == null) {
            qDRect = this.getPortRect();
        }
        Object object = QTNative.globalsLock;
        synchronized (object) {
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QDGraphics.GetGWorld(savedPort, savedDevice);
            }
            QDGraphics.SetGWorld(this._ID(), 0);
            QDGraphics.FrameArc(qDRect.getRect(), (short)n, (short)n2);
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QDGraphics.SetGWorld(savedPort[0], savedDevice[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintArc(QDRect qDRect, int n, int n2) throws QDException {
        if (qDRect == null) {
            qDRect = this.getPortRect();
        }
        Object object = QTNative.globalsLock;
        synchronized (object) {
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QDGraphics.GetGWorld(savedPort, savedDevice);
            }
            QDGraphics.SetGWorld(this._ID(), 0);
            QDGraphics.PaintArc(qDRect.getRect(), (short)n, (short)n2);
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QDGraphics.SetGWorld(savedPort[0], savedDevice[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eraseArc(QDRect qDRect, int n, int n2) throws QDException {
        if (qDRect == null) {
            qDRect = this.getPortRect();
        }
        Object object = QTNative.globalsLock;
        synchronized (object) {
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QDGraphics.GetGWorld(savedPort, savedDevice);
            }
            QDGraphics.SetGWorld(this._ID(), 0);
            QDGraphics.EraseArc(qDRect.getRect(), (short)n, (short)n2);
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QDGraphics.SetGWorld(savedPort[0], savedDevice[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invertArc(QDRect qDRect, int n, int n2) throws QDException {
        if (qDRect == null) {
            qDRect = this.getPortRect();
        }
        Object object = QTNative.globalsLock;
        synchronized (object) {
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QDGraphics.GetGWorld(savedPort, savedDevice);
            }
            QDGraphics.SetGWorld(this._ID(), 0);
            QDGraphics.InvertArc(qDRect.getRect(), (short)n, (short)n2);
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QDGraphics.SetGWorld(savedPort[0], savedDevice[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void frameRoundRect(QDRect qDRect, int n, int n2) throws QDException {
        if (qDRect == null) {
            qDRect = this.getPortRect();
        }
        Object object = QTNative.globalsLock;
        synchronized (object) {
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QDGraphics.GetGWorld(savedPort, savedDevice);
            }
            QDGraphics.SetGWorld(this._ID(), 0);
            QDGraphics.FrameRoundRect(qDRect.getRect(), (short)n, (short)n2);
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QDGraphics.SetGWorld(savedPort[0], savedDevice[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintRoundRect(QDRect qDRect, int n, int n2) throws QDException {
        if (qDRect == null) {
            qDRect = this.getPortRect();
        }
        Object object = QTNative.globalsLock;
        synchronized (object) {
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QDGraphics.GetGWorld(savedPort, savedDevice);
            }
            QDGraphics.SetGWorld(this._ID(), 0);
            QDGraphics.PaintRoundRect(qDRect.getRect(), (short)n, (short)n2);
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QDGraphics.SetGWorld(savedPort[0], savedDevice[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eraseRoundRect(QDRect qDRect, int n, int n2) throws QDException {
        if (qDRect == null) {
            qDRect = this.getPortRect();
        }
        Object object = QTNative.globalsLock;
        synchronized (object) {
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QDGraphics.GetGWorld(savedPort, savedDevice);
            }
            QDGraphics.SetGWorld(this._ID(), 0);
            QDGraphics.EraseRoundRect(qDRect.getRect(), (short)n, (short)n2);
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QDGraphics.SetGWorld(savedPort[0], savedDevice[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invertRoundRect(QDRect qDRect, int n, int n2) throws QDException {
        if (qDRect == null) {
            qDRect = this.getPortRect();
        }
        Object object = QTNative.globalsLock;
        synchronized (object) {
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QDGraphics.GetGWorld(savedPort, savedDevice);
            }
            QDGraphics.SetGWorld(this._ID(), 0);
            QDGraphics.InvertRoundRect(qDRect.getRect(), (short)n, (short)n2);
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QDGraphics.SetGWorld(savedPort[0], savedDevice[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void frameOval(QDRect qDRect) throws QDException {
        if (qDRect == null) {
            qDRect = this.getPortRect();
        }
        Object object = QTNative.globalsLock;
        synchronized (object) {
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QDGraphics.GetGWorld(savedPort, savedDevice);
            }
            QDGraphics.SetGWorld(this._ID(), 0);
            QDGraphics.FrameOval(qDRect.getRect());
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QDGraphics.SetGWorld(savedPort[0], savedDevice[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintOval(QDRect qDRect) throws QDException {
        if (qDRect == null) {
            qDRect = this.getPortRect();
        }
        Object object = QTNative.globalsLock;
        synchronized (object) {
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QDGraphics.GetGWorld(savedPort, savedDevice);
            }
            QDGraphics.SetGWorld(this._ID(), 0);
            QDGraphics.PaintOval(qDRect.getRect());
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QDGraphics.SetGWorld(savedPort[0], savedDevice[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eraseOval(QDRect qDRect) throws QDException {
        if (qDRect == null) {
            qDRect = this.getPortRect();
        }
        Object object = QTNative.globalsLock;
        synchronized (object) {
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QDGraphics.GetGWorld(savedPort, savedDevice);
            }
            QDGraphics.SetGWorld(this._ID(), 0);
            QDGraphics.EraseOval(qDRect.getRect());
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QDGraphics.SetGWorld(savedPort[0], savedDevice[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invertOval(QDRect qDRect) throws QDException {
        if (qDRect == null) {
            qDRect = this.getPortRect();
        }
        Object object = QTNative.globalsLock;
        synchronized (object) {
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QDGraphics.GetGWorld(savedPort, savedDevice);
            }
            QDGraphics.SetGWorld(this._ID(), 0);
            QDGraphics.InvertOval(qDRect.getRect());
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QDGraphics.SetGWorld(savedPort[0], savedDevice[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void framePoly(Polygon polygon) throws QDException {
        Object object = QTNative.globalsLock;
        synchronized (object) {
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QDGraphics.GetGWorld(savedPort, savedDevice);
            }
            QDGraphics.SetGWorld(this._ID(), 0);
            QDGraphics.FramePoly(QTObject.ID(polygon));
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QDGraphics.SetGWorld(savedPort[0], savedDevice[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintPoly(Polygon polygon) throws QDException {
        Object object = QTNative.globalsLock;
        synchronized (object) {
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QDGraphics.GetGWorld(savedPort, savedDevice);
            }
            QDGraphics.SetGWorld(this._ID(), 0);
            QDGraphics.PaintPoly(QTObject.ID(polygon));
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QDGraphics.SetGWorld(savedPort[0], savedDevice[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void erasePoly(Polygon polygon) throws QDException {
        Object object = QTNative.globalsLock;
        synchronized (object) {
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QDGraphics.GetGWorld(savedPort, savedDevice);
            }
            QDGraphics.SetGWorld(this._ID(), 0);
            QDGraphics.ErasePoly(QTObject.ID(polygon));
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QDGraphics.SetGWorld(savedPort[0], savedDevice[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invertPoly(Polygon polygon) throws QDException {
        Object object = QTNative.globalsLock;
        synchronized (object) {
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QDGraphics.GetGWorld(savedPort, savedDevice);
            }
            QDGraphics.SetGWorld(this._ID(), 0);
            QDGraphics.InvertPoly(QTObject.ID(polygon));
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QDGraphics.SetGWorld(savedPort[0], savedDevice[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void frameRect(QDRect qDRect) throws QDException {
        if (qDRect == null) {
            qDRect = this.getPortRect();
        }
        Object object = QTNative.globalsLock;
        synchronized (object) {
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QDGraphics.GetGWorld(savedPort, savedDevice);
            }
            QDGraphics.SetGWorld(this._ID(), 0);
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QDGraphics.FrameRect(qDRect.getRect());
            } else {
                QDGraphics.MacFrameRect(qDRect.getRect());
            }
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QDGraphics.SetGWorld(savedPort[0], savedDevice[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eraseRect(QDRect qDRect) throws QDException {
        if (qDRect == null) {
            qDRect = this.getPortRect();
        }
        Object object = QTNative.globalsLock;
        synchronized (object) {
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QDGraphics.GetGWorld(savedPort, savedDevice);
            }
            QDGraphics.SetGWorld(this._ID(), 0);
            QDGraphics.EraseRect(qDRect.getRect());
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QDGraphics.SetGWorld(savedPort[0], savedDevice[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eraseRgn(Region region) throws QDException {
        Object object = QTNative.globalsLock;
        synchronized (object) {
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QDGraphics.GetGWorld(savedPort, savedDevice);
            }
            QDGraphics.SetGWorld(this._ID(), 0);
            QDGraphics.EraseRgn(QTObject.ID(region));
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QDGraphics.SetGWorld(savedPort[0], savedDevice[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QDColor getCPixel(int n, int n2) throws QDException {
        byte[] byArray = new byte[6];
        Object object = QTNative.globalsLock;
        synchronized (object) {
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QDGraphics.GetGWorld(savedPort, savedDevice);
            }
            QDGraphics.SetGWorld(this._ID(), 0);
            QDGraphics.GetCPixel((short)n, (short)n2, byArray);
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QDGraphics.SetGWorld(savedPort[0], savedDevice[0]);
            }
        }
        return QDColor.fromArray(byArray, 6);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCPixel(int n, int n2, QDColor qDColor) throws QDException {
        Object object = QTNative.globalsLock;
        synchronized (object) {
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QDGraphics.GetGWorld(savedPort, savedDevice);
            }
            QDGraphics.SetGWorld(this._ID(), 0);
            QDGraphics.SetCPixel((short)n, (short)n2, qDColor.getRGBColor());
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QDGraphics.SetGWorld(savedPort[0], savedDevice[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void penSize(int n, int n2) throws QDException {
        Object object = QTNative.globalsLock;
        synchronized (object) {
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QDGraphics.GetGWorld(savedPort, savedDevice);
            }
            QDGraphics.SetGWorld(this._ID(), 0);
            QDGraphics.PenSize((short)n, (short)n2);
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QDGraphics.SetGWorld(savedPort[0], savedDevice[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void penNormal() throws QDException {
        Object object = QTNative.globalsLock;
        synchronized (object) {
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QDGraphics.GetGWorld(savedPort, savedDevice);
            }
            QDGraphics.SetGWorld(this._ID(), 0);
            QDGraphics.PenNormal();
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QDGraphics.SetGWorld(savedPort[0], savedDevice[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QDColor getForeColor() {
        byte[] byArray = new byte[6];
        Object object = QTNative.globalsLock;
        synchronized (object) {
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QDGraphics.GetGWorld(savedPort, savedDevice);
            }
            QDGraphics.SetGWorld(this._ID(), 0);
            QDGraphics.GetForeColor(byArray);
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QDGraphics.SetGWorld(savedPort[0], savedDevice[0]);
            }
        }
        return QDColor.fromArray(byArray, 6);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setForeColor(QDColor qDColor) {
        Object object = QTNative.globalsLock;
        synchronized (object) {
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QDGraphics.GetGWorld(savedPort, savedDevice);
            }
            QDGraphics.SetGWorld(this._ID(), 0);
            QDGraphics.RGBForeColor(qDColor.getRGBColor());
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QDGraphics.SetGWorld(savedPort[0], savedDevice[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintRect(QDRect qDRect) throws QDException {
        if (qDRect == null) {
            qDRect = this.getPortRect();
        }
        Object object = QTNative.globalsLock;
        synchronized (object) {
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QDGraphics.GetGWorld(savedPort, savedDevice);
            }
            QDGraphics.SetGWorld(this._ID(), 0);
            QDGraphics.PaintRect(qDRect.getRect());
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QDGraphics.SetGWorld(savedPort[0], savedDevice[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lineTo(int n, int n2) throws QDException {
        Object object = QTNative.globalsLock;
        synchronized (object) {
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QDGraphics.GetGWorld(savedPort, savedDevice);
            }
            QDGraphics.SetGWorld(this._ID(), 0);
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QDGraphics.LineTo((short)n, (short)n2);
            } else {
                QDGraphics.MacLineTo((short)n, (short)n2);
            }
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QDGraphics.SetGWorld(savedPort[0], savedDevice[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void line(int n, int n2) throws QDException {
        Object object = QTNative.globalsLock;
        synchronized (object) {
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QDGraphics.GetGWorld(savedPort, savedDevice);
            }
            QDGraphics.SetGWorld(this._ID(), 0);
            QDGraphics.Line((short)n, (short)n2);
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QDGraphics.SetGWorld(savedPort[0], savedDevice[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveTo(int n, int n2) throws QDException {
        Object object = QTNative.globalsLock;
        synchronized (object) {
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QDGraphics.GetGWorld(savedPort, savedDevice);
            }
            QDGraphics.SetGWorld(this._ID(), 0);
            QDGraphics.MoveTo((short)n, (short)n2);
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QDGraphics.SetGWorld(savedPort[0], savedDevice[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void move(int n, int n2) throws QDException {
        Object object = QTNative.globalsLock;
        synchronized (object) {
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QDGraphics.GetGWorld(savedPort, savedDevice);
            }
            QDGraphics.SetGWorld(this._ID(), 0);
            QDGraphics.Move((short)n, (short)n2);
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QDGraphics.SetGWorld(savedPort[0], savedDevice[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintRgn(Region region) throws QDException {
        Object object = QTNative.globalsLock;
        synchronized (object) {
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QDGraphics.GetGWorld(savedPort, savedDevice);
            }
            QDGraphics.SetGWorld(this._ID(), 0);
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QDGraphics.PaintRgn(QTObject.ID(region));
            } else {
                QDGraphics.MacPaintRgn(QTObject.ID(region));
            }
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QDGraphics.SetGWorld(savedPort[0], savedDevice[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void frameRgn(Region region) throws QDException {
        Object object = QTNative.globalsLock;
        synchronized (object) {
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QDGraphics.GetGWorld(savedPort, savedDevice);
            }
            QDGraphics.SetGWorld(this._ID(), 0);
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QDGraphics.FrameRgn(QTObject.ID(region));
            } else {
                QDGraphics.MacFrameRgn(QTObject.ID(region));
            }
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QDGraphics.SetGWorld(savedPort[0], savedDevice[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void textFont(int n) {
        boolean bl = QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4);
        Object object = QTNative.globalsLock;
        synchronized (object) {
            if (bl) {
                QDGraphics.GetGWorld(savedPort, savedDevice);
            }
            QDGraphics.SetGWorld(this._ID(), 0);
            QDGraphics.TextFont((short)n);
            if (bl) {
                QDGraphics.SetGWorld(savedPort[0], savedDevice[0]);
            }
        }
    }

    public int getTextFont() {
        return this.getShortAt(68);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void textFace(int n) {
        boolean bl = QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4);
        Object object = QTNative.globalsLock;
        synchronized (object) {
            if (bl) {
                QDGraphics.GetGWorld(savedPort, savedDevice);
            }
            QDGraphics.SetGWorld(this._ID(), 0);
            QDGraphics.TextFace((short)n);
            if (bl) {
                QDGraphics.SetGWorld(savedPort[0], savedDevice[0]);
            }
        }
    }

    public int getTextFace() {
        return QTUtils.UByte2Int(this.getByteAt(70));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void textMode(int n) {
        boolean bl = QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4);
        Object object = QTNative.globalsLock;
        synchronized (object) {
            if (bl) {
                QDGraphics.GetGWorld(savedPort, savedDevice);
            }
            QDGraphics.SetGWorld(this._ID(), 0);
            QDGraphics.TextMode((short)n);
            if (bl) {
                QDGraphics.SetGWorld(savedPort[0], savedDevice[0]);
            }
        }
    }

    public int getTextMode() {
        return this.getShortAt(72);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void textSize(int n) {
        boolean bl = QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4);
        Object object = QTNative.globalsLock;
        synchronized (object) {
            if (bl) {
                QDGraphics.GetGWorld(savedPort, savedDevice);
            }
            QDGraphics.SetGWorld(this._ID(), 0);
            QDGraphics.TextSize((short)n);
            if (bl) {
                QDGraphics.SetGWorld(savedPort[0], savedDevice[0]);
            }
        }
    }

    public int getTextSize() {
        return this.getShortAt(74);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawChar(int n) {
        boolean bl = QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4);
        Object object = QTNative.globalsLock;
        synchronized (object) {
            if (bl) {
                QDGraphics.GetGWorld(savedPort, savedDevice);
            }
            QDGraphics.SetGWorld(this._ID(), 0);
            QDGraphics.DrawChar((short)n);
            if (bl) {
                QDGraphics.SetGWorld(savedPort[0], savedDevice[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawText(String string, int n, int n2) {
        byte[] byArray = string.getBytes();
        boolean bl = QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4);
        Object object = QTNative.globalsLock;
        synchronized (object) {
            if (bl) {
                QDGraphics.GetGWorld(savedPort, savedDevice);
            }
            QDGraphics.SetGWorld(this._ID(), 0);
            if (bl) {
                QDGraphics.DrawText(byArray, (short)n, (short)n2);
                QDGraphics.SetGWorld(savedPort[0], savedDevice[0]);
            } else {
                QDGraphics.MacDrawText(byArray, (short)n, (short)n2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int charWidth(int n) {
        short s = 0;
        boolean bl = QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4);
        Object object = QTNative.globalsLock;
        synchronized (object) {
            if (bl) {
                QDGraphics.GetGWorld(savedPort, savedDevice);
            }
            QDGraphics.SetGWorld(this._ID(), 0);
            s = QDGraphics.CharWidth((short)n);
            if (bl) {
                QDGraphics.SetGWorld(savedPort[0], savedDevice[0]);
            }
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int textWidth(String string, int n, int n2) {
        short s = 0;
        byte[] byArray = string.getBytes();
        boolean bl = QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4);
        Object object = QTNative.globalsLock;
        synchronized (object) {
            if (bl) {
                QDGraphics.GetGWorld(savedPort, savedDevice);
            }
            QDGraphics.SetGWorld(this._ID(), 0);
            s = QDGraphics.TextWidth(byArray, (short)n, (short)n2);
            if (bl) {
                QDGraphics.SetGWorld(savedPort[0], savedDevice[0]);
            }
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawTextScaled(int n, String string, float f, float f2) {
        QDPoint qDPoint = new QDPoint((int)(f * 100.0f), (int)(f2 * 100.0f));
        QDPoint qDPoint2 = new QDPoint(100, 100);
        byte[] byArray = string.getBytes();
        boolean bl = QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4);
        Object object = QTNative.globalsLock;
        synchronized (object) {
            if (bl) {
                QDGraphics.GetGWorld(savedPort, savedDevice);
            }
            QDGraphics.SetGWorld(this._ID(), 0);
            QDGraphics.StdText((short)n, byArray, qDPoint.getPoint(), qDPoint2.getPoint());
            if (bl) {
                QDGraphics.SetGWorld(savedPort[0], savedDevice[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int measureScaledText(int n, String string, float f, float f2) {
        int[] nArray = new int[]{0};
        int[] nArray2 = new int[]{0};
        QDPoint qDPoint = new QDPoint((int)(f * 100.0f), (int)(f2 * 100.0f));
        nArray[0] = qDPoint.getPoint();
        QDPoint qDPoint2 = new QDPoint(100, 100);
        nArray2[0] = qDPoint2.getPoint();
        byte[] byArray = string.getBytes();
        short[] sArray = new short[4];
        short s = 0;
        boolean bl = QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4);
        Object object = QTNative.globalsLock;
        synchronized (object) {
            if (bl) {
                QDGraphics.GetGWorld(savedPort, savedDevice);
            }
            QDGraphics.SetGWorld(this._ID(), 0);
            QDGraphics.GetFontInfo(sArray);
            s = QDGraphics.StdTxMeas((short)n, byArray, nArray, nArray2, sArray);
            if (bl) {
                QDGraphics.SetGWorld(savedPort[0], savedDevice[0]);
            }
        }
        return s;
    }

    public String toString() {
        return super.toString() + "[PortRect=" + this.getPortRect() + ",isOffscreen=" + this.isOffscreen() + "]";
    }

    private static native int GraphicsExportGetInputGWorld(int var0, int[] var1);

    private static native short QTGetPixelSize(int var0);

    private static native int GraphicsImportGetGWorld(int var0, int[] var1, int[] var2);

    private static native void GetMovieGWorld(int var0, int[] var1, int[] var2);

    private static native short GetMoviesError();

    private static native int MCGetControllerPort(int var0);

    private static native int SGGetGWorld(int var0, int[] var1, int[] var2);

    private static native short GetCSequencePrevBuffer(int var0, int[] var1);

    private static native short GetDSequenceImageBuffer(int var0, int[] var1);

    private static native short GetDSequenceScreenBuffer(int var0, int[] var1);

    private static native int GetNativeWindowPort(int var0);

    private static native int GetGWorldPixMap(int var0);

    private static native byte LockPixels(int var0);

    private static native short QTNewGWorld(int[] var0, int var1, byte[] var2, int var3, int var4, int var5);

    private static native int SCNewGWorld(int var0, int[] var1, byte[] var2, int var3);

    private static native short NewImageGWorld(int[] var0, int var1, int var2);

    private static native void GetBackColor(byte[] var0);

    private static native void RGBBackColor(byte[] var0);

    private static native void EraseRect(byte[] var0);

    private static native void FrameRect(byte[] var0);

    private static native void MacFrameRect(byte[] var0);

    private static native void EraseRgn(int var0);

    private static native void GetForeColor(byte[] var0);

    private static native void RGBForeColor(byte[] var0);

    private static native void PaintRect(byte[] var0);

    private static native void MacPaintRgn(int var0);

    private static native void MacFrameRgn(int var0);

    private static native void GetPort(int[] var0);

    private static native void SetGWorld(int var0, int var1);

    private static native void PaintRgn(int var0);

    private static native void FrameRgn(int var0);

    private static native void CopyRgn(int var0, int var1);

    private static native void SetRectRgn(int var0, short var1, short var2, short var3, short var4);

    private static native void OffsetRgn(int var0, short var1, short var2);

    private static native void UnionRgn(int var0, int var1, int var2);

    private static native void XorRgn(int var0, int var1, int var2);

    private static native byte EqualRgn(int var0, int var1);

    private static native void SectRgn(int var0, int var1, int var2);

    private static native void GetClip(int var0);

    private static native void SetClip(int var0);

    private static native void ClipRect(byte[] var0);

    private static native void ClipRect(int var0);

    private static native void GetGWorld(int[] var0, int[] var1);

    private static native void Move(short var0, short var1);

    private static native void MoveTo(short var0, short var1);

    private static native void MacLineTo(short var0, short var1);

    private static native void LineTo(short var0, short var1);

    private static native void Line(short var0, short var1);

    private static native void SetCPixel(short var0, short var1, byte[] var2);

    private static native void GetCPixel(short var0, short var1, byte[] var2);

    private static native void PenSize(short var0, short var1);

    private static native void PenNormal();

    private static native void FrameArc(byte[] var0, short var1, short var2);

    private static native void PaintArc(byte[] var0, short var1, short var2);

    private static native void EraseArc(byte[] var0, short var1, short var2);

    private static native void InvertArc(byte[] var0, short var1, short var2);

    private static native void FrameRoundRect(byte[] var0, short var1, short var2);

    private static native void PaintRoundRect(byte[] var0, short var1, short var2);

    private static native void EraseRoundRect(byte[] var0, short var1, short var2);

    private static native void InvertRoundRect(byte[] var0, short var1, short var2);

    private static native void FrameOval(byte[] var0);

    private static native void PaintOval(byte[] var0);

    private static native void EraseOval(byte[] var0);

    private static native void InvertOval(byte[] var0);

    private static native void FramePoly(int var0);

    private static native void PaintPoly(int var0);

    private static native void ErasePoly(int var0);

    private static native void InvertPoly(int var0);

    private static native short getShortFromPointer(int var0, int var1);

    private static native void setIntInPointer(int var0, int var1, int var2);

    private static native int getIntFromPointer(int var0, int var1);

    private static native void TextFont(short var0);

    private static native void TextFace(short var0);

    private static native void TextMode(short var0);

    private static native void TextSize(short var0);

    private static native void DrawChar(short var0);

    private static native void MacDrawText(byte[] var0, short var1, short var2);

    private static native void DrawText(byte[] var0, short var1, short var2);

    private static native short CharWidth(short var0);

    private static native short TextWidth(byte[] var0, short var1, short var2);

    private static native void MeasureText(short var0, byte[] var1, int[] var2);

    private static native void StdText(short var0, byte[] var1, int var2, int var3);

    private static native short StdTxMeas(short var0, byte[] var1, int[] var2, int[] var3, short[] var4);

    private static native void GetFontInfo(short[] var0);

    private static native byte IsPortOffscreen(int var0);

    private static native int GetPortBounds(int var0, byte[] var1);

    private static native int GetPortClipRegion(int var0, int var1);

    private static native int GetPortVisibleRegion(int var0, int var1);

    private static native short QTSPresGetGWorld(int var0, int var1, int[] var2, int[] var3);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            scratch = new QDGraphics(kDefaultPixelFormat, new QDRect(1, 1), null, GDevice.getMain(), 2);
            validScratch = new QDGraphics(kDefaultPixelFormat, new QDRect(1, 1), null, GDevice.getMain(), 2);
        }
        catch (QTException qTException) {
            // empty catch block
        }
        kDefaultPixelFormat = QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4) ? 32 : 1111970369;
        savedPort = new int[]{0};
        savedDevice = new int[]{0};
    }
}

