/*
 * Decompiled with CFR 0.152.
 */
package quicktime.qd;

import java.awt.Point;
import quicktime.QTSession;
import quicktime.jdirect.PrimitivesLib;
import quicktime.jdirect.QTNative;
import quicktime.util.EndianDescriptor;
import quicktime.util.QTUtils;

public final class QDPoint
implements PrimitivesLib,
Cloneable {
    private static Object linkage = QTNative.linkNativeMethods(class$quicktime$qd$QDPoint == null ? (class$quicktime$qd$QDPoint = QDPoint.class$("quicktime.qd.QDPoint")) : class$quicktime$qd$QDPoint);
    private static final int kNativeSize = 8;
    private static boolean doEndianSwap = !QTSession.isCurrentOS(1) && !QTSession.isCurrentOS(4);
    public static final int kIsFixedPoint = 8;
    public static final int kIsGXPoint = 8;
    public static final int kIsQ3Point2D = -8;
    public static final int kIsQTVRFloatPoint = -16;
    private short x;
    private short y;
    byte[] floatPt = null;
    static /* synthetic */ Class class$quicktime$qd$QDPoint;

    public static final EndianDescriptor getEndianDescriptorFixedPoint() {
        return EndianDescriptor.flipAll32;
    }

    public static final EndianDescriptor getEndianDescriptorTQ3Point2D() {
        return EndianDescriptor.flipAll32;
    }

    public static final EndianDescriptor getEndianDescriptorQTVRFloatPoint() {
        return EndianDescriptor.flipAll32;
    }

    public static QDPoint fromArray(byte[] byArray, int n) {
        return QDPoint.fromArray(byArray, n, 0);
    }

    public static QDPoint fromArray(byte[] byArray, int n, int n2) {
        if (byArray.length - n2 < 8) {
            throw new IllegalArgumentException("Mismatch between flag and supplied ptBytes");
        }
        if (n == 8) {
            int n3 = QDPoint.getIntFromArray(byArray, n2);
            int n4 = QDPoint.getIntFromArray(byArray, n2 + 4);
            return new QDPoint(QTUtils.Fix2X(n3), QTUtils.Fix2X(n4));
        }
        if (n == -8 || n == -16) {
            float f = QDPoint.getFloatFromArray(byArray, n2);
            float f2 = QDPoint.getFloatFromArray(byArray, n2 + 4);
            return new QDPoint(f, f2);
        }
        throw new IllegalArgumentException("Unknown point bytes format");
    }

    public QDPoint(int n, int n2) {
        this.setX(n);
        this.setY(n2);
    }

    public QDPoint(float f, float f2) {
        this.setX(f);
        this.setY(f2);
    }

    public QDPoint(Point point) {
        this(point.x, point.y);
    }

    private QDPoint(short s, short s2, byte[] byArray) {
        this.x = s;
        this.y = s2;
        if (byArray != null) {
            this.floatPt = new byte[8];
            System.arraycopy(byArray, 0, this.floatPt, 0, 8);
        }
    }

    public int getPoint() {
        return doEndianSwap ? this.x << 16 | this.y & 0xFFFF : this.y << 16 | this.x & 0xFFFF;
    }

    public byte[] getGXPoint() {
        return this.getFixedPoint();
    }

    public byte[] getFixedPoint() {
        byte[] byArray = new byte[8];
        QDPoint.setIntInArray(byArray, 0, QTUtils.X2Fix(this.getXF()));
        QDPoint.setIntInArray(byArray, 4, QTUtils.X2Fix(this.getYF()));
        return byArray;
    }

    public byte[] getQ3Point2D() {
        if (this.floatPt == null) {
            this.floatPt = new byte[8];
            this.setX(this.getX());
            this.setY(this.getY());
        }
        return this.floatPt;
    }

    public byte[] getQTVRFloatPoint() {
        return this.getQ3Point2D();
    }

    public int getX() {
        return this.x;
    }

    public float getXF() {
        return this.floatPt != null ? QDPoint.getFloatFromArray(this.floatPt, 0) : (float)this.getX();
    }

    public void setX(int n) {
        if (this.floatPt == null) {
            this.x = (short)n;
        } else {
            this.setX((float)n);
        }
    }

    public void setX(float f) {
        if (this.floatPt == null) {
            this.floatPt = new byte[8];
        }
        QDPoint.setFloatInArray(this.floatPt, 0, f);
        this.x = (short)f;
    }

    public int getY() {
        return this.y;
    }

    public float getYF() {
        return this.floatPt != null ? QDPoint.getFloatFromArray(this.floatPt, 4) : (float)this.getY();
    }

    public void setY(int n) {
        if (this.floatPt == null) {
            this.y = (short)n;
        } else {
            this.setY((float)n);
        }
    }

    public void setY(float f) {
        if (this.floatPt == null) {
            this.floatPt = new byte[8];
        }
        QDPoint.setFloatInArray(this.floatPt, 4, f);
        this.y = (short)f;
    }

    public void translate(int n, int n2) {
        this.move(this.getX() + n, this.getY() + n2);
    }

    public void translate(float f, float f2) {
        this.move(this.getXF() + f, this.getYF() + f2);
    }

    public void move(int n, int n2) {
        this.setX(n);
        this.setY(n2);
    }

    public void move(float f, float f2) {
        this.setX(f);
        this.setY(f2);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof QDPoint) {
            QDPoint qDPoint = (QDPoint)object;
            return qDPoint.getXF() == this.getXF() && qDPoint.getYF() == this.getYF();
        }
        return false;
    }

    public String toString() {
        return this.getClass().getName() + "[x=" + this.getXF() + ",y=" + this.getYF() + "]";
    }

    public Object clone() {
        return this.copy();
    }

    public QDPoint copy() {
        return new QDPoint(this.x, this.y, this.floatPt);
    }

    private static native int getIntFromArray(byte[] var0, int var1);

    private static native float getFloatFromArray(byte[] var0, int var1);

    private static native void setIntInArray(byte[] var0, int var1, int var2);

    private static native void setFloatInArray(byte[] var0, int var1, float var2);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

