/*
 * Decompiled with CFR 0.152.
 */
package quicktime.qd3d.math;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import quicktime.QTRuntimeException;
import quicktime.QTSession;
import quicktime.jdirect.QTNative;
import quicktime.jdirect.QuickDraw3DLib;
import quicktime.jdirect.QuickTimeLib;
import quicktime.qd3d.math.Quaternion;
import quicktime.qd3d.math.Vector3D;
import quicktime.util.EndianDescriptor;
import quicktime.util.EndianOrder;
import quicktime.util.QTByteObject;
import quicktime.util.UtilException;

public final class Point3D
extends QTByteObject
implements QuickTimeLib,
QuickDraw3DLib,
Cloneable {
    private static Object linkage;
    public static final int kNativeSize = 12;
    static final long serialVersionUID = 8457546849143567880L;
    static /* synthetic */ Class class$quicktime$qd3d$math$Point3D;

    public static final EndianDescriptor getEndianDescriptor() {
        return EndianDescriptor.flipAll32;
    }

    public Point3D() {
        super(12);
    }

    public Point3D(float f, float f2, float f3) {
        this();
        this.setX(f);
        this.setY(f2);
        this.setZ(f3);
    }

    private Point3D(byte[] byArray) {
        super(byArray);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        this.bytes = new byte[12];
        objectInputStream.read(this.bytes);
        try {
            EndianOrder.flipBigEndianToNative(this, 0, Point3D.getEndianDescriptor());
        }
        catch (UtilException utilException) {
            utilException.printStackTrace();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Point3D point3D = (Point3D)this.clone();
        try {
            EndianOrder.flipNativeToBigEndian(point3D, 0, Point3D.getEndianDescriptor());
        }
        catch (UtilException utilException) {
            utilException.printStackTrace();
        }
        objectOutputStream.write(point3D.getBytes());
    }

    public float getX() {
        return this.getFloatAt(0);
    }

    public float getY() {
        return this.getFloatAt(4);
    }

    public float getZ() {
        return this.getFloatAt(8);
    }

    public void setX(float f) {
        this.setFloatAt(0, f);
    }

    public void setY(float f) {
        this.setFloatAt(4, f);
    }

    public void setZ(float f) {
        this.setFloatAt(8, f);
    }

    public Vector3D subtract(Point3D point3D) {
        Vector3D vector3D = new Vector3D();
        int n = Point3D.Q3Point3D_Subtract(this.getBytes(), point3D.getBytes(), vector3D.getBytes());
        return vector3D;
    }

    public float distance(Point3D point3D) {
        return Point3D.Q3Point3D_Distance(this.getBytes(), point3D.getBytes());
    }

    public float distanceSquared(Point3D point3D) {
        return Point3D.Q3Point3D_DistanceSquared(this.getBytes(), point3D.getBytes());
    }

    public Point3D rRatio(Point3D point3D, float f, float f2) {
        Point3D point3D2 = new Point3D();
        int n = Point3D.Q3Point3D_RRatio(this.getBytes(), point3D.getBytes(), f, f2, point3D2.getBytes());
        return point3D2;
    }

    public Point3D add(Vector3D vector3D) {
        Point3D point3D = new Point3D();
        int n = Point3D.Q3Point3D_Vector3D_Add(this.getBytes(), vector3D.getBytes(), point3D.getBytes());
        return point3D;
    }

    public Point3D subtract(Vector3D vector3D) {
        Point3D point3D = new Point3D();
        int n = Point3D.Q3Point3D_Vector3D_Subtract(this.getBytes(), vector3D.getBytes(), point3D.getBytes());
        return point3D;
    }

    public Vector3D cross(Point3D point3D, Point3D point3D2) {
        Vector3D vector3D = new Vector3D();
        int n = Point3D.Q3Point3D_CrossProductTri(this.getBytes(), point3D.getBytes(), point3D2.getBytes(), vector3D.getBytes());
        return vector3D;
    }

    public Point3D transformQuaternion(Quaternion quaternion) {
        Point3D point3D = new Point3D();
        int n = Point3D.Q3Point3D_TransformQuaternion(this.getBytes(), quaternion.getBytes(), point3D.getBytes());
        return point3D;
    }

    public Object clone() {
        return new Point3D(this.getBytes());
    }

    public String toString() {
        return super.toString() + "[x=" + this.getX() + ",y=" + this.getY() + ",z=" + this.getZ() + "]";
    }

    private static native int Q3Point3D_Subtract(byte[] var0, byte[] var1, byte[] var2);

    private static native float Q3Point3D_Distance(byte[] var0, byte[] var1);

    private static native float Q3Point3D_DistanceSquared(byte[] var0, byte[] var1);

    private static native int Q3Point3D_RRatio(byte[] var0, byte[] var1, float var2, float var3, byte[] var4);

    private static native int Q3Point3D_Vector3D_Add(byte[] var0, byte[] var1, byte[] var2);

    private static native int Q3Point3D_Vector3D_Subtract(byte[] var0, byte[] var1, byte[] var2);

    private static native int Q3Point3D_CrossProductTri(byte[] var0, byte[] var1, byte[] var2, byte[] var3);

    private static native int Q3Point3D_TransformQuaternion(byte[] var0, byte[] var1, byte[] var2);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        if (QTSession.isCurrentOS(4)) {
            throw new QTRuntimeException("Unsupported OS");
        }
        linkage = QTNative.linkNativeMethods(class$quicktime$qd3d$math$Point3D == null ? (class$quicktime$qd3d$math$Point3D = Point3D.class$("quicktime.qd3d.math.Point3D")) : class$quicktime$qd3d$math$Point3D);
    }
}

