/*
 * Decompiled with CFR 0.152.
 */
package quicktime.qd3d.math;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import quicktime.QTRuntimeException;
import quicktime.QTSession;
import quicktime.jdirect.QTNative;
import quicktime.jdirect.QuickDraw3DLib;
import quicktime.jdirect.QuickTimeLib;
import quicktime.qd3d.math.Quaternion;
import quicktime.qd3d.math.Vector2D;
import quicktime.util.EndianDescriptor;
import quicktime.util.EndianOrder;
import quicktime.util.QTByteObject;
import quicktime.util.UtilException;

public final class Vector3D
extends QTByteObject
implements QuickTimeLib,
QuickDraw3DLib,
Cloneable {
    private static Object linkage;
    public static final int kNativeSize = 12;
    static final long serialVersionUID = -8566142369958926912L;
    static /* synthetic */ Class class$quicktime$qd3d$math$Vector3D;

    public static final EndianDescriptor getEndianDescriptor() {
        return EndianDescriptor.flipAll32;
    }

    public Vector3D() {
        super(12);
    }

    public Vector3D(float f, float f2, float f3) {
        this();
        this.setX(f);
        this.setY(f2);
        this.setZ(f3);
    }

    private Vector3D(byte[] byArray) {
        super(byArray);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        this.bytes = new byte[12];
        objectInputStream.read(this.bytes);
        try {
            EndianOrder.flipBigEndianToNative(this, 0, Vector3D.getEndianDescriptor());
        }
        catch (UtilException utilException) {
            utilException.printStackTrace();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Vector3D vector3D = (Vector3D)this.clone();
        try {
            EndianOrder.flipNativeToBigEndian(vector3D, 0, Vector3D.getEndianDescriptor());
        }
        catch (UtilException utilException) {
            utilException.printStackTrace();
        }
        objectOutputStream.write(vector3D.getBytes());
    }

    public float getX() {
        return this.getFloatAt(0);
    }

    public float getY() {
        return this.getFloatAt(4);
    }

    public float getZ() {
        return this.getFloatAt(8);
    }

    public void setX(float f) {
        this.setFloatAt(0, f);
    }

    public void setY(float f) {
        this.setFloatAt(4, f);
    }

    public void setZ(float f) {
        this.setFloatAt(8, f);
    }

    public Vector3D scale(float f) {
        Vector3D vector3D = new Vector3D();
        int n = Vector3D.Q3Vector3D_Scale(this.getBytes(), f, vector3D.getBytes());
        return vector3D;
    }

    public float length() {
        return Vector3D.Q3Vector3D_Length(this.getBytes());
    }

    public Vector3D normalize() {
        Vector3D vector3D = new Vector3D();
        int n = Vector3D.Q3Vector3D_Normalize(this.getBytes(), vector3D.getBytes());
        return vector3D;
    }

    public Vector3D add(Vector3D vector3D) {
        Vector3D vector3D2 = new Vector3D();
        int n = Vector3D.Q3Vector3D_Add(this.getBytes(), vector3D.getBytes(), vector3D2.getBytes());
        return vector3D2;
    }

    public Vector3D subtract(Vector3D vector3D) {
        Vector3D vector3D2 = new Vector3D();
        int n = Vector3D.Q3Vector3D_Subtract(this.getBytes(), vector3D.getBytes(), vector3D2.getBytes());
        return vector3D2;
    }

    public Vector3D cross(Vector3D vector3D) {
        Vector3D vector3D2 = new Vector3D();
        int n = Vector3D.Q3Vector3D_Cross(this.getBytes(), vector3D.getBytes(), vector3D2.getBytes());
        return vector3D2;
    }

    public float dot(Vector2D vector2D) {
        return Vector3D.Q3Vector3D_Dot(this.getBytes(), vector2D.getBytes());
    }

    public Vector3D transformQuaternion(Quaternion quaternion) {
        Vector3D vector3D = new Vector3D();
        int n = Vector3D.Q3Vector3D_TransformQuaternion(this.getBytes(), quaternion.getBytes(), vector3D.getBytes());
        return vector3D;
    }

    public Object clone() {
        return new Vector3D(this.getBytes());
    }

    public String toString() {
        return super.toString() + "[x=" + this.getX() + ",y=" + this.getY() + ",z=" + this.getX() + "]";
    }

    private static native int Q3Vector3D_Scale(byte[] var0, float var1, byte[] var2);

    private static native float Q3Vector3D_Length(byte[] var0);

    private static native int Q3Vector3D_Normalize(byte[] var0, byte[] var1);

    private static native int Q3Vector3D_Add(byte[] var0, byte[] var1, byte[] var2);

    private static native int Q3Vector3D_Subtract(byte[] var0, byte[] var1, byte[] var2);

    private static native int Q3Vector3D_Cross(byte[] var0, byte[] var1, byte[] var2);

    private static native float Q3Vector3D_Dot(byte[] var0, byte[] var1);

    private static native int Q3Vector3D_TransformQuaternion(byte[] var0, byte[] var1, byte[] var2);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        if (QTSession.isCurrentOS(4)) {
            throw new QTRuntimeException("Unsupported OS");
        }
        linkage = QTNative.linkNativeMethods(class$quicktime$qd3d$math$Vector3D == null ? (class$quicktime$qd3d$math$Vector3D = Vector3D.class$("quicktime.qd3d.math.Vector3D")) : class$quicktime$qd3d$math$Vector3D);
    }
}

