/*
 * Decompiled with CFR 0.152.
 */
package quicktime.sound;

import quicktime.QTException;
import quicktime.QTObject;
import quicktime.QTRuntimeException;
import quicktime.jdirect.PrimitivesLib;
import quicktime.jdirect.QTNative;
import quicktime.jdirect.QuickTimeLib;
import quicktime.sound.SICompletion;
import quicktime.sound.SPBDevice;
import quicktime.sound.SoundException;
import quicktime.sound.SoundRunner;
import quicktime.util.QTByteObject;
import quicktime.util.QTPointer;
import quicktime.util.QTPointerRef;

public final class SPB
extends QTByteObject
implements QuickTimeLib,
PrimitivesLib {
    private static Object linkage = QTNative.linkNativeMethods(class$quicktime$sound$SPB == null ? (class$quicktime$sound$SPB = SPB.class$("quicktime.sound.SPB")) : class$quicktime$sound$SPB);
    public static final int kNativeSize = 38;
    private SPBDevice device;
    private QTPointerRef buffer;
    private SoundRunner runner;
    private QTPointer realObject;
    private short[] recordingStatus = new short[]{0};
    private short[] meterLevelValue = new short[]{0};
    private int[] totalSamplesToRecordVal = new int[]{0};
    private int[] numberOfSamplesRecordedVal = new int[]{0};
    private int[] totalMsecsToRecordVal = new int[]{0};
    private int[] numberOfMsecsRecordedVal = new int[]{0};
    static /* synthetic */ Class class$quicktime$sound$SPB;

    public SPB(SPBDevice sPBDevice, int n, int n2, QTPointerRef qTPointerRef) {
        super(38);
        try {
            this.realObject = new QTPointer(38, true);
        }
        catch (QTException qTException) {
            throw new QTRuntimeException(qTException);
        }
        this.setIntAt(0, QTObject.ID(sPBDevice));
        SPB.setIntInPointer(QTObject.ID(this.realObject), 0, QTObject.ID(sPBDevice));
        this.setIntAt(12, qTPointerRef.getSize());
        SPB.setIntInPointer(QTObject.ID(this.realObject), 12, qTPointerRef.getSize());
        this.device = sPBDevice;
        this.setCount(n);
        this.setMilliseconds(n2);
        this.setBuffer(qTPointerRef);
    }

    public void setCompletionProc(SICompletion sICompletion) {
        if (this.runner != null) {
            this.runner.cleanup();
        }
        if (sICompletion == null) {
            this.setIntAt(20, 0);
            SPB.setIntInPointer(QTObject.ID(this.realObject), 20, 0);
            this.runner = null;
        } else {
            this.runner = new SoundRunner(this, sICompletion);
            int n = this.runner.getClosure();
            this.setIntAt(20, n);
            SPB.setIntInPointer(QTObject.ID(this.realObject), 20, n);
        }
    }

    public void removeCompletionProc() {
        this.setCompletionProc(null);
    }

    public int getCount() {
        return SPB.getIntFromPointer(QTObject.ID(this.realObject), 4);
    }

    public void setCount(int n) {
        this.setIntAt(4, n);
        SPB.setIntInPointer(QTObject.ID(this.realObject), 4, n);
    }

    public int getBufferLength() {
        return SPB.getIntFromPointer(QTObject.ID(this.realObject), 12);
    }

    public int getMilliseconds() {
        return SPB.getIntFromPointer(QTObject.ID(this.realObject), 8);
    }

    public void setMilliseconds(int n) {
        this.setIntAt(8, n);
        SPB.setIntInPointer(QTObject.ID(this.realObject), 8, n);
    }

    public SPBDevice getDevice() {
        return this.device;
    }

    public void setBuffer(QTPointerRef qTPointerRef) {
        this.setIntAt(16, QTObject.ID(qTPointerRef));
        SPB.setIntInPointer(QTObject.ID(this.realObject), 16, QTObject.ID(qTPointerRef));
        this.setIntAt(12, qTPointerRef.getSize());
        SPB.setIntInPointer(QTObject.ID(this.realObject), 12, qTPointerRef.getSize());
        this.buffer = qTPointerRef;
    }

    public QTPointerRef getBuffer() {
        return this.buffer;
    }

    public short getError() {
        return SPB.getShortFromPointer(QTObject.ID(this.realObject), 32);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void record(boolean bl) throws SoundException {
        short s = 0;
        byte by = (byte)(bl ? 1 : 0);
        this.setShortAt(32, (short)0);
        SPB.setShortInPointer(QTObject.ID(this.realObject), 32, (short)0);
        Object object = QTNative.globalsLock;
        synchronized (object) {
            s = SPB.SPBRecord(QTObject.ID(this.realObject), by);
        }
        SoundException.checkError(s);
    }

    public void pauseRecording() throws SoundException {
        SoundException.checkError(SPB.SPBPauseRecording(SPB.getIntFromPointer(QTObject.ID(this.realObject), 0)));
    }

    public void resumeRecording() throws SoundException {
        SoundException.checkError(SPB.SPBResumeRecording(SPB.getIntFromPointer(QTObject.ID(this.realObject), 0)));
    }

    public void stopRecording() throws SoundException {
        SoundException.checkError(SPB.SPBStopRecording(SPB.getIntFromPointer(QTObject.ID(this.realObject), 0)));
    }

    public boolean isRecording() throws SoundException {
        this.getRecordingStatus();
        if (this.recordingStatus[0] > 0) {
            return true;
        }
        if (this.recordingStatus[0] == 0) {
            return false;
        }
        throw new SoundException(this.recordingStatus[0]);
    }

    public short meterLevel() throws SoundException {
        this.getRecordingStatus();
        return this.meterLevelValue[0];
    }

    public int totalSamplesToRecord() throws SoundException {
        this.getRecordingStatus();
        return this.totalSamplesToRecordVal[0];
    }

    public int numberOfSamplesRecorded() throws SoundException {
        this.getRecordingStatus();
        return this.numberOfSamplesRecordedVal[0];
    }

    public int totalMsecsToRecord() throws SoundException {
        this.getRecordingStatus();
        return this.totalMsecsToRecordVal[0];
    }

    public int numberOfMsecsRecorded() throws SoundException {
        this.getRecordingStatus();
        return this.numberOfMsecsRecordedVal[0];
    }

    private final void getRecordingStatus() throws SoundException {
        short s = SPB.SPBGetRecordingStatus(SPB.getIntFromPointer(QTObject.ID(this.realObject), 0), this.recordingStatus, this.meterLevelValue, this.totalSamplesToRecordVal, this.numberOfSamplesRecordedVal, this.totalMsecsToRecordVal, this.numberOfMsecsRecordedVal);
        SoundException.checkError(s);
    }

    private static native short getShortFromPointer(int var0, int var1);

    private static native int getIntFromPointer(int var0, int var1);

    private static native void setIntInPointer(int var0, int var1, int var2);

    private static native void setShortInPointer(int var0, int var1, short var2);

    private static native short SPBRecord(int var0, byte var1);

    private static native short SPBPauseRecording(int var0);

    private static native short SPBResumeRecording(int var0);

    private static native short SPBStopRecording(int var0);

    private static native short SPBGetRecordingStatus(int var0, short[] var1, short[] var2, int[] var3, int[] var4, int[] var5, int[] var6);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

