/*
 * Decompiled with CFR 0.152.
 */
package quicktime.sound;

import quicktime.QTException;
import quicktime.QTObject;
import quicktime.jdirect.InterfaceLib;
import quicktime.jdirect.QTNative;
import quicktime.jdirect.SoundLib;
import quicktime.sound.SCStatus;
import quicktime.sound.SndCommand;
import quicktime.sound.SndHandle;
import quicktime.sound.SoundCallBack;
import quicktime.sound.SoundException;
import quicktime.sound.SoundRunner;
import quicktime.std.clocks.Clock;
import quicktime.std.movies.media.LevelMeterInfo;
import quicktime.std.movies.media.MediaEQSpectrumBands;
import quicktime.util.QTUtils;

public final class SndChannel
extends QTObject
implements InterfaceLib,
SoundLib {
    private static Object linkage = QTNative.linkNativeMethods(class$quicktime$sound$SndChannel == null ? (class$quicktime$sound$SndChannel = SndChannel.class$("quicktime.sound.SndChannel")) : class$quicktime$sound$SndChannel);
    private static SoundRunner tempUPP;
    private boolean quietNow = false;
    private byte[] scratchArray;
    private SoundRunner sndUPP;
    static /* synthetic */ Class class$quicktime$sound$SndChannel;

    public SndChannel() throws QTException {
        this(5, 192);
    }

    public SndChannel(int n, int n2) throws QTException {
        super(SndChannel.allocate((short)n, n2));
    }

    public SndChannel(SoundCallBack soundCallBack) throws QTException {
        this(5, 192, soundCallBack);
    }

    public SndChannel(int n, int n2, SoundCallBack soundCallBack) throws QTException {
        super(SndChannel.allocate((short)n, n2, soundCallBack));
        if (soundCallBack != null) {
            this.sndUPP = tempUPP;
            this.sndUPP.setSndChannel(this);
        }
        tempUPP = null;
    }

    private static int allocate(short s, int n, SoundCallBack soundCallBack) throws QTException {
        int[] nArray = new int[]{0};
        if (soundCallBack != null) {
            tempUPP = new SoundRunner(soundCallBack);
            SoundException.checkError(SndChannel.SndNewChannel(nArray, s, n, tempUPP.getClosure()));
        } else {
            SoundException.checkError(SndChannel.SndNewChannel(nArray, s, n, 0));
        }
        return nArray[0];
    }

    private static int allocate(short s, int n) throws SoundException {
        int[] nArray = new int[]{0};
        SoundException.checkError(SndChannel.SndNewChannel(nArray, s, n, 0));
        return nArray[0];
    }

    protected void _dispose() throws QTException {
        if (this.sndUPP != null) {
            this.sndUPP.cleanup();
            this.sndUPP = null;
        }
    }

    public boolean isQuietNow() {
        return this.quietNow;
    }

    public void setQuietNow(boolean bl) {
        this.quietNow = bl;
    }

    public void play(SndHandle sndHandle) throws SoundException {
        SoundException.checkError(SndChannel.SndPlay(this._ID(), QTObject.ID(sndHandle), (byte)1));
    }

    public boolean isFinished() throws SoundException {
        if (this.scratchArray == null) {
            this.scratchArray = new byte[24];
        }
        short s = SndChannel.SndChannelStatus(this._ID(), (short)24, this.scratchArray);
        SoundException.checkError(s);
        return this.scratchArray[12] == 0 && this.scratchArray[14] == 0;
    }

    public boolean isPaused() throws SoundException {
        if (this.scratchArray == null) {
            this.scratchArray = new byte[24];
        }
        short s = SndChannel.SndChannelStatus(this._ID(), (short)24, this.scratchArray);
        SoundException.checkError(s);
        return this.scratchArray[14] != 0;
    }

    public SCStatus status() throws SoundException {
        SCStatus sCStatus = new SCStatus();
        short s = SndChannel.SndChannelStatus(this._ID(), (short)24, sCStatus.getBytes());
        SoundException.checkError(s);
        return sCStatus;
    }

    public void doCommand(SndCommand sndCommand) throws SoundException {
        this.doCommand(sndCommand, true);
    }

    public void doCommand(SndCommand sndCommand, boolean bl) throws SoundException {
        SoundException.checkError(SndChannel.SndDoCommand(this._ID(), QTObject.ID(sndCommand), (byte)(bl ? 1 : 0)));
    }

    public void doImmediate(SndCommand sndCommand) throws SoundException {
        SoundException.checkError(SndChannel.SndDoImmediate(this._ID(), QTObject.ID(sndCommand)));
    }

    public boolean getLevelMeterOnOff() throws SoundException {
        byte[] byArray = new byte[]{0};
        SoundException.checkError(SndChannel.SndGetInfo(this._ID(), 1819108724, byArray));
        return byArray[0] != 0;
    }

    public void setLevelMeterOnOff(boolean bl) throws SoundException {
        SoundException.checkError(SndChannel.SndSetInfo(this._ID(), 1819108724, (byte)(bl ? 1 : 0)));
    }

    public void enableClock(boolean bl) throws SoundException {
        SoundException.checkError(SndChannel.SndSetInfo(this._ID(), 1935895659, (byte)(bl ? 1 : 0)));
    }

    public Clock getClock() throws SoundException {
        return Clock.fromSndChannel(this);
    }

    public LevelMeterInfo getActiveLevels() throws SoundException {
        LevelMeterInfo levelMeterInfo = new LevelMeterInfo();
        short s = SndChannel.SndGetInfo(this._ID(), 1819107683, levelMeterInfo.getBytes());
        return levelMeterInfo;
    }

    public MediaEQSpectrumBands getEQSpectrumBands(int n) throws SoundException {
        MediaEQSpectrumBands mediaEQSpectrumBands = new MediaEQSpectrumBands(n);
        SoundException.checkError(SndChannel.SndGetInfo(this._ID(), 1701933922, mediaEQSpectrumBands.getBytes()));
        return mediaEQSpectrumBands;
    }

    public void setEQSpectrumBands(MediaEQSpectrumBands mediaEQSpectrumBands) throws SoundException {
        SoundException.checkError(SndChannel.SndSetInfo(this._ID(), 1701933922, mediaEQSpectrumBands.getBytes()));
    }

    public int[] getEQSpectrumLevels(int n) throws SoundException {
        byte[] byArray = new byte[n];
        SoundException.checkError(SndChannel.SndGetInfo(this._ID(), 1701932150, byArray));
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < nArray.length) {
            nArray[n2] = QTUtils.UByte2Int(byArray[n2]);
            ++n2;
        }
        return nArray;
    }

    public boolean getEQToneControlOnOff() throws SoundException {
        byte[] byArray = new byte[]{0};
        SoundException.checkError(SndChannel.SndGetInfo(this._ID(), 1701934179, byArray));
        return byArray[0] != 0;
    }

    public void setEQToneControlOnOff(boolean bl) throws SoundException {
        byte[] byArray = new byte[]{0};
        SoundException.checkError(SndChannel.SndSetInfo(this._ID(), 1701934179, (byte)(bl ? 1 : 0)));
    }

    public void setEQToneControlGain(int n, int n2) throws SoundException {
        short s = QTUtils.X2ShortFix(n);
        short s2 = QTUtils.X2ShortFix(n2);
        int n3 = s2 << 16 | s & 0xFFFF;
        SoundException.checkError(SndChannel.SndSetInfo(this._ID(), 1701934183, n3));
    }

    public int[] getEQToneControlGain() throws SoundException {
        int[] nArray = new int[2];
        SoundException.checkError(SndChannel.SndGetInfo(this._ID(), 1701934183, nArray));
        int n = nArray[0];
        nArray[0] = n | 0xFFFF;
        nArray[1] = n >>> 16;
        return nArray;
    }

    private static native short SndNewChannel(int[] var0, short var1, int var2, int var3);

    private static native short SndPlay(int var0, int var1, byte var2);

    private static native short SndChannelStatus(int var0, short var1, byte[] var2);

    private static native short SndDoCommand(int var0, int var1, byte var2);

    private static native short SndDoImmediate(int var0, int var1);

    private static native short SndSetInfo(int var0, int var1, byte var2);

    private static native short SndSetInfo(int var0, int var1, byte[] var2);

    private static native short SndSetInfo(int var0, int var1, int var2);

    private static native short SndGetInfo(int var0, int var1, byte[] var2);

    private static native short SndGetInfo(int var0, int var1, int[] var2);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

