/*
 * Decompiled with CFR 0.152.
 */
package quicktime.std.anim;

import quicktime.QTException;
import quicktime.QTObject;
import quicktime.jdirect.QTNative;
import quicktime.jdirect.QuickTimeLib;
import quicktime.qd.QDColor;
import quicktime.qd.QDException;
import quicktime.qd.QDGraphics;
import quicktime.qd.QDPoint;
import quicktime.qd.QDRect;
import quicktime.qd.Region;
import quicktime.std.StdQTException;
import quicktime.std.anim.Sprite;
import quicktime.std.image.GraphicsMode;
import quicktime.std.image.Matrix;

public class SpriteWorld
extends QTObject
implements QuickTimeLib {
    private static Object linkage = QTNative.linkNativeMethods(class$quicktime$std$anim$SpriteWorld == null ? (class$quicktime$std$anim$SpriteWorld = SpriteWorld.class$("quicktime.std.anim.SpriteWorld")) : class$quicktime$std$anim$SpriteWorld);
    private Matrix mMatrix = new Matrix();
    private int mWidth;
    private int mHeight;
    private int destPort;
    private int[] savedPort = new int[]{0};
    private int[] savedDevice = new int[]{0};
    private QDRect bounds = new QDRect();
    static /* synthetic */ Class class$quicktime$std$anim$SpriteWorld;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int allocate(QDGraphics qDGraphics, QDGraphics qDGraphics2, QDColor qDColor, QDGraphics qDGraphics3) throws StdQTException, QDException {
        int[] nArray = new int[1];
        Object object = QTNative.globalsLock;
        synchronized (object) {
            short s = SpriteWorld.NewSpriteWorld(nArray, QTObject.ID(qDGraphics), QTObject.ID(qDGraphics2), qDColor == null ? null : qDColor.getRGBColor(), QTObject.ID(qDGraphics3));
            StdQTException.checkError(s);
        }
        return nArray[0];
    }

    public SpriteWorld(QDGraphics qDGraphics, QDGraphics qDGraphics2, QDColor qDColor, QDGraphics qDGraphics3) throws QTException {
        super(SpriteWorld.allocate(qDGraphics, qDGraphics2, qDColor, qDGraphics3));
        this.setWidthHeight(qDGraphics2);
        this.setMatrix(this.mMatrix);
        this.destPort = QTObject.ID(qDGraphics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setWidthHeight(QDGraphics qDGraphics) {
        Object object = QTNative.globalsLock;
        synchronized (object) {
            QDRect qDRect = qDGraphics.getPortRect();
            this.mWidth = qDRect.getWidth();
            this.mHeight = qDRect.getHeight();
        }
    }

    public final void setBounds(QDRect qDRect) throws StdQTException {
        Matrix matrix = new Matrix();
        matrix.setTx(qDRect.getX());
        matrix.setTy(qDRect.getY());
        matrix.setSx((float)qDRect.getWidth() / (float)this.mWidth);
        matrix.setSy((float)qDRect.getHeight() / (float)this.mHeight);
        this.setMatrix(matrix);
    }

    public final QDRect getBounds() throws StdQTException {
        this.bounds.setX((int)this.mMatrix.getTx());
        this.bounds.setY((int)this.mMatrix.getTy());
        this.bounds.setWidth((int)(this.mMatrix.getSx() * (float)this.mWidth));
        this.bounds.setHeight((int)(this.mMatrix.getSy() * (float)this.mHeight));
        return this.bounds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setClip(Region region) throws StdQTException {
        Object object = QTNative.globalsLock;
        synchronized (object) {
            StdQTException.checkError(SpriteWorld.SetSpriteWorldClip(this._ID(), QTObject.ID(region)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setGraphicsMode(GraphicsMode graphicsMode) throws StdQTException {
        graphicsMode = graphicsMode == null ? new GraphicsMode() : graphicsMode;
        Object object = QTNative.globalsLock;
        synchronized (object) {
            StdQTException.checkError(SpriteWorld.SetSpriteWorldGraphicsMode(this._ID(), graphicsMode.getGraphicsMode(), graphicsMode.getColor().getRGBColor()));
        }
    }

    public final Matrix getMatrix() {
        return this.mMatrix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setMatrix(Matrix matrix) throws StdQTException {
        Object object = QTNative.globalsLock;
        synchronized (object) {
            this.mMatrix = matrix == null ? new Matrix() : matrix;
            StdQTException.checkError(SpriteWorld.SetSpriteWorldMatrix(this._ID(), this.mMatrix.getBytes()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int idle(int n) throws StdQTException {
        int[] nArray = new int[1];
        Object object = QTNative.globalsLock;
        synchronized (object) {
            short s = SpriteWorld.SpriteWorldIdle(this._ID(), n, nArray);
            StdQTException.checkError(s);
        }
        return nArray[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void invalidate(QDRect qDRect) throws StdQTException {
        Object object = QTNative.globalsLock;
        synchronized (object) {
            StdQTException.checkError(SpriteWorld.InvalidateSpriteWorld(this._ID(), qDRect == null ? null : qDRect.getRect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Sprite hitTest(int n, QDPoint qDPoint) throws QTException {
        int[] nArray = new int[1];
        Object object = QTNative.globalsLock;
        synchronized (object) {
            StdQTException.checkError(SpriteWorld.SpriteWorldHitTest(this._ID(), n, qDPoint.getPoint(), nArray));
        }
        return nArray[0] == 0 ? null : new Sprite(nArray[0], this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setFlags(int n, int n2) throws StdQTException {
        Object object = QTNative.globalsLock;
        synchronized (object) {
            StdQTException.checkError(SpriteWorld.SetSpriteWorldFlags(this._ID(), n, n2));
        }
    }

    private static native short NewSpriteWorld(int[] var0, int var1, int var2, byte[] var3, int var4);

    private static native short SetSpriteWorldClip(int var0, int var1);

    private static native short SetSpriteWorldGraphicsMode(int var0, int var1, byte[] var2);

    private static native short SetSpriteWorldMatrix(int var0, byte[] var1);

    private static native short SpriteWorldIdle(int var0, int var1, int[] var2);

    private static native short InvalidateSpriteWorld(int var0, byte[] var1);

    private static native short SpriteWorldHitTest(int var0, int var1, int var2, int[] var3);

    private static native short SetSpriteWorldFlags(int var0, int var1, int var2);

    private static native void DisposeAllSprites(int var0);

    private static native short GetMoviesError();

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

