/*
 * Decompiled with CFR 0.152.
 */
package quicktime.std.image;

import com.apple.mrj.macos.carbon.CarbonAccess;
import com.apple.mrj.macos.carbon.CarbonEventClient;
import quicktime.Errors;
import quicktime.QTException;
import quicktime.QTObject;
import quicktime.QTSession;
import quicktime.io.QTFile;
import quicktime.jdirect.QTNative;
import quicktime.jdirect.QuickTimeLib;
import quicktime.qd.Pict;
import quicktime.qd.PixMap;
import quicktime.qd.QDDimension;
import quicktime.qd.QDGraphics;
import quicktime.qd.QDRect;
import quicktime.std.StdQTException;
import quicktime.std.comp.Component;
import quicktime.std.image.GECompressorInfo;
import quicktime.std.image.GraphicsImporter;
import quicktime.std.image.ImageDescription;
import quicktime.std.movies.AtomContainer;
import quicktime.std.movies.media.DataRef;
import quicktime.std.movies.media.UserData;
import quicktime.util.QTHandle;
import quicktime.util.QTHandleRef;
import quicktime.util.QTPointer;
import quicktime.util.QTPointerRef;
import quicktime.util.QTUtils;

public final class GraphicsExporter
extends Component
implements QuickTimeLib,
Errors {
    private static Object linkage = QTNative.linkNativeMethods(class$quicktime$std$image$GraphicsExporter == null ? (class$quicktime$std$image$GraphicsExporter = GraphicsExporter.class$("quicktime.std.image.GraphicsExporter")) : class$quicktime$std$image$GraphicsExporter);
    private static final int[] savedPort = new int[]{0};
    private static final int[] savedDevice = new int[]{0};
    static /* synthetic */ Class class$quicktime$std$image$GraphicsExporter;

    public GraphicsExporter(int n) throws QTException {
        super(1735550328, n);
    }

    public int doExport() throws StdQTException {
        int[] nArray = new int[]{0};
        int n = GraphicsExporter.GraphicsExportDoExport(this._ID(), nArray);
        StdQTException.checkError(n);
        return nArray[0];
    }

    public void doStandaloneExport() throws QTException {
        int n = GraphicsExporter.GraphicsExportDoStandaloneExport(this._ID());
        StdQTException.checkError(n);
    }

    public void setInputDataReference(DataRef dataRef, ImageDescription imageDescription) throws QTException {
        int n = dataRef.getType();
        int n2 = GraphicsExporter.GraphicsExportSetInputDataReference(this._ID(), QTObject.ID(dataRef), dataRef.getType(), QTObject.ID(imageDescription));
        StdQTException.checkError(n2);
    }

    public DataRef getInputDataReference() throws QTException {
        return DataRef.fromGraphicsExporterInputDataRef(this);
    }

    public void setInputFile(QTFile qTFile, ImageDescription imageDescription) throws QTException {
        int n = GraphicsExporter.GraphicsExportSetInputFile(this._ID(), qTFile.getFSSpec(true, 256), QTObject.ID(imageDescription));
        StdQTException.checkError(n);
    }

    public QTFile getInputFile() throws QTException {
        return QTFile.fromGraphicsExporterInput(this);
    }

    public void setInputHandle(QTHandle qTHandle, ImageDescription imageDescription) throws QTException {
        int n = GraphicsExporter.GraphicsExportSetInputHandle(this._ID(), QTObject.ID(qTHandle), QTObject.ID(imageDescription));
        StdQTException.checkError(n);
    }

    public QTHandle getInputHandle() throws QTException {
        return QTHandle.fromGraphicsExporterInput(this);
    }

    public void setInputPtr(QTPointerRef qTPointerRef, ImageDescription imageDescription) throws QTException {
        int n = GraphicsExporter.GraphicsExportSetInputPtr(this._ID(), QTObject.ID(qTPointerRef), imageDescription.getDataSize(), QTObject.ID(imageDescription));
        StdQTException.checkError(n);
    }

    public QTPointerRef getInputPtr() throws QTException {
        return QTPointer.fromGraphicsExporter(this);
    }

    public void setInputGraphicsImporter(GraphicsImporter graphicsImporter) throws QTException {
        int n = GraphicsExporter.GraphicsExportSetInputGraphicsImporter(this._ID(), QTObject.ID(graphicsImporter));
        StdQTException.checkError(n);
    }

    public GraphicsImporter getInputGraphicsImporter() throws QTException {
        return GraphicsImporter.fromGraphicsExporter(this);
    }

    public void setInputPicture(Pict pict) throws QTException {
        int n = GraphicsExporter.GraphicsExportSetInputPicture(this._ID(), QTObject.ID(pict));
        StdQTException.checkError(n);
    }

    public Pict getInputPicture() throws QTException {
        return Pict.fromGraphicsExporter(this);
    }

    public void setInputGWorld(QDGraphics qDGraphics) throws QTException {
        int n = GraphicsExporter.GraphicsExportSetInputGWorld(this._ID(), QTObject.ID(qDGraphics));
        StdQTException.checkError(n);
    }

    public QDGraphics getInputGWorld() throws QTException {
        return QDGraphics.fromGraphicsExporter(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInputPixmap(QDGraphics qDGraphics) throws StdQTException {
        if (qDGraphics == null) {
            throw new StdQTException(-50);
        }
        int n = 0;
        Object object = QTNative.globalsLock;
        synchronized (object) {
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                GraphicsExporter.GetGWorld(savedPort, savedDevice);
            }
            GraphicsExporter.SetGWorld(QTObject.ID(qDGraphics), 0);
            n = GraphicsExporter.GraphicsExportSetInputPixmap(this._ID(), QTObject.ID(qDGraphics.getPixMap()));
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                GraphicsExporter.SetGWorld(savedPort[0], savedDevice[0]);
            }
        }
        StdQTException.checkError(n);
    }

    public PixMap getInputPixmap() throws QTException {
        return PixMap.fromGraphicsExporter(this);
    }

    public void setOutputDataReference(DataRef dataRef) throws QTException {
        int n = dataRef.getType();
        int n2 = GraphicsExporter.GraphicsExportSetOutputDataReference(this._ID(), QTObject.ID(dataRef), dataRef.getType());
        StdQTException.checkError(n2);
    }

    public DataRef getOutputDataReference() throws QTException {
        return DataRef.fromGraphicsExporterOutputDataRef(this);
    }

    public void setOutputFile(QTFile qTFile) throws QTException {
        int n = GraphicsExporter.GraphicsExportSetOutputFile(this._ID(), qTFile.getFSSpec(false, 512));
        StdQTException.checkError(n);
    }

    public QTFile getOutputFile() throws QTException {
        return QTFile.fromGraphicsExporterOutput(this);
    }

    public void setOutputHandle(QTHandleRef qTHandleRef) throws QTException {
        int n = GraphicsExporter.GraphicsExportSetOutputHandle(this._ID(), QTObject.ID(qTHandleRef));
        StdQTException.checkError(n);
    }

    public QTHandle getOutputHandle() throws QTException {
        return QTHandle.fromGraphicsExporterOutput(this);
    }

    public void setOutputOffsetAndMaxSize(int n, int n2, boolean bl) throws QTException {
        int n3 = GraphicsExporter.GraphicsExportSetOutputOffsetAndMaxSize(this._ID(), n, n2, (byte)(bl ? 1 : 0));
        StdQTException.checkError(n3);
    }

    public int getOutputOffset() throws StdQTException {
        int[] nArray = new int[]{0};
        int n = GraphicsExporter.GraphicsExportGetOutputOffsetAndMaxSize(this._ID(), nArray, null, null);
        StdQTException.checkError(n);
        return nArray[0];
    }

    public int getOutputMaxSize() throws StdQTException {
        int[] nArray = new int[]{0};
        int n = GraphicsExporter.GraphicsExportGetOutputOffsetAndMaxSize(this._ID(), null, nArray, null);
        StdQTException.checkError(n);
        return nArray[0];
    }

    public boolean getOutputTruncateFile() throws StdQTException {
        byte[] byArray = new byte[]{0};
        int n = GraphicsExporter.GraphicsExportGetOutputOffsetAndMaxSize(this._ID(), null, null, byArray);
        StdQTException.checkError(n);
        return byArray[0] != 0;
    }

    public void setOutputFileTypeAndCreator(int n, int n2) throws QTException {
        int n3 = GraphicsExporter.GraphicsExportSetOutputFileTypeAndCreator(this._ID(), n, n2);
        StdQTException.checkError(n3);
    }

    public int getOutputFileType() throws QTException {
        int[] nArray = new int[]{0};
        int[] nArray2 = new int[]{0};
        int n = GraphicsExporter.GraphicsExportGetOutputFileTypeAndCreator(this._ID(), nArray, nArray2);
        StdQTException.checkError(n);
        return nArray[0];
    }

    public int getOutputFileCreator() throws QTException {
        int[] nArray = new int[]{0};
        int[] nArray2 = new int[]{0};
        int n = GraphicsExporter.GraphicsExportGetOutputFileTypeAndCreator(this._ID(), nArray, nArray2);
        StdQTException.checkError(n);
        return nArray2[0];
    }

    public boolean mayExporterReadInputData() throws QTException {
        byte[] byArray = new byte[]{0};
        int n = GraphicsExporter.GraphicsExportMayExporterReadInputData(this._ID(), byArray);
        StdQTException.checkError(n);
        return byArray[0] != 0;
    }

    public int getInputDataSize() throws QTException {
        int[] nArray = new int[]{0};
        int n = GraphicsExporter.GraphicsExportGetInputDataSize(this._ID(), nArray);
        StdQTException.checkError(n);
        return nArray[0];
    }

    public byte[] readInputData(int n, int n2) throws StdQTException {
        byte[] byArray = new byte[n2];
        int n3 = GraphicsExporter.GraphicsExportReadInputData(this._ID(), byArray, n, n2);
        StdQTException.checkError(n3);
        return byArray;
    }

    public ImageDescription getInputImageDescription() throws QTException {
        return ImageDescription.fromGraphicsExporter(this);
    }

    public QDRect getInputImageDimensions() throws QTException {
        QDRect qDRect = new QDRect();
        int n = GraphicsExporter.GraphicsExportGetInputImageDimensions(this._ID(), qDRect.getRect());
        StdQTException.checkError(n);
        return qDRect;
    }

    public int getInputImageDepth() throws QTException {
        int[] nArray = new int[]{0};
        int n = GraphicsExporter.GraphicsExportGetInputImageDepth(this._ID(), nArray);
        StdQTException.checkError(n);
        return nArray[0];
    }

    public void drawInputImage(QDGraphics qDGraphics, QDRect qDRect, QDRect qDRect2) throws QTException {
        int n = GraphicsExporter.GraphicsExportDrawInputImage(this._ID(), QTObject.ID(qDGraphics), 0, qDRect.getRect(), qDRect2.getRect());
        StdQTException.checkError(n);
    }

    public void setInputOffsetAndLimit(int n, int n2) throws QTException {
        int n3 = GraphicsExporter.GraphicsExportSetInputOffsetAndLimit(this._ID(), n, n2);
        StdQTException.checkError(n3);
    }

    public int getInputOffset() throws QTException {
        int[] nArray = new int[]{0};
        int[] nArray2 = new int[]{0};
        int n = GraphicsExporter.GraphicsExportGetInputOffsetAndLimit(this._ID(), nArray, nArray2);
        StdQTException.checkError(n);
        return nArray[0];
    }

    public int getInputLimit() throws QTException {
        int[] nArray = new int[]{0};
        int[] nArray2 = new int[]{0};
        int n = GraphicsExporter.GraphicsExportGetInputOffsetAndLimit(this._ID(), nArray, nArray2);
        StdQTException.checkError(n);
        return nArray2[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestSettings() throws QTException {
        final int n = this._ID();
        if (QTSession.isCurrentOS(4)) {
            int n2 = (Integer)CarbonAccess.invokeCarbonEventClient(new CarbonEventClient(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object invoke() {
                    int n2 = 0;
                    Object object = QTNative.globalsLock;
                    synchronized (object) {
                        n2 = GraphicsExporter.GraphicsExportRequestSettings(n, 0, 0);
                    }
                    return new Integer(n2);
                }
            });
            StdQTException.checkError(n2);
        } else {
            Object object = QTNative.globalsLock;
            synchronized (object) {
                int n3 = GraphicsExporter.GraphicsExportRequestSettings(this._ID(), 0, 0);
                if (n3 == 1) {
                    throw new StdQTException(-128);
                }
                StdQTException.checkError(n3);
            }
        }
    }

    public void setSettingsFromAtomContainer(AtomContainer atomContainer) throws QTException {
        int n = GraphicsExporter.GraphicsExportSetSettingsFromAtomContainer(this._ID(), atomContainer.getBytes());
        StdQTException.checkError(n);
    }

    public AtomContainer getSettingsAsAtomContainer() throws QTException {
        return AtomContainer.fromGraphicsExporter(this);
    }

    public QTHandle getSettingsAsText() throws QTException {
        return QTHandle.fromGraphicsExporterText(this);
    }

    public String getDefaultFileNameExtension() throws QTException {
        int[] nArray = new int[]{0};
        int n = GraphicsExporter.GraphicsExportGetDefaultFileNameExtension(this._ID(), nArray);
        StdQTException.checkError(n);
        return QTUtils.fromOSType(nArray[0]);
    }

    public AtomContainer getMIMETypeList() throws QTException {
        return AtomContainer.fromGraphicsExporterMIME(this);
    }

    public String getDefaultFileType() throws QTException {
        int[] nArray = new int[]{0};
        int[] nArray2 = new int[]{0};
        int n = GraphicsExporter.GraphicsExportGetDefaultFileTypeAndCreator(this._ID(), nArray, nArray2);
        StdQTException.checkError(n);
        return QTUtils.fromOSType(nArray[0]);
    }

    public String getDefaultFileCreator() throws QTException {
        int[] nArray = new int[]{0};
        int[] nArray2 = new int[]{0};
        int n = GraphicsExporter.GraphicsExportGetDefaultFileTypeAndCreator(this._ID(), nArray, nArray2);
        StdQTException.checkError(n);
        return QTUtils.fromOSType(nArray2[0]);
    }

    public boolean canTranscode() throws QTException {
        byte[] byArray = new byte[]{0};
        int n = GraphicsExporter.GraphicsExportCanTranscode(this._ID(), byArray);
        StdQTException.checkError(n);
        return byArray[0] != 0;
    }

    public void doTranscode() throws QTException {
        int n = GraphicsExporter.GraphicsExportDoTranscode(this._ID());
        StdQTException.checkError(n);
    }

    public GECompressorInfo canUseCompressor() throws QTException {
        return AtomContainer.fromGraphicsExporterCompressor(this);
    }

    public ImageDescription doUseCompressor(AtomContainer atomContainer) throws QTException {
        return ImageDescription.fromGraphicsExporterCompressor(this, atomContainer);
    }

    public void setDontRecompress(boolean bl) throws QTException {
        int n = GraphicsExporter.GraphicsExportSetDontRecompress(this._ID(), (byte)(bl ? 1 : 0));
        StdQTException.checkError(n);
    }

    public boolean getDontRecompress() throws QTException {
        byte[] byArray = new byte[]{0};
        int n = GraphicsExporter.GraphicsExportGetDontRecompress(this._ID(), byArray);
        StdQTException.checkError(n);
        return byArray[0] != 0;
    }

    public void setInterlaceStyle(int n) throws QTException {
        int n2 = GraphicsExporter.GraphicsExportSetInterlaceStyle(this._ID(), n);
        StdQTException.checkError(n2);
    }

    public int getInterlaceStyle() throws QTException {
        int[] nArray = new int[]{0};
        int n = GraphicsExporter.GraphicsExportGetInterlaceStyle(this._ID(), nArray);
        StdQTException.checkError(n);
        return nArray[0];
    }

    public void setMetaData(UserData userData) throws QTException {
        int n = GraphicsExporter.GraphicsExportSetMetaData(this._ID(), QTObject.ID(userData));
        StdQTException.checkError(n);
    }

    public UserData getMetaData() throws QTException {
        return UserData.fromGraphicsExporter(this);
    }

    public void setTargetDataSize(int n) throws QTException {
        int n2 = GraphicsExporter.GraphicsExportSetTargetDataSize(this._ID(), n);
        StdQTException.checkError(n2);
    }

    public int getTargetDataSize() throws QTException {
        int[] nArray = new int[]{0};
        int n = GraphicsExporter.GraphicsExportGetTargetDataSize(this._ID(), nArray);
        StdQTException.checkError(n);
        return nArray[0];
    }

    public void setCompressionMethod(int n) throws QTException {
        int n2 = GraphicsExporter.GraphicsExportSetCompressionMethod(this._ID(), n);
        StdQTException.checkError(n2);
    }

    public int getCompressionMethod() throws QTException {
        int[] nArray = new int[]{0};
        int n = GraphicsExporter.GraphicsExportGetCompressionMethod(this._ID(), nArray);
        StdQTException.checkError(n);
        return nArray[0];
    }

    public void setCompressionQuality(int n) throws QTException {
        int n2 = GraphicsExporter.GraphicsExportSetCompressionQuality(this._ID(), n);
        StdQTException.checkError(n2);
    }

    public int getCompressionQuality() throws QTException {
        int[] nArray = new int[]{0};
        int n = GraphicsExporter.GraphicsExportGetCompressionQuality(this._ID(), nArray);
        StdQTException.checkError(n);
        return nArray[0];
    }

    public void setResolution(int n, int n2) throws QTException {
        int n3 = GraphicsExporter.GraphicsExportSetResolution(this._ID(), n, n2);
        StdQTException.checkError(n3);
    }

    public int getHorizontalResolution() throws QTException {
        int[] nArray = new int[]{0};
        int[] nArray2 = new int[]{0};
        int n = GraphicsExporter.GraphicsExportGetResolution(this._ID(), nArray, nArray2);
        StdQTException.checkError(n);
        return nArray[0];
    }

    public int getVerticalResolution() throws QTException {
        int[] nArray = new int[]{0};
        int[] nArray2 = new int[]{0};
        int n = GraphicsExporter.GraphicsExportGetResolution(this._ID(), nArray, nArray2);
        StdQTException.checkError(n);
        return nArray2[0];
    }

    public void setDepth(int n) throws QTException {
        int n2 = GraphicsExporter.GraphicsExportSetDepth(this._ID(), n);
        StdQTException.checkError(n2);
    }

    public int getDepth() throws QTException {
        int[] nArray = new int[]{0};
        int n = GraphicsExporter.GraphicsExportGetDepth(this._ID(), nArray);
        StdQTException.checkError(n);
        return nArray[0];
    }

    public void GraphicsExportWriteOutputData(byte[] byArray, int n) throws StdQTException {
        int n2 = GraphicsExporter.GraphicsExportWriteOutputData(this._ID(), byArray, n);
        StdQTException.checkError(n2);
    }

    public byte[] GraphicsExportReadOutputData(int n, int n2) throws StdQTException {
        byte[] byArray = new byte[n2];
        int n3 = GraphicsExporter.GraphicsExportReadOutputData(this._ID(), byArray, n, n2);
        StdQTException.checkError(n3);
        return byArray;
    }

    public void setExifEnabled(boolean bl) throws StdQTException {
        int n = GraphicsExporter.GraphicsExportSetExifEnabled(this._ID(), (byte)(!bl ? 1 : 0));
        StdQTException.checkError(n);
    }

    public boolean getExifEnabled() throws StdQTException {
        byte[] byArray = new byte[]{0};
        int n = GraphicsExporter.GraphicsExportGetExifEnabled(this._ID(), byArray);
        StdQTException.checkError(n);
        return byArray[0] != 0;
    }

    public void setThumbnailEnabled(boolean bl, int n, int n2) throws StdQTException {
        int n3 = GraphicsExporter.GraphicsExportSetThumbnailEnabled(this._ID(), (byte)(bl ? 1 : 0), n, n2);
        StdQTException.checkError(n3);
    }

    public boolean getThumbnailEnabled() throws StdQTException {
        byte[] byArray = new byte[]{0};
        int[] nArray = new int[]{0};
        int[] nArray2 = new int[]{0};
        int n = GraphicsExporter.GraphicsExportGetThumbnailEnabled(this._ID(), byArray, nArray, nArray2);
        StdQTException.checkError(n);
        return byArray[0] != 0;
    }

    public QDDimension getThumbnailDimension() throws StdQTException {
        byte[] byArray = new byte[]{0};
        int[] nArray = new int[]{0};
        int[] nArray2 = new int[]{0};
        int n = GraphicsExporter.GraphicsExportGetThumbnailEnabled(this._ID(), byArray, nArray, nArray2);
        StdQTException.checkError(n);
        return new QDDimension(nArray[0], nArray2[0]);
    }

    private static native int GraphicsExportSetExifEnabled(int var0, byte var1);

    private static native int GraphicsExportGetExifEnabled(int var0, byte[] var1);

    private static native int GraphicsExportSetThumbnailEnabled(int var0, byte var1, int var2, int var3);

    private static native int GraphicsExportGetThumbnailEnabled(int var0, byte[] var1, int[] var2, int[] var3);

    private static native int GraphicsExportDoExport(int var0, int[] var1);

    private static native int GraphicsExportSetInputDataReference(int var0, int var1, int var2, int var3);

    private static native int GraphicsExportSetInputFile(int var0, byte[] var1, int var2);

    private static native int GraphicsExportSetInputHandle(int var0, int var1, int var2);

    private static native int GraphicsExportSetInputPtr(int var0, int var1, int var2, int var3);

    private static native int GraphicsExportSetInputGraphicsImporter(int var0, int var1);

    private static native int GraphicsExportSetInputPicture(int var0, int var1);

    private static native int GraphicsExportSetInputGWorld(int var0, int var1);

    private static native int GraphicsExportSetInputPixmap(int var0, int var1);

    private static native int GraphicsExportSetOutputDataReference(int var0, int var1, int var2);

    private static native int GraphicsExportSetOutputFile(int var0, byte[] var1);

    private static native int GraphicsExportSetOutputHandle(int var0, int var1);

    private static native int GraphicsExportSetOutputOffsetAndMaxSize(int var0, int var1, int var2, byte var3);

    private static native int GraphicsExportGetOutputOffsetAndMaxSize(int var0, int[] var1, int[] var2, byte[] var3);

    private static native int GraphicsExportSetOutputFileTypeAndCreator(int var0, int var1, int var2);

    private static native int GraphicsExportGetOutputFileTypeAndCreator(int var0, int[] var1, int[] var2);

    private static native int GraphicsExportMayExporterReadInputData(int var0, byte[] var1);

    private static native int GraphicsExportGetInputDataSize(int var0, int[] var1);

    private static native int GraphicsExportReadInputData(int var0, byte[] var1, int var2, int var3);

    private static native int GraphicsExportGetInputImageDimensions(int var0, byte[] var1);

    private static native int GraphicsExportGetInputImageDepth(int var0, int[] var1);

    private static native int GraphicsExportDrawInputImage(int var0, int var1, int var2, byte[] var3, byte[] var4);

    private static native int GraphicsExportSetInputOffsetAndLimit(int var0, int var1, int var2);

    private static native int GraphicsExportGetInputOffsetAndLimit(int var0, int[] var1, int[] var2);

    private static native int GraphicsExportRequestSettings(int var0, int var1, int var2);

    private static native int GraphicsExportSetSettingsFromAtomContainer(int var0, byte[] var1);

    private static native int GraphicsExportGetDefaultFileTypeAndCreator(int var0, int[] var1, int[] var2);

    private static native int GraphicsExportGetDefaultFileNameExtension(int var0, int[] var1);

    private static native int GraphicsExportGetMIMETypeList(int var0, int[] var1);

    private static native int GraphicsExportCanTranscode(int var0, byte[] var1);

    private static native int GraphicsExportDoTranscode(int var0);

    private static native int GraphicsExportCanUseCompressor(int var0, byte[] var1, int[] var2);

    private static native int GraphicsExportDoStandaloneExport(int var0);

    private static native int GraphicsExportSetDontRecompress(int var0, byte var1);

    private static native int GraphicsExportGetDontRecompress(int var0, byte[] var1);

    private static native int GraphicsExportSetInterlaceStyle(int var0, int var1);

    private static native int GraphicsExportGetInterlaceStyle(int var0, int[] var1);

    private static native int GraphicsExportSetMetaData(int var0, int var1);

    private static native int GraphicsExportGetMetaData(int var0, int[] var1);

    private static native int GraphicsExportSetTargetDataSize(int var0, int var1);

    private static native int GraphicsExportGetTargetDataSize(int var0, int[] var1);

    private static native int GraphicsExportSetCompressionMethod(int var0, int var1);

    private static native int GraphicsExportGetCompressionMethod(int var0, int[] var1);

    private static native int GraphicsExportSetCompressionQuality(int var0, int var1);

    private static native int GraphicsExportGetCompressionQuality(int var0, int[] var1);

    private static native int GraphicsExportSetResolution(int var0, int var1, int var2);

    private static native int GraphicsExportGetResolution(int var0, int[] var1, int[] var2);

    private static native int GraphicsExportSetDepth(int var0, int var1);

    private static native int GraphicsExportGetDepth(int var0, int[] var1);

    private static native int GraphicsExportWriteOutputData(int var0, byte[] var1, int var2);

    private static native int GraphicsExportReadOutputData(int var0, byte[] var1, int var2, int var3);

    private static native void SetGWorld(int var0, int var1);

    private static native void GetGWorld(int[] var0, int[] var1);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

