/*
 * Decompiled with CFR 0.152.
 */
package quicktime.std.image;

import quicktime.QTException;
import quicktime.QTObject;
import quicktime.QTSession;
import quicktime.io.QTFile;
import quicktime.jdirect.QTNative;
import quicktime.jdirect.QuickTimeLib;
import quicktime.qd.GDevice;
import quicktime.qd.Pict;
import quicktime.qd.QDColor;
import quicktime.qd.QDGraphics;
import quicktime.qd.QDRect;
import quicktime.qd.Region;
import quicktime.std.StdQTException;
import quicktime.std.comp.Component;
import quicktime.std.image.GraphicsExporter;
import quicktime.std.image.GraphicsImporterInfo;
import quicktime.std.image.GraphicsMode;
import quicktime.std.image.ImageDescription;
import quicktime.std.image.Matrix;
import quicktime.std.movies.AtomContainer;
import quicktime.std.movies.media.DataRef;
import quicktime.std.movies.media.UserData;
import quicktime.util.ByteEncodedImage;
import quicktime.util.EncodedImage;
import quicktime.util.IntEncodedImage;
import quicktime.util.QTHandle;
import quicktime.util.QTHandleRef;
import quicktime.util.RawEncodedImage;

public final class GraphicsImporter
extends Component
implements QuickTimeLib {
    private static Object linkage = QTNative.linkNativeMethods(class$quicktime$std$image$GraphicsImporter == null ? (class$quicktime$std$image$GraphicsImporter = GraphicsImporter.class$("quicktime.std.image.GraphicsImporter")) : class$quicktime$std$image$GraphicsImporter);
    private static final int[] savedPort = new int[]{0};
    private static final int[] savedDevice = new int[]{0};
    private Object ref = null;
    static /* synthetic */ Class class$quicktime$std$image$GraphicsImporter;

    public static final GraphicsImporter fromGraphicsExporter(GraphicsExporter graphicsExporter) throws QTException {
        return new GraphicsImporter(graphicsExporter);
    }

    private GraphicsImporter(GraphicsExporter graphicsExporter) throws QTException {
        super(GraphicsImporter.allocate(graphicsExporter), null);
    }

    public GraphicsImporter(int n) throws QTException {
        super(1735551344, n);
    }

    public GraphicsImporter(QTFile qTFile) throws QTException {
        super(GraphicsImporter.allocate(qTFile), null);
    }

    public GraphicsImporter(QTFile qTFile, int n) throws QTException {
        super(GraphicsImporter.allocate(qTFile, n), null);
    }

    public GraphicsImporter(DataRef dataRef) throws QTException {
        super(GraphicsImporter.allocate(dataRef), null);
        this.ref = dataRef;
    }

    public GraphicsImporter(DataRef dataRef, int n) throws QTException {
        super(GraphicsImporter.allocate(dataRef, n), null);
        this.ref = dataRef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int allocate(QTFile qTFile) throws QTException {
        int[] nArray = new int[]{0};
        short s = 0;
        Object object = QTNative.globalsLock;
        synchronized (object) {
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                GraphicsImporter.GetGWorld(savedPort, savedDevice);
            }
            GraphicsImporter.SetGWorld(QTObject.ID(QDGraphics.scratch), 0);
            s = GraphicsImporter.GetGraphicsImporterForFile(qTFile.getFSSpec(true, 256), nArray);
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                GraphicsImporter.SetGWorld(savedPort[0], savedDevice[0]);
            }
        }
        StdQTException.checkError(s);
        return nArray[0];
    }

    private static int allocate(GraphicsExporter graphicsExporter) throws QTException {
        int[] nArray = new int[]{0};
        int n = GraphicsImporter.GraphicsExportGetInputGraphicsImporter(QTObject.ID(graphicsExporter), nArray);
        StdQTException.checkError(n);
        return nArray[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int allocate(QTFile qTFile, int n) throws QTException {
        int[] nArray = new int[]{0};
        short s = 0;
        Object object = QTNative.globalsLock;
        synchronized (object) {
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                GraphicsImporter.GetGWorld(savedPort, savedDevice);
            }
            GraphicsImporter.SetGWorld(QTObject.ID(QDGraphics.scratch), 0);
            s = GraphicsImporter.GetGraphicsImporterForFileWithFlags(qTFile.getFSSpec(true, 256), nArray, n);
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                GraphicsImporter.SetGWorld(savedPort[0], savedDevice[0]);
            }
        }
        StdQTException.checkError(s);
        return nArray[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int allocate(DataRef dataRef) throws QTException {
        int[] nArray = new int[]{0};
        short s = 0;
        Object object = QTNative.globalsLock;
        synchronized (object) {
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                GraphicsImporter.GetGWorld(savedPort, savedDevice);
            }
            GraphicsImporter.SetGWorld(QTObject.ID(QDGraphics.scratch), 0);
            s = GraphicsImporter.GetGraphicsImporterForDataRef(QTObject.ID(dataRef), dataRef.getType(), nArray);
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                GraphicsImporter.SetGWorld(savedPort[0], savedDevice[0]);
            }
        }
        StdQTException.checkError(s);
        if (nArray[0] == 0) {
            throw new StdQTException(-2012);
        }
        return nArray[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int allocate(DataRef dataRef, int n) throws QTException {
        int[] nArray = new int[]{0};
        short s = 0;
        Object object = QTNative.globalsLock;
        synchronized (object) {
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                GraphicsImporter.GetGWorld(savedPort, savedDevice);
            }
            GraphicsImporter.SetGWorld(QTObject.ID(QDGraphics.scratch), 0);
            s = GraphicsImporter.GetGraphicsImporterForDataRefWithFlags(QTObject.ID(dataRef), dataRef.getType(), nArray, n);
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                GraphicsImporter.SetGWorld(savedPort[0], savedDevice[0]);
            }
        }
        StdQTException.checkError(s);
        if (nArray[0] == 0) {
            throw new StdQTException(-2012);
        }
        return nArray[0];
    }

    public final void setDataReference(DataRef dataRef) throws StdQTException {
        int n = GraphicsImporter.GraphicsImportSetDataReference(this._ID(), QTObject.ID(dataRef), dataRef.getType());
        StdQTException.checkError(n);
        this.ref = dataRef;
    }

    public final int getDataReferenceType() throws StdQTException {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int n = GraphicsImporter.GraphicsImportGetDataReference(this._ID(), nArray, nArray2);
        StdQTException.checkError(n);
        return nArray2[0];
    }

    public final void setDataFile(QTFile qTFile) throws QTException {
        int n = GraphicsImporter.GraphicsImportSetDataFile(this._ID(), qTFile.getFSSpec(true, 256));
        StdQTException.checkError(n);
        this.ref = null;
    }

    public final QTFile getDataFile() throws QTException {
        return QTFile.fromGraphicsImporter(this);
    }

    public final void setDataHandle(QTHandleRef qTHandleRef) throws StdQTException {
        int n = GraphicsImporter.GraphicsImportSetDataHandle(this._ID(), QTObject.ID(qTHandleRef));
        StdQTException.checkError(n);
        this.ref = qTHandleRef;
    }

    public final QTHandle getDataHandle() throws QTException {
        return QTHandle.fromGraphicsImporterData(this);
    }

    public final ImageDescription getImageDescription() throws StdQTException {
        return ImageDescription.fromGraphicsImporter(this);
    }

    public final int getDataOffset() throws StdQTException {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int n = GraphicsImporter.GraphicsImportGetDataOffsetAndSize(this._ID(), nArray, nArray2);
        StdQTException.checkError(n);
        return nArray[0];
    }

    public final int getDataSize() throws StdQTException {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int n = GraphicsImporter.GraphicsImportGetDataOffsetAndSize(this._ID(), nArray, nArray2);
        StdQTException.checkError(n);
        return nArray2[0];
    }

    public final void readData(EncodedImage encodedImage, int n, int n2) throws StdQTException {
        int n3 = -50;
        if (encodedImage instanceof ByteEncodedImage) {
            n3 = GraphicsImporter.GraphicsImportReadData(this._ID(), ((ByteEncodedImage)encodedImage).getBytes(), n, n2);
        } else if (encodedImage instanceof IntEncodedImage) {
            n3 = GraphicsImporter.GraphicsImportReadData(this._ID(), ((IntEncodedImage)encodedImage).getInts(), n, n2);
        } else if (encodedImage instanceof RawEncodedImage) {
            n3 = GraphicsImporter.GraphicsImportReadData(this._ID(), QTObject.ID((RawEncodedImage)encodedImage), n, n2);
        }
        StdQTException.checkError(n3);
    }

    public final void setClip(Region region) throws StdQTException {
        int n = GraphicsImporter.GraphicsImportSetClip(this._ID(), QTObject.ID(region));
        StdQTException.checkError(n);
    }

    public final Region getClip() throws QTException {
        return Region.fromGraphicsImporter(this);
    }

    public final void setSourceRect(QDRect qDRect) throws StdQTException {
        int n = GraphicsImporter.GraphicsImportSetSourceRect(this._ID(), qDRect.getRect());
        StdQTException.checkError(n);
    }

    public final QDRect getSourceRect() throws StdQTException {
        QDRect qDRect = new QDRect();
        int n = GraphicsImporter.GraphicsImportGetSourceRect(this._ID(), qDRect.getRect());
        StdQTException.checkError(n);
        return qDRect;
    }

    public final QDRect getNaturalBounds() throws StdQTException {
        QDRect qDRect = new QDRect();
        int n = GraphicsImporter.GraphicsImportGetNaturalBounds(this._ID(), qDRect.getRect());
        StdQTException.checkError(n);
        return qDRect;
    }

    public final void draw() throws StdQTException {
        int n = GraphicsImporter.GraphicsImportDraw(this._ID());
        StdQTException.checkError(n);
    }

    public final void setMatrix(Matrix matrix) throws StdQTException {
        int n = GraphicsImporter.GraphicsImportSetMatrix(this._ID(), matrix.getBytes());
        StdQTException.checkError(n);
    }

    public final Matrix getMatrix() throws StdQTException {
        Matrix matrix = new Matrix();
        int n = GraphicsImporter.GraphicsImportGetMatrix(this._ID(), matrix.getBytes());
        StdQTException.checkError(n);
        return matrix;
    }

    public final void setBoundsRect(QDRect qDRect) throws StdQTException {
        int n = GraphicsImporter.GraphicsImportSetBoundsRect(this._ID(), qDRect.getRect());
        StdQTException.checkError(n);
    }

    public final QDRect getBoundsRect() throws StdQTException {
        QDRect qDRect = new QDRect();
        int n = GraphicsImporter.GraphicsImportGetBoundsRect(this._ID(), qDRect.getRect());
        StdQTException.checkError(n);
        return qDRect;
    }

    public final void saveAsPicture(QTFile qTFile, int n) throws QTException {
        int n2 = GraphicsImporter.GraphicsImportSaveAsPicture(this._ID(), qTFile.getFSSpec(false, 512), n);
        StdQTException.checkError(n2);
    }

    public final void saveAsQuickTimeImageFile(QTFile qTFile, int n) throws QTException {
        int n2 = GraphicsImporter.GraphicsImportSaveAsQuickTimeImageFile(this._ID(), qTFile.getFSSpec(false, 512), n);
        StdQTException.checkError(n2);
    }

    public final void setGraphicsMode(GraphicsMode graphicsMode) throws StdQTException {
        int n = GraphicsImporter.GraphicsImportSetGraphicsMode(this._ID(), graphicsMode.getGraphicsMode(), graphicsMode.getColor().getRGBColor());
        StdQTException.checkError(n);
    }

    public final GraphicsMode getGraphicsMode() throws StdQTException {
        int[] nArray = new int[1];
        byte[] byArray = new byte[6];
        int n = GraphicsImporter.GraphicsImportGetGraphicsMode(this._ID(), nArray, byArray);
        StdQTException.checkError(n);
        return new GraphicsMode(nArray[0], QDColor.fromArray(byArray, 6));
    }

    public final void setQuality(int n) throws StdQTException {
        int n2 = GraphicsImporter.GraphicsImportSetQuality(this._ID(), n);
        StdQTException.checkError(n2);
    }

    public final int getQuality() throws StdQTException {
        int[] nArray = new int[1];
        int n = GraphicsImporter.GraphicsImportGetQuality(this._ID(), nArray);
        StdQTException.checkError(n);
        return nArray[0];
    }

    public final QTHandle getAliasedDataReference() throws QTException {
        return QTHandle.fromGraphicsImporterAlias(this);
    }

    public final int getAliasedDataType() throws StdQTException {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int n = GraphicsImporter.GraphicsImportGetAliasedDataReference(this._ID(), nArray, nArray2);
        StdQTException.checkError(n);
        return nArray2[0];
    }

    public final void setGWorld(QDGraphics qDGraphics, GDevice gDevice) throws StdQTException {
        int n = GraphicsImporter.GraphicsImportSetGWorld(this._ID(), QTObject.ID(qDGraphics), QTObject.ID(gDevice));
        StdQTException.checkError(n);
    }

    public final QDGraphics getGWorld() throws StdQTException {
        return QDGraphics.fromGraphicsImporter(this);
    }

    public final boolean validate() throws StdQTException {
        int[] nArray = new int[1];
        int n = GraphicsImporter.GraphicsImportValidate(this._ID(), nArray);
        StdQTException.checkError(n);
        return nArray[0] != 0;
    }

    public final int doesDrawAllPixels() throws StdQTException {
        short[] sArray = new short[]{0};
        int n = GraphicsImporter.GraphicsImportDoesDrawAllPixels(this._ID(), sArray);
        if (n == -2147450878) {
            return 0;
        }
        StdQTException.checkError(n);
        return sArray[0];
    }

    public Pict getAsPicture() throws QTException {
        return Pict.fromGraphicsImporter(this);
    }

    public UserData getMetaData(GraphicsImporter graphicsImporter) throws QTException {
        UserData userData = new UserData();
        int n = GraphicsImporter.GraphicsImportGetMetaData(QTObject.ID(graphicsImporter), QTObject.ID(userData));
        StdQTException.checkError(n);
        return userData;
    }

    public AtomContainer getMIMETypeList() throws StdQTException {
        return AtomContainer.fromGraphicsImporterMIME(this);
    }

    public void exportImageFile(int n, int n2, QTFile qTFile, int n3) throws QTException {
        short s = GraphicsImporter.GraphicsImportExportImageFile(this._ID(), n, n2, qTFile.getFSSpec(false, 512), (short)n3);
        StdQTException.checkError(s);
    }

    public final AtomContainer getExportImageTypeList() throws StdQTException {
        return AtomContainer.fromGraphicsImporterExportImage(this);
    }

    public final AtomContainer getExportSettingsAsAtomContainer() throws StdQTException {
        return AtomContainer.fromGraphicsImporterExportSettings(this);
    }

    public final void setExportSettingsFromAtomContainer(AtomContainer atomContainer) throws StdQTException {
        int[] nArray = new int[]{0};
        nArray[0] = QTObject.ID(atomContainer);
        int n = GraphicsImporter.GraphicsImportSetExportSettingsFromAtomContainer(this._ID(), nArray);
        StdQTException.checkError(n);
    }

    public final GraphicsImporterInfo doExportImageFileDialog(QTFile qTFile, String string) throws QTException {
        return QTFile.fromGraphicsImporter(this, qTFile, string);
    }

    public final void setDataReferenceOffsetAndLimit(int n, int n2) throws StdQTException {
        int n3 = GraphicsImporter.GraphicsImportSetDataReferenceOffsetAndLimit(this._ID(), n, n2);
        StdQTException.checkError(n3);
    }

    public final int[] getDataReferenceOffsetAndLimit() throws StdQTException {
        int[] nArray = new int[]{0};
        int[] nArray2 = new int[]{0};
        int[] nArray3 = new int[2];
        int n = GraphicsImporter.GraphicsImportGetDataReferenceOffsetAndLimit(this._ID(), nArray, nArray2);
        StdQTException.checkError(n);
        nArray3[0] = nArray[0];
        nArray3[1] = nArray2[0];
        return nArray3;
    }

    public final int getImageCount() throws StdQTException {
        int[] nArray = new int[]{0};
        int n = GraphicsImporter.GraphicsImportGetImageCount(this._ID(), nArray);
        StdQTException.checkError(n);
        return nArray[0];
    }

    public final void setImageIndex(int n) throws StdQTException {
        int n2 = GraphicsImporter.GraphicsImportSetImageIndex(this._ID(), n);
        StdQTException.checkError(n2);
    }

    public final int getImageIndex() throws StdQTException {
        int[] nArray = new int[]{0};
        int n = GraphicsImporter.GraphicsImportGetImageIndex(this._ID(), nArray);
        StdQTException.checkError(n);
        return nArray[0];
    }

    public final Matrix getDefaultMatrix() throws StdQTException {
        Matrix matrix = new Matrix();
        int n = GraphicsImporter.GraphicsImportGetDefaultMatrix(this._ID(), matrix.getBytes());
        StdQTException.checkError(n);
        return matrix;
    }

    public final Region getDefaultClip() throws QTException {
        return Region.fromGraphicsImporterDefault(this);
    }

    public final GraphicsMode getDefaultGraphicsMode() throws QTException {
        int[] nArray = new int[]{0};
        QDColor qDColor = new QDColor();
        int n = GraphicsImporter.GraphicsImportGetDefaultGraphicsMode(this._ID(), nArray, qDColor.getRGBColor());
        StdQTException.checkError(n);
        return new GraphicsMode(nArray[0], qDColor);
    }

    public final QDRect getDefaultSourceRect() throws QTException {
        QDRect qDRect = new QDRect();
        int n = GraphicsImporter.GraphicsImportGetDefaultSourceRect(this._ID(), qDRect.getBytes());
        return qDRect;
    }

    public final void setDestRect(QDRect qDRect) throws QTException {
        int n = GraphicsImporter.GraphicsImportSetDestRect(this._ID(), qDRect.getBytes());
    }

    public final QDRect getDestRect() throws QTException {
        QDRect qDRect = new QDRect();
        int n = GraphicsImporter.GraphicsImportGetDestRect(this._ID(), qDRect.getBytes());
        return qDRect;
    }

    public final void setFlags(int n) throws QTException {
        int n2 = GraphicsImporter.GraphicsImportSetFlags(this._ID(), n);
    }

    public final int getFlags() throws QTException {
        int[] nArray = new int[]{0};
        int n = GraphicsImporter.GraphicsImportGetFlags(this._ID(), nArray);
        return nArray[0];
    }

    private static native int GraphicsExportGetInputGraphicsImporter(int var0, int[] var1);

    private static native short GetGraphicsImporterForFile(byte[] var0, int[] var1);

    private static native short GetGraphicsImporterForFileWithFlags(byte[] var0, int[] var1, int var2);

    private static native short GetGraphicsImporterForDataRef(int var0, int var1, int[] var2);

    private static native short GetGraphicsImporterForDataRefWithFlags(int var0, int var1, int[] var2, int var3);

    private static native int GraphicsImportSetDataReference(int var0, int var1, int var2);

    private static native int GraphicsImportGetDataReference(int var0, int[] var1, int[] var2);

    private static native int GraphicsImportSetDataFile(int var0, byte[] var1);

    private static native int GraphicsImportSetDataHandle(int var0, int var1);

    private static native int GraphicsImportGetDataOffsetAndSize(int var0, int[] var1, int[] var2);

    private static native int GraphicsImportReadData(int var0, int var1, int var2, int var3);

    private static native int GraphicsImportReadData(int var0, byte[] var1, int var2, int var3);

    private static native int GraphicsImportReadData(int var0, int[] var1, int var2, int var3);

    private static native int GraphicsImportSetClip(int var0, int var1);

    private static native int GraphicsImportSetSourceRect(int var0, byte[] var1);

    private static native int GraphicsImportGetSourceRect(int var0, byte[] var1);

    private static native int GraphicsImportGetNaturalBounds(int var0, byte[] var1);

    private static native int GraphicsImportDraw(int var0);

    private static native int GraphicsImportSetMatrix(int var0, byte[] var1);

    private static native int GraphicsImportGetMatrix(int var0, byte[] var1);

    private static native int GraphicsImportSetBoundsRect(int var0, byte[] var1);

    private static native int GraphicsImportGetBoundsRect(int var0, byte[] var1);

    private static native int GraphicsImportSaveAsPicture(int var0, byte[] var1, int var2);

    private static native int GraphicsImportSaveAsQuickTimeImageFile(int var0, byte[] var1, int var2);

    private static native int GraphicsImportSetGraphicsMode(int var0, int var1, byte[] var2);

    private static native int GraphicsImportGetGraphicsMode(int var0, int[] var1, byte[] var2);

    private static native int GraphicsImportSetQuality(int var0, int var1);

    private static native int GraphicsImportGetQuality(int var0, int[] var1);

    private static native int GraphicsImportGetAliasedDataReference(int var0, int[] var1, int[] var2);

    private static native int GraphicsImportSetGWorld(int var0, int var1, int var2);

    private static native int GraphicsImportValidate(int var0, int[] var1);

    private static native int GraphicsImportDoesDrawAllPixels(int var0, short[] var1);

    private static native int GraphicsImportGetMetaData(int var0, int var1);

    private static native short GraphicsImportExportImageFile(int var0, int var1, int var2, byte[] var3, short var4);

    private static native int GraphicsImportSetExportSettingsFromAtomContainer(int var0, int[] var1);

    private static native void SetGWorld(int var0, int var1);

    private static native void GetGWorld(int[] var0, int[] var1);

    private static native int GraphicsImportSetDataReferenceOffsetAndLimit(int var0, int var1, int var2);

    private static native int GraphicsImportGetDataReferenceOffsetAndLimit(int var0, int[] var1, int[] var2);

    private static native int GraphicsImportGetImageCount(int var0, int[] var1);

    private static native int GraphicsImportSetImageIndex(int var0, int var1);

    private static native int GraphicsImportGetImageIndex(int var0, int[] var1);

    private static native int GraphicsImportGetDefaultMatrix(int var0, byte[] var1);

    private static native int GraphicsImportGetDefaultGraphicsMode(int var0, int[] var1, byte[] var2);

    private static native int GraphicsImportGetDefaultSourceRect(int var0, byte[] var1);

    private static native int GraphicsImportSetDestRect(int var0, byte[] var1);

    private static native int GraphicsImportGetDestRect(int var0, byte[] var1);

    private static native int GraphicsImportSetFlags(int var0, int var1);

    private static native int GraphicsImportGetFlags(int var0, int[] var1);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

