/*
 * Decompiled with CFR 0.152.
 */
package quicktime.std.image;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import quicktime.QTObject;
import quicktime.jdirect.PrimitivesLib;
import quicktime.jdirect.QTNative;
import quicktime.std.clocks.TimeBase;
import quicktime.util.EndianOrder;
import quicktime.util.QTByteObject;
import quicktime.util.QTUtils;

public final class ICMFrameTime
extends QTByteObject
implements PrimitivesLib,
Cloneable {
    private static Object linkage = QTNative.linkNativeMethods(class$quicktime$std$image$ICMFrameTime == null ? (class$quicktime$std$image$ICMFrameTime = ICMFrameTime.class$("quicktime.std.image.ICMFrameTime")) : class$quicktime$std$image$ICMFrameTime);
    public static final int kNativeSize = 48;
    static final long serialVersionUID = 8668877262716984973L;
    static /* synthetic */ Class class$quicktime$std$image$ICMFrameTime;

    public ICMFrameTime() {
        super(48);
        this.setRecordSize(48);
        this.setFlags(1);
    }

    private ICMFrameTime(byte[] byArray) {
        super(byArray);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        this.bytes = new byte[48];
        objectInputStream.read(this.bytes);
        long l = ICMFrameTime.getLongFromArray(this.bytes, 0);
        ICMFrameTime.setLongInArray(this.bytes, 0, EndianOrder.flipBigEndianToNative64(l));
        int n = ICMFrameTime.getIntFromArray(this.bytes, 8);
        ICMFrameTime.setIntInArray(this.bytes, 8, EndianOrder.flipBigEndianToNative32(n));
        ICMFrameTime.setIntInArray(this.bytes, 12, 0);
        int n2 = 16;
        while (n2 < 36) {
            int n3 = ICMFrameTime.getIntFromArray(this.bytes, n2);
            int n4 = EndianOrder.flipBigEndianToNative32(n3);
            ICMFrameTime.setIntInArray(this.bytes, n2, n4);
            n2 += 4;
        }
        long l2 = ICMFrameTime.getLongFromArray(this.bytes, 36);
        ICMFrameTime.setLongInArray(this.bytes, 36, EndianOrder.flipBigEndianToNative64(l2));
        int n5 = ICMFrameTime.getIntFromArray(this.bytes, 44);
        ICMFrameTime.setIntInArray(this.bytes, 44, EndianOrder.flipNativeToBigEndian32(n5));
        this.setBase(TimeBase.fromICMFrameTime(this));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        byte[] byArray = new byte[48];
        long l = this.getValue();
        ICMFrameTime.setLongInArray(byArray, 0, EndianOrder.flipNativeToBigEndian64(l));
        int n = this.getScale();
        ICMFrameTime.setIntInArray(byArray, 8, EndianOrder.flipNativeToBigEndian32(n));
        ICMFrameTime.setIntInArray(byArray, 12, 0);
        int n2 = 16;
        while (n2 < 36) {
            int n3 = ICMFrameTime.getIntFromArray(this.getBytes(), n2);
            int n4 = EndianOrder.flipNativeToBigEndian32(n3);
            ICMFrameTime.setIntInArray(byArray, n2, n4);
            n2 += 4;
        }
        long l2 = this.getVirtualStartTime();
        ICMFrameTime.setLongInArray(byArray, 36, EndianOrder.flipNativeToBigEndian64(l2));
        int n5 = this.getVirtualDuration();
        ICMFrameTime.setIntInArray(byArray, 44, EndianOrder.flipNativeToBigEndian32(n5));
        objectOutputStream.write(byArray);
    }

    private void setRecordSize(int n) {
        this.setIntAt(24, n);
    }

    public void setValue(long l) {
        this.setLongAt(0, l);
    }

    public void setScale(int n) {
        this.setIntAt(8, n);
    }

    public void setDuration(int n) {
        this.setIntAt(16, n);
    }

    public void setRate(float f) {
        this.setIntAt(20, QTUtils.X2Fix(f));
    }

    public void setFrameNumber(int n) {
        this.setIntAt(28, n);
    }

    public long getValue() {
        return this.getLongAt(0);
    }

    public int getScale() {
        return this.getIntAt(8);
    }

    public TimeBase getBase() {
        return TimeBase.fromICMFrameTime(this);
    }

    public void setBase(TimeBase timeBase) {
        this.setIntAt(12, QTObject.ID(timeBase));
    }

    public int getDuration() {
        return this.getIntAt(16);
    }

    public float getRate() {
        return QTUtils.Fix2X(this.getIntAt(20));
    }

    public int getFrameNumber() {
        return this.getIntAt(28);
    }

    public void setFlags(int n) {
        this.setIntAt(32, n);
    }

    public int getFlags() {
        return this.getIntAt(32);
    }

    public void setVirtualStartTime(long l) {
        this.setLongAt(36, l);
    }

    public long getVirtualStartTime() {
        return this.getLongAt(36);
    }

    public void setVirtualDuration(int n) {
        this.setIntAt(44, n);
    }

    public int getVirtualDuration() {
        return this.getIntAt(44);
    }

    public Object clone() {
        return new ICMFrameTime(this.bytes);
    }

    public String toString() {
        return this.getClass().getName();
    }

    private static native void setLongInArray(byte[] var0, int var1, long var2);

    private static native void setIntInArray(byte[] var0, int var1, int var2);

    private static native long getLongFromArray(byte[] var0, int var1);

    private static native int getIntFromArray(byte[] var0, int var1);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

