/*
 * Decompiled with CFR 0.152.
 */
package quicktime.std.image;

import quicktime.QTException;
import quicktime.QTObject;
import quicktime.QTSession;
import quicktime.jdirect.QTNative;
import quicktime.jdirect.QuickTimeLib;
import quicktime.qd.ColorTable;
import quicktime.qd.PixMap;
import quicktime.qd.QDGraphics;
import quicktime.qd.QDRect;
import quicktime.std.StdQTException;
import quicktime.std.anim.Sprite;
import quicktime.std.image.GraphicsExporter;
import quicktime.std.image.GraphicsImporter;
import quicktime.std.image.ImageDescription;
import quicktime.std.image.QTImage;
import quicktime.std.movies.AtomContainer;
import quicktime.std.movies.media.SampleDescription;
import quicktime.std.qtcomponents.ImageCompressionDialog;
import quicktime.util.EndianDescriptor;
import quicktime.util.EndianFlipSpec;
import quicktime.util.QTHandle;
import quicktime.util.QTHandleRef;
import quicktime.util.QTUtils;
import quicktime.util.RawEncodedImage;
import quicktime.util.UtilException;

public class ImageDescription
extends SampleDescription
implements QuickTimeLib {
    private static Object linkage = QTNative.linkNativeMethods(class$quicktime$std$image$ImageDescription == null ? (class$quicktime$std$image$ImageDescription = ImageDescription.class$("quicktime.std.image.ImageDescription")) : class$quicktime$std$image$ImageDescription);
    private static EndianDescriptor ed;
    public static final int kNativeSize = 86;
    private static final int[] savedPort;
    private static final int[] savedDevice;
    static /* synthetic */ Class class$quicktime$std$image$ImageDescription;

    protected static EndianDescriptor makeED() {
        EndianDescriptor endianDescriptor = SampleDescription.makeED();
        EndianFlipSpec endianFlipSpec = new EndianFlipSpec(16, 2, 2);
        endianDescriptor.addFlipSpec(endianFlipSpec);
        EndianFlipSpec endianFlipSpec2 = new EndianFlipSpec(20, 4, 3);
        endianDescriptor.addFlipSpec(endianFlipSpec2);
        EndianFlipSpec endianFlipSpec3 = new EndianFlipSpec(32, 2, 2);
        endianDescriptor.addFlipSpec(endianFlipSpec3);
        EndianFlipSpec endianFlipSpec4 = new EndianFlipSpec(36, 4, 2);
        endianDescriptor.addFlipSpec(endianFlipSpec4);
        EndianFlipSpec endianFlipSpec5 = new EndianFlipSpec(44, 4, 1);
        endianDescriptor.addFlipSpec(endianFlipSpec5);
        EndianFlipSpec endianFlipSpec6 = new EndianFlipSpec(48, 2, 1);
        endianDescriptor.addFlipSpec(endianFlipSpec6);
        EndianFlipSpec endianFlipSpec7 = new EndianFlipSpec(82, 2, 2);
        endianDescriptor.addFlipSpec(endianFlipSpec7);
        return endianDescriptor;
    }

    public static EndianDescriptor getEndianDescriptor() {
        if (ed == null) {
            ed = ImageDescription.makeED();
        }
        return ed;
    }

    public static ImageDescription fromGraphicsExporter(GraphicsExporter graphicsExporter) throws StdQTException {
        int[] nArray = new int[1];
        int n = ImageDescription.GraphicsExportGetInputImageDescription(QTObject.ID(graphicsExporter), nArray);
        StdQTException.checkError(n);
        return new ImageDescription(nArray[0], null);
    }

    public static ImageDescription fromGraphicsExporterCompressor(GraphicsExporter graphicsExporter, AtomContainer atomContainer) throws StdQTException {
        int[] nArray = new int[]{0};
        int n = ImageDescription.GraphicsExportDoUseCompressor(QTObject.ID(graphicsExporter), QTObject.ID(atomContainer), nArray);
        StdQTException.checkError(n);
        return new ImageDescription(nArray[0], graphicsExporter);
    }

    public static ImageDescription fromGraphicsImporter(GraphicsImporter graphicsImporter) throws StdQTException {
        int[] nArray = new int[1];
        int n = ImageDescription.GraphicsImportGetImageDescription(QTObject.ID(graphicsImporter), nArray);
        StdQTException.checkError(n);
        return new ImageDescription(nArray[0], null);
    }

    public static ImageDescription fromSprite(Sprite sprite) throws StdQTException {
        int[] nArray = new int[]{0};
        short s = ImageDescription.GetSpriteProperty(QTObject.ID(sprite), 2, nArray);
        StdQTException.checkError(s);
        return new ImageDescription(nArray[0], sprite);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static QTImage fromImageCompressionDialog(ImageCompressionDialog imageCompressionDialog, QDGraphics qDGraphics, QDRect qDRect) throws QTException {
        byte[] byArray = qDRect != null ? qDRect.getRect() : null;
        int[] nArray = new int[]{0};
        int[] nArray2 = new int[]{0};
        if (qDGraphics == null) {
            throw new StdQTException(-50);
        }
        int n = 0;
        Object object = QTNative.globalsLock;
        synchronized (object) {
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                ImageDescription.GetGWorld(savedPort, savedDevice);
            }
            ImageDescription.SetGWorld(QTObject.ID(qDGraphics), 0);
            n = ImageDescription.SCCompressImage(QTObject.ID(imageCompressionDialog), QTObject.ID(qDGraphics.getPixMap()), byArray, nArray, nArray2);
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                ImageDescription.SetGWorld(savedPort[0], savedDevice[0]);
            }
        }
        if (n == 1) {
            throw new StdQTException(-128);
        }
        StdQTException.checkError(n);
        class ImageHdl
        extends QTHandleRef {
            ImageHdl(int n, Object object) {
                super(n, object, false);
            }
        }
        ImageHdl imageHdl = new ImageHdl(nArray2[0], null);
        imageHdl.lockHigh();
        return new QTImage(new ImageDescription(nArray[0], null), RawEncodedImage.fromQTHandle(imageHdl));
    }

    public static ImageDescription getJavaDefaultPixelDescription(int n, int n2) throws QTException {
        ImageDescription imageDescription = null;
        imageDescription = QTSession.isCurrentOS(2) ? new ImageDescription(QDGraphics.kDefaultPixelFormat) : new ImageDescription(1918990112);
        imageDescription.setDepth(32);
        imageDescription.setSpatialQuality(512);
        imageDescription.setWidth(n);
        imageDescription.setHeight(n2);
        imageDescription.setHRes(72.0f);
        imageDescription.setVRes(72.0f);
        imageDescription.setFrameCount(1);
        imageDescription.setClutID(-1);
        return (ImageDescription)imageDescription.clone();
    }

    public static ImageDescription forEffect(int n) throws QTException {
        return new ImageDescription(ImageDescription.allocate(n), null);
    }

    public ImageDescription(int n) throws QTException {
        super(86, true, n);
    }

    public ImageDescription(PixMap pixMap) throws QTException {
        this(ImageDescription.allocate(pixMap), null);
    }

    protected ImageDescription(int n, Object object) {
        super(n, object, false);
    }

    private static int allocate(PixMap pixMap) throws QTException {
        int[] nArray = new int[]{0};
        StdQTException.checkError(ImageDescription.MakeImageDescriptionForPixMap(QTObject.ID(pixMap), nArray));
        return nArray[0];
    }

    private static int allocate(int n) throws QTException {
        int[] nArray = new int[]{0};
        StdQTException.checkError(ImageDescription.MakeImageDescriptionForEffect(n, nArray));
        return nArray[0];
    }

    public Object clone() {
        return new ImageDescription(this.makeAndCopyHandle(), null);
    }

    public void setCTable(ColorTable colorTable) throws StdQTException {
        StdQTException.checkError(ImageDescription.SetImageDescriptionCTable(this._ID(), QTObject.ID(colorTable)));
    }

    public ColorTable getCTable() throws QTException {
        return ColorTable.fromImageDescription(this);
    }

    public int countExtensionType(int n) throws StdQTException {
        int[] nArray = new int[1];
        StdQTException.checkError(ImageDescription.CountImageDescriptionExtensionType(this._ID(), n, nArray));
        return nArray[0];
    }

    public int getNextExtensionType() throws StdQTException {
        int[] nArray = new int[1];
        StdQTException.checkError(ImageDescription.GetNextImageDescriptionExtensionType(this._ID(), nArray));
        return nArray[0];
    }

    public void addExtension(int n, QTHandle qTHandle) throws StdQTException {
        StdQTException.checkError(ImageDescription.AddImageDescriptionExtension(this._ID(), QTObject.ID(qTHandle), n));
    }

    public void removeExtension(int n, int n2) throws StdQTException {
        StdQTException.checkError(ImageDescription.RemoveImageDescriptionExtension(this._ID(), n, n2));
    }

    public QTHandle getExtension(int n, int n2) throws StdQTException {
        return QTHandle.fromImageDescription(this, n, n2);
    }

    public QDGraphics newGWorld(int n) throws QTException {
        return new QDGraphics(this, n);
    }

    public int getIdSize() {
        return this.getIntAt(0);
    }

    public int getCType() {
        return this.getIntAt(4);
    }

    public int getVersion() {
        return this.getShortAt(16);
    }

    public int getRevisionLevel() {
        return this.getShortAt(18);
    }

    public int getVendor() {
        return this.getIntAt(20);
    }

    public int getTemporalQuality() {
        return this.getIntAt(24);
    }

    public int getSpatialQuality() {
        return this.getIntAt(28);
    }

    public int getWidth() {
        return this.getShortAt(32);
    }

    public int getHeight() {
        return this.getShortAt(34);
    }

    public QDRect getBounds() {
        return new QDRect(0, 0, this.getShortAt(32), this.getShortAt(34));
    }

    public float getHRes() {
        return QTUtils.Fix2X(this.getIntAt(36));
    }

    public float getVRes() {
        return QTUtils.Fix2X(this.getIntAt(40));
    }

    public int getDataSize() {
        return this.getIntAt(44);
    }

    public int getFrameCount() {
        return this.getShortAt(48);
    }

    public String getName() throws UtilException {
        return this.getPStringAt(50);
    }

    public int getDepth() {
        return this.getShortAt(82);
    }

    public int getClutID() {
        return this.getShortAt(84);
    }

    public void setCType(int n) {
        this.setIntAt(4, n);
    }

    public void setVersion(int n) {
        this.setShortAt(16, (short)n);
    }

    public void setRevisionLevel(int n) {
        this.setShortAt(18, (short)n);
    }

    public void setVendor(int n) {
        this.setIntAt(20, n);
    }

    public void setTemporalQuality(int n) {
        this.setIntAt(24, n);
    }

    public void setSpatialQuality(int n) {
        this.setIntAt(28, n);
    }

    public void setWidth(int n) {
        this.setShortAt(32, (short)n);
    }

    public void setHeight(int n) {
        this.setShortAt(34, (short)n);
    }

    public void setHRes(float f) {
        this.setIntAt(36, QTUtils.X2Fix(f));
    }

    public void setVRes(float f) {
        this.setIntAt(40, QTUtils.X2Fix(f));
    }

    public void setDataSize(int n) {
        this.setIntAt(44, n);
    }

    public void setFrameCount(int n) {
        this.setShortAt(48, (short)n);
    }

    public void setName(String string) throws UtilException {
        this.setPStringAt(50, 31, string);
    }

    public void setDepth(int n) {
        this.setShortAt(82, (short)n);
    }

    public void setClutID(int n) {
        this.setShortAt(84, (short)n);
    }

    public String toString() {
        String string = "";
        try {
            string = this.getName();
        }
        catch (QTException qTException) {
            // empty catch block
        }
        return this.getClass().getName() + "[cType=" + QTUtils.fromOSType(this.getCType()) + ",temporalQuality=" + this.getTemporalQuality() + ",spatialQulity=" + this.getSpatialQuality() + ",width=" + this.getWidth() + ",height=" + this.getHeight() + ",dataSize=" + this.getDataSize() + ",frameCount=" + this.getFrameCount() + ",name=" + string + ",depth=" + this.getDepth() + "]";
    }

    private static native int GraphicsExportDoUseCompressor(int var0, int var1, int[] var2);

    private static native int GraphicsExportGetInputImageDescription(int var0, int[] var1);

    private static native int GraphicsImportGetImageDescription(int var0, int[] var1);

    private static native short GetSpriteProperty(int var0, int var1, int[] var2);

    private static native int SCCompressImage(int var0, int var1, byte[] var2, int[] var3, int[] var4);

    private static native short MakeImageDescriptionForPixMap(int var0, int[] var1);

    private static native short SetImageDescriptionCTable(int var0, int var1);

    private static native short GetImageDescriptionExtension(int var0, int[] var1, int var2, int var3);

    private static native short AddImageDescriptionExtension(int var0, int var1, int var2);

    private static native short RemoveImageDescriptionExtension(int var0, int var1, int var2);

    private static native short CountImageDescriptionExtensionType(int var0, int var1, int[] var2);

    private static native short GetNextImageDescriptionExtensionType(int var0, int[] var1);

    private static native short MakeImageDescriptionForEffect(int var0, int[] var1);

    private static native void SetGWorld(int var0, int var1);

    private static native void GetGWorld(int[] var0, int[] var1);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        savedPort = new int[]{0};
        savedDevice = new int[]{0};
    }
}

