/*
 * Decompiled with CFR 0.152.
 */
package quicktime.std.image;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import quicktime.QTException;
import quicktime.QTObject;
import quicktime.QTSession;
import quicktime.jdirect.QTNative;
import quicktime.jdirect.QuickTimeLib;
import quicktime.qd.QDPoint;
import quicktime.qd.QDRect;
import quicktime.qd.Region;
import quicktime.std.StdQTException;
import quicktime.util.EndianOrder;
import quicktime.util.QTByteObject;
import quicktime.util.QTUtils;

public final class Matrix
extends QTByteObject
implements QuickTimeLib,
Cloneable {
    private static Object linkage = QTNative.linkNativeMethods(class$quicktime$std$image$Matrix == null ? (class$quicktime$std$image$Matrix = Matrix.class$("quicktime.std.image.Matrix")) : class$quicktime$std$image$Matrix);
    public static final int kNativeSize = 36;
    private static final long serialVersionUID = -3479751345142891528L;
    static /* synthetic */ Class class$quicktime$std$image$Matrix;

    public Matrix() {
        super(36);
        this.setIdentity();
    }

    private Matrix(byte[] byArray) {
        super(byArray);
    }

    public Matrix(float[][] fArray) {
        super(36);
        this.setSx(fArray[0][0]);
        this.setB(fArray[0][1]);
        this.setU(fArray[0][2]);
        this.setC(fArray[1][0]);
        this.setSy(fArray[1][1]);
        this.setV(fArray[1][2]);
        this.setTx(fArray[2][0]);
        this.setTy(fArray[2][1]);
        this.setW(fArray[2][2]);
    }

    public Matrix(QDPoint[] qDPointArray, QDPoint[] qDPointArray2) throws QTException {
        this();
        if (qDPointArray.length < 4 || qDPointArray2.length < 4 || QTSession.getQTMajorVersion() < 4) {
            throw new StdQTException(-50);
        }
        int[] nArray = Matrix.DoublePts2FixedPts(qDPointArray);
        int[] nArray2 = Matrix.DoublePts2FixedPts(qDPointArray2);
        short s = Matrix.QuadToQuadMatrix(nArray, nArray2, this.getBytes());
        StdQTException.checkError(s);
    }

    private static int[] DoublePts2FixedPts(QDPoint[] qDPointArray) throws QTException {
        if (qDPointArray == null) {
            return null;
        }
        int[] nArray = new int[qDPointArray.length * 2];
        int n = 0;
        while (n < qDPointArray.length) {
            nArray[n * 2] = QTUtils.X2Fix(qDPointArray[n].getXF());
            nArray[n * 2 + 1] = QTUtils.X2Fix(qDPointArray[n].getYF());
            ++n;
        }
        return nArray;
    }

    private static void FixedPts2DoublePts(int[] nArray, QDPoint[] qDPointArray) throws QTException {
        if (nArray == null || qDPointArray == null) {
            return;
        }
        int n = 0;
        while (n < qDPointArray.length) {
            qDPointArray[n].setX(QTUtils.Fix2X(nArray[n * 2]));
            qDPointArray[n].setY(QTUtils.Fix2X(nArray[n * 2 + 1]));
            ++n;
        }
    }

    private static int[] DoublePt2FixedPt(QDPoint qDPoint) throws QTException {
        if (qDPoint == null) {
            return null;
        }
        int[] nArray = new int[]{QTUtils.X2Fix(qDPoint.getXF()), QTUtils.X2Fix(qDPoint.getYF())};
        return nArray;
    }

    private static void FixedPt2DoublePt(int[] nArray, QDPoint qDPoint) throws QTException {
        if (nArray == null || qDPoint == null) {
            return;
        }
        qDPoint.setX(QTUtils.Fix2X(nArray[0]));
        qDPoint.setY(QTUtils.Fix2X(nArray[1]));
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        this.bytes = new byte[36];
        objectInputStream.read(this.bytes);
        int n = 0;
        while (n < 36) {
            int n2 = Matrix.getIntFromArray(this.bytes, n);
            int n3 = EndianOrder.flipBigEndianToNative32(n2);
            Matrix.setIntInArray(this.bytes, n, n3);
            n += 4;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        byte[] byArray = new byte[36];
        int n = 0;
        while (n < this.getBytes().length) {
            int n2 = Matrix.getIntFromArray(this.getBytes(), n);
            int n3 = EndianOrder.flipNativeToBigEndian32(n2);
            Matrix.setIntInArray(byArray, n, n3);
            n += 4;
        }
        objectOutputStream.write(byArray);
    }

    public void setTx(float f) {
        this.setIntAt(24, QTUtils.X2Fix(f));
    }

    public float getTx() {
        return QTUtils.Fix2X(this.getIntAt(24));
    }

    public void setTy(float f) {
        this.setIntAt(28, QTUtils.X2Fix(f));
    }

    public float getTy() {
        return QTUtils.Fix2X(this.getIntAt(28));
    }

    public void setSx(float f) {
        this.setIntAt(0, QTUtils.X2Fix(f));
    }

    public float getSx() {
        return QTUtils.Fix2X(this.getIntAt(0));
    }

    public void setSy(float f) {
        this.setIntAt(16, QTUtils.X2Fix(f));
    }

    public float getSy() {
        return QTUtils.Fix2X(this.getIntAt(16));
    }

    public void setB(float f) {
        this.setIntAt(4, QTUtils.X2Fix(f));
    }

    public float getB() {
        return QTUtils.Fix2X(this.getIntAt(4));
    }

    public void setU(float f) {
        this.setIntAt(8, QTUtils.X2Fract(f));
    }

    public float getU() {
        return QTUtils.Fract2X(this.getIntAt(8));
    }

    public void setC(float f) {
        this.setIntAt(12, QTUtils.X2Fix(f));
    }

    public float getC() {
        return QTUtils.Fix2X(this.getIntAt(12));
    }

    public void setV(float f) {
        this.setIntAt(20, QTUtils.X2Fract(f));
    }

    public float getV() {
        return QTUtils.Fract2X(this.getIntAt(20));
    }

    public void setW(float f) {
        this.setIntAt(32, QTUtils.X2Fract(f));
    }

    public float getW() {
        return QTUtils.Fract2X(this.getIntAt(32));
    }

    public short getType() {
        return Matrix.GetMatrixType(this.getBytes());
    }

    public boolean isIdentity() {
        return this.getType() == 0;
    }

    public void setIdentity() {
        Matrix.SetIdentityMatrix(this.getBytes());
    }

    public void translate(float f, float f2) {
        Matrix.TranslateMatrix(this.getBytes(), QTUtils.X2Fix(f), QTUtils.X2Fix(f2));
    }

    public void rotate(float f, float f2, float f3) {
        Matrix.RotateMatrix(this.getBytes(), QTUtils.X2Fix(f), QTUtils.X2Fix(f2), QTUtils.X2Fix(f3));
    }

    public void scale(float f, float f2, float f3, float f4) {
        Matrix.ScaleMatrix(this.getBytes(), QTUtils.X2Fix(f), QTUtils.X2Fix(f2), QTUtils.X2Fix(f3), QTUtils.X2Fix(f4));
    }

    public void skew(float f, float f2, float f3, float f4) {
        Matrix.SkewMatrix(this.getBytes(), QTUtils.X2Fix(f), QTUtils.X2Fix(f2), QTUtils.X2Fix(f3), QTUtils.X2Fix(f4));
    }

    public boolean inverse(Matrix matrix) {
        return Matrix.InverseMatrix(this.getBytes(), matrix.getBytes()) != 0;
    }

    public void concat(Matrix matrix) {
        Matrix.ConcatMatrix(this.getBytes(), matrix.getBytes());
    }

    public void transformDPoints(QDPoint qDPoint) throws QTException {
        int[] nArray = Matrix.DoublePt2FixedPt(qDPoint);
        short s = Matrix.TransformFixedPoints(this.getBytes(), nArray, 1);
        StdQTException.checkError(s);
        Matrix.FixedPt2DoublePt(nArray, qDPoint);
    }

    public void transformDPoints(QDPoint[] qDPointArray) throws QTException {
        int[] nArray = Matrix.DoublePts2FixedPts(qDPointArray);
        short s = Matrix.TransformFixedPoints(this.getBytes(), nArray, qDPointArray.length);
        StdQTException.checkError(s);
        Matrix.FixedPts2DoublePts(nArray, qDPointArray);
    }

    public void transformPoints(QDPoint qDPoint) throws StdQTException {
        int[] nArray = new int[]{(qDPoint.getY() << 16) + qDPoint.getX()};
        StdQTException.checkError(Matrix.TransformPoints(this.getBytes(), nArray, 1));
        qDPoint.setY(nArray[0] >> 16);
        qDPoint.setX(nArray[0] & 0xFFFF);
    }

    public void transformPoints(QDPoint[] qDPointArray) throws StdQTException {
        int[] nArray = new int[qDPointArray.length];
        int n = 0;
        while (n < qDPointArray.length) {
            nArray[n] = (qDPointArray[n].getY() << 16) + qDPointArray[n].getX();
            ++n;
        }
        StdQTException.checkError(Matrix.TransformPoints(this.getBytes(), nArray, qDPointArray.length));
        int n2 = 0;
        while (n2 < qDPointArray.length) {
            qDPointArray[n2].setY(nArray[n2] >> 16);
            qDPointArray[n2].setX(nArray[n2] & 0xFFFF);
            ++n2;
        }
    }

    public boolean transformDRect(QDRect qDRect) throws QTException {
        if (qDRect.getFixedRect() == null) {
            throw new QTException(-50);
        }
        return Matrix.TransformFixedRect(this.getBytes(), qDRect.getFixedRect(), 0) != 0;
    }

    public boolean transformDRect(QDRect qDRect, QDPoint[] qDPointArray) throws QTException {
        int[] nArray = Matrix.DoublePts2FixedPts(qDPointArray);
        if (qDRect.getFixedRect() == null) {
            throw new QTException(-50);
        }
        byte by = Matrix.TransformFixedRect(this.getBytes(), qDRect.getFixedRect(), nArray);
        if (by == 0) {
            Matrix.FixedPts2DoublePts(nArray, qDPointArray);
        }
        return by != 0;
    }

    public boolean transformRect(QDRect qDRect) throws QTException {
        return Matrix.TransformRect(this.getBytes(), qDRect.getRect(), 0) != 0;
    }

    public boolean transformRect(QDRect qDRect, QDPoint[] qDPointArray) throws QTException {
        int[] nArray = Matrix.DoublePts2FixedPts(qDPointArray);
        byte by = Matrix.TransformRect(this.getBytes(), qDRect.getRect(), nArray);
        if (by == 0) {
            Matrix.FixedPts2DoublePts(nArray, qDPointArray);
        }
        return by != 0;
    }

    public void transformRgn(Region region) throws StdQTException {
        StdQTException.checkError(Matrix.TransformRgn(this.getBytes(), QTObject.ID(region)));
    }

    public void rect(QDRect qDRect, QDRect qDRect2) {
        Matrix.RectMatrix(this.getBytes(), qDRect.getRect(), qDRect2.getRect());
    }

    public void map(QDRect qDRect, QDRect qDRect2) {
        Matrix.MapMatrix(this.getBytes(), qDRect.getRect(), qDRect2.getRect());
    }

    public String toString() {
        return this.getClass().getName() + "[(" + Double.toString(this.getSx()) + ", " + Double.toString(this.getB()) + ", " + Double.toString(this.getU()) + "), (" + Double.toString(this.getC()) + ", " + Double.toString(this.getSy()) + ", " + Double.toString(this.getV()) + "), (" + Double.toString(this.getTx()) + ", " + Double.toString(this.getTy()) + ", " + Double.toString(this.getW()) + ")]";
    }

    public Matrix copy() {
        return new Matrix(this.getBytes());
    }

    public Object clone() {
        return this.copy();
    }

    public boolean equals(Matrix matrix) {
        return Matrix.EqualMatrix(this.getBytes(), matrix.getBytes()) != 0;
    }

    private static native short QuadToQuadMatrix(int[] var0, int[] var1, byte[] var2);

    private static native short GetMatrixType(byte[] var0);

    private static native void SetIdentityMatrix(byte[] var0);

    private static native void TranslateMatrix(byte[] var0, int var1, int var2);

    private static native void RotateMatrix(byte[] var0, int var1, int var2, int var3);

    private static native void ScaleMatrix(byte[] var0, int var1, int var2, int var3, int var4);

    private static native void SkewMatrix(byte[] var0, int var1, int var2, int var3, int var4);

    private static native byte InverseMatrix(byte[] var0, byte[] var1);

    private static native void ConcatMatrix(byte[] var0, byte[] var1);

    private static native short TransformFixedPoints(byte[] var0, int[] var1, int var2);

    private static native short TransformPoints(byte[] var0, int[] var1, int var2);

    private static native byte TransformFixedRect(byte[] var0, byte[] var1, int[] var2);

    private static native byte TransformFixedRect(byte[] var0, byte[] var1, int var2);

    private static native byte TransformRect(byte[] var0, byte[] var1, int[] var2);

    private static native byte TransformRect(byte[] var0, byte[] var1, int var2);

    private static native short TransformRgn(byte[] var0, int var1);

    private static native void RectMatrix(byte[] var0, byte[] var1, byte[] var2);

    private static native void MapMatrix(byte[] var0, byte[] var1, byte[] var2);

    private static native void CopyMatrix(byte[] var0, byte[] var1);

    private static native byte EqualMatrix(byte[] var0, byte[] var1);

    private static native int getIntFromArray(byte[] var0, int var1);

    private static native void setIntInArray(byte[] var0, int var1, int var2);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

