/*
 * Decompiled with CFR 0.152.
 */
package quicktime.std.image;

import quicktime.QTException;
import quicktime.QTObject;
import quicktime.QTSession;
import quicktime.jdirect.QTNative;
import quicktime.jdirect.QuickTimeLib;
import quicktime.qd.ColorTable;
import quicktime.qd.PixMap;
import quicktime.qd.QDException;
import quicktime.qd.QDGraphics;
import quicktime.qd.QDRect;
import quicktime.qd.Region;
import quicktime.std.StdQTException;
import quicktime.std.image.CodecComponent;
import quicktime.std.image.ImageDescription;
import quicktime.std.image.Matrix;
import quicktime.util.ByteEncodedImage;
import quicktime.util.EncodedImage;
import quicktime.util.IntEncodedImage;
import quicktime.util.QTUtils;
import quicktime.util.RawEncodedImage;

public class QTImage
implements QuickTimeLib {
    private static Object linkage = QTNative.linkNativeMethods(class$quicktime$std$image$QTImage == null ? (class$quicktime$std$image$QTImage = QTImage.class$("quicktime.std.image.QTImage")) : class$quicktime$std$image$QTImage);
    private static final int[] savedPort = new int[]{0};
    private static final int[] savedDevice = new int[]{0};
    private ImageDescription desc;
    private EncodedImage data;
    static /* synthetic */ Class class$quicktime$std$image$QTImage;

    public QTImage(ImageDescription imageDescription, EncodedImage encodedImage) {
        this.data = encodedImage;
        this.desc = imageDescription;
    }

    public EncodedImage getImage() {
        return this.data;
    }

    public ImageDescription getDescription() {
        return this.desc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final ImageDescription compress(QDGraphics qDGraphics, QDRect qDRect, int n, int n2, EncodedImage encodedImage) throws QTException {
        ImageDescription imageDescription = new ImageDescription(0);
        if (qDGraphics == null) {
            throw new StdQTException(-50);
        }
        int n3 = -50;
        Object object = QTNative.globalsLock;
        synchronized (object) {
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QTImage.GetGWorld(savedPort, savedDevice);
            }
            QTImage.SetGWorld(QTObject.ID(qDGraphics), 0);
            if (encodedImage instanceof ByteEncodedImage) {
                n3 = QTImage.CompressImage(QTObject.ID(qDGraphics.getPixMap()), qDRect.getRect(), n, n2, QTObject.ID(imageDescription), ((ByteEncodedImage)encodedImage).getBytes());
            } else if (encodedImage instanceof IntEncodedImage) {
                n3 = QTImage.CompressImage(QTObject.ID(qDGraphics.getPixMap()), qDRect.getRect(), n, n2, QTObject.ID(imageDescription), ((IntEncodedImage)encodedImage).getInts());
            } else if (encodedImage instanceof RawEncodedImage) {
                n3 = QTImage.CompressImage(QTObject.ID(qDGraphics.getPixMap()), qDRect.getRect(), n, n2, QTObject.ID(imageDescription), QTObject.ID((RawEncodedImage)encodedImage));
            }
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QTImage.SetGWorld(savedPort[0], savedDevice[0]);
            }
        }
        StdQTException.checkError(n3);
        return imageDescription;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final ImageDescription fCompress(QDGraphics qDGraphics, QDRect qDRect, int n, int n2, int n3, CodecComponent codecComponent, ColorTable colorTable, int n4, EncodedImage encodedImage) throws QTException {
        ImageDescription imageDescription = new ImageDescription(0);
        if (qDGraphics == null) {
            throw new StdQTException(-50);
        }
        int n5 = -50;
        Object object = QTNative.globalsLock;
        synchronized (object) {
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QTImage.GetGWorld(savedPort, savedDevice);
            }
            QTImage.SetGWorld(QTObject.ID(qDGraphics), 0);
            if (encodedImage instanceof ByteEncodedImage) {
                n5 = QTImage.FCompressImage(QTObject.ID(qDGraphics.getPixMap()), qDRect.getRect(), (short)n, n2, n3, QTObject.ID(codecComponent), QTObject.ID(colorTable), (short)n4, 0, 0, 0, QTObject.ID(imageDescription), ((ByteEncodedImage)encodedImage).getBytes());
            } else if (encodedImage instanceof IntEncodedImage) {
                n5 = QTImage.FCompressImage(QTObject.ID(qDGraphics.getPixMap()), qDRect.getRect(), (short)n, n2, n3, QTObject.ID(codecComponent), QTObject.ID(colorTable), (short)n4, 0, 0, 0, QTObject.ID(imageDescription), ((IntEncodedImage)encodedImage).getInts());
            } else if (encodedImage instanceof RawEncodedImage) {
                n5 = QTImage.FCompressImage(QTObject.ID(qDGraphics.getPixMap()), qDRect.getRect(), (short)n, n2, n3, QTObject.ID(codecComponent), QTObject.ID(colorTable), (short)n4, 0, 0, 0, QTObject.ID(imageDescription), QTObject.ID((RawEncodedImage)encodedImage));
            }
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QTImage.SetGWorld(savedPort[0], savedDevice[0]);
            }
        }
        StdQTException.checkError(n5);
        return imageDescription;
    }

    public static final ImageDescription convert(ImageDescription imageDescription, EncodedImage encodedImage, int n, ColorTable colorTable, int n2, int n3, int n4, CodecComponent codecComponent, EncodedImage encodedImage2) throws QTException {
        ImageDescription imageDescription2 = new ImageDescription(0);
        int n5 = -50;
        if (encodedImage instanceof ByteEncodedImage) {
            if (encodedImage2 instanceof ByteEncodedImage) {
                n5 = QTImage.ConvertImage(QTObject.ID(imageDescription), ((ByteEncodedImage)encodedImage).getBytes(), (short)n, QTObject.ID(colorTable), n2, n3, n4, QTObject.ID(codecComponent), QTObject.ID(imageDescription2), ((ByteEncodedImage)encodedImage2).getBytes());
            } else if (encodedImage2 instanceof IntEncodedImage) {
                n5 = QTImage.ConvertImage(QTObject.ID(imageDescription), ((ByteEncodedImage)encodedImage).getBytes(), (short)n, QTObject.ID(colorTable), n2, n3, n4, QTObject.ID(codecComponent), QTObject.ID(imageDescription2), ((IntEncodedImage)encodedImage2).getInts());
            } else if (encodedImage2 instanceof RawEncodedImage) {
                n5 = QTImage.ConvertImage(QTObject.ID(imageDescription), ((ByteEncodedImage)encodedImage).getBytes(), (short)n, QTObject.ID(colorTable), n2, n3, n4, QTObject.ID(codecComponent), QTObject.ID(imageDescription2), QTObject.ID((RawEncodedImage)encodedImage2));
            }
        } else if (encodedImage instanceof IntEncodedImage) {
            if (encodedImage2 instanceof ByteEncodedImage) {
                n5 = QTImage.ConvertImage(QTObject.ID(imageDescription), ((IntEncodedImage)encodedImage).getInts(), (short)n, QTObject.ID(colorTable), n2, n3, n4, QTObject.ID(codecComponent), QTObject.ID(imageDescription2), ((ByteEncodedImage)encodedImage2).getBytes());
            } else if (encodedImage2 instanceof IntEncodedImage) {
                n5 = QTImage.ConvertImage(QTObject.ID(imageDescription), ((IntEncodedImage)encodedImage).getInts(), (short)n, QTObject.ID(colorTable), n2, n3, n4, QTObject.ID(codecComponent), QTObject.ID(imageDescription2), ((IntEncodedImage)encodedImage2).getInts());
            } else if (encodedImage2 instanceof RawEncodedImage) {
                n5 = QTImage.ConvertImage(QTObject.ID(imageDescription), ((IntEncodedImage)encodedImage).getInts(), (short)n, QTObject.ID(colorTable), n2, n3, n4, QTObject.ID(codecComponent), QTObject.ID(imageDescription2), QTObject.ID((RawEncodedImage)encodedImage2));
            }
        } else if (encodedImage instanceof RawEncodedImage) {
            if (encodedImage2 instanceof ByteEncodedImage) {
                n5 = QTImage.ConvertImage(QTObject.ID(imageDescription), QTObject.ID((RawEncodedImage)encodedImage), (short)n, QTObject.ID(colorTable), n2, n3, n4, QTObject.ID(codecComponent), QTObject.ID(imageDescription2), ((ByteEncodedImage)encodedImage2).getBytes());
            } else if (encodedImage2 instanceof IntEncodedImage) {
                n5 = QTImage.ConvertImage(QTObject.ID(imageDescription), QTObject.ID((RawEncodedImage)encodedImage), (short)n, QTObject.ID(colorTable), n2, n3, n4, QTObject.ID(codecComponent), QTObject.ID(imageDescription2), ((IntEncodedImage)encodedImage2).getInts());
            } else if (encodedImage2 instanceof RawEncodedImage) {
                n5 = QTImage.ConvertImage(QTObject.ID(imageDescription), QTObject.ID((RawEncodedImage)encodedImage), (short)n, QTObject.ID(colorTable), n2, n3, n4, QTObject.ID(codecComponent), QTObject.ID(imageDescription2), QTObject.ID((RawEncodedImage)encodedImage2));
            }
        }
        StdQTException.checkError(n5);
        return imageDescription2;
    }

    public static final void trim(ImageDescription imageDescription, EncodedImage encodedImage, EncodedImage encodedImage2, QDRect qDRect) throws StdQTException {
        int n = -50;
        if (encodedImage instanceof ByteEncodedImage) {
            if (encodedImage2 instanceof ByteEncodedImage) {
                n = QTImage.TrimImage(QTObject.ID(imageDescription), ((ByteEncodedImage)encodedImage).getBytes(), 0, 0, ((ByteEncodedImage)encodedImage2).getBytes(), 0, 0, qDRect.getRect(), 0);
            } else if (encodedImage2 instanceof IntEncodedImage) {
                n = QTImage.TrimImage(QTObject.ID(imageDescription), ((ByteEncodedImage)encodedImage).getBytes(), 0, 0, ((IntEncodedImage)encodedImage2).getInts(), 0, 0, qDRect.getRect(), 0);
            } else if (encodedImage2 instanceof RawEncodedImage) {
                n = QTImage.TrimImage(QTObject.ID(imageDescription), ((ByteEncodedImage)encodedImage).getBytes(), 0, 0, QTObject.ID((RawEncodedImage)encodedImage2), 0, 0, qDRect.getRect(), 0);
            }
        } else if (encodedImage instanceof IntEncodedImage) {
            if (encodedImage2 instanceof ByteEncodedImage) {
                n = QTImage.TrimImage(QTObject.ID(imageDescription), ((IntEncodedImage)encodedImage).getInts(), 0, 0, ((ByteEncodedImage)encodedImage2).getBytes(), 0, 0, qDRect.getBytes(), 0);
            } else if (encodedImage2 instanceof IntEncodedImage) {
                n = QTImage.TrimImage(QTObject.ID(imageDescription), ((IntEncodedImage)encodedImage).getInts(), 0, 0, ((IntEncodedImage)encodedImage2).getInts(), 0, 0, qDRect.getBytes(), 0);
            } else if (encodedImage2 instanceof RawEncodedImage) {
                n = QTImage.TrimImage(QTObject.ID(imageDescription), ((IntEncodedImage)encodedImage).getInts(), 0, 0, QTObject.ID((RawEncodedImage)encodedImage2), 0, 0, qDRect.getBytes(), 0);
            }
        } else if (encodedImage instanceof RawEncodedImage) {
            if (encodedImage2 instanceof ByteEncodedImage) {
                n = QTImage.TrimImage(QTObject.ID(imageDescription), QTObject.ID((RawEncodedImage)encodedImage), 0, 0, ((ByteEncodedImage)encodedImage2).getBytes(), 0, 0, qDRect.getBytes(), 0);
            } else if (encodedImage2 instanceof IntEncodedImage) {
                n = QTImage.TrimImage(QTObject.ID(imageDescription), QTObject.ID((RawEncodedImage)encodedImage), 0, 0, ((IntEncodedImage)encodedImage2).getInts(), 0, 0, qDRect.getBytes(), 0);
            } else if (encodedImage2 instanceof RawEncodedImage) {
                n = QTImage.TrimImage(QTObject.ID(imageDescription), QTObject.ID((RawEncodedImage)encodedImage), 0, 0, QTObject.ID((RawEncodedImage)encodedImage2), 0, 0, qDRect.getBytes(), 0);
            }
        }
        StdQTException.checkError(n);
    }

    public static final void decompress(EncodedImage encodedImage, ImageDescription imageDescription, QDGraphics qDGraphics, QDRect qDRect, int n) throws StdQTException, QDException {
        QTImage.decompress(encodedImage, imageDescription, qDGraphics, null, qDRect, n, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void decompress(EncodedImage encodedImage, ImageDescription imageDescription, QDGraphics qDGraphics, QDRect qDRect, QDRect qDRect2, int n, Region region) throws StdQTException, QDException {
        if (qDGraphics == null) {
            throw new StdQTException(-50);
        }
        int n2 = -50;
        Object object = QTNative.globalsLock;
        synchronized (object) {
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QTImage.GetGWorld(savedPort, savedDevice);
            }
            QTImage.SetGWorld(QTObject.ID(qDGraphics), 0);
            if (encodedImage instanceof ByteEncodedImage) {
                n2 = QTImage.DecompressImage(((ByteEncodedImage)encodedImage).getBytes(), QTObject.ID(imageDescription), QTObject.ID(qDGraphics.getPixMap()), qDRect == null ? null : qDRect.getRect(), qDRect2.getRect(), (short)n, QTObject.ID(region));
            } else if (encodedImage instanceof IntEncodedImage) {
                n2 = QTImage.DecompressImage(((IntEncodedImage)encodedImage).getInts(), QTObject.ID(imageDescription), QTObject.ID(qDGraphics.getPixMap()), qDRect == null ? null : qDRect.getRect(), qDRect2.getRect(), (short)n, QTObject.ID(region));
            } else if (encodedImage instanceof RawEncodedImage) {
                n2 = QTImage.DecompressImage(QTObject.ID((RawEncodedImage)encodedImage), QTObject.ID(imageDescription), QTObject.ID(qDGraphics.getPixMap()), qDRect == null ? null : qDRect.getRect(), qDRect2.getRect(), (short)n, QTObject.ID(region));
            }
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QTImage.SetGWorld(savedPort[0], savedDevice[0]);
            }
        }
        StdQTException.checkError(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void fDecompress(EncodedImage encodedImage, ImageDescription imageDescription, QDGraphics qDGraphics, QDRect qDRect, Matrix matrix, int n, Region region, PixMap pixMap, QDRect qDRect2, int n2, CodecComponent codecComponent) throws StdQTException, QDException {
        if (qDGraphics == null) {
            throw new StdQTException(-50);
        }
        short s = 0;
        Object object = QTNative.globalsLock;
        synchronized (object) {
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QTImage.GetGWorld(savedPort, savedDevice);
            }
            QTImage.SetGWorld(QTObject.ID(qDGraphics), 0);
            s = QTImage.FDecompressImage(QTObject.ID((RawEncodedImage)encodedImage), QTObject.ID(imageDescription), QTObject.ID(qDGraphics.getPixMap()), qDRect == null ? null : qDRect.getRect(), matrix == null ? null : matrix.getBytes(), (short)n, QTObject.ID(region), QTObject.ID(pixMap), qDRect2 == null ? null : qDRect2.getRect(), n2, QTObject.ID(codecComponent), 0, 0, 0);
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QTImage.SetGWorld(savedPort[0], savedDevice[0]);
            }
        }
        StdQTException.checkError(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int getMaxCompressionSize(QDGraphics qDGraphics, QDRect qDRect, int n, int n2, int n3, CodecComponent codecComponent) throws StdQTException, QDException {
        int[] nArray = new int[1];
        if (qDGraphics == null) {
            throw new StdQTException(-50);
        }
        short s = 0;
        Object object = QTNative.globalsLock;
        synchronized (object) {
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QTImage.GetGWorld(savedPort, savedDevice);
            }
            QTImage.SetGWorld(QTObject.ID(qDGraphics), 0);
            s = QTImage.GetMaxCompressionSize(QTObject.ID(qDGraphics.getPixMap()), qDRect == null ? null : qDRect.getRect(), (short)n, n2, n3, QTObject.ID(codecComponent), nArray);
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QTImage.SetGWorld(savedPort[0], savedDevice[0]);
            }
        }
        StdQTException.checkError(s);
        return nArray[0];
    }

    public static final int getCompressedSize(ImageDescription imageDescription, EncodedImage encodedImage) throws StdQTException {
        int[] nArray = new int[1];
        int n = -50;
        if (encodedImage instanceof ByteEncodedImage) {
            n = QTImage.GetCompressedImageSize(QTObject.ID(imageDescription), ((ByteEncodedImage)encodedImage).getBytes(), 0, 0, nArray);
        } else if (encodedImage instanceof IntEncodedImage) {
            n = QTImage.GetCompressedImageSize(QTObject.ID(imageDescription), ((IntEncodedImage)encodedImage).getInts(), 0, 0, nArray);
        } else if (encodedImage instanceof RawEncodedImage) {
            n = QTImage.GetCompressedImageSize(QTObject.ID(imageDescription), QTObject.ID((RawEncodedImage)encodedImage), 0, 0, nArray);
        }
        StdQTException.checkError(n);
        return nArray[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int getCompressionTime(QDGraphics qDGraphics, QDRect qDRect, int n, int n2, CodecComponent codecComponent, int n3, int n4) throws StdQTException, QDException {
        int[] nArray = new int[1];
        int n5 = 0;
        short s = 0;
        Object object = QTNative.globalsLock;
        synchronized (object) {
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QTImage.GetGWorld(savedPort, savedDevice);
            }
            if (qDGraphics != null) {
                QTImage.SetGWorld(QTObject.ID(qDGraphics), 0);
                n5 = QTObject.ID(qDGraphics.getPixMap());
            }
            s = QTImage.GetCompressionTime(n5, qDRect == null ? null : qDRect.getRect(), (short)n, n2, QTObject.ID(codecComponent), n3, n4, nArray);
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QTImage.SetGWorld(savedPort[0], savedDevice[0]);
            }
        }
        StdQTException.checkError(s);
        return nArray[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final float getSimilarity(QDGraphics qDGraphics, QDRect qDRect, ImageDescription imageDescription, EncodedImage encodedImage) throws StdQTException, QDException {
        int[] nArray = new int[1];
        if (qDGraphics == null) {
            throw new StdQTException(-50);
        }
        int n = -50;
        Object object = QTNative.globalsLock;
        synchronized (object) {
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QTImage.GetGWorld(savedPort, savedDevice);
            }
            QTImage.SetGWorld(QTObject.ID(qDGraphics), 0);
            if (encodedImage instanceof ByteEncodedImage) {
                n = QTImage.GetSimilarity(QTObject.ID(qDGraphics.getPixMap()), qDRect.getRect(), QTObject.ID(imageDescription), ((ByteEncodedImage)encodedImage).getBytes(), nArray);
            } else if (encodedImage instanceof IntEncodedImage) {
                n = QTImage.GetSimilarity(QTObject.ID(qDGraphics.getPixMap()), qDRect.getBytes(), QTObject.ID(imageDescription), ((IntEncodedImage)encodedImage).getInts(), nArray);
            } else if (encodedImage instanceof RawEncodedImage) {
                n = QTImage.GetSimilarity(QTObject.ID(qDGraphics.getPixMap()), qDRect.getBytes(), QTObject.ID(imageDescription), QTObject.ID((RawEncodedImage)encodedImage), nArray);
            }
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                QTImage.SetGWorld(savedPort[0], savedDevice[0]);
            }
        }
        StdQTException.checkError(n);
        return QTUtils.Fix2X(nArray[0]);
    }

    private static native void GetGWorld(int[] var0, int[] var1);

    private static native void SetGWorld(int var0, int var1);

    private static native short CompressImage(int var0, byte[] var1, int var2, int var3, int var4, int var5);

    private static native short CompressImage(int var0, byte[] var1, int var2, int var3, int var4, byte[] var5);

    private static native short CompressImage(int var0, byte[] var1, int var2, int var3, int var4, int[] var5);

    private static native short FCompressImage(int var0, byte[] var1, short var2, int var3, int var4, int var5, int var6, short var7, int var8, int var9, int var10, int var11, int var12);

    private static native short FCompressImage(int var0, byte[] var1, short var2, int var3, int var4, int var5, int var6, short var7, int var8, int var9, int var10, int var11, byte[] var12);

    private static native short FCompressImage(int var0, byte[] var1, short var2, int var3, int var4, int var5, int var6, short var7, int var8, int var9, int var10, int var11, int[] var12);

    private static native short ConvertImage(int var0, byte[] var1, short var2, int var3, int var4, int var5, int var6, int var7, int var8, byte[] var9);

    private static native short ConvertImage(int var0, byte[] var1, short var2, int var3, int var4, int var5, int var6, int var7, int var8, int[] var9);

    private static native short ConvertImage(int var0, byte[] var1, short var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9);

    private static native short ConvertImage(int var0, int[] var1, short var2, int var3, int var4, int var5, int var6, int var7, int var8, byte[] var9);

    private static native short ConvertImage(int var0, int[] var1, short var2, int var3, int var4, int var5, int var6, int var7, int var8, int[] var9);

    private static native short ConvertImage(int var0, int[] var1, short var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9);

    private static native short ConvertImage(int var0, int var1, short var2, int var3, int var4, int var5, int var6, int var7, int var8, byte[] var9);

    private static native short ConvertImage(int var0, int var1, short var2, int var3, int var4, int var5, int var6, int var7, int var8, int[] var9);

    private static native short ConvertImage(int var0, int var1, short var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9);

    private static native short TrimImage(int var0, int var1, int var2, int var3, byte[] var4, int var5, int var6, byte[] var7, int var8);

    private static native short TrimImage(int var0, int var1, int var2, int var3, int[] var4, int var5, int var6, byte[] var7, int var8);

    private static native short TrimImage(int var0, int var1, int var2, int var3, int var4, int var5, int var6, byte[] var7, int var8);

    private static native short TrimImage(int var0, int[] var1, int var2, int var3, byte[] var4, int var5, int var6, byte[] var7, int var8);

    private static native short TrimImage(int var0, int[] var1, int var2, int var3, int[] var4, int var5, int var6, byte[] var7, int var8);

    private static native short TrimImage(int var0, int[] var1, int var2, int var3, int var4, int var5, int var6, byte[] var7, int var8);

    private static native short TrimImage(int var0, byte[] var1, int var2, int var3, byte[] var4, int var5, int var6, byte[] var7, int var8);

    private static native short TrimImage(int var0, byte[] var1, int var2, int var3, int[] var4, int var5, int var6, byte[] var7, int var8);

    private static native short TrimImage(int var0, byte[] var1, int var2, int var3, int var4, int var5, int var6, byte[] var7, int var8);

    private static native short DecompressImage(byte[] var0, int var1, int var2, byte[] var3, byte[] var4, short var5, int var6);

    private static native short DecompressImage(int[] var0, int var1, int var2, byte[] var3, byte[] var4, short var5, int var6);

    private static native short DecompressImage(int var0, int var1, int var2, byte[] var3, byte[] var4, short var5, int var6);

    private static native short FDecompressImage(int var0, int var1, int var2, byte[] var3, byte[] var4, short var5, int var6, int var7, byte[] var8, int var9, int var10, int var11, int var12, int var13);

    private static native short GetMaxCompressionSize(int var0, byte[] var1, short var2, int var3, int var4, int var5, int[] var6);

    private static native short GetCompressedImageSize(int var0, byte[] var1, int var2, int var3, int[] var4);

    private static native short GetCompressedImageSize(int var0, int[] var1, int var2, int var3, int[] var4);

    private static native short GetCompressedImageSize(int var0, int var1, int var2, int var3, int[] var4);

    private static native short GetCompressionTime(int var0, byte[] var1, short var2, int var3, int var4, int var5, int var6, int[] var7);

    private static native short GetSimilarity(int var0, byte[] var1, int var2, byte[] var3, int[] var4);

    private static native short GetSimilarity(int var0, byte[] var1, int var2, int[] var3, int[] var4);

    private static native short GetSimilarity(int var0, byte[] var1, int var2, int var3, int[] var4);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

