/*
 * Decompiled with CFR 0.152.
 */
package quicktime.std.image;

import quicktime.QTException;
import quicktime.QTObject;
import quicktime.jdirect.PrimitivesLib;
import quicktime.jdirect.QTNative;
import quicktime.jdirect.QuickTimeLib;
import quicktime.qd.QDColor;
import quicktime.qd.QDPoint;
import quicktime.std.StdQTException;
import quicktime.std.image.Curve;
import quicktime.std.movies.AtomContainer;
import quicktime.std.movies.AtomData;
import quicktime.util.EndianDescriptor;
import quicktime.util.EndianOrder;
import quicktime.util.QTHandle;

public class VectorStream
extends AtomContainer
implements QuickTimeLib,
PrimitivesLib {
    private static Object linkage = QTNative.linkNativeMethods(class$quicktime$std$image$VectorStream == null ? (class$quicktime$std$image$VectorStream = VectorStream.class$("quicktime.std.image.VectorStream")) : class$quicktime$std$image$VectorStream);
    private Curve c;
    static /* synthetic */ Class class$quicktime$std$image$VectorStream;

    private static int allocate(Curve curve) throws QTException {
        int[] nArray = new int[]{0};
        int n = VectorStream.CurveCreateVectorStream(QTObject.ID(curve), nArray);
        StdQTException.checkError(n);
        return nArray[0];
    }

    public VectorStream(Curve curve) throws QTException {
        super(VectorStream.allocate(curve), null, false);
        this.c = curve;
    }

    public void addPathAtom(QTHandle qTHandle) throws QTException {
        int n = VectorStream.CurveAddPathAtomToVectorStream(QTObject.ID(this.c), QTObject.ID(qTHandle), this._ID());
        StdQTException.checkError(n);
    }

    public void addZeroAtom() throws StdQTException {
        int n = VectorStream.CurveAddZeroAtomToVectorStream(QTObject.ID(this.c), this._ID());
        StdQTException.checkError(n);
    }

    public void addAtom(int n, byte[] byArray) throws StdQTException {
        int n2 = VectorStream.CurveAddAtomToVectorStream(QTObject.ID(this.c), n, byArray.length, byArray, this._ID());
        StdQTException.checkError(n2);
    }

    public void addAtom(QDColor qDColor) throws QTException {
        EndianDescriptor endianDescriptor = QDColor.getEndianDescriptorARGBColor();
        EndianOrder.flipNativeToBigEndian(qDColor, 0, endianDescriptor);
        byte[] byArray = qDColor.getARGBColor();
        int n = VectorStream.CurveAddAtomToVectorStream(QTObject.ID(this.c), 1634887522, byArray.length, byArray, this._ID());
        StdQTException.checkError(n);
    }

    public void addAtom(int n, int n2) throws StdQTException {
        int[] nArray = new int[]{EndianOrder.flipNativeToBigEndian32(n2)};
        int n3 = VectorStream.CurveAddAtomToVectorStream(QTObject.ID(this.c), n, 4, nArray, this._ID());
        StdQTException.checkError(n3);
    }

    public void addAtom(boolean bl, QDPoint[] qDPointArray) throws StdQTException {
        int n;
        int[] nArray = new int[qDPointArray.length * 2 + 3];
        nArray[0] = 1;
        nArray[1] = qDPointArray.length;
        nArray[2] = bl ? 1 : 0;
        int n2 = 0;
        while (n2 < qDPointArray.length) {
            byte[] byArray = qDPointArray[n2].getGXPoint();
            n = VectorStream.getIntFromArray(byArray, 0);
            int n3 = VectorStream.getIntFromArray(byArray, 4);
            nArray[3 + 2 * n2] = n;
            nArray[4 + 2 * n2] = n3;
            ++n2;
        }
        int n4 = 0;
        while (n4 < nArray.length) {
            nArray[n4] = EndianOrder.flipNativeToBigEndian32(nArray[n4]);
            ++n4;
        }
        n = VectorStream.CurveAddAtomToVectorStream(QTObject.ID(this.c), 1885434984, nArray.length * 4, nArray, this._ID());
        StdQTException.checkError(n);
    }

    public void addAtom(QDColor[] qDColorArray) throws QTException {
        byte[] byArray = new byte[qDColorArray.length * 12];
        int n = 0;
        while (n < qDColorArray.length) {
            QDColor qDColor = qDColorArray[n];
            EndianDescriptor endianDescriptor = QDColor.getEndianDescriptorGradientColor();
            byte[] byArray2 = qDColor.getGradientColor();
            EndianOrder.flipNativeToBigEndian(byArray2, 0, endianDescriptor);
            System.arraycopy(byArray2, 0, byArray, 12 * n, byArray2.length);
            ++n;
        }
        int n2 = VectorStream.CurveAddAtomToVectorStream(QTObject.ID(this.c), 1735549284, byArray.length, byArray, this._ID());
        StdQTException.checkError(n2);
    }

    public void removeAtom(int n) throws StdQTException {
        int n2 = VectorStream.CurveAddAtomToVectorStream(QTObject.ID(this.c), n, 0, 0, this._ID());
        StdQTException.checkError(n2);
    }

    public AtomData getAtomData(int n) throws QTException {
        return AtomData.fromVectorStream(this.c, this, n);
    }

    private static native int getIntFromArray(byte[] var0, int var1);

    private static native void setIntInArray(byte[] var0, int var1, int var2);

    private static native int CurveCreateVectorStream(int var0, int[] var1);

    private static native int CurveAddAtomToVectorStream(int var0, int var1, int var2, int var3, int var4);

    private static native int CurveAddAtomToVectorStream(int var0, int var1, int var2, int[] var3, int var4);

    private static native int CurveAddAtomToVectorStream(int var0, int var1, int var2, byte[] var3, int var4);

    private static native int CurveAddPathAtomToVectorStream(int var0, int var1, int var2);

    private static native int CurveAddZeroAtomToVectorStream(int var0, int var1);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

