/*
 * Decompiled with CFR 0.152.
 */
package quicktime.std.movies;

import quicktime.QTException;
import quicktime.QTObject;
import quicktime.jdirect.QTNative;
import quicktime.jdirect.QuickTimeLib;
import quicktime.jdirect.QuickTimeVRLib;
import quicktime.std.StdQTException;
import quicktime.std.image.GECompressorInfo;
import quicktime.std.image.GraphicsExporter;
import quicktime.std.image.GraphicsImporter;
import quicktime.std.movies.Atom;
import quicktime.std.movies.AtomData;
import quicktime.std.movies.IStringInfo;
import quicktime.std.movies.media.Media;
import quicktime.std.movies.media.ThreeDMediaHandler;
import quicktime.std.qtcomponents.CompressionDialog;
import quicktime.std.qtcomponents.MovieExporter;
import quicktime.std.qtcomponents.MovieImporter;
import quicktime.util.QTByteObject;
import quicktime.util.QTHandle;
import quicktime.util.QTHandleRef;
import quicktime.util.QTPointer;
import quicktime.util.QTPointerRef;
import quicktime.util.QTUtils;
import quicktime.vr.QTVRException;
import quicktime.vr.QTVRInstance;

public class AtomContainer
extends QTHandleRef
implements QuickTimeLib,
QuickTimeVRLib {
    private static Object linkage = QTNative.linkNativeMethods(class$quicktime$std$movies$AtomContainer == null ? (class$quicktime$std$movies$AtomContainer = AtomContainer.class$("quicktime.std.movies.AtomContainer")) : class$quicktime$std$movies$AtomContainer);
    static /* synthetic */ Class class$quicktime$std$movies$AtomContainer;

    public static AtomContainer fromGraphicsExporter(GraphicsExporter graphicsExporter) throws StdQTException {
        int[] nArray = new int[]{0};
        StdQTException.checkError(AtomContainer.GraphicsExportGetSettingsAsAtomContainer(QTObject.ID(graphicsExporter), nArray));
        return new AtomContainer(nArray[0], null, false);
    }

    public static GECompressorInfo fromGraphicsExporterCompressor(GraphicsExporter graphicsExporter) throws QTException {
        byte[] byArray = new byte[1];
        int[] nArray = new int[1];
        StdQTException.checkError(AtomContainer.GraphicsExportCanUseCompressor(QTObject.ID(graphicsExporter), byArray, nArray));
        AtomContainer atomContainer = byArray[0] != 0 ? new AtomContainer(nArray[0], null, false) : null;
        return new GECompressorInfo(byArray[0] != 0, atomContainer);
    }

    public static AtomContainer fromGraphicsExporterMIME(GraphicsExporter graphicsExporter) throws StdQTException {
        int[] nArray = new int[]{0};
        StdQTException.checkError(AtomContainer.GraphicsExportGetMIMETypeList(QTObject.ID(graphicsExporter), nArray));
        return new AtomContainer(nArray[0], null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AtomContainer fromQTVRInstanceWorld(QTVRInstance qTVRInstance) throws QTVRException {
        int[] nArray = new int[]{0};
        short s = 0;
        Object object = QTNative.globalsLock;
        synchronized (object) {
            s = AtomContainer.QTVRGetVRWorld(QTObject.ID(qTVRInstance), nArray);
        }
        QTVRException.checkError(s);
        return nArray[0] != 0 ? new AtomContainer(nArray[0], null, false) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AtomContainer fromQTVRInstanceNode(QTVRInstance qTVRInstance, int n) throws QTVRException {
        int[] nArray = new int[]{0};
        short s = 0;
        Object object = QTNative.globalsLock;
        synchronized (object) {
            s = AtomContainer.QTVRGetNodeInfo(QTObject.ID(qTVRInstance), n, nArray);
        }
        QTVRException.checkError(s);
        return nArray[0] != 0 ? new AtomContainer(nArray[0], null, false) : null;
    }

    public static AtomContainer fromQTHandle(QTHandleRef qTHandleRef) {
        if (QTObject.ID(qTHandleRef) != 0) {
            return new AtomContainer(QTObject.ID(qTHandleRef), (Object)qTHandleRef, qTHandleRef.isLocked());
        }
        return null;
    }

    public static AtomContainer fromGraphicsImporterMIME(GraphicsImporter graphicsImporter) throws StdQTException {
        int[] nArray = new int[]{0};
        StdQTException.checkError(AtomContainer.GraphicsImportGetMIMETypeList(QTObject.ID(graphicsImporter), nArray));
        return nArray[0] != 0 ? new AtomContainer(nArray[0], null, false) : null;
    }

    public static AtomContainer fromGraphicsImporterExportImage(GraphicsImporter graphicsImporter) throws StdQTException {
        int[] nArray = new int[]{0};
        StdQTException.checkError(AtomContainer.GraphicsImportGetExportImageTypeList(QTObject.ID(graphicsImporter), nArray));
        return nArray[0] != 0 ? new AtomContainer(nArray[0], null, false) : null;
    }

    public static AtomContainer fromGraphicsImporterExportSettings(GraphicsImporter graphicsImporter) throws StdQTException {
        int[] nArray = new int[]{0};
        StdQTException.checkError(AtomContainer.GraphicsImportGetExportSettingsAsAtomContainer(QTObject.ID(graphicsImporter), nArray));
        return nArray[0] != 0 ? new AtomContainer(nArray[0], null, false) : null;
    }

    public static AtomContainer fromMediaInput(Media media) throws StdQTException {
        int[] nArray = new int[1];
        StdQTException.checkError(AtomContainer.GetMediaInputMap(QTObject.ID(media), nArray));
        return nArray[0] != 0 ? new AtomContainer(nArray[0], null, false) : null;
    }

    public static AtomContainer fromMediaProperty(Media media) throws StdQTException {
        int[] nArray = new int[1];
        StdQTException.checkError(AtomContainer.GetMediaPropertyAtom(QTObject.ID(media), nArray));
        return nArray[0] != 0 ? new AtomContainer(nArray[0], null, false) : null;
    }

    public static AtomContainer fromMovieExporter(MovieExporter movieExporter) throws StdQTException {
        int[] nArray = new int[]{0};
        StdQTException.checkError(AtomContainer.MovieExportGetSettingsAsAtomContainer(QTObject.ID(movieExporter), nArray));
        return nArray[0] != 0 ? new AtomContainer(nArray[0], null, false) : null;
    }

    public static AtomContainer fromMovieImporterMIME(MovieImporter movieImporter) throws StdQTException {
        int[] nArray = new int[]{0};
        StdQTException.checkError(AtomContainer.MovieImportGetMIMETypeList(QTObject.ID(movieImporter), nArray));
        return nArray[0] != 0 ? new AtomContainer(nArray[0], null, false) : null;
    }

    public static AtomContainer fromMovieImporterSettings(MovieImporter movieImporter) throws StdQTException {
        int[] nArray = new int[]{0};
        StdQTException.checkError(AtomContainer.MovieImportGetSettingsAsAtomContainer(QTObject.ID(movieImporter), nArray));
        return nArray[0] != 0 ? new AtomContainer(nArray[0], null, false) : null;
    }

    public static AtomContainer fromThreeDMediaHandlerObject(ThreeDMediaHandler threeDMediaHandler) throws StdQTException {
        int[] nArray = new int[1];
        StdQTException.checkError(AtomContainer.Media3DGetNamedObjectList(QTObject.ID(threeDMediaHandler), nArray));
        return nArray[0] != 0 ? new AtomContainer(nArray[0], null, false) : null;
    }

    public static AtomContainer fromThreeDMediaHandlerRenderer(ThreeDMediaHandler threeDMediaHandler) throws StdQTException {
        int[] nArray = new int[1];
        StdQTException.checkError(AtomContainer.Media3DGetRendererList(QTObject.ID(threeDMediaHandler), nArray));
        return nArray[0] != 0 ? new AtomContainer(nArray[0], null, false) : null;
    }

    public static AtomContainer fromCompressionDialog(CompressionDialog compressionDialog) throws StdQTException {
        int[] nArray = new int[]{0};
        StdQTException.checkError(AtomContainer.SCGetSettingsAsAtomContainer(QTObject.ID(compressionDialog), nArray));
        return nArray[0] != 0 ? new AtomContainer(nArray[0], null, false) : null;
    }

    protected AtomContainer(int n, Object object, boolean bl) {
        super(n, object, bl);
    }

    public AtomContainer() throws QTException {
        super(AtomContainer.allocate(), null, false);
    }

    private static int allocate() throws StdQTException {
        int[] nArray = new int[]{0};
        short s = AtomContainer.QTNewAtomContainer(nArray);
        if (s != 0) {
            throw new StdQTException(s);
        }
        return nArray[0];
    }

    void _setNR(int n) {
        this.setNR(n);
    }

    public AtomData getAtomData(Atom atom) throws StdQTException {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        StdQTException.checkError(AtomContainer.QTGetAtomDataPtr(this._ID(), atom.getAtom(), nArray, nArray2));
        return new AtomData(nArray2[0], nArray[0], this);
    }

    public int getAtomDataSize(Atom atom) throws StdQTException {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        StdQTException.checkError(AtomContainer.QTGetAtomDataPtr(this._ID(), atom.getAtom(), nArray, nArray2));
        return nArray[0];
    }

    public int getNextChildType(Atom atom, int n) throws StdQTException {
        int n2 = AtomContainer.QTGetNextChildType(this._ID(), atom != null ? atom.getAtom() : 0, n);
        StdQTException.checkError(AtomContainer.GetMoviesError());
        return n2;
    }

    public int countChildrenOfType(Atom atom, int n) throws StdQTException {
        short s = AtomContainer.QTCountChildrenOfType(this._ID(), atom != null ? atom.getAtom() : 0, n);
        StdQTException.checkError(AtomContainer.GetMoviesError());
        return s;
    }

    public Atom findChildByIndex_Atom(Atom atom, int n, int n2) throws StdQTException {
        int n3 = AtomContainer.QTFindChildByIndex(this._ID(), atom != null ? atom.getAtom() : 0, n, (short)n2, null);
        StdQTException.checkError(AtomContainer.GetMoviesError());
        return n3 != 0 ? new Atom(n3) : null;
    }

    public int findChildByIndex_id(Atom atom, int n, int n2) throws StdQTException {
        int[] nArray = new int[1];
        AtomContainer.QTFindChildByIndex(this._ID(), atom != null ? atom.getAtom() : 0, n, (short)n2, nArray);
        StdQTException.checkError(AtomContainer.GetMoviesError());
        return nArray[0];
    }

    public Atom findChildByID_Atom(Atom atom, int n, int n2) throws StdQTException {
        int n3 = AtomContainer.QTFindChildByID(this._ID(), atom != null ? atom.getAtom() : 0, n, n2, null);
        StdQTException.checkError(AtomContainer.GetMoviesError());
        return n3 != 0 ? new Atom(n3) : null;
    }

    public int findChildByID_index(Atom atom, int n, int n2) throws StdQTException {
        short[] sArray = new short[1];
        AtomContainer.QTFindChildByID(this._ID(), atom != null ? atom.getAtom() : 0, n, n2, sArray);
        StdQTException.checkError(AtomContainer.GetMoviesError());
        return sArray[0];
    }

    public Atom nextChildAnyType(Atom atom, Atom atom2) throws StdQTException {
        int[] nArray = new int[1];
        int n = atom != null ? atom.getAtom() : 0;
        StdQTException.checkError(AtomContainer.QTNextChildAnyType(this._ID(), n, atom2 != null ? atom2.getAtom() : 0, nArray));
        return nArray[0] != 0 ? new Atom(nArray[0]) : null;
    }

    public void setAtomData(Atom atom, QTHandleRef qTHandleRef) throws StdQTException {
        QTPointerRef qTPointerRef = qTHandleRef.toQTPointer();
        short s = AtomContainer.QTSetAtomData(this._ID(), atom.getAtom(), qTHandleRef.getSize(), QTObject.ID(qTPointerRef));
        if (!this.isLocked()) {
            qTHandleRef.unlock();
        }
        StdQTException.checkError(s);
    }

    public void setAtomData(Atom atom, QTPointerRef qTPointerRef) throws StdQTException {
        StdQTException.checkError(AtomContainer.QTSetAtomData(this._ID(), atom.getAtom(), qTPointerRef.getSize(), QTObject.ID(qTPointerRef)));
    }

    public void setAtomData(Atom atom, byte[] byArray) throws StdQTException {
        StdQTException.checkError(AtomContainer.QTSetAtomData(this._ID(), atom.getAtom(), byArray.length, byArray));
    }

    public void setAtomData(Atom atom, QTByteObject qTByteObject) throws StdQTException {
        StdQTException.checkError(AtomContainer.QTSetAtomData(this._ID(), atom.getAtom(), qTByteObject.getSize(), qTByteObject.getBytes()));
    }

    public void setAtomData(Atom atom, int n) throws StdQTException {
        int[] nArray = new int[]{n};
        StdQTException.checkError(AtomContainer.QTSetAtomData(this._ID(), atom.getAtom(), 4, nArray));
    }

    public void setAtomData(Atom atom, short s) throws StdQTException {
        short[] sArray = new short[]{s};
        StdQTException.checkError(AtomContainer.QTSetAtomData(this._ID(), atom.getAtom(), 2, sArray));
    }

    public void setAtomData(Atom atom, byte by) throws StdQTException {
        byte[] byArray = new byte[]{by};
        StdQTException.checkError(AtomContainer.QTSetAtomData(this._ID(), atom.getAtom(), 1, byArray));
    }

    public QTHandle copyAtomDataToHandle(Atom atom) throws QTException {
        QTHandle qTHandle = new QTHandle();
        StdQTException.checkError(AtomContainer.QTCopyAtomDataToHandle(this._ID(), atom.getAtom(), QTObject.ID(qTHandle)));
        return qTHandle;
    }

    public int copyAtomDataToPtr(Atom atom, boolean bl, QTPointer qTPointer) throws StdQTException {
        int[] nArray = new int[1];
        byte by = (byte)(bl ? 1 : 0);
        StdQTException.checkError(AtomContainer.QTCopyAtomDataToPtr(this._ID(), atom.getAtom(), by, qTPointer.getSize(), QTObject.ID(qTPointer), nArray));
        return nArray[0];
    }

    public byte[] copyAtomDataToArray(Atom atom) throws StdQTException {
        int[] nArray = new int[]{0};
        int[] nArray2 = new int[]{0};
        StdQTException.checkError(AtomContainer.QTGetAtomDataPtr(this._ID(), atom.getAtom(), nArray, nArray2));
        byte[] byArray = new byte[nArray[0]];
        int[] nArray3 = new int[]{0};
        StdQTException.checkError(AtomContainer.QTCopyAtomDataToPtr(this._ID(), atom.getAtom(), (byte)0, byArray.length, byArray, nArray3));
        return byArray;
    }

    public int getAtomType(Atom atom) throws StdQTException {
        int[] nArray = new int[1];
        StdQTException.checkError(AtomContainer.QTGetAtomTypeAndID(this._ID(), atom.getAtom(), nArray, null));
        return nArray[0];
    }

    public int getAtomID(Atom atom) throws StdQTException {
        int[] nArray = new int[1];
        StdQTException.checkError(AtomContainer.QTGetAtomTypeAndID(this._ID(), atom.getAtom(), null, nArray));
        return nArray[0];
    }

    public AtomContainer copyAtom(Atom atom) throws StdQTException {
        int[] nArray = new int[1];
        StdQTException.checkError(AtomContainer.QTCopyAtom(this._ID(), atom.getAtom(), nArray));
        return new AtomContainer(nArray[0], null, false);
    }

    protected final void doLock() {
        AtomContainer.QTLockContainer(this._ID());
    }

    protected final void doUnlock() {
        AtomContainer.QTUnlockContainer(this._ID());
    }

    public Atom insertChild(Atom atom, int n, int n2, int n3) throws QTException {
        int[] nArray = new int[1];
        StdQTException.checkError(AtomContainer.QTInsertChild(this._ID(), atom != null ? atom.getAtom() : 0, n, n2, (short)n3, 0, 0, nArray));
        return nArray[0] != 0 ? new Atom(nArray[0]) : null;
    }

    public Atom insertChild(Atom atom, int n, int n2, int n3, QTByteObject qTByteObject) throws StdQTException {
        int[] nArray = new int[1];
        StdQTException.checkError(AtomContainer.QTInsertChild(this._ID(), atom != null ? atom.getAtom() : 0, n, n2, (short)n3, qTByteObject.getSize(), qTByteObject.getBytes(), nArray));
        return nArray[0] != 0 ? new Atom(nArray[0]) : null;
    }

    public Atom insertChild(Atom atom, int n, int n2, int n3, byte[] byArray) throws StdQTException {
        int[] nArray = new int[1];
        StdQTException.checkError(AtomContainer.QTInsertChild(this._ID(), atom != null ? atom.getAtom() : 0, n, n2, (short)n3, byArray.length, byArray, nArray));
        return nArray[0] != 0 ? new Atom(nArray[0]) : null;
    }

    public Atom insertChild(Atom atom, int n, int n2, int n3, QTPointerRef qTPointerRef) throws StdQTException {
        int[] nArray = new int[1];
        StdQTException.checkError(AtomContainer.QTInsertChild(this._ID(), atom != null ? atom.getAtom() : 0, n, n2, (short)n3, qTPointerRef.getSize(), QTObject.ID(qTPointerRef), nArray));
        return nArray[0] != 0 ? new Atom(nArray[0]) : null;
    }

    public Atom insertChild(Atom atom, int n, int n2, int n3, QTHandleRef qTHandleRef) throws StdQTException {
        int[] nArray = new int[1];
        QTPointerRef qTPointerRef = qTHandleRef.toQTPointer();
        short s = AtomContainer.QTInsertChild(this._ID(), atom != null ? atom.getAtom() : 0, n, n2, (short)n3, qTHandleRef.getSize(), QTObject.ID(qTPointerRef), nArray);
        if (!qTHandleRef.isLocked()) {
            qTHandleRef.unlock();
        }
        StdQTException.checkError(s);
        return nArray[0] != 0 ? new Atom(nArray[0]) : null;
    }

    public Atom insertChild(Atom atom, int n, int n2, int n3, int n4) throws StdQTException {
        int[] nArray = new int[1];
        int[] nArray2 = new int[]{n4};
        StdQTException.checkError(AtomContainer.QTInsertChild(this._ID(), atom != null ? atom.getAtom() : 0, n, n2, (short)n3, 4, nArray2, nArray));
        return nArray[0] != 0 ? new Atom(nArray[0]) : null;
    }

    public Atom insertChild(Atom atom, int n, int n2, int n3, short s) throws StdQTException {
        int[] nArray = new int[1];
        short[] sArray = new short[]{s};
        StdQTException.checkError(AtomContainer.QTInsertChild(this._ID(), atom != null ? atom.getAtom() : 0, n, n2, (short)n3, 2, sArray, nArray));
        return nArray[0] != 0 ? new Atom(nArray[0]) : null;
    }

    public Atom insertChild(Atom atom, int n, int n2, int n3, byte by) throws StdQTException {
        int[] nArray = new int[1];
        byte[] byArray = new byte[]{by};
        StdQTException.checkError(AtomContainer.QTInsertChild(this._ID(), atom != null ? atom.getAtom() : 0, n, n2, (short)n3, 1, byArray, nArray));
        return nArray[0] != 0 ? new Atom(nArray[0]) : null;
    }

    public void insertChildren(Atom atom, AtomContainer atomContainer) throws StdQTException {
        if (QTObject.ID(atomContainer) == 0) {
            throw new StdQTException(-2107);
        }
        StdQTException.checkError(AtomContainer.QTInsertChildren(this._ID(), atom != null ? atom.getAtom() : 0, QTObject.ID(atomContainer)));
    }

    public void removeAtom(Atom atom) throws StdQTException {
        StdQTException.checkError(AtomContainer.QTRemoveAtom(this._ID(), atom.getAtom()));
    }

    public void removeChildren(Atom atom) throws StdQTException {
        StdQTException.checkError(AtomContainer.QTRemoveChildren(this._ID(), atom.getAtom()));
    }

    public void replaceAtom(Atom atom, AtomContainer atomContainer, Atom atom2) throws StdQTException {
        if (QTObject.ID(atomContainer) == 0) {
            throw new StdQTException(-2107);
        }
        StdQTException.checkError(AtomContainer.QTReplaceAtom(this._ID(), atom.getAtom(), QTObject.ID(atomContainer), atom2.getAtom()));
    }

    public void swapAtoms(Atom atom, Atom atom2) throws StdQTException {
        StdQTException.checkError(AtomContainer.QTSwapAtoms(this._ID(), atom.getAtom(), atom2.getAtom()));
    }

    public void setAtomID(Atom atom, int n) throws StdQTException {
        StdQTException.checkError(AtomContainer.QTSetAtomID(this._ID(), atom.getAtom(), n));
    }

    public void iTextAddString(Atom atom, int n, String string) throws StdQTException {
        StdQTException.checkError(AtomContainer.ITextAddString(this._ID(), atom != null ? atom.getAtom() : 0, (short)n, QTUtils.String2PString(string, 255)));
    }

    public void iTextRemoveString(Atom atom, int n, int n2) throws StdQTException {
        StdQTException.checkError(AtomContainer.ITextRemoveString(this._ID(), atom != null ? atom.getAtom() : 0, (short)n, n2));
    }

    public IStringInfo iTextGetString(Atom atom, int n) throws StdQTException {
        short[] sArray = new short[1];
        byte[] byArray = new byte[256];
        StdQTException.checkError(AtomContainer.ITextGetString(this._ID(), atom != null ? atom.getAtom() : 0, (short)n, sArray, byArray));
        return new IStringInfo(QTUtils.PString2String(byArray, 0), sArray[0]);
    }

    public Atom getParent(Atom atom) throws StdQTException {
        int n = AtomContainer.QTGetAtomParent(this._ID(), atom.getAtom());
        if (n < 0) {
            throw new StdQTException(n);
        }
        return new Atom(n);
    }

    private static native int GraphicsExportGetSettingsAsAtomContainer(int var0, int[] var1);

    private static native int GraphicsExportCanUseCompressor(int var0, byte[] var1, int[] var2);

    private static native int GraphicsExportGetMIMETypeList(int var0, int[] var1);

    private static native short QTVRGetVRWorld(int var0, int[] var1);

    private static native short QTVRGetNodeInfo(int var0, int var1, int[] var2);

    private static native int GraphicsImportGetMIMETypeList(int var0, int[] var1);

    private static native int GraphicsImportGetExportImageTypeList(int var0, int[] var1);

    private static native int GraphicsImportGetExportSettingsAsAtomContainer(int var0, int[] var1);

    private static native short GetMediaInputMap(int var0, int[] var1);

    private static native short GetMediaPropertyAtom(int var0, int[] var1);

    private static native int MovieExportGetSettingsAsAtomContainer(int var0, int[] var1);

    private static native int MovieImportGetMIMETypeList(int var0, int[] var1);

    private static native int MovieImportGetSettingsAsAtomContainer(int var0, int[] var1);

    private static native int Media3DGetNamedObjectList(int var0, int[] var1);

    private static native int Media3DGetRendererList(int var0, int[] var1);

    private static native int SCGetSettingsAsAtomContainer(int var0, int[] var1);

    private static native short QTNewAtomContainer(int[] var0);

    private static native short QTGetAtomDataPtr(int var0, int var1, int[] var2, int[] var3);

    private static native int QTGetNextChildType(int var0, int var1, int var2);

    private static native short GetMoviesError();

    private static native short QTCountChildrenOfType(int var0, int var1, int var2);

    private static native int QTFindChildByIndex(int var0, int var1, int var2, short var3, int[] var4);

    private static native int QTFindChildByID(int var0, int var1, int var2, int var3, short[] var4);

    private static native short QTNextChildAnyType(int var0, int var1, int var2, int[] var3);

    private static native short QTSetAtomData(int var0, int var1, int var2, byte[] var3);

    private static native short QTSetAtomData(int var0, int var1, int var2, int var3);

    private static native short QTSetAtomData(int var0, int var1, int var2, int[] var3);

    private static native short QTSetAtomData(int var0, int var1, int var2, short[] var3);

    private static native short QTCopyAtomDataToHandle(int var0, int var1, int var2);

    private static native short QTCopyAtomDataToPtr(int var0, int var1, byte var2, int var3, int var4, int[] var5);

    private static native short QTCopyAtomDataToPtr(int var0, int var1, byte var2, int var3, byte[] var4, int[] var5);

    private static native short QTGetAtomTypeAndID(int var0, int var1, int[] var2, int[] var3);

    private static native short QTCopyAtom(int var0, int var1, int[] var2);

    private static native short QTLockContainer(int var0);

    private static native short QTUnlockContainer(int var0);

    private static native short QTInsertChild(int var0, int var1, int var2, int var3, short var4, int var5, byte[] var6, int[] var7);

    private static native short QTInsertChild(int var0, int var1, int var2, int var3, short var4, int var5, int var6, int[] var7);

    private static native short QTInsertChild(int var0, int var1, int var2, int var3, short var4, int var5, int[] var6, int[] var7);

    private static native short QTInsertChild(int var0, int var1, int var2, int var3, short var4, int var5, short[] var6, int[] var7);

    private static native short QTInsertChildren(int var0, int var1, int var2);

    private static native short QTRemoveAtom(int var0, int var1);

    private static native short QTRemoveChildren(int var0, int var1);

    private static native short QTReplaceAtom(int var0, int var1, int var2, int var3);

    private static native short QTSwapAtoms(int var0, int var1, int var2);

    private static native short QTSetAtomID(int var0, int var1, int var2);

    private static native short ITextAddString(int var0, int var1, short var2, byte[] var3);

    private static native short ITextRemoveString(int var0, int var1, short var2, int var3);

    private static native short ITextGetString(int var0, int var1, short var2, short[] var3, byte[] var4);

    private static native int QTGetAtomParent(int var0, int var1);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

