/*
 * Decompiled with CFR 0.152.
 */
package quicktime.std.movies.media;

import java.io.File;
import java.io.IOException;
import quicktime.QTException;
import quicktime.QTObject;
import quicktime.QTSession;
import quicktime.io.AliasHandle;
import quicktime.io.QTFile;
import quicktime.jdirect.QTNative;
import quicktime.jdirect.QuickTimeLib;
import quicktime.std.StdQTException;
import quicktime.std.image.GraphicsExporter;
import quicktime.std.movies.Movie;
import quicktime.std.movies.media.Media;
import quicktime.std.sg.SGOutput;
import quicktime.std.sg.SequenceGrabber;
import quicktime.util.EndianOrder;
import quicktime.util.QTHandle;
import quicktime.util.QTHandleRef;
import quicktime.util.QTUtils;
import quicktime.util.StringHandle;

public final class DataRef
extends QTHandle
implements QuickTimeLib {
    private static Object linkage = QTNative.linkNativeMethods(class$quicktime$std$movies$media$DataRef == null ? (class$quicktime$std$movies$media$DataRef = DataRef.class$("quicktime.std.movies.media.DataRef")) : class$quicktime$std$movies$media$DataRef);
    private int dataRefType;
    private int dataRefAttributes = 0;
    private QTHandleRef hdl = null;
    static /* synthetic */ Class class$quicktime$std$movies$media$DataRef;

    public static DataRef fromGraphicsExporterInputDataRef(GraphicsExporter graphicsExporter) throws QTException {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int n = DataRef.GraphicsExportGetInputDataReference(QTObject.ID(graphicsExporter), nArray, nArray2);
        return new DataRef(nArray[0], nArray2[0], 0);
    }

    public static DataRef fromGraphicsExporterOutputDataRef(GraphicsExporter graphicsExporter) throws QTException {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int n = DataRef.GraphicsExportGetOutputDataReference(QTObject.ID(graphicsExporter), nArray, nArray2);
        StdQTException.checkError(n);
        return new DataRef(nArray[0], nArray2[0], 0);
    }

    public static DataRef fromMovie(Movie movie) throws QTException {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        short s = DataRef.GetMovieDefaultDataRef(QTObject.ID(movie), nArray, nArray2);
        StdQTException.checkError(s);
        return new DataRef(nArray[0], nArray2[0], 0);
    }

    public static DataRef fromSequenceGrabber(SequenceGrabber sequenceGrabber) throws StdQTException {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        int n = DataRef.SGGetDataRef(QTObject.ID(sequenceGrabber), nArray, nArray2, nArray3);
        StdQTException.checkError(n);
        return new DataRef(nArray[0], nArray2[0], 0, sequenceGrabber);
    }

    public static DataRef fromMedia(Media media, int n) throws QTException {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        StdQTException.checkError(DataRef.GetMediaDataRef(QTObject.ID(media), (short)n, nArray, nArray2, nArray3));
        return new DataRef(nArray[0], nArray2[0], nArray3[0]);
    }

    public static DataRef fromSGOutput(SequenceGrabber sequenceGrabber, SGOutput sGOutput) throws StdQTException {
        int[] nArray = new int[]{0};
        int[] nArray2 = new int[]{0};
        int n = DataRef.SGGetOutputDataReference(QTObject.ID(sequenceGrabber), QTObject.ID(sGOutput), nArray, nArray2);
        StdQTException.checkError(n);
        return new DataRef(nArray[0], nArray2[0], 0);
    }

    public DataRef(String string) throws QTException {
        super(4, false);
        if (string.startsWith("file")) {
            QTFile qTFile = new QTFile(string.substring(7).replace('/', File.separatorChar));
            this.setAliasHandle(qTFile.newAlias(true));
        } else {
            this.setURLDataRef(QTUtils.String2CString(string));
        }
    }

    public DataRef(QTFile qTFile) throws QTException {
        super(4, false);
        this.setAliasHandle(qTFile.newAlias(true));
    }

    public DataRef(AliasHandle aliasHandle) throws IOException, QTException {
        super(4, false);
        this.setAliasHandle(aliasHandle);
    }

    public DataRef(QTHandleRef qTHandleRef) throws QTException {
        super(4, true);
        this.dataRefType = 1752065132;
        this.hdl = qTHandleRef;
        this.setIntAt(0, QTObject.ID(qTHandleRef));
    }

    public DataRef(QTHandleRef qTHandleRef, int n, String string) throws QTException {
        super(4, true);
        this.dataRefType = 1752065132;
        this.hdl = qTHandleRef;
        this.setIntAt(0, QTObject.ID(qTHandleRef));
        switch (n) {
            case 1718909296: {
                if (QTSession.getQTVersion() == 3) {
                    throw new QTException(-50);
                }
                this.setSize(17);
                this.setByteAt(4, (byte)0);
                this.setIntAt(5, EndianOrder.flipNativeToBigEndian32(12));
                this.setIntAt(9, EndianOrder.flipNativeToBigEndian32(1718909296));
                this.setIntAt(13, EndianOrder.flipNativeToBigEndian32(QTUtils.toOSType(string)));
                break;
            }
            case 1835625829: {
                if (QTSession.getQTVersion() == 3) {
                    throw new QTException(-50);
                }
                byte[] byArray = QTUtils.String2PString(string, 255);
                this.setSize(13 + byArray.length);
                this.setByteAt(4, (byte)0);
                this.setIntAt(5, EndianOrder.flipNativeToBigEndian32(8 + byArray.length));
                this.setIntAt(9, EndianOrder.flipNativeToBigEndian32(1835625829));
                this.setBytesAt(13, byArray.length, byArray, 0);
                break;
            }
            case 1702392864: {
                this.concatenate(new StringHandle("X." + string, 2));
                break;
            }
            default: {
                throw new QTException(-50);
            }
        }
    }

    private DataRef(int n, int n2, int n3, Object object) {
        super(n, object, false);
        this.dataRefType = n2;
        this.dataRefAttributes = n3;
    }

    private DataRef(int n, int n2, int n3) {
        super(n, null, false);
        this.dataRefType = n2;
        this.dataRefAttributes = n3;
    }

    private void setAliasHandle(AliasHandle aliasHandle) throws QTException {
        this.copyFromHandle(aliasHandle);
        this.dataRefType = 1634494835;
    }

    private void setURLDataRef(byte[] byArray) throws QTException {
        this.setSize(byArray.length);
        this.copyFromArray(0, byArray, 0, byArray.length);
        this.dataRefType = 1970433056;
        int n = DataRef.GetDataHandler(this._ID(), this.getType(), 1);
        if (n == 0) {
            throw new QTException(-2012);
        }
    }

    private void copyFromHandle(QTHandleRef qTHandleRef) throws QTException {
        this.setSize(qTHandleRef.getSize());
        this.copyFromHandle(0, qTHandleRef, 0, qTHandleRef.getSize());
    }

    public int getType() {
        return this.dataRefType;
    }

    public int getAttributes() {
        return this.dataRefAttributes;
    }

    public String getUniversalResourceLocator() throws QTException {
        if (this.dataRefType == 1970433056) {
            return this.getCStringAt(0);
        }
        if (this.dataRefType == 1634494835) {
            AliasHandle aliasHandle = AliasHandle.fromDataRef(this);
            QTFile qTFile = QTFile.resolveAlias(aliasHandle);
            return qTFile.getPath();
        }
        return null;
    }

    public DataRef fromMovieAnchor(Movie movie) throws StdQTException {
        short s = 0;
        int[] nArray = new int[]{0};
        int[] nArray2 = new int[]{0};
        int[] nArray3 = new int[]{0};
        s = DataRef.GetMovieAnchorDataRef(QTObject.ID(movie), nArray, nArray2, nArray3);
        StdQTException.checkError(s);
        if (nArray[0] == 0) {
            return null;
        }
        return new DataRef(nArray[0], nArray2[0], 0);
    }

    private static native short GetMediaDataRef(int var0, short var1, int[] var2, int[] var3, int[] var4);

    private static native short GetMovieDefaultDataRef(int var0, int[] var1, int[] var2);

    private static native int SGGetDataRef(int var0, int[] var1, int[] var2, int[] var3);

    private static native int GraphicsExportGetInputDataReference(int var0, int[] var1, int[] var2);

    private static native int GraphicsExportGetOutputDataReference(int var0, int[] var1, int[] var2);

    private static native int GetDataHandler(int var0, int var1, int var2);

    private static native int SGGetOutputDataReference(int var0, int var1, int[] var2, int[] var3);

    private static native short GetMovieAnchorDataRef(int var0, int[] var1, int[] var2, int[] var3);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

