/*
 * Decompiled with CFR 0.152.
 */
package quicktime.std.movies.media;

import java.lang.reflect.Constructor;
import java.util.Hashtable;
import quicktime.QTException;
import quicktime.QTObject;
import quicktime.jdirect.QTNative;
import quicktime.jdirect.QuickTimeLib;
import quicktime.std.StdQTException;
import quicktime.std.movies.AtomContainer;
import quicktime.std.movies.TimeInfo;
import quicktime.std.movies.Track;
import quicktime.std.movies.media.BaseMedia;
import quicktime.std.movies.media.DataHandler;
import quicktime.std.movies.media.DataRef;
import quicktime.std.movies.media.FlashMedia;
import quicktime.std.movies.media.GenericMedia;
import quicktime.std.movies.media.HandlerInfo;
import quicktime.std.movies.media.MPEGMedia;
import quicktime.std.movies.media.MediaHandler;
import quicktime.std.movies.media.MediaSample;
import quicktime.std.movies.media.MovieMedia;
import quicktime.std.movies.media.MusicMedia;
import quicktime.std.movies.media.SampleDescription;
import quicktime.std.movies.media.SampleInfo;
import quicktime.std.movies.media.SampleReferenceInfo;
import quicktime.std.movies.media.SampleReferenceVector;
import quicktime.std.movies.media.SampleTimeInfo;
import quicktime.std.movies.media.SoundMedia;
import quicktime.std.movies.media.SpriteMedia;
import quicktime.std.movies.media.StreamMedia;
import quicktime.std.movies.media.TextMedia;
import quicktime.std.movies.media.ThreeDMedia;
import quicktime.std.movies.media.TimeCodeMedia;
import quicktime.std.movies.media.TweenMedia;
import quicktime.std.movies.media.UserData;
import quicktime.std.movies.media.VideoMedia;
import quicktime.util.QTHandle;
import quicktime.util.QTHandleRef;
import quicktime.util.QTUtils;

public abstract class Media
extends QTObject
implements QuickTimeLib {
    private static Object linkage = QTNative.linkNativeMethods(class$quicktime$std$movies$media$Media == null ? (class$quicktime$std$movies$media$Media = Media.class$("quicktime.std.movies.media.Media")) : class$quicktime$std$movies$media$Media);
    private static Hashtable mediaObjects = new Hashtable();
    Track track;
    static /* synthetic */ Class class$quicktime$std$movies$media$Media;

    private static Media makeGenericMedia(int n, int n2, Track track) throws QTException {
        String string = (String)mediaObjects.get(new Integer(n));
        try {
            GenericMedia genericMedia = null;
            if (string == null) {
                genericMedia = new GenericMedia(n2);
            } else {
                Class<?> clazz = Class.forName(string);
                Class[] classArray = new Class[]{Class.forName("java.lang.Integer")};
                Constructor<?> constructor = clazz.getDeclaredConstructor(classArray);
                Object[] objectArray = new Object[]{new Integer(n2)};
                genericMedia = (GenericMedia)constructor.newInstance(objectArray);
            }
            genericMedia.setIDs(n, track);
            return genericMedia;
        }
        catch (Exception exception) {
            throw new QTException(exception.toString());
        }
    }

    private static Media fromGenericType(int n, Track track, int n2, DataRef dataRef) throws QTException {
        int n3 = Media.NewTrackMedia(QTObject.ID(track), n, n2, QTObject.ID(dataRef), dataRef != null ? dataRef.getType() : 0);
        StdQTException.checkError(Media.GetMoviesError());
        return Media.makeGenericMedia(n, n3, track);
    }

    private static Media makeMedia(int n, Track track) throws QTException {
        if (n == 0) {
            return null;
        }
        int[] nArray = new int[1];
        Media.GetMediaHandlerDescription(n, nArray, null, null);
        StdQTException.checkError(Media.GetMoviesError());
        switch (nArray[0]) {
            case 1735291491: {
                return new BaseMedia(n, track);
            }
            case 1297106247: {
                return new MPEGMedia(n, track);
            }
            case 1836413801: {
                return new MusicMedia(n, track);
            }
            case 1936684398: {
                return new SoundMedia(n, track);
            }
            case 1936749172: {
                return new SpriteMedia(n, track);
            }
            case 1952807028: {
                return new TextMedia(n, track);
            }
            case 1902392164: {
                return new ThreeDMedia(n, track);
            }
            case 1953325924: {
                return new TimeCodeMedia(n, track);
            }
            case 1953981806: {
                return new TweenMedia(n, track);
            }
            case 1986618469: {
                return new VideoMedia(n, track);
            }
            case 1718383464: {
                return new FlashMedia(n, track);
            }
            case 1937011309: {
                return new StreamMedia(n, track);
            }
            case 1836019574: {
                return new MovieMedia(n, track);
            }
        }
        return Media.makeGenericMedia(nArray[0], n, track);
    }

    protected static void addMediaType(int n, String string) {
        mediaObjects.put(new Integer(n), string);
    }

    public static Media newFromType(int n, Track track, int n2, DataRef dataRef) throws QTException {
        if (n == 0 || track == null) {
            throw new QTException(-50);
        }
        switch (n) {
            case 1735291491: {
                return new BaseMedia(track, n2, dataRef);
            }
            case 1297106247: {
                return new MPEGMedia(track, n2, dataRef);
            }
            case 1836413801: {
                return new MusicMedia(track, n2, dataRef);
            }
            case 1936684398: {
                return new SoundMedia(track, n2, dataRef);
            }
            case 1936749172: {
                return new SpriteMedia(track, n2, dataRef);
            }
            case 1952807028: {
                return new TextMedia(track, n2, dataRef);
            }
            case 1902392164: {
                return new ThreeDMedia(track, n2, dataRef);
            }
            case 1953325924: {
                return new TimeCodeMedia(track, n2, dataRef);
            }
            case 1953981806: {
                return new TweenMedia(track, n2, dataRef);
            }
            case 1986618469: {
                return new VideoMedia(track, n2, dataRef);
            }
            case 1718383464: {
                return new FlashMedia(track, n2, dataRef);
            }
            case 1937011309: {
                return new StreamMedia(track, n2, dataRef);
            }
            case 1836019574: {
                return new MovieMedia(track, n2, dataRef);
            }
        }
        return Media.fromGenericType(n, track, n2, dataRef);
    }

    public static Media fromTrack(Track track) throws QTException {
        return Media.getTrackMedia(track);
    }

    public static Media getTrackMedia(Track track) throws QTException {
        int n = Media.GetTrackMedia(QTObject.ID(track));
        StdQTException.checkError(Media.GetMoviesError());
        return Media.makeMedia(n, track);
    }

    protected Media(Track track, int n, int n2, DataRef dataRef) throws QTException {
        super(Media.allocate(track, n, n2, dataRef));
        this.track = track;
    }

    private static int allocate(Track track, int n, int n2, DataRef dataRef) throws StdQTException {
        int n3 = Media.NewTrackMedia(QTObject.ID(track), n, n2, QTObject.ID(dataRef), dataRef != null ? dataRef.getType() : 0);
        StdQTException.checkError(Media.GetMoviesError());
        return n3;
    }

    Media(Track track, int n) throws QTException {
        super(n);
        this.track = track;
    }

    protected final int getNativeMediaHandler() throws StdQTException {
        int n = Media.GetMediaHandler(this._ID());
        StdQTException.checkError(Media.GetMoviesError());
        return n;
    }

    protected final void getNativeSampleDescription(int n, SampleDescription sampleDescription) throws StdQTException {
        Media.GetMediaSampleDescription(this._ID(), n, QTObject.ID(sampleDescription));
        StdQTException.checkError(Media.GetMoviesError());
    }

    abstract SampleDescription makeDescription() throws QTException;

    abstract MediaHandler makeHandler(int var1, Object var2) throws StdQTException;

    public SampleDescription getSampleDescription(int n) throws QTException {
        SampleDescription sampleDescription = this.makeDescription();
        this.getNativeSampleDescription(n, sampleDescription);
        return sampleDescription;
    }

    public final void setSampleDescription(int n, SampleDescription sampleDescription) throws StdQTException {
        Media.SetMediaSampleDescription(this._ID(), n, QTObject.ID(sampleDescription));
        StdQTException.checkError(Media.GetMoviesError());
    }

    public final DataHandler getDataHandler(int n) throws StdQTException {
        int n2 = Media.GetMediaDataHandler(this._ID(), (short)n);
        StdQTException.checkError(Media.GetMoviesError());
        return new DataHandler(n2, this);
    }

    public final void setDataHandler(int n, DataHandler dataHandler) throws StdQTException {
        StdQTException.checkError(Media.SetMediaDataHandler(this._ID(), (short)n, QTObject.ID(dataHandler)));
    }

    public MediaHandler getHandler() throws StdQTException {
        return this.makeHandler(this.getNativeMediaHandler(), this);
    }

    public final void setHandler(MediaHandler mediaHandler) throws StdQTException {
        StdQTException.checkError(Media.SetMediaHandler(this._ID(), QTObject.ID(mediaHandler)));
    }

    public final Track getTrack() throws QTException {
        return Track.fromMedia(this);
    }

    public final int getCreationTime() throws StdQTException {
        int n = Media.GetMediaCreationTime(this._ID());
        StdQTException.checkError(Media.GetMoviesError());
        return n;
    }

    public final int getModificationTime() throws StdQTException {
        int n = Media.GetMediaModificationTime(this._ID());
        StdQTException.checkError(Media.GetMoviesError());
        return n;
    }

    public final int getTimeScale() throws StdQTException {
        int n = Media.GetMediaTimeScale(this._ID());
        StdQTException.checkError(Media.GetMoviesError());
        return n;
    }

    public final void setTimeScale(int n) throws StdQTException {
        Media.SetMediaTimeScale(this._ID(), n);
        StdQTException.checkError(Media.GetMoviesError());
    }

    public final int getDuration() throws StdQTException {
        int n = Media.GetMediaDuration(this._ID());
        StdQTException.checkError(Media.GetMoviesError());
        return n;
    }

    public final int getLanguage() throws StdQTException {
        short s = Media.GetMediaLanguage(this._ID());
        StdQTException.checkError(Media.GetMoviesError());
        return s;
    }

    public final void setLanguage(int n) throws StdQTException {
        Media.SetMediaLanguage(this._ID(), (short)n);
        StdQTException.checkError(Media.GetMoviesError());
    }

    public final int getQuality() throws StdQTException {
        short s = Media.GetMediaQuality(this._ID());
        StdQTException.checkError(Media.GetMoviesError());
        return s;
    }

    public final void setQuality(int n) throws StdQTException {
        Media.SetMediaQuality(this._ID(), (short)n);
        StdQTException.checkError(Media.GetMoviesError());
    }

    public final HandlerInfo getHandlerDescription() throws StdQTException {
        int[] nArray = new int[1];
        byte[] byArray = new byte[255];
        int[] nArray2 = new int[1];
        Media.GetMediaHandlerDescription(this._ID(), nArray, byArray, nArray2);
        StdQTException.checkError(Media.GetMoviesError());
        return new HandlerInfo(nArray[0], new String(byArray, 1, (int)byArray[0]), nArray2[0]);
    }

    public final UserData getUserData() throws StdQTException {
        return UserData.fromMedia(this);
    }

    public final AtomContainer getInputMap() throws StdQTException {
        return AtomContainer.fromMediaInput(this);
    }

    public final void setInputMap(AtomContainer atomContainer) throws StdQTException {
        StdQTException.checkError(Media.SetMediaInputMap(this._ID(), QTObject.ID(atomContainer)));
    }

    public final void beginEdits() throws StdQTException {
        StdQTException.checkError(Media.BeginMediaEdits(this._ID()));
    }

    public final void endEdits() throws StdQTException {
        StdQTException.checkError(Media.EndMediaEdits(this._ID()));
    }

    public final void setDefaultDataRefIndex(int n) throws StdQTException {
        StdQTException.checkError(Media.SetMediaDefaultDataRefIndex(this._ID(), (short)n));
    }

    public final HandlerInfo getDataHandlerDescription(int n) throws StdQTException {
        int[] nArray = new int[1];
        byte[] byArray = new byte[255];
        int[] nArray2 = new int[1];
        Media.GetMediaDataHandlerDescription(this._ID(), (short)n, nArray, byArray, nArray2);
        StdQTException.checkError(Media.GetMoviesError());
        return new HandlerInfo(nArray[0], new String(byArray, 1, (int)byArray[0]), nArray2[0]);
    }

    public final int getSampleDescriptionCount() throws StdQTException {
        int n = Media.GetMediaSampleDescriptionCount(this._ID());
        StdQTException.checkError(Media.GetMoviesError());
        return n;
    }

    public final int getSampleCount() throws StdQTException {
        int n = Media.GetMediaSampleCount(this._ID());
        StdQTException.checkError(Media.GetMoviesError());
        return n;
    }

    public final int getSyncSampleCount() throws StdQTException {
        int n = Media.GetMediaSyncSampleCount(this._ID());
        StdQTException.checkError(Media.GetMoviesError());
        return n;
    }

    public final TimeInfo sampleNumToMediaTime(int n) throws StdQTException {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        Media.SampleNumToMediaTime(this._ID(), n, nArray, nArray2);
        StdQTException.checkError(Media.GetMoviesError());
        return new TimeInfo(nArray[0], nArray2[0]);
    }

    public final SampleTimeInfo timeToSampleNum(int n) throws StdQTException {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        Media.MediaTimeToSampleNum(this._ID(), n, nArray, nArray2, nArray3);
        StdQTException.checkError(Media.GetMoviesError());
        return new SampleTimeInfo(nArray2[0], nArray3[0], nArray[0]);
    }

    public final int addSample(QTHandleRef qTHandleRef, int n, int n2, int n3, SampleDescription sampleDescription, int n4, int n5) throws StdQTException {
        int[] nArray = new int[1];
        StdQTException.checkError(Media.AddMediaSample(this._ID(), QTObject.ID(qTHandleRef), n, n2, n3, QTObject.ID(sampleDescription), n4, (short)n5, nArray));
        return nArray[0];
    }

    public final MediaSample getSample(int n, int n2, int n3) throws QTException {
        QTHandle qTHandle = new QTHandle();
        SampleDescription sampleDescription = this.makeDescription();
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        int[] nArray4 = new int[1];
        int[] nArray5 = new int[1];
        short[] sArray = new short[1];
        StdQTException.checkError(Media.GetMediaSample(this._ID(), QTObject.ID(qTHandle), n, nArray, n2, nArray2, nArray3, QTObject.ID(sampleDescription), nArray4, n3, nArray5, sArray));
        return new MediaSample(nArray2[0], nArray3[0], qTHandle, 0, nArray[0], nArray5[0], sampleDescription, nArray4[0], sArray[0]);
    }

    public final int addSampleReference(int n, int n2, int n3, SampleDescription sampleDescription, int n4, int n5) throws StdQTException {
        int[] nArray = new int[1];
        StdQTException.checkError(Media.AddMediaSampleReference(this._ID(), n, n2, n3, QTObject.ID(sampleDescription), n4, (short)n5, nArray));
        return nArray[0];
    }

    public final SampleInfo getSampleReference(int n, int n2) throws QTException {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        int[] nArray4 = new int[1];
        SampleDescription sampleDescription = this.makeDescription();
        int[] nArray5 = new int[1];
        int[] nArray6 = new int[1];
        short[] sArray = new short[1];
        StdQTException.checkError(Media.GetMediaSampleReference(this._ID(), nArray, nArray2, n, nArray3, nArray4, QTObject.ID(sampleDescription), nArray5, n2, nArray6, sArray));
        return new SampleInfo(nArray3[0], nArray4[0], nArray[0], nArray2[0], nArray6[0], sampleDescription, nArray5[0], sArray[0]);
    }

    public final int addSampleReference(SampleDescription sampleDescription, int n, SampleReferenceVector sampleReferenceVector) throws StdQTException {
        int[] nArray = new int[1];
        short s = Media.AddMediaSampleReferences(this._ID(), QTObject.ID(sampleDescription), n, QTObject.ID(sampleReferenceVector), nArray);
        StdQTException.checkError(s);
        return nArray[0];
    }

    public final SampleReferenceInfo getSampleReferences(int n, int n2) throws QTException {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        SampleDescription sampleDescription = this.makeDescription();
        SampleReferenceVector sampleReferenceVector = new SampleReferenceVector(n2);
        int n3 = QTObject.ID(sampleReferenceVector);
        short s = Media.GetMediaSampleReferences(this._ID(), n, nArray, QTObject.ID(sampleDescription), nArray2, n2, nArray3, n3);
        StdQTException.checkError(s);
        sampleReferenceVector._setNumSamples(nArray3[0]);
        return new SampleReferenceInfo(nArray[0], sampleDescription, nArray2[0], sampleReferenceVector);
    }

    public final void setPreferredChunkSize(int n) throws StdQTException {
        StdQTException.checkError(Media.SetMediaPreferredChunkSize(this._ID(), n));
    }

    public final int getPreferredChunkSize() throws StdQTException {
        int[] nArray = new int[1];
        StdQTException.checkError(Media.GetMediaPreferredChunkSize(this._ID(), nArray));
        return nArray[0];
    }

    public final void setShadowSync(int n, int n2) throws StdQTException {
        StdQTException.checkError(Media.SetMediaShadowSync(this._ID(), n, n2));
    }

    public final int getShadowSync(int n) throws StdQTException {
        int[] nArray = new int[1];
        StdQTException.checkError(Media.GetMediaShadowSync(this._ID(), n, nArray));
        return nArray[0];
    }

    public final TimeInfo getNextInterestingTime(int n, int n2, float f) throws StdQTException {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        Media.GetMediaNextInterestingTime(this._ID(), (short)n, n2, QTUtils.X2Fix(f), nArray, nArray2);
        StdQTException.checkError(Media.GetMoviesError());
        return new TimeInfo(nArray[0], nArray2[0]);
    }

    public final int getDataSize(int n, int n2) throws StdQTException {
        int n3 = Media.GetMediaDataSize(this._ID(), n, n2);
        StdQTException.checkError(Media.GetMoviesError());
        return n3;
    }

    public final DataRef getDataRef(int n) throws QTException {
        return DataRef.fromMedia(this, n);
    }

    public final void setDataRef(int n, DataRef dataRef) throws StdQTException {
        StdQTException.checkError(Media.SetMediaDataRef(this._ID(), (short)n, QTObject.ID(dataRef), dataRef.getType()));
    }

    public final void setDataRefAttributes(int n, int n2) throws StdQTException {
        StdQTException.checkError(Media.SetMediaDataRefAttributes(this._ID(), (short)n, n2));
    }

    public final int addDataRef(DataRef dataRef) throws StdQTException {
        short[] sArray = new short[1];
        StdQTException.checkError(Media.AddMediaDataRef(this._ID(), sArray, QTObject.ID(dataRef), dataRef.getType()));
        return sArray[0];
    }

    public final int getDataRefCount() throws StdQTException {
        short[] sArray = new short[1];
        StdQTException.checkError(Media.GetMediaDataRefCount(this._ID(), sArray));
        return sArray[0];
    }

    public final void setPlayHints(int n, int n2) throws StdQTException {
        Media.SetMediaPlayHints(this._ID(), n, n2);
        StdQTException.checkError(Media.GetMoviesError());
    }

    public final int getPlayHints(int n, int n2) throws StdQTException {
        int[] nArray = new int[]{0};
        Media.GetMediaPlayHints(this._ID(), nArray);
        StdQTException.checkError(Media.GetMoviesError());
        return nArray[0];
    }

    public final int getPlayHints() throws StdQTException {
        int[] nArray = new int[]{0};
        Media.GetMediaPlayHints(this._ID(), nArray);
        StdQTException.checkError(Media.GetMoviesError());
        return nArray[0];
    }

    public final void setPropertyAtom(AtomContainer atomContainer) throws StdQTException {
        StdQTException.checkError(Media.SetMediaPropertyAtom(this._ID(), QTObject.ID(atomContainer)));
    }

    public final AtomContainer getPropertyAtom() throws StdQTException {
        return AtomContainer.fromMediaProperty(this);
    }

    public final void loadIntoRam(int n, int n2, int n3) throws StdQTException {
        StdQTException.checkError(Media.LoadMediaIntoRam(this._ID(), n, n2, n3));
    }

    public void copyUserDataToMedia(Media media, boolean bl) throws StdQTException {
        StdQTException.checkError(Media.CopyMediaUserData(this._ID(), QTObject.ID(media), bl ? 1919970403 : 1835361639));
    }

    public void copyUserDataFromMedia(Media media, boolean bl) throws StdQTException {
        StdQTException.checkError(Media.CopyMediaUserData(QTObject.ID(media), this._ID(), bl ? 1919970403 : 1835361639));
    }

    public static void copyUserData(Media media, Media media2, int n) throws StdQTException {
        StdQTException.checkError(Media.CopyMediaUserData(QTObject.ID(media), QTObject.ID(media2), n));
    }

    private static native int NewTrackMedia(int var0, int var1, int var2, int var3, int var4);

    private static native short GetMoviesError();

    private static native void GetMediaHandlerDescription(int var0, int[] var1, byte[] var2, int[] var3);

    private static native int GetTrackMedia(int var0);

    private static native int GetMediaHandler(int var0);

    private static native void GetMediaSampleDescription(int var0, int var1, int var2);

    private static native short SetMediaSampleDescription(int var0, int var1, int var2);

    private static native int GetMediaDataHandler(int var0, short var1);

    private static native short SetMediaDataHandler(int var0, short var1, int var2);

    private static native short SetMediaHandler(int var0, int var1);

    private static native int GetMediaCreationTime(int var0);

    private static native int GetMediaModificationTime(int var0);

    private static native int GetMediaTimeScale(int var0);

    private static native void SetMediaTimeScale(int var0, int var1);

    private static native int GetMediaDuration(int var0);

    private static native short GetMediaLanguage(int var0);

    private static native void SetMediaLanguage(int var0, short var1);

    private static native short GetMediaQuality(int var0);

    private static native void SetMediaQuality(int var0, short var1);

    private static native short SetMediaInputMap(int var0, int var1);

    private static native short BeginMediaEdits(int var0);

    private static native short EndMediaEdits(int var0);

    private static native short SetMediaDefaultDataRefIndex(int var0, short var1);

    private static native void GetMediaDataHandlerDescription(int var0, short var1, int[] var2, byte[] var3, int[] var4);

    private static native int GetMediaSampleDescriptionCount(int var0);

    private static native int GetMediaSampleCount(int var0);

    private static native int GetMediaSyncSampleCount(int var0);

    private static native void SampleNumToMediaTime(int var0, int var1, int[] var2, int[] var3);

    private static native void MediaTimeToSampleNum(int var0, int var1, int[] var2, int[] var3, int[] var4);

    private static native short AddMediaSample(int var0, int var1, int var2, int var3, int var4, int var5, int var6, short var7, int[] var8);

    private static native short GetMediaSample(int var0, int var1, int var2, int[] var3, int var4, int[] var5, int[] var6, int var7, int[] var8, int var9, int[] var10, short[] var11);

    private static native short AddMediaSampleReference(int var0, int var1, int var2, int var3, int var4, int var5, short var6, int[] var7);

    private static native short GetMediaSampleReference(int var0, int[] var1, int[] var2, int var3, int[] var4, int[] var5, int var6, int[] var7, int var8, int[] var9, short[] var10);

    private static native short AddMediaSampleReferences(int var0, int var1, int var2, int var3, int[] var4);

    private static native short GetMediaSampleReferences(int var0, int var1, int[] var2, int var3, int[] var4, int var5, int[] var6, int var7);

    private static native short SetMediaPreferredChunkSize(int var0, int var1);

    private static native short GetMediaPreferredChunkSize(int var0, int[] var1);

    private static native short SetMediaShadowSync(int var0, int var1, int var2);

    private static native short GetMediaShadowSync(int var0, int var1, int[] var2);

    private static native void GetMediaNextInterestingTime(int var0, short var1, int var2, int var3, int[] var4, int[] var5);

    private static native int GetMediaDataSize(int var0, int var1, int var2);

    private static native short SetMediaDataRef(int var0, short var1, int var2, int var3);

    private static native short SetMediaDataRefAttributes(int var0, short var1, int var2);

    private static native short AddMediaDataRef(int var0, short[] var1, int var2, int var3);

    private static native short GetMediaDataRefCount(int var0, short[] var1);

    private static native void SetMediaPlayHints(int var0, int var1, int var2);

    private static native void GetMediaPlayHints(int var0, int[] var1);

    private static native short SetMediaPropertyAtom(int var0, int var1);

    private static native short LoadMediaIntoRam(int var0, int var1, int var2, int var3);

    private static native short CopyMediaUserData(int var0, int var1, int var2);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

