/*
 * Decompiled with CFR 0.152.
 */
package quicktime.std.movies.media;

import quicktime.QTException;
import quicktime.QTObject;
import quicktime.jdirect.QTNative;
import quicktime.jdirect.QuickTimeLib;
import quicktime.std.StdQTException;
import quicktime.std.image.GraphicsExporter;
import quicktime.std.movies.Movie;
import quicktime.std.movies.Track;
import quicktime.std.movies.media.Media;
import quicktime.std.qtcomponents.TimeCodeDescription;
import quicktime.std.qtcomponents.TimeCoder;
import quicktime.std.sg.SGChannel;
import quicktime.std.sg.SequenceGrabber;
import quicktime.util.QTHandle;
import quicktime.util.QTHandleRef;
import quicktime.util.QTPointer;
import quicktime.util.QTPointerRef;

public final class UserData
extends QTObject
implements QuickTimeLib {
    private static Object linkage = QTNative.linkNativeMethods(class$quicktime$std$movies$media$UserData == null ? (class$quicktime$std$movies$media$UserData = UserData.class$("quicktime.std.movies.media.UserData")) : class$quicktime$std$movies$media$UserData);
    static /* synthetic */ Class class$quicktime$std$movies$media$UserData;

    public static UserData fromGraphicsExporter(GraphicsExporter graphicsExporter) throws StdQTException {
        int[] nArray = new int[1];
        int n = UserData.GraphicsExportGetMetaData(QTObject.ID(graphicsExporter), nArray);
        StdQTException.checkError(n);
        return new UserData(nArray[0], graphicsExporter);
    }

    public static UserData fromMovie(Movie movie) throws StdQTException {
        int n = UserData.GetMovieUserData(QTObject.ID(movie));
        StdQTException.checkError(UserData.GetMoviesError());
        return new UserData(n, movie);
    }

    public static UserData fromSequenceGrabber(SequenceGrabber sequenceGrabber) throws StdQTException {
        int[] nArray = new int[1];
        int n = UserData.SGGetSettings(QTObject.ID(sequenceGrabber), nArray, 0);
        StdQTException.checkError(n);
        return new UserData(nArray[0], null);
    }

    public static UserData fromSGChannel(SGChannel sGChannel) throws StdQTException {
        int[] nArray = new int[1];
        int n = UserData.SGGetChannelSettings(QTObject.ID(sGChannel.getSequenceGrabber()), QTObject.ID(sGChannel), nArray, 0);
        StdQTException.checkError(n);
        return new UserData(nArray[0], null);
    }

    public static UserData fromTrack(Track track) throws StdQTException {
        int n = UserData.GetTrackUserData(QTObject.ID(track));
        StdQTException.checkError(UserData.GetMoviesError());
        return n == 0 ? null : new UserData(n, track);
    }

    public static UserData fromMedia(Media media) throws StdQTException {
        int n = UserData.GetMediaUserData(QTObject.ID(media));
        StdQTException.checkError(UserData.GetMoviesError());
        return new UserData(n, media);
    }

    public static UserData fromTimeCoderSource(TimeCoder timeCoder, TimeCodeDescription timeCodeDescription) throws StdQTException {
        int[] nArray = new int[1];
        StdQTException.checkError(UserData.TCGetSourceRef(QTObject.ID(timeCoder), QTObject.ID(timeCodeDescription), nArray));
        return new UserData(nArray[0], null);
    }

    public UserData() throws StdQTException {
        this(UserData.allocate(), null);
    }

    public UserData(QTHandle qTHandle) throws StdQTException {
        this(UserData.allocate(qTHandle), null);
    }

    private UserData(int n, Object object) {
        super(n, object);
    }

    private static int allocate() throws StdQTException {
        int[] nArray = new int[1];
        short s = UserData.NewUserData(nArray);
        StdQTException.checkError(s);
        return nArray[0];
    }

    private static int allocate(QTHandle qTHandle) throws StdQTException {
        int[] nArray = new int[1];
        short s = UserData.NewUserDataFromHandle(QTObject.ID(qTHandle), nArray);
        StdQTException.checkError(s);
        return nArray[0];
    }

    public QTHandle putIntoHandle() throws QTException {
        QTHandle qTHandle = new QTHandle();
        short s = UserData.PutUserDataIntoHandle(this._ID(), QTObject.ID(qTHandle));
        StdQTException.checkError(s);
        return qTHandle;
    }

    public QTHandle getData(int n, int n2) throws QTException {
        QTHandle qTHandle = new QTHandle();
        short s = UserData.GetUserData(this._ID(), QTObject.ID(qTHandle), n, n2);
        StdQTException.checkError(s);
        return qTHandle;
    }

    public void addData(QTHandleRef qTHandleRef, int n) throws StdQTException {
        short s = UserData.AddUserData(this._ID(), QTObject.ID(qTHandleRef), n);
        StdQTException.checkError(s);
    }

    public void removeData(int n, int n2) throws StdQTException {
        short s = UserData.RemoveUserData(this._ID(), n, n2);
        StdQTException.checkError(s);
    }

    public int countType(int n) throws StdQTException {
        short s = UserData.CountUserDataType(this._ID(), n);
        StdQTException.checkError(UserData.GetMoviesError());
        return s;
    }

    public int getNextType(int n) throws StdQTException {
        int n2 = UserData.GetNextUserDataType(this._ID(), n);
        StdQTException.checkError(UserData.GetMoviesError());
        return n2;
    }

    public QTPointer getDataItem(int n, int n2, int n3) throws QTException {
        QTPointer qTPointer = new QTPointer(n, true);
        short s = UserData.GetUserDataItem(this._ID(), QTObject.ID(qTPointer), qTPointer.getSize(), n2, n3);
        StdQTException.checkError(s);
        return qTPointer;
    }

    public void setDataItem(QTPointerRef qTPointerRef, int n, int n2) throws StdQTException {
        short s = UserData.SetUserDataItem(this._ID(), QTObject.ID(qTPointerRef), qTPointerRef.getSize(), n, n2);
        StdQTException.checkError(s);
    }

    public void addText(QTHandleRef qTHandleRef, int n, int n2, int n3) throws StdQTException {
        short s = UserData.AddUserDataText(this._ID(), QTObject.ID(qTHandleRef), n, n2, (short)n3);
        StdQTException.checkError(s);
    }

    public void addText(String string, int n, int n2, int n3) throws StdQTException {
        int n4 = UserData.NewHandle(string.length());
        byte[] byArray = new byte[string.length()];
        string.getBytes(0, string.length(), byArray, 0);
        UserData.HLock(n4);
        int n5 = UserData.getIntFromPointer(n4, 0);
        UserData.copyArrayToPointer(byArray, 0, n5, 0, string.length());
        short s = UserData.AddUserDataText(this._ID(), n4, n, n2, (short)n3);
        UserData.DisposeHandle(n4);
        StdQTException.checkError(s);
    }

    public QTHandle getText(int n, int n2, short s) throws QTException {
        QTHandle qTHandle = new QTHandle();
        short s2 = UserData.GetUserDataText(this._ID(), QTObject.ID(qTHandle), n, n2, s);
        StdQTException.checkError(s2);
        return qTHandle;
    }

    public String getTextAsString(int n, int n2, int n3) throws QTException {
        int n4 = UserData.NewHandle(4);
        short s = UserData.GetUserDataText(this._ID(), n4, n, n2, (short)n3);
        if (s == 0) {
            byte[] byArray = new byte[UserData.GetHandleSize(n4)];
            UserData.HLock(n4);
            UserData.copyPointerToArray(UserData.getIntFromPointer(n4, 0), 0, byArray, 0, byArray.length);
            UserData.DisposeHandle(n4);
            return new String(byArray);
        }
        throw new StdQTException(s);
    }

    public void removeText(int n, int n2, int n3) throws StdQTException {
        short s = UserData.RemoveUserDataText(this._ID(), n, n2, (short)n3);
        StdQTException.checkError(s);
    }

    public void copyFromUserData(UserData userData, boolean bl) throws StdQTException {
        StdQTException.checkError(UserData.CopyUserData(this._ID(), QTObject.ID(userData), bl ? 1919970403 : 1835361639));
    }

    public void copyToUserData(UserData userData, boolean bl) throws StdQTException {
        StdQTException.checkError(UserData.CopyUserData(QTObject.ID(userData), this._ID(), bl ? 1919970403 : 1835361639));
    }

    public static void copyUserData(UserData userData, UserData userData2, int n) throws StdQTException {
        StdQTException.checkError(UserData.CopyUserData(QTObject.ID(userData), QTObject.ID(userData2), n));
    }

    private static native void copyArrayToPointer(byte[] var0, int var1, int var2, int var3, int var4);

    private static native void copyPointerToArray(int var0, int var1, byte[] var2, int var3, int var4);

    private static native int NewHandle(int var0);

    private static native int GetHandleSize(int var0);

    private static native void DisposeHandle(int var0);

    private static native int getIntFromPointer(int var0, int var1);

    private static native void HLock(int var0);

    private static native int TCGetSourceRef(int var0, int var1, int[] var2);

    private static native int GraphicsExportGetMetaData(int var0, int[] var1);

    private static native int GetMovieUserData(int var0);

    private static native short GetMoviesError();

    private static native int SGGetSettings(int var0, int[] var1, int var2);

    private static native int SGGetChannelSettings(int var0, int var1, int[] var2, int var3);

    private static native int GetTrackUserData(int var0);

    private static native int GetMediaUserData(int var0);

    private static native short NewUserData(int[] var0);

    private static native short NewUserDataFromHandle(int var0, int[] var1);

    private static native short PutUserDataIntoHandle(int var0, int var1);

    private static native short GetUserData(int var0, int var1, int var2, int var3);

    private static native short AddUserData(int var0, int var1, int var2);

    private static native short RemoveUserData(int var0, int var1, int var2);

    private static native short CountUserDataType(int var0, int var1);

    private static native int GetNextUserDataType(int var0, int var1);

    private static native short GetUserDataItem(int var0, int var1, int var2, int var3, int var4);

    private static native short SetUserDataItem(int var0, int var1, int var2, int var3, int var4);

    private static native short AddUserDataText(int var0, int var1, int var2, int var3, short var4);

    private static native short GetUserDataText(int var0, int var1, int var2, int var3, short var4);

    private static native short RemoveUserDataText(int var0, int var1, int var2, short var3);

    private static native int MediaSetGraphicsMode(int var0, int var1, byte[] var2);

    private static native int MediaGetGraphicsMode(int var0, int[] var1, byte[] var2);

    private static native int MediaGetTrackOpaque(int var0, byte[] var1);

    private static native short CopyUserData(int var0, int var1, int var2);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

