/*
 * Decompiled with CFR 0.152.
 */
package quicktime.std.music;

import quicktime.QTException;
import quicktime.jdirect.QTNative;
import quicktime.jdirect.QuickTimeLib;
import quicktime.std.StdQTException;
import quicktime.std.comp.Component;
import quicktime.std.music.AtomicInstrument;
import quicktime.std.music.KnobDescription;
import quicktime.std.music.SynthesizerDescription;
import quicktime.util.QTUtils;

public final class MusicComponent
extends Component
implements QuickTimeLib {
    private static Object linkage = QTNative.linkNativeMethods(class$quicktime$std$music$MusicComponent == null ? (class$quicktime$std$music$MusicComponent = MusicComponent.class$("quicktime.std.music.MusicComponent")) : class$quicktime$std$music$MusicComponent);
    static /* synthetic */ Class class$quicktime$std$music$MusicComponent;

    public MusicComponent() throws QTException {
        this(0);
    }

    public MusicComponent(int n) throws QTException {
        super(1836413801, n);
    }

    MusicComponent(int n, Object object) {
        super(n, object);
    }

    public SynthesizerDescription getDescription() throws StdQTException {
        SynthesizerDescription synthesizerDescription = new SynthesizerDescription();
        StdQTException.checkError(MusicComponent.MusicGetDescription(this._ID(), synthesizerDescription.getBytes()));
        return synthesizerDescription;
    }

    public AtomicInstrument getPartAtomicInstrument(int n, int n2) throws StdQTException {
        int[] nArray = new int[]{0};
        StdQTException.checkError(MusicComponent.MusicGetPartAtomicInstrument(this._ID(), n, nArray, n2));
        if (nArray[0] == 0) {
            return null;
        }
        return new AtomicInstrument(nArray[0], this);
    }

    public int getKnob(int n) throws StdQTException {
        int n2 = MusicComponent.MusicGetKnob(this._ID(), n);
        if (n2 >>> 16 == 32768 && (n2 | 0xFFFF) != 0) {
            throw new StdQTException(n2 | 0xFFFF);
        }
        return n2;
    }

    public void setKnob(int n, int n2) throws StdQTException {
        StdQTException.checkError(MusicComponent.MusicSetKnob(this._ID(), n, n2));
    }

    public String getPartName(int n) throws StdQTException {
        byte[] byArray = new byte[32];
        StdQTException.checkError(MusicComponent.MusicGetPartName(this._ID(), n, byArray));
        return QTUtils.PString2String(byArray, 0);
    }

    public void setPartName(int n, String string) throws StdQTException {
        StdQTException.checkError(MusicComponent.MusicSetPartName(this._ID(), n, QTUtils.String2PString(string, 31)));
    }

    public void setMasterTune(float f) throws StdQTException {
        StdQTException.checkError(MusicComponent.MusicSetMasterTune(this._ID(), QTUtils.X2Fix(f)));
    }

    public float getMasterTune() throws StdQTException {
        int n = MusicComponent.MusicGetMasterTune(this._ID());
        if (n < 0) {
            throw new StdQTException(n);
        }
        return QTUtils.Fix2X(n);
    }

    public KnobDescription getInstrumentKnobDescrption(int n) throws StdQTException {
        KnobDescription knobDescription = new KnobDescription();
        StdQTException.checkError(MusicComponent.MusicGetInstrumentKnobDescription(this._ID(), n, knobDescription.getBytes()));
        return knobDescription;
    }

    public KnobDescription getDrumKnobDescrption(int n) throws StdQTException {
        KnobDescription knobDescription = new KnobDescription();
        StdQTException.checkError(MusicComponent.MusicGetDrumKnobDescription(this._ID(), n, knobDescription.getBytes()));
        return knobDescription;
    }

    public KnobDescription getKnobDescrption(int n) throws StdQTException {
        KnobDescription knobDescription = new KnobDescription();
        StdQTException.checkError(MusicComponent.MusicGetKnobDescription(this._ID(), n, knobDescription.getBytes()));
        return knobDescription;
    }

    private static native int MusicGetDescription(int var0, byte[] var1);

    private static native int MusicGetPartAtomicInstrument(int var0, int var1, int[] var2, int var3);

    private static native int MusicGetPartName(int var0, int var1, byte[] var2);

    private static native int MusicSetPartName(int var0, int var1, byte[] var2);

    private static native int MusicGetKnob(int var0, int var1);

    private static native int MusicSetKnob(int var0, int var1, int var2);

    private static native int MusicGetMasterTune(int var0);

    private static native int MusicSetMasterTune(int var0, int var1);

    private static native int MusicGetInstrumentKnobDescription(int var0, int var1, byte[] var2);

    private static native int MusicGetDrumKnobDescription(int var0, int var1, byte[] var2);

    private static native int MusicGetKnobDescription(int var0, int var1, byte[] var2);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

