/*
 * Decompiled with CFR 0.152.
 */
package quicktime.std.music;

import quicktime.QTException;
import quicktime.std.music.AtomicInstrument;
import quicktime.std.music.NoteRequest;
import quicktime.util.EndianOrder;
import quicktime.util.QTHandle;
import quicktime.util.UtilException;

public class MusicData
extends QTHandle {
    public static final int kNoteRequestHeaderEventLength = 23;

    public static int stuffGeneralEvent_Header(int n, int n2) {
        int n3 = 0xF0000000 | n << 16 | n2 << 0;
        return EndianOrder.flipNativeToBigEndian32(n3);
    }

    public static int stuffGeneralEvent_Footer(int n, int n2) {
        int n3 = 0xC0000000 | n << 16 | n2 << 0;
        return EndianOrder.flipNativeToBigEndian32(n3);
    }

    public static int stuffRestEvent(int n) {
        int n2 = 0 | n << 0;
        return EndianOrder.flipNativeToBigEndian32(n2);
    }

    public static int stuffNoteEvent(int n, int n2, int n3, int n4) {
        int n5 = 0x20000000 | n << 24 | n2 - 32 << 18 | n3 - 0 << 11 | n4 << 0;
        return EndianOrder.flipNativeToBigEndian32(n5);
    }

    public static int stuffControlEvent(int n, int n2, int n3) {
        int n4 = 0x40000000 | n << 24 | n2 << 16 | (n3 & MusicData.qtma_MASK(16)) << 0;
        return EndianOrder.flipNativeToBigEndian32(n4);
    }

    public static int stuffMarkerEvent(int n, int n2) {
        int n3 = 0x60000000 | n << 16 | n2 << 0;
        return EndianOrder.flipNativeToBigEndian32(n3);
    }

    public static long stuffXNoteEvent(int n, int n2, int n3, int n4) {
        long l = 0x90000000 | n << 16 | n2 << 0;
        l = EndianOrder.flipNativeToBigEndian64(l);
        long l2 = Integer.MIN_VALUE | n4 << 0 | n3 << 22;
        l2 = EndianOrder.flipNativeToBigEndian64(l2);
        return (l &= 0xFFFFFFFFL) << 32 | (l2 &= 0xFFFFFFFFL);
    }

    public static long stuffXControlEvent(int n, int n2, int n3) {
        long l = 0xA0000000 | n << 16 | (n3 & MusicData.qtma_MASK(16)) << 0;
        l = EndianOrder.flipNativeToBigEndian64(l);
        long l2 = Integer.MIN_VALUE | n2 << 0;
        l2 = EndianOrder.flipNativeToBigEndian64(l2);
        return (l &= 0xFFFFFFFFL) << 32 | (l2 &= 0xFFFFFFFFL);
    }

    public static long stuffXKnobEvent(int n, int n2, int n3) {
        long l = 0xB0000000 | n << 16 | n3 >> 16 << 0;
        l = EndianOrder.flipNativeToBigEndian64(l);
        long l2 = Integer.MIN_VALUE | n2 << 16 | (n3 & 0xFFFF) << 0;
        l2 = EndianOrder.flipNativeToBigEndian64(l2);
        return (l &= 0xFFFFFFFFL) << 32 | (l2 &= 0xFFFFFFFFL);
    }

    public static int eventType(int n) {
        return MusicData.qtma_EXT(n, 29, 3) > 3 ? MusicData.qtma_EXT(n, 28, 4) : MusicData.qtma_EXT(n, 29, 3);
    }

    public static int part(int n) {
        return MusicData.qtma_EXT(n, 24, 5);
    }

    public static int xPart(long l) {
        long l2 = l >>> 32;
        return MusicData.qtma_EXT((int)l2, 16, 12);
    }

    public static int restDuration(int n) {
        return MusicData.qtma_EXT(n, 0, 24);
    }

    public static int notePitch(int n) {
        return MusicData.qtma_EXT(n, 18, 6) + 32;
    }

    public static int noteVelocity(int n) {
        return MusicData.qtma_EXT(n, 11, 7) + 0;
    }

    public static int noteDuration(int n) {
        return MusicData.qtma_EXT(n, 0, 11);
    }

    public static int xNotePitch(long l) {
        long l2 = l >>> 32;
        return MusicData.qtma_EXT((int)l2, 0, 16);
    }

    public static int xNoteVelocity(long l) {
        return MusicData.qtma_EXT((int)l, 22, 7);
    }

    public static int xNoteDuration(long l) {
        return MusicData.qtma_EXT((int)l, 0, 22);
    }

    public static int controlController(int n) {
        return MusicData.qtma_EXT(n, 16, 8);
    }

    public static int controlValue(int n) {
        return MusicData.qtma_EXT(n, 0, 16);
    }

    public static int xControlController(long l) {
        return MusicData.qtma_EXT((int)l, 0, 16);
    }

    public static int xControlValue(long l) {
        long l2 = l >>> 32;
        return MusicData.qtma_EXT((int)l2, 0, 16);
    }

    public static int markerSubtype(int n) {
        return MusicData.qtma_EXT(n, 16, 8);
    }

    public static int markerValue(int n) {
        return MusicData.qtma_EXT(n, 0, 16);
    }

    public static int xKnobValue(long l) {
        int n = (int)(l >>> 32);
        int n2 = (int)l;
        return MusicData.qtma_EXT(n, 0, 16) << 16 | MusicData.qtma_EXT(n2, 0, 16);
    }

    public static int xKnobID(long l) {
        return MusicData.qtma_EXT((int)l, 16, 14);
    }

    public static int generalSubtype_Footer(int n) {
        return MusicData.qtma_EXT(n, 16, 14);
    }

    public static int generalLength(int n) {
        return MusicData.qtma_EXT(n, 0, 16);
    }

    private static int qtma_MASK(int n) {
        return (1 << n) - 1;
    }

    private static int qtma_EXT(int n, int n2, int n3) {
        return EndianOrder.flipBigEndianToNative32(n) >>> n2 & MusicData.qtma_MASK(n3);
    }

    public MusicData(int n) throws QTException {
        super(n, true);
        this.setIntAt(n - 4, EndianOrder.flipNativeToBigEndian32(0x60000000));
    }

    public void setSize(int n) throws UtilException {
        super.setSize(n);
        this.setIntAt(n - 4, EndianOrder.flipNativeToBigEndian32(0x60000000));
    }

    public int getMusicEvent(int n) throws QTException {
        if (n * 4 >= this.getSize() - 4) {
            throw new QTException(-50);
        }
        return this.getIntAt(n * 4);
    }

    public void setMusicEvent(int n, int n2) throws QTException {
        if (n * 4 >= this.getSize()) {
            throw new QTException(-50);
        }
        if (n * 4 == this.getSize() - 4 && n2 != EndianOrder.flipNativeToBigEndian32(0x60000000)) {
            throw new QTException(-50);
        }
        this.setIntAt(n * 4, n2);
    }

    public long getXMusicEvent(int n) throws QTException {
        if (n * 4 >= this.getSize() - 8) {
            throw new QTException(-50);
        }
        return this.getLongAt(n * 4);
    }

    public void setXMusicEvent(int n, long l) throws QTException {
        if (n * 4 >= this.getSize() - 8) {
            throw new QTException(-50);
        }
        this.setLongAt(n * 4, l);
    }

    public void setNoteRequest(int n, int n2, NoteRequest noteRequest) throws QTException {
        if (n * 4 >= this.getSize() - 92) {
            throw new QTException(-50);
        }
        this.setIntAt(n * 4, MusicData.stuffGeneralEvent_Header(n2, 23));
        this.copyFromArray(n * 4 + 4, noteRequest.getBytes(), 0, noteRequest.getSize());
        this.setIntAt(n * 4 + 4 + noteRequest.getSize(), MusicData.stuffGeneralEvent_Footer(1, 23));
    }

    public NoteRequest getNoteRequest(int n) throws QTException {
        if (n * 4 >= this.getSize() - 92) {
            throw new QTException(-50);
        }
        int n2 = this.getIntAt(n * 4 + 84);
        if (MusicData.generalSubtype_Footer(n2) != 1) {
            throw new QTException(-50);
        }
        NoteRequest noteRequest = new NoteRequest();
        this.copyToArray(n * 4, noteRequest.getBytes(), 0, noteRequest.getSize());
        return noteRequest;
    }

    public void setAtomicInstrument(int n, int n2, AtomicInstrument atomicInstrument) throws QTException {
        int n3 = atomicInstrument.getSize() / 4;
        if (atomicInstrument.getSize() % 4 != 0) {
            ++n3;
        }
        int n4 = n3 + 2;
        if (n * 4 >= this.getSize() - n4 * 4) {
            throw new QTException(-50);
        }
        this.setIntAt(n * 4, MusicData.stuffGeneralEvent_Header(n2, n4));
        this.copyFromHandle(n * 4 + 4, atomicInstrument, 0, atomicInstrument.getSize());
        this.setIntAt(n * 4 + 4 + n3 * 4, MusicData.stuffGeneralEvent_Footer(6, n4));
    }

    public AtomicInstrument getAtomicInstrument(int n) throws QTException {
        if (n * 4 > this.getSize() - 4) {
            throw new QTException(-50);
        }
        int n2 = this.getIntAt(n * 4 - 4);
        int n3 = MusicData.generalLength(n2) * 4;
        if (n * 4 - 4 + n3 > this.getSize()) {
            throw new QTException(-50);
        }
        int n4 = this.getIntAt(n * 4 - 4 + n3 - 4);
        if (MusicData.generalSubtype_Footer(n4) != 6) {
            throw new QTException(-50);
        }
        int n5 = this.makeAndCopyHandle(n * 4, n3 - 8);
        return new AtomicInstrument(n5, null);
    }
}

