/*
 * Decompiled with CFR 0.152.
 */
package quicktime.std.music;

import com.apple.mrj.macos.carbon.CarbonAccess;
import com.apple.mrj.macos.carbon.CarbonEventClient;
import quicktime.QTException;
import quicktime.QTObject;
import quicktime.QTSession;
import quicktime.jdirect.QTNative;
import quicktime.jdirect.QuickTimeLib;
import quicktime.std.StdQTException;
import quicktime.std.music.AtomicInstrument;
import quicktime.std.music.MusicComponent;
import quicktime.std.music.MusicMIDIPacket;
import quicktime.std.music.NoteAllocator;
import quicktime.std.music.NoteRequest;
import quicktime.std.music.SoundLocalization;
import quicktime.std.music.ToneDescription;
import quicktime.util.QTPointerRef;
import quicktime.util.QTUtils;

public final class NoteChannel
extends QTObject
implements QuickTimeLib {
    private static Object linkage = QTNative.linkNativeMethods(class$quicktime$std$music$NoteChannel == null ? (class$quicktime$std$music$NoteChannel = NoteChannel.class$("quicktime.std.music.NoteChannel")) : class$quicktime$std$music$NoteChannel);
    public static final float kMicrotonalResolution = 0.0078125f;
    public static final float kMicroControllerResolution = 0.0078125f;
    private NoteAllocator na;
    static /* synthetic */ Class class$quicktime$std$music$NoteChannel;

    private static int allocate(NoteAllocator noteAllocator, NoteRequest noteRequest) throws QTException {
        int[] nArray = new int[1];
        StdQTException.checkError(NoteChannel.NANewNoteChannel(QTObject.ID(noteAllocator), noteRequest.getBytes(), nArray));
        return nArray[0];
    }

    private static int allocate(NoteAllocator noteAllocator, int n) throws QTException {
        ToneDescription toneDescription = new ToneDescription(noteAllocator, n);
        NoteRequest noteRequest = new NoteRequest(toneDescription);
        int[] nArray = new int[1];
        StdQTException.checkError(NoteChannel.NANewNoteChannel(QTObject.ID(noteAllocator), noteRequest.getBytes(), nArray));
        return nArray[0];
    }

    public NoteChannel(int n, int n2) throws QTException {
        this(new NoteRequest(n, n2));
    }

    public NoteChannel(NoteRequest noteRequest) throws QTException {
        this(NoteAllocator.getDefault(), noteRequest);
    }

    public NoteChannel(NoteAllocator noteAllocator, NoteRequest noteRequest) throws QTException {
        super(NoteChannel.allocate(noteAllocator, noteRequest), QTObject.ID(noteAllocator));
        this.na = noteAllocator;
    }

    public NoteChannel(NoteAllocator noteAllocator, int n) throws QTException {
        super(NoteChannel.allocate(noteAllocator, n), QTObject.ID(noteAllocator));
        this.na = noteAllocator;
    }

    NoteChannel(NoteAllocator noteAllocator, int n, Object object) {
        super(n, object);
        this.na = noteAllocator;
    }

    public final NoteAllocator getNoteAllocator() {
        return this.na;
    }

    public final int getIndexInfo() throws StdQTException {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        StdQTException.checkError(NoteChannel.NAGetNoteChannelInfo(QTObject.ID(this.na), this._ID(), nArray, nArray2));
        return nArray[0];
    }

    public final int getPartInfo() throws StdQTException {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        StdQTException.checkError(NoteChannel.NAGetNoteChannelInfo(QTObject.ID(this.na), this._ID(), nArray, nArray2));
        return nArray2[0];
    }

    public MusicComponent getMusicComponent() throws StdQTException {
        int[] nArray = new int[1];
        int n = NoteChannel.NAGetRegisteredMusicDevice(QTObject.ID(this.na), this.getIndexInfo(), 0, 0, 0, nArray);
        if (n < 0) {
            StdQTException.checkError(n);
        }
        return new MusicComponent(nArray[0], this);
    }

    public final void preroll() throws StdQTException {
        StdQTException.checkError(NoteChannel.NAPrerollNoteChannel(QTObject.ID(this.na), this._ID()));
    }

    public final void unroll() throws StdQTException {
        StdQTException.checkError(NoteChannel.NAUnrollNoteChannel(QTObject.ID(this.na), this._ID()));
    }

    public final void reset() throws StdQTException {
        StdQTException.checkError(NoteChannel.NAResetNoteChannel(QTObject.ID(this.na), this._ID()));
    }

    public final void setVolume(float f) throws StdQTException {
        StdQTException.checkError(NoteChannel.NASetNoteChannelVolume(QTObject.ID(this.na), this._ID(), QTUtils.X2Fix(f)));
    }

    public final void setBalance(int n) throws StdQTException {
        StdQTException.checkError(NoteChannel.NASetNoteChannelBalance(QTObject.ID(this.na), this._ID(), n));
    }

    public final void playNoteRaw(int n, int n2) throws StdQTException {
        StdQTException.checkError(NoteChannel.NAPlayNote(QTObject.ID(this.na), this._ID(), n, n2));
    }

    public final void playNoteCents(int n, int n2, int n3) throws StdQTException {
        n <<= 8;
        this.playNoteRaw(n += (int)(1.28f * (float)n2 + 0.5f), n3);
    }

    public final void playNote(float f, int n) throws StdQTException {
        StdQTException.checkError(NoteChannel.NAPlayNote(QTObject.ID(this.na), this._ID(), QTUtils.X2ShortFix(f), n));
    }

    public final float getController(int n) throws StdQTException {
        int[] nArray = new int[]{0};
        StdQTException.checkError(NoteChannel.NAGetController(QTObject.ID(this.na), this._ID(), n, nArray));
        return QTUtils.ShortFix2X((short)nArray[0]);
    }

    public final void setControllerRaw(int n, int n2) throws StdQTException {
        StdQTException.checkError(NoteChannel.NASetController(QTObject.ID(this.na), this._ID(), n, n2));
    }

    public final void setController(int n, float f) throws StdQTException {
        StdQTException.checkError(NoteChannel.NASetController(QTObject.ID(this.na), this._ID(), n, QTUtils.X2ShortFix(f)));
    }

    public final int getKnob(int n) throws StdQTException {
        int[] nArray = new int[1];
        StdQTException.checkError(NoteChannel.NAGetKnob(QTObject.ID(this.na), this._ID(), n, nArray));
        return nArray[0];
    }

    public final void setKnob(int n, int n2) throws StdQTException {
        StdQTException.checkError(NoteChannel.NASetKnob(QTObject.ID(this.na), this._ID(), n, n2));
    }

    public final int findTone(ToneDescription toneDescription) throws StdQTException {
        int[] nArray = new int[1];
        StdQTException.checkError(NoteChannel.NAFindNoteChannelTone(QTObject.ID(this.na), this._ID(), toneDescription.getBytes(), nArray));
        return nArray[0];
    }

    public final void setAtomicInstrument(AtomicInstrument atomicInstrument, int n) throws StdQTException {
        QTPointerRef qTPointerRef = atomicInstrument.toQTPointer();
        int n2 = NoteChannel.NASetAtomicInstrument(QTObject.ID(this.na), this._ID(), QTObject.ID(qTPointerRef), n);
        if (!atomicInstrument.isLocked()) {
            atomicInstrument.unlock();
        }
        StdQTException.checkError(n2);
    }

    public final void setInstrumentNumber(int n) throws StdQTException {
        StdQTException.checkError(NoteChannel.NASetInstrumentNumber(QTObject.ID(this.na), this._ID(), n));
    }

    public final NoteRequest getNoteRequest() throws QTException {
        NoteRequest noteRequest = new NoteRequest();
        StdQTException.checkError(NoteChannel.NAGetNoteRequest(QTObject.ID(this.na), this._ID(), noteRequest.getBytes()));
        return noteRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void pickEditInstrument(String string, int n) throws StdQTException {
        final String string2 = string;
        final int n2 = n;
        final int n3 = this._ID();
        int n4 = 0;
        if (QTSession.isCurrentOS(4)) {
            n4 = (Integer)CarbonAccess.invokeCarbonEventClient(new CarbonEventClient(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object invoke() {
                    int n = 0;
                    Object object = QTNative.globalsLock;
                    synchronized (object) {
                        n = NoteChannel.NAPickEditInstrument(QTObject.ID(NoteChannel.this.na), 0, QTUtils.String2PString(string2, 255), 0, n3, 0, n2);
                        return new Integer(n);
                    }
                }
            });
            StdQTException.checkError(n4);
        } else {
            Object object = QTNative.globalsLock;
            synchronized (object) {
                StdQTException.checkError(NoteChannel.NAPickEditInstrument(QTObject.ID(this.na), 0, QTUtils.String2PString(string, 255), 0, this._ID(), 0, n));
            }
        }
    }

    public final void sendMIDI(MusicMIDIPacket musicMIDIPacket) throws StdQTException {
        int n = NoteChannel.NASendMIDI(QTObject.ID(this.na), this._ID(), musicMIDIPacket.getBytes());
        StdQTException.checkError(n);
    }

    public final void setSoundLocalization(SoundLocalization soundLocalization) throws StdQTException {
        StdQTException.checkError(NoteChannel.NASetNoteChannelSoundLocalization(QTObject.ID(this.na), this._ID(), QTObject.ID(soundLocalization)));
    }

    private static native int NANewNoteChannel(int var0, byte[] var1, int[] var2);

    private static native int NAGetNoteChannelInfo(int var0, int var1, int[] var2, int[] var3);

    private static native int NAPrerollNoteChannel(int var0, int var1);

    private static native int NAUnrollNoteChannel(int var0, int var1);

    private static native int NAResetNoteChannel(int var0, int var1);

    private static native int NASetNoteChannelVolume(int var0, int var1, int var2);

    private static native int NAPlayNote(int var0, int var1, int var2, int var3);

    private static native int NAGetController(int var0, int var1, int var2, int[] var3);

    private static native int NASetController(int var0, int var1, int var2, int var3);

    private static native int NAGetKnob(int var0, int var1, int var2, int[] var3);

    private static native int NASetKnob(int var0, int var1, int var2, int var3);

    private static native int NAFindNoteChannelTone(int var0, int var1, byte[] var2, int[] var3);

    private static native int NASetAtomicInstrument(int var0, int var1, int var2, int var3);

    private static native int NASetInstrumentNumber(int var0, int var1, int var2);

    private static native int NAGetNoteRequest(int var0, int var1, byte[] var2);

    private static native int NAPickEditInstrument(int var0, int var1, byte[] var2, int var3, int var4, int var5, int var6);

    private static native int NASendMIDI(int var0, int var1, byte[] var2);

    private static native int NASetNoteChannelSoundLocalization(int var0, int var1, int var2);

    private static native int NASetNoteChannelBalance(int var0, int var1, int var2);

    private static native int NAGetRegisteredMusicDevice(int var0, int var1, int var2, int var3, int var4, int[] var5);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

