/*
 * Decompiled with CFR 0.152.
 */
package quicktime.std.music;

import com.apple.mrj.macos.carbon.CarbonAccess;
import com.apple.mrj.macos.carbon.CarbonEventClient;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import quicktime.QTException;
import quicktime.QTObject;
import quicktime.QTSession;
import quicktime.jdirect.QTNative;
import quicktime.jdirect.QuickTimeLib;
import quicktime.std.StdQTException;
import quicktime.std.music.NoteAllocator;
import quicktime.util.EndianOrder;
import quicktime.util.QTByteObject;
import quicktime.util.QTUtils;
import quicktime.util.UtilException;

public final class ToneDescription
extends QTByteObject
implements QuickTimeLib,
Cloneable {
    private static Object linkage = QTNative.linkNativeMethods(class$quicktime$std$music$ToneDescription == null ? (class$quicktime$std$music$ToneDescription = ToneDescription.class$("quicktime.std.music.ToneDescription")) : class$quicktime$std$music$ToneDescription);
    public static final int kNativeSize = 76;
    static final long serialVersionUID = 2107309866399025424L;
    int res = 0;
    static /* synthetic */ Class class$quicktime$std$music$ToneDescription;

    public ToneDescription() {
        super(76);
    }

    public ToneDescription(int n) throws QTException {
        this(NoteAllocator.getDefault(), n);
    }

    public ToneDescription(NoteAllocator noteAllocator, int n) throws StdQTException {
        this();
        this.stuff(noteAllocator, n);
    }

    private ToneDescription(byte[] byArray) {
        super(byArray);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        this.bytes = new byte[76];
        objectInputStream.read(this.getBytes());
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.write(this.getBytes());
    }

    public final int getSynthesizerType() {
        return EndianOrder.flipBigEndianToNative32(this.getIntAt(0));
    }

    public final void setSynthesizerType(int n) {
        this.setIntAt(0, EndianOrder.flipNativeToBigEndian32(n));
    }

    public final String getSynthesizerName() throws UtilException {
        return this.getPStringAt(4);
    }

    public final void setSynthesizerName(String string) throws UtilException {
        this.setPStringAt(4, 31, string);
    }

    public final String getInstrumentName() throws UtilException {
        return this.getPStringAt(36);
    }

    public final void setInstrumentName(String string) throws UtilException {
        this.setPStringAt(36, 31, string);
    }

    public final int getInstrumentNumber() {
        return EndianOrder.flipBigEndianToNative32(this.getIntAt(68));
    }

    public final void setInstrumentNumber(int n) {
        this.setIntAt(68, EndianOrder.flipNativeToBigEndian32(n));
    }

    public final int getGMNumber() {
        return EndianOrder.flipBigEndianToNative32(this.getIntAt(72));
    }

    public final void setGMNumber(int n) {
        this.setIntAt(72, EndianOrder.flipNativeToBigEndian32(n));
    }

    public final void stuff(NoteAllocator noteAllocator, int n) throws StdQTException {
        StdQTException.checkError(ToneDescription.NAStuffToneDescription(QTObject.ID(noteAllocator), n, this.getBytes()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void pickInstrument(NoteAllocator noteAllocator, String string, int n) throws StdQTException {
        int n2 = 0;
        final NoteAllocator noteAllocator2 = noteAllocator;
        final String string2 = string;
        final int n3 = n;
        if (QTSession.isCurrentOS(4)) {
            n2 = (Integer)CarbonAccess.invokeCarbonEventClient(new CarbonEventClient(){
                int res1 = 0;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object invoke() {
                    int n = 0;
                    Object object = QTNative.globalsLock;
                    synchronized (object) {
                        n = ToneDescription.NAPickInstrument(QTObject.ID(noteAllocator2), 0, QTUtils.String2PString(string2, 255), ToneDescription.this.getBytes(), n3, 0, 0, 0);
                    }
                    return new Integer(n);
                }
            });
            StdQTException.checkError(n2);
        } else {
            Object object = QTNative.globalsLock;
            synchronized (object) {
                n2 = ToneDescription.NAPickInstrument(QTObject.ID(noteAllocator), 0, QTUtils.String2PString(string, 255), this.getBytes(), n, 0, 0, 0);
            }
            StdQTException.checkError(n2);
        }
    }

    public String toString() {
        String string = "";
        try {
            string = this.getInstrumentName();
        }
        catch (UtilException utilException) {
            // empty catch block
        }
        return this.getClass().getName() + "[synthType=" + QTUtils.fromOSType(this.getSynthesizerType()) + ",instNum=" + Integer.toString(this.getInstrumentNumber()) + ",gmNum=" + Integer.toString(this.getGMNumber()) + ",instName=" + string + "]";
    }

    public Object clone() {
        return new ToneDescription(this.getBytes());
    }

    private static native int NAStuffToneDescription(int var0, int var1, byte[] var2);

    private static native int NAPickInstrument(int var0, int var1, byte[] var2, byte[] var3, int var4, int var5, int var6, int var7);

    private static native int GetMainEventLoop();

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

