/*
 * Decompiled with CFR 0.152.
 */
package quicktime.std.music;

import quicktime.QTException;
import quicktime.QTObject;
import quicktime.jdirect.QTNative;
import quicktime.jdirect.QuickTimeLib;
import quicktime.std.StdQTException;
import quicktime.std.clocks.TimeBase;
import quicktime.std.comp.Component;
import quicktime.std.movies.media.MusicMediaHandler;
import quicktime.std.music.MixStateInfo;
import quicktime.std.music.MusicData;
import quicktime.std.music.NoteAllocator;
import quicktime.std.music.NoteChannel;
import quicktime.std.music.SoundLocalization;
import quicktime.std.music.TuneStatus;
import quicktime.util.QTUtils;

public final class TunePlayer
extends Component
implements QuickTimeLib {
    private static Object linkage = QTNative.linkNativeMethods(class$quicktime$std$music$TunePlayer == null ? (class$quicktime$std$music$TunePlayer = TunePlayer.class$("quicktime.std.music.TunePlayer")) : class$quicktime$std$music$TunePlayer);
    Object noteChannels;
    static /* synthetic */ Class class$quicktime$std$music$TunePlayer;

    public static TunePlayer fromMusicMediaHandler(MusicMediaHandler musicMediaHandler, int n) throws StdQTException {
        int[] nArray = new int[]{0};
        StdQTException.checkError(TunePlayer.MusicMediaGetIndexedTunePlayer(QTObject.ID(musicMediaHandler), n, nArray));
        return new TunePlayer(nArray[0], musicMediaHandler);
    }

    private TunePlayer(int n, Object object) {
        super(n, object);
    }

    public TunePlayer() throws QTException {
        super(1953853029, 0);
    }

    public void setHeader(MusicData musicData) throws StdQTException {
        musicData.lock();
        int n = TunePlayer.getIntFromPointer(QTObject.ID(musicData), 0);
        StdQTException.checkError(TunePlayer.TuneSetHeader(this._ID(), n));
    }

    public TimeBase getTimeBase() throws StdQTException {
        return TimeBase.fromTunePlayer(this);
    }

    public void setTimeScale(int n) throws StdQTException {
        StdQTException.checkError(TunePlayer.TuneSetTimeScale(this._ID(), n));
    }

    public int getTimeScale() throws StdQTException {
        int[] nArray = new int[]{0};
        StdQTException.checkError(TunePlayer.TuneGetTimeScale(this._ID(), nArray));
        return nArray[0];
    }

    public int getNumberOfNoteChannels() throws StdQTException {
        int n = TunePlayer.TuneGetIndexedNoteChannel(this._ID(), 0, null);
        if (n < 0) {
            throw new StdQTException(n);
        }
        return n;
    }

    public NoteChannel getIndexedNoteChannel(int n) throws StdQTException {
        if (n > 0) {
            int[] nArray = new int[]{0};
            int n2 = TunePlayer.TuneGetIndexedNoteChannel(this._ID(), n, nArray);
            if (n2 < 0) {
                throw new StdQTException(n2);
            }
            return new NoteChannel(this.getNoteAllocator(), nArray[0], this);
        }
        throw new StdQTException(-2075);
    }

    public void queue(MusicData musicData, float f, int n, int n2, int n3) throws StdQTException {
        musicData.lock();
        int n4 = TunePlayer.getIntFromPointer(QTObject.ID(musicData), 0);
        StdQTException.checkError(TunePlayer.TuneQueue(this._ID(), n4, QTUtils.X2Fix(f), n, n2, n3, 0, 0));
    }

    public void instant(TuneStatus tuneStatus, int n) throws StdQTException {
        StdQTException.checkError(TunePlayer.TuneInstant(this._ID(), tuneStatus.getTuneDataPtr(), n));
    }

    public TuneStatus getStatus() throws StdQTException {
        TuneStatus tuneStatus = new TuneStatus();
        StdQTException.checkError(TunePlayer.TuneGetStatus(this._ID(), tuneStatus.getBytes()));
        return tuneStatus;
    }

    public void stop() throws StdQTException {
        StdQTException.checkError(TunePlayer.TuneStop(this._ID(), 0));
    }

    public void setVolume(float f) throws StdQTException {
        StdQTException.checkError(TunePlayer.TuneSetVolume(this._ID(), QTUtils.X2Fix(f)));
    }

    public float getVolume() throws StdQTException {
        int n = TunePlayer.TuneGetVolume(this._ID());
        if (n < 0) {
            throw new StdQTException(n);
        }
        return QTUtils.Fix2X(n);
    }

    public void preroll() throws StdQTException {
        StdQTException.checkError(TunePlayer.TunePreroll(this._ID()));
    }

    public void unroll() throws StdQTException {
        StdQTException.checkError(TunePlayer.TuneUnroll(this._ID()));
    }

    public void setNoteChannels(NoteChannel[] noteChannelArray) throws StdQTException {
        int n = noteChannelArray.length;
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = QTObject.ID(noteChannelArray[n2]);
            ++n2;
        }
        StdQTException.checkError(TunePlayer.TuneSetNoteChannels(this._ID(), n, nArray, 0, 0));
        this.noteChannels = noteChannelArray;
    }

    public void setPartTranspose(int n, float f, int n2) throws StdQTException {
        StdQTException.checkError(TunePlayer.TuneSetPartTranspose(this._ID(), n, QTUtils.X2Fix(f), n2));
    }

    public NoteAllocator getNoteAllocator() {
        return new NoteAllocator(TunePlayer.TuneGetNoteAllocator(this._ID()), this);
    }

    public void setSofter(boolean bl) throws StdQTException {
        StdQTException.checkError(TunePlayer.TuneSetSofter(this._ID(), bl ? 1 : 0));
    }

    public void task() throws StdQTException {
        StdQTException.checkError(TunePlayer.TuneTask(this._ID()));
    }

    public void setBalance(int n) throws StdQTException {
        StdQTException.checkError(TunePlayer.TuneSetBalance(this._ID(), n));
    }

    public void setSoundLocalization(SoundLocalization soundLocalization) throws StdQTException {
        StdQTException.checkError(TunePlayer.TuneSetSoundLocalization(this._ID(), QTObject.ID(soundLocalization)));
    }

    public void setHeaderWithSize(MusicData musicData, int n) throws StdQTException {
        musicData.lock();
        int n2 = TunePlayer.getIntFromPointer(QTObject.ID(musicData), 0);
        StdQTException.checkError(TunePlayer.TuneSetHeaderWithSize(this._ID(), n2, n));
    }

    public void setPartMix(int n, float f, float f2, int n2) throws StdQTException {
        StdQTException.checkError(TunePlayer.TuneSetPartMix(this._ID(), n, QTUtils.X2Fix(f), QTUtils.X2Fix(f2), n2));
    }

    public MixStateInfo getPartMix(int n) throws StdQTException {
        int[] nArray = new int[]{0};
        int[] nArray2 = new int[]{0};
        int[] nArray3 = new int[]{0};
        StdQTException.checkError(TunePlayer.TuneGetPartMix(this._ID(), n, nArray, nArray2, nArray3));
        return new MixStateInfo(n, QTUtils.Fix2X(nArray[0]), QTUtils.Fix2X(nArray2[0]), nArray3[0]);
    }

    private static native int getIntFromPointer(int var0, int var1);

    private static native int MusicMediaGetIndexedTunePlayer(int var0, int var1, int[] var2);

    private static native int TuneSetHeader(int var0, int var1);

    private static native int TuneSetTimeScale(int var0, int var1);

    private static native int TuneGetTimeScale(int var0, int[] var1);

    private static native int TuneGetIndexedNoteChannel(int var0, int var1, int[] var2);

    private static native int TuneQueue(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7);

    private static native int TuneInstant(int var0, int var1, int var2);

    private static native int TuneGetStatus(int var0, byte[] var1);

    private static native int TuneStop(int var0, int var1);

    private static native int TuneSetVolume(int var0, int var1);

    private static native int TuneGetVolume(int var0);

    private static native int TunePreroll(int var0);

    private static native int TuneUnroll(int var0);

    private static native int TuneSetNoteChannels(int var0, int var1, int[] var2, int var3, int var4);

    private static native int TuneSetPartTranspose(int var0, int var1, int var2, int var3);

    private static native int TuneGetNoteAllocator(int var0);

    private static native int TuneSetSofter(int var0, int var1);

    private static native int TuneTask(int var0);

    private static native int TuneSetBalance(int var0, int var1);

    private static native int TuneSetSoundLocalization(int var0, int var1);

    private static native int TuneSetHeaderWithSize(int var0, int var1, int var2);

    private static native int TuneSetPartMix(int var0, int var1, int var2, int var3, int var4);

    private static native int TuneGetPartMix(int var0, int var1, int[] var2, int[] var3, int[] var4);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

