/*
 * Decompiled with CFR 0.152.
 */
package quicktime.std.qtcomponents;

import com.apple.mrj.macos.carbon.CarbonAccess;
import com.apple.mrj.macos.carbon.CarbonEventClient;
import quicktime.QTException;
import quicktime.QTNullPointerException;
import quicktime.QTObject;
import quicktime.QTSession;
import quicktime.io.QTFile;
import quicktime.jdirect.QTNative;
import quicktime.jdirect.QuickTimeLib;
import quicktime.std.StdQTException;
import quicktime.std.comp.Component;
import quicktime.std.comp.ComponentIdentifier;
import quicktime.std.movies.AtomContainer;
import quicktime.std.movies.Movie;
import quicktime.std.movies.MovieProgress;
import quicktime.std.movies.Track;
import quicktime.std.movies.media.DataRef;
import quicktime.std.movies.media.SampleDescription;
import quicktime.std.qtcomponents.QTCompDispatcher;
import quicktime.util.QTHandle;
import quicktime.util.QTUtils;

public final class MovieExporter
extends Component
implements QuickTimeLib {
    private static Object linkage = QTNative.linkNativeMethods(class$quicktime$std$qtcomponents$MovieExporter == null ? (class$quicktime$std$qtcomponents$MovieExporter = MovieExporter.class$("quicktime.std.qtcomponents.MovieExporter")) : class$quicktime$std$qtcomponents$MovieExporter);
    private QTCompDispatcher progUPP;
    static /* synthetic */ Class class$quicktime$std$qtcomponents$MovieExporter;

    public MovieExporter(int n) throws QTException {
        super(1936746868, n);
        this.setProgressProc(null);
    }

    public MovieExporter(ComponentIdentifier componentIdentifier) throws QTException {
        super(componentIdentifier, 1936746868);
        this.setProgressProc(null);
    }

    public void setProgressProc(MovieProgress movieProgress) throws StdQTException {
        if (this.progUPP != null) {
            this.progUPP.cleanupMethodClosure();
        }
        this.progUPP = movieProgress == null ? new QTCompDispatcher(this) : new QTCompDispatcher(movieProgress);
        int n = MovieExporter.MovieExportSetProgressProc(this._ID(), this.progUPP.ID(), 0);
        StdQTException.checkError(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toFile(QTFile qTFile, Movie movie, Track track, int n, int n2) throws QTException {
        int n3 = 0;
        this.progUPP.theCurrentMov = movie;
        Object object = QTNative.globalsLock;
        synchronized (object) {
            n3 = MovieExporter.MovieExportToFile(this._ID(), qTFile.getFSSpec(true, 512), QTObject.ID(movie), QTObject.ID(track), n, n2);
        }
        StdQTException.checkError(n3);
    }

    public QTHandle toHandle(Movie movie, Track track, int n, int n2) throws QTException {
        this.progUPP.theCurrentMov = movie;
        QTHandle qTHandle = new QTHandle();
        int n3 = MovieExporter.MovieExportToHandle(this._ID(), QTObject.ID(qTHandle), QTObject.ID(movie), QTObject.ID(track), n, n2);
        StdQTException.checkError(n3);
        return qTHandle;
    }

    public void toDataRef(DataRef dataRef, Movie movie, Track track, int n, int n2) throws StdQTException {
        this.progUPP.theCurrentMov = movie;
        StdQTException.checkError(MovieExporter.MovieExportToDataRef(this._ID(), QTObject.ID(dataRef), dataRef.getType(), QTObject.ID(movie), QTObject.ID(track), n, n2));
    }

    public int getAuxiliaryData(QTHandle qTHandle) throws StdQTException {
        int[] nArray = new int[1];
        int n = MovieExporter.MovieExportGetAuxiliaryData(this._ID(), QTObject.ID(qTHandle), nArray);
        StdQTException.checkError(n);
        return nArray[0];
    }

    public void setSampleDescription(SampleDescription sampleDescription, int n) throws StdQTException {
        int n2 = MovieExporter.MovieExportSetSampleDescription(this._ID(), QTObject.ID(sampleDescription), n);
        StdQTException.checkError(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doUserDialog(Movie movie, Track track, int n, int n2) throws StdQTException {
        final byte[] byArray = new byte[1];
        final Movie movie2 = movie;
        final Track track2 = track;
        final int n3 = n;
        final int n4 = n2;
        final int n5 = this._ID();
        int n6 = 0;
        if (QTSession.isCurrentOS(4)) {
            n6 = (Integer)CarbonAccess.invokeCarbonEventClient(new CarbonEventClient(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object invoke() {
                    int n = 0;
                    Object object = QTNative.globalsLock;
                    synchronized (object) {
                        n = MovieExporter.MovieExportDoUserDialog(n5, QTObject.ID(movie2), QTObject.ID(track2), n3, n4, byArray);
                    }
                    return new Integer(n);
                }
            });
            StdQTException.checkError(n6);
        } else {
            Object object = QTNative.globalsLock;
            synchronized (object) {
                n6 = MovieExporter.MovieExportDoUserDialog(this._ID(), QTObject.ID(movie), QTObject.ID(track), n, n2, byArray);
                StdQTException.checkError(n6);
            }
        }
        return byArray[0] != 0;
    }

    public int getCreatorType() throws StdQTException {
        int[] nArray = new int[1];
        int n = MovieExporter.MovieExportGetCreatorType(this._ID(), nArray);
        StdQTException.checkError(n);
        return nArray[0];
    }

    public boolean validate(Movie movie, Track track) throws StdQTException {
        this.progUPP.theCurrentMov = movie;
        byte[] byArray = new byte[]{0};
        StdQTException.checkError(MovieExporter.MovieExportValidate(this._ID(), QTObject.ID(movie), QTObject.ID(track), byArray));
        return byArray[0] != 0;
    }

    public AtomContainer getExportSettingsFromAtomContainer() throws StdQTException {
        return AtomContainer.fromMovieExporter(this);
    }

    public void setExportSettingsFromAtomContainer(AtomContainer atomContainer) throws StdQTException {
        int n = MovieExporter.MovieExportSetSettingsFromAtomContainer(this._ID(), QTObject.ID(atomContainer));
        StdQTException.checkError(n);
    }

    public final int getExportFileNameExtension() throws StdQTException {
        int[] nArray = new int[1];
        int n = MovieExporter.MovieExportGetFileNameExtension(this._ID(), nArray);
        StdQTException.checkError(n);
        return nArray[0];
    }

    public final String getExportShortFileTypeString() throws StdQTException {
        byte[] byArray = new byte[256];
        int n = MovieExporter.MovieExportGetShortFileTypeString(this._ID(), byArray);
        StdQTException.checkError(n);
        return QTUtils.PString2String(byArray, 0);
    }

    public final int getExportSourceMediaType() throws StdQTException {
        int[] nArray = new int[1];
        int n = MovieExporter.MovieExportGetSourceMediaType(this._ID(), nArray);
        StdQTException.checkError(n);
        return nArray[0];
    }

    protected void _dispose() throws QTException {
        try {
            MovieExporter.MovieExportSetProgressProc(this._ID(), 0, 0);
        }
        catch (QTNullPointerException qTNullPointerException) {
            // empty catch block
        }
        this.progUPP.cleanupMethodClosure();
        this.progUPP = null;
    }

    private static native int MovieExportToHandle(int var0, int var1, int var2, int var3, int var4, int var5);

    private static native int MovieExportToDataRef(int var0, int var1, int var2, int var3, int var4, int var5, int var6);

    private static native int MovieExportGetAuxiliaryData(int var0, int var1, int[] var2);

    private static native int MovieExportSetProgressProc(int var0, int var1, int var2);

    private static native int MovieExportSetSampleDescription(int var0, int var1, int var2);

    private static native int MovieExportDoUserDialog(int var0, int var1, int var2, int var3, int var4, byte[] var5);

    private static native int MovieExportGetCreatorType(int var0, int[] var1);

    private static native int MovieExportValidate(int var0, int var1, int var2, byte[] var3);

    private static native int MovieExportSetSettingsFromAtomContainer(int var0, int var1);

    private static native int MovieExportGetFileNameExtension(int var0, int[] var1);

    private static native int MovieExportGetShortFileTypeString(int var0, byte[] var1);

    private static native int MovieExportGetSourceMediaType(int var0, int[] var1);

    private static native int MovieExportToFile(int var0, byte[] var1, int var2, int var3, int var4, int var5);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

