/*
 * Decompiled with CFR 0.152.
 */
package quicktime.std.qtcomponents;

import quicktime.QTException;
import quicktime.QTObject;
import quicktime.jdirect.QTNative;
import quicktime.jdirect.QuickTimeLib;
import quicktime.std.StdQTException;
import quicktime.std.movies.media.TimeCodeMedia;
import quicktime.std.movies.media.UserData;
import quicktime.std.movies.media.VisualMediaHandler;
import quicktime.std.qtcomponents.TCTextOptions;
import quicktime.std.qtcomponents.TimeCodeDef;
import quicktime.std.qtcomponents.TimeCodeDescription;
import quicktime.std.qtcomponents.TimeCodeInfo;
import quicktime.std.qtcomponents.TimeCodeTime;
import quicktime.util.QTHandle;
import quicktime.util.QTHandleRef;

public final class TimeCoder
extends VisualMediaHandler
implements QuickTimeLib {
    private static Object linkage = QTNative.linkNativeMethods(class$quicktime$std$qtcomponents$TimeCoder == null ? (class$quicktime$std$qtcomponents$TimeCoder = TimeCoder.class$("quicktime.std.qtcomponents.TimeCoder")) : class$quicktime$std$qtcomponents$TimeCoder);
    static /* synthetic */ Class class$quicktime$std$qtcomponents$TimeCoder;

    public static TimeCoder fromMedia(TimeCodeMedia timeCodeMedia) throws StdQTException {
        int n = TimeCoder.GetMediaHandler(QTObject.ID(timeCodeMedia));
        StdQTException.checkError(TimeCoder.GetMoviesError());
        return new TimeCoder(n, timeCodeMedia);
    }

    private TimeCoder(int n, Object object) {
        super(n, object);
    }

    public TimeCodeInfo getCurrent() throws QTException {
        return QTHandle.fromTimeCoderCurrent(this);
    }

    public TimeCodeInfo getAtTime(int n) throws QTException {
        return QTHandle.fromTimeCoderTime(this, n);
    }

    public String timeCodeToString(TimeCodeDef timeCodeDef, TimeCodeTime timeCodeTime) throws StdQTException {
        byte[] byArray = new byte[256];
        StdQTException.checkError(TimeCoder.TCTimeCodeToString(this._ID(), timeCodeDef.getBytes(), timeCodeTime.getBytes(), byArray));
        return new String(byArray, 1, (int)byArray[0]);
    }

    public String timeCodeToString(TimeCodeDef timeCodeDef, int n) throws StdQTException {
        byte[] byArray = new byte[256];
        int[] nArray = new int[]{n};
        StdQTException.checkError(TimeCoder.TCTimeCodeToString(this._ID(), timeCodeDef.getBytes(), nArray, byArray));
        return new String(byArray, 1, (int)byArray[0]);
    }

    public int toFrameNumber(TimeCodeTime timeCodeTime, TimeCodeDef timeCodeDef) throws StdQTException {
        int[] nArray = new int[1];
        int n = TimeCoder.TCTimeCodeToFrameNumber(this._ID(), timeCodeDef.getBytes(), timeCodeTime.getBytes(), nArray);
        StdQTException.checkError(n);
        return nArray[0];
    }

    public TimeCodeTime toTimeCode(int n, TimeCodeDef timeCodeDef) throws StdQTException {
        TimeCodeTime timeCodeTime = new TimeCodeTime();
        int n2 = TimeCoder.TCFrameNumberToTimeCode(this._ID(), n, timeCodeDef.getBytes(), timeCodeTime.getBytes());
        StdQTException.checkError(n2);
        return timeCodeTime;
    }

    public QTHandle getSourceRef(TimeCodeDescription timeCodeDescription) throws QTException {
        return QTHandle.fromTimeCoderSource(this, timeCodeDescription);
    }

    public UserData getUserDataSourceRef(TimeCodeDescription timeCodeDescription) throws QTException {
        return UserData.fromTimeCoderSource(this, timeCodeDescription);
    }

    public void setSourceRef(TimeCodeDescription timeCodeDescription, QTHandleRef qTHandleRef) throws StdQTException {
        StdQTException.checkError(TimeCoder.TCSetSourceRef(this._ID(), QTObject.ID(timeCodeDescription), QTObject.ID(qTHandleRef)));
    }

    public void setUserDataSourceRef(TimeCodeDescription timeCodeDescription, UserData userData) throws StdQTException {
        StdQTException.checkError(TimeCoder.TCSetSourceRef(this._ID(), QTObject.ID(timeCodeDescription), QTObject.ID(userData)));
    }

    public void setFlags(int n, int n2) throws StdQTException {
        StdQTException.checkError(TimeCoder.TCSetTimeCodeFlags(this._ID(), n, n2));
    }

    public int getFlags() throws StdQTException {
        int[] nArray = new int[1];
        StdQTException.checkError(TimeCoder.TCGetTimeCodeFlags(this._ID(), nArray));
        return nArray[0];
    }

    public void setDisplayOptions(TCTextOptions tCTextOptions) throws StdQTException {
        StdQTException.checkError(TimeCoder.TCSetDisplayOptions(this._ID(), tCTextOptions.getBytes()));
    }

    public TCTextOptions getDisplayOptions() throws StdQTException {
        TCTextOptions tCTextOptions = new TCTextOptions();
        StdQTException.checkError(TimeCoder.TCGetDisplayOptions(this._ID(), tCTextOptions.getBytes()));
        return tCTextOptions;
    }

    private static native int GetMediaHandler(int var0);

    private static native short GetMoviesError();

    private static native int TCTimeCodeToString(int var0, byte[] var1, byte[] var2, byte[] var3);

    private static native int TCTimeCodeToString(int var0, byte[] var1, int[] var2, byte[] var3);

    private static native int TCTimeCodeToFrameNumber(int var0, byte[] var1, byte[] var2, int[] var3);

    private static native int TCFrameNumberToTimeCode(int var0, int var1, byte[] var2, byte[] var3);

    private static native int TCSetSourceRef(int var0, int var1, int var2);

    private static native int TCSetTimeCodeFlags(int var0, int var1, int var2);

    private static native int TCGetTimeCodeFlags(int var0, int[] var1);

    private static native int TCSetDisplayOptions(int var0, byte[] var1);

    private static native int TCGetDisplayOptions(int var0, byte[] var1);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

