/*
 * Decompiled with CFR 0.152.
 */
package quicktime.std.sg;

import com.apple.mrj.macos.carbon.CarbonAccess;
import com.apple.mrj.macos.carbon.CarbonEventClient;
import quicktime.QTException;
import quicktime.QTObject;
import quicktime.QTSession;
import quicktime.jdirect.QTNative;
import quicktime.jdirect.QuickTimeLib;
import quicktime.std.StdQTException;
import quicktime.std.comp.Component;
import quicktime.std.movies.media.SampleDescription;
import quicktime.std.movies.media.UserData;
import quicktime.std.sg.SGDataSourceInfo;
import quicktime.std.sg.SGDeviceList;
import quicktime.std.sg.SGOutput;
import quicktime.std.sg.SequenceGrabber;
import quicktime.util.QTUtils;

public abstract class SGChannel
extends Component
implements QuickTimeLib {
    private static Object linkage = QTNative.linkNativeMethods(class$quicktime$std$sg$SGChannel == null ? (class$quicktime$std$sg$SGChannel = SGChannel.class$("quicktime.std.sg.SGChannel")) : class$quicktime$std$sg$SGChannel);
    private SequenceGrabber owner;
    static /* synthetic */ Class class$quicktime$std$sg$SGChannel;

    SGChannel(int n, SequenceGrabber sequenceGrabber) throws StdQTException {
        super(n, sequenceGrabber);
        this.setOwner(sequenceGrabber);
    }

    SGChannel(SequenceGrabber sequenceGrabber, int n) throws StdQTException {
        super(SGChannel.allocate(sequenceGrabber, n), sequenceGrabber);
        this.setOwner(sequenceGrabber);
    }

    private static int allocate(SequenceGrabber sequenceGrabber, int n) throws StdQTException {
        int[] nArray = new int[1];
        int n2 = SGChannel.SGNewChannel(QTObject.ID(sequenceGrabber), n, nArray);
        StdQTException.checkError(n2);
        return nArray[0];
    }

    private void setOwner(SequenceGrabber sequenceGrabber) throws StdQTException {
        if (sequenceGrabber == null) {
            throw new StdQTException(-50);
        }
        this.owner = sequenceGrabber;
    }

    void disposeChannel(SequenceGrabber sequenceGrabber) throws StdQTException {
        if (this.owner != sequenceGrabber) {
            throw new StdQTException(-50);
        }
        StdQTException.checkError(SGChannel.SGDisposeChannel(QTObject.ID(this.owner), this._ID()));
        this.setNR(0);
        this.owner = null;
    }

    abstract SampleDescription makeDescription() throws QTException;

    public final SampleDescription getSampleDescription() throws QTException {
        SampleDescription sampleDescription = this.makeDescription();
        int n = SGChannel.SGGetChannelSampleDescription(this._ID(), QTObject.ID(sampleDescription));
        StdQTException.checkError(n);
        return sampleDescription;
    }

    public SequenceGrabber getSequenceGrabber() {
        return this.owner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void settingsDialog() throws StdQTException {
        final int[] nArray = null;
        final int n = this._ID();
        if (QTSession.isCurrentOS(4)) {
            int n2 = (Integer)CarbonAccess.invokeCarbonEventClient(new CarbonEventClient(){

                public Object invoke() {
                    int n2 = SGChannel.SGSettingsDialog(QTObject.ID(SGChannel.this.owner), n, (short)0, nArray, 0, 0, 0);
                    return new Integer(n2);
                }
            });
            StdQTException.checkError(n2);
        } else {
            Object object = QTNative.globalsLock;
            synchronized (object) {
                int n3 = SGChannel.SGSettingsDialog(QTObject.ID(this.owner), this._ID(), (short)0, nArray, 0, 0, 0);
                StdQTException.checkError(n3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void settingsDialog(int n, Component[] componentArray) throws StdQTException {
        int[] nArray;
        int n2;
        final int n3 = n2 = 0;
        final int[] nArray2 = nArray = null;
        final int n4 = n;
        int n5 = 0;
        final int n6 = this._ID();
        if (componentArray != null) {
            n2 = componentArray.length;
            nArray = new int[n2];
            int n7 = 0;
            while (n7 < n2) {
                nArray[n7] = QTObject.ID(componentArray[n7]);
                ++n7;
            }
        }
        if (QTSession.isCurrentOS(4)) {
            n5 = (Integer)CarbonAccess.invokeCarbonEventClient(new CarbonEventClient(){

                public Object invoke() {
                    int n = SGChannel.SGSettingsDialog(QTObject.ID(SGChannel.this.owner), n6, (short)n3, nArray2, n4, 0, 0);
                    return new Integer(n);
                }
            });
            StdQTException.checkError(n5);
        } else {
            Object object = QTNative.globalsLock;
            synchronized (object) {
                n5 = SGChannel.SGSettingsDialog(QTObject.ID(this.owner), this._ID(), (short)n2, nArray, n, 0, 0);
                StdQTException.checkError(n5);
            }
        }
    }

    public void setDataSourceName(String string, int n) throws StdQTException {
        int n2 = SGChannel.SGChannelSetDataSourceName(this._ID(), QTUtils.String2PString(string, 255), n);
        StdQTException.checkError(n2);
    }

    public SGDataSourceInfo getDataSourceName() throws StdQTException {
        int[] nArray = new int[1];
        byte[] byArray = new byte[256];
        int n = SGChannel.SGChannelGetDataSourceName(this._ID(), byArray, nArray);
        StdQTException.checkError(n);
        return new SGDataSourceInfo(QTUtils.PString2String(byArray, 0), nArray[0]);
    }

    public void setSettings(UserData userData) throws StdQTException {
        int n = SGChannel.SGSetChannelSettings(QTObject.ID(this.owner), this._ID(), QTObject.ID(userData), 0);
        StdQTException.checkError(n);
    }

    public UserData getSettings() throws StdQTException {
        return UserData.fromSGChannel(this);
    }

    public void setUsage(int n) throws StdQTException {
        StdQTException.checkError(SGChannel.SGSetChannelUsage(this._ID(), n));
    }

    public int getUsage() throws StdQTException {
        int[] nArray = new int[]{0};
        StdQTException.checkError(SGChannel.SGGetChannelUsage(this._ID(), nArray));
        return nArray[0];
    }

    public void setPlayFlags(int n) throws StdQTException {
        StdQTException.checkError(SGChannel.SGSetChannelPlayFlags(this._ID(), n));
    }

    public int getPlayFlags() throws StdQTException {
        int[] nArray = new int[]{0};
        StdQTException.checkError(SGChannel.SGGetChannelPlayFlags(this._ID(), nArray));
        return nArray[0];
    }

    public void setDevice(String string) throws StdQTException {
        StdQTException.checkError(SGChannel.SGSetChannelDevice(this._ID(), QTUtils.String2PString(string, 255)));
    }

    public SGDeviceList getDeviceList(int n) throws StdQTException {
        int[] nArray = new int[]{0};
        int n2 = SGChannel.SGGetChannelDeviceList(this._ID(), n ^= 1, nArray);
        StdQTException.checkError(n2);
        return new SGDeviceList(nArray[0], null, this.owner);
    }

    public int getTimeScale() throws StdQTException {
        int[] nArray = new int[]{0};
        int n = SGChannel.SGGetChannelTimeScale(this._ID(), nArray);
        StdQTException.checkError(n);
        return nArray[0];
    }

    public void setOutput(SGOutput sGOutput) throws StdQTException {
        sGOutput.setChannel(this);
    }

    private static native int SGSetChannelDevice(int var0, byte[] var1);

    private static native int SGNewChannel(int var0, int var1, int[] var2);

    private static native int SGSettingsDialog(int var0, int var1, short var2, int[] var3, int var4, int var5, int var6);

    private static native int SGChannelSetDataSourceName(int var0, byte[] var1, int var2);

    private static native int SGChannelGetDataSourceName(int var0, byte[] var1, int[] var2);

    private static native int SGSetChannelSettings(int var0, int var1, int var2, int var3);

    private static native int SGInitChannel(int var0, int var1);

    private static native int SGSetChannelUsage(int var0, int var1);

    private static native int SGGetChannelUsage(int var0, int[] var1);

    private static native int SGSetChannelPlayFlags(int var0, int var1);

    private static native int SGGetChannelPlayFlags(int var0, int[] var1);

    private static native int SGGetChannelDeviceList(int var0, int var1, int[] var2);

    private static native int SGGetChannelSampleDescription(int var0, int var1);

    private static native int SGGetChannelTimeScale(int var0, int[] var1);

    private static native int SGDisposeChannel(int var0, int var1);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

