/*
 * Decompiled with CFR 0.152.
 */
package quicktime.streaming;

import quicktime.QTException;
import quicktime.QTObject;
import quicktime.qd.GDevice;
import quicktime.qd.QDColor;
import quicktime.qd.QDDimension;
import quicktime.qd.QDGraphics;
import quicktime.qd.Region;
import quicktime.std.image.Matrix;
import quicktime.util.QTPointer;
import quicktime.util.QTPointerRef;
import quicktime.util.QTUtils;

public class MediaParams
extends QTPointerRef {
    public static final int kNativeSize = 80;
    private QTPointer bands = null;
    private QDGraphics g = null;
    private GDevice gd = null;
    private Region rgn = null;

    public MediaParams() throws QTException {
        super(80, true);
        this.setMatrix(new Matrix());
        this.setGDHandle(GDevice.getMain());
        this.setGraphicsMode(64);
        this.setOpColor(QDColor.black);
        this.setLeftVolume(256);
        this.setRightVolume(256);
        this.setLevelMeteringEnabled(false);
    }

    public MediaParams(QDDimension qDDimension, QDGraphics qDGraphics) throws QTException {
        this();
        this.setWidth(qDDimension.getWidth());
        this.setHeight(qDDimension.getHeight());
        this.setGWorld(qDGraphics);
    }

    public MediaParams(QDDimension qDDimension, Matrix matrix, QDGraphics qDGraphics, int n, int n2, int n3, int n4) throws QTException {
        this(qDDimension, qDGraphics);
        this.setMatrix(matrix);
        this.setLeftVolume(n);
        this.setRightVolume(n2);
        this.setBassLevel(n3);
        this.setTrebleLevel(n4);
    }

    public void setWidth(float f) {
        this.setIntAt(0, QTUtils.X2Fix(f));
    }

    public float getWidth() {
        return QTUtils.Fix2X(this.getIntAt(0));
    }

    public void setHeight(float f) {
        this.setIntAt(4, QTUtils.X2Fix(f));
    }

    public float getHeight() {
        return QTUtils.Fix2X(this.getIntAt(4));
    }

    public void setMatrix(Matrix matrix) {
        this.setBytesAt(8, 36, matrix.getBytes(), 0);
    }

    public Matrix getMatrix() {
        Matrix matrix = new Matrix();
        this.getBytesAt(8, 36, matrix.getBytes(), 0);
        return matrix;
    }

    public void setGWorld(QDGraphics qDGraphics) {
        this.g = qDGraphics;
        this.setIntAt(44, QTObject.ID(qDGraphics));
    }

    public QDGraphics getGWorld() {
        return this.g;
    }

    public void setGDHandle(GDevice gDevice) {
        this.gd = gDevice;
        this.setIntAt(48, QTObject.ID(gDevice));
    }

    public GDevice getGDHandle() {
        return this.gd;
    }

    public void setClip(Region region) {
        this.rgn = region;
        this.setIntAt(52, QTObject.ID(region));
    }

    public Region getClip() {
        return this.rgn;
    }

    public void setGraphicsMode(int n) {
        this.setShortAt(56, (short)n);
    }

    public int getGraphicsMode() {
        return this.getShortAt(56);
    }

    public void setOpColor(QDColor qDColor) {
        this.setBytesAt(58, 6, qDColor.getBytes(), 0);
    }

    public QDColor getOpColor() {
        QDColor qDColor = new QDColor();
        this.getBytesAt(58, 6, qDColor.getBytes(), 0);
        return qDColor;
    }

    public void setLeftVolume(int n) {
        this.setShortAt(64, (short)n);
    }

    public int getLeftVolume() {
        return this.getShortAt(64);
    }

    public void setRightVolume(int n) {
        this.setShortAt(66, (short)n);
    }

    public int getRightVolume() {
        return this.getShortAt(66);
    }

    public void setVolumes(int n, int n2) {
        this.setLeftVolume(n);
        this.setRightVolume(n2);
    }

    public void setBassLevel(int n) {
        this.setShortAt(68, (short)n);
    }

    public int getBassLevel() {
        return this.getShortAt(68);
    }

    public void setTrebleLevel(int n) {
        this.setShortAt(70, (short)n);
    }

    public int getTrebleLevel() {
        return this.getShortAt(70);
    }

    public void setFrequencyBands(QTPointer qTPointer) throws QTException {
        this.setShortAt(72, (short)qTPointer.getSize());
        this.bands = qTPointer;
        this.setIntAt(74, QTObject.ID(this.bands));
    }

    public int getFrequencyBandsCount() {
        return this.getShortAt(72);
    }

    public byte[] getFrequencyBands() {
        if (this.bands != null) {
            return this.bands.getBytes();
        }
        return null;
    }

    public void setLevelMeteringEnabled(boolean bl) {
        this.setByteAt(78, (byte)(bl ? 1 : 0));
    }

    public boolean isLevelMeteringEnabled() {
        return this.getByteAt(78) == 1;
    }

    public String toString() {
        return this.getClass().getName() + "[width=" + this.getWidth() + ",height=" + this.getHeight() + ",matrix=" + this.getMatrix() + ",\n" + "gWorld=" + this.getGWorld() + ",gdHandle=" + this.getGDHandle() + ",clip=" + this.getClip() + ",graphicsMode=" + this.getGraphicsMode() + ",opColor=" + this.getOpColor() + ",\n" + "leftVolume=" + this.getLeftVolume() + ",rightVolume=" + this.getRightVolume() + ",bassLevel=" + this.getBassLevel() + ",trebleLevel=" + this.getTrebleLevel() + ",frequencyBandsCount=" + this.getFrequencyBandsCount() + ",frequencyBands=" + this.getFrequencyBands() + ",levelMeteringEnabled=" + this.isLevelMeteringEnabled() + "]";
    }
}

