/*
 * Decompiled with CFR 0.152.
 */
package quicktime.util;

import java.util.Enumeration;
import java.util.Vector;
import quicktime.QTRuntimeException;
import quicktime.util.EndianFlipSpec;

public class EndianDescriptor {
    public static final int kFlipSpecifiedFields = 0;
    public static final int kFlipAllFields16 = 1;
    public static final int kFlipAllFields32 = 16;
    public static final int kFlipAllFields64 = 256;
    public static final int kFlipNoFields = 4096;
    public static final EndianDescriptor flipAll16 = new EndianDescriptor(1);
    public static final EndianDescriptor flipAll32 = new EndianDescriptor(16);
    public static final EndianDescriptor flipAll64 = new EndianDescriptor(256);
    private int flag;
    private Vector vec;

    public EndianDescriptor(int n) {
        this.flag = n;
    }

    public int getFormatFlag() {
        return this.flag;
    }

    public void addFlipSpec(EndianFlipSpec endianFlipSpec) {
        if (this.flag != 0) {
            throw new QTRuntimeException("Can't specify endian flip with " + this.flag + " format flag");
        }
        if (this.vec == null) {
            this.vec = new Vector();
        }
        int n = 0;
        while (n < this.vec.size()) {
            EndianFlipSpec endianFlipSpec2 = (EndianFlipSpec)this.vec.elementAt(n);
            if (endianFlipSpec.offset == endianFlipSpec2.offset) {
                throw new QTRuntimeException("Each offset must be unique");
            }
            if (endianFlipSpec.offset < endianFlipSpec2.offset) {
                this.vec.insertElementAt(endianFlipSpec, n);
                return;
            }
            ++n;
        }
        this.vec.addElement(endianFlipSpec);
    }

    public void removeFlipSpec(EndianFlipSpec endianFlipSpec) {
        if (this.vec != null) {
            this.vec.removeElement(endianFlipSpec);
        }
    }

    public EndianFlipSpec getFlipSpec(int n) {
        if (this.vec == null) {
            return null;
        }
        int n2 = 0;
        while (n2 < this.vec.size()) {
            EndianFlipSpec endianFlipSpec = (EndianFlipSpec)this.vec.elementAt(n2);
            if (n == endianFlipSpec.offset) {
                return endianFlipSpec;
            }
            if (endianFlipSpec.offset > n) {
                return null;
            }
            ++n2;
        }
        return null;
    }

    public Enumeration flipSpecs() {
        return this.vec == null ? null : this.vec.elements();
    }

    public String toString() {
        String string = this.getClass().getName() + "[flipFlag=";
        switch (this.flag) {
            case 0: {
                string = string + "kFlipSpecifiedFields";
                break;
            }
            case 1: {
                string = string + "kFlipAllFields16";
                break;
            }
            case 16: {
                string = string + "kFlipAllFields32";
                break;
            }
            case 256: {
                string = string + "kFlipAllFields64";
                break;
            }
            case 4096: {
                string = string + "kFlipNoFields";
            }
        }
        if (this.flag == 0) {
            string = string + "[";
            Enumeration enumeration = this.flipSpecs();
            while (enumeration.hasMoreElements()) {
                string = string + enumeration.nextElement() + ",";
            }
            string = string + "]";
        }
        string = string + "]";
        return string;
    }
}

