/*
 * Decompiled with CFR 0.152.
 */
package quicktime.util;

import quicktime.QTSession;
import quicktime.util.EndianDescriptor;
import quicktime.util.QTUtils;
import quicktime.util.UtilException;

public final class EndianOrder {
    private static final boolean isLittleEndian = QTSession.isCurrentOS(2);

    private EndianOrder() {
    }

    public static boolean isNativeLittleEndian() {
        return isLittleEndian;
    }

    public static boolean isNativeBigEndian() {
        return !isLittleEndian;
    }

    public static short flipNativeToBigEndian16(short s) {
        return EndianOrder.isNativeLittleEndian() ? QTUtils.endianFlip16(s) : s;
    }

    public static short flipBigEndianToNative16(short s) {
        return EndianOrder.isNativeLittleEndian() ? QTUtils.endianFlip16(s) : s;
    }

    public static short flipNativeToLittleEndian16(short s) {
        return EndianOrder.isNativeBigEndian() ? QTUtils.endianFlip16(s) : s;
    }

    public static short flipLittleEndianToNative16(short s) {
        return EndianOrder.isNativeBigEndian() ? QTUtils.endianFlip16(s) : s;
    }

    public static int flipNativeToBigEndian32(int n) {
        return EndianOrder.isNativeLittleEndian() ? QTUtils.endianFlip32(n) : n;
    }

    public static int flipBigEndianToNative32(int n) {
        return EndianOrder.isNativeLittleEndian() ? QTUtils.endianFlip32(n) : n;
    }

    public static int flipNativeToLittleEndian32(int n) {
        return EndianOrder.isNativeBigEndian() ? QTUtils.endianFlip32(n) : n;
    }

    public static int flipLittleEndianToNative32(int n) {
        return EndianOrder.isNativeBigEndian() ? QTUtils.endianFlip32(n) : n;
    }

    public static long flipNativeToBigEndian64(long l) {
        return EndianOrder.isNativeLittleEndian() ? QTUtils.endianFlip64(l) : l;
    }

    public static long flipBigEndianToNative64(long l) {
        return EndianOrder.isNativeLittleEndian() ? QTUtils.endianFlip64(l) : l;
    }

    public static long flipNativeToLittleEndian64(long l) {
        return EndianOrder.isNativeBigEndian() ? QTUtils.endianFlip64(l) : l;
    }

    public static long flipLittleEndianToNative64(long l) {
        return EndianOrder.isNativeBigEndian() ? QTUtils.endianFlip64(l) : l;
    }

    public static void flipNativeToBigEndian(Object object, int n, EndianDescriptor endianDescriptor) throws UtilException {
        if (EndianOrder.isNativeLittleEndian()) {
            QTUtils.endianFlip(object, n, endianDescriptor);
        }
    }

    public static void flipBigEndianToNative(Object object, int n, EndianDescriptor endianDescriptor) throws UtilException {
        if (EndianOrder.isNativeLittleEndian()) {
            QTUtils.endianFlip(object, n, endianDescriptor);
        }
    }

    public static void flipNativeToLittleEndian(Object object, int n, EndianDescriptor endianDescriptor) throws UtilException {
        if (EndianOrder.isNativeBigEndian()) {
            QTUtils.endianFlip(object, n, endianDescriptor);
        }
    }

    public static void flipLittleEndianToNative(Object object, int n, EndianDescriptor endianDescriptor) throws UtilException {
        if (EndianOrder.isNativeBigEndian()) {
            QTUtils.endianFlip(object, n, endianDescriptor);
        }
    }

    public static void flipNativeToBigEndian(Object object, int n, Object object2, int n2, EndianDescriptor endianDescriptor) throws UtilException {
        if (EndianOrder.isNativeLittleEndian()) {
            QTUtils.endianFlip(object, n, object2, n2, endianDescriptor);
        }
    }

    public static void flipBigEndianToNative(Object object, int n, Object object2, int n2, EndianDescriptor endianDescriptor) throws UtilException {
        if (EndianOrder.isNativeLittleEndian()) {
            QTUtils.endianFlip(object, n, object2, n2, endianDescriptor);
        }
    }

    public static void flipNativeToLittleEndian(Object object, int n, Object object2, int n2, EndianDescriptor endianDescriptor) throws UtilException {
        if (EndianOrder.isNativeBigEndian()) {
            QTUtils.endianFlip(object, n, object2, n2, endianDescriptor);
        }
    }

    public static void flipLittleEndianToNative(Object object, int n, Object object2, int n2, EndianDescriptor endianDescriptor) throws UtilException {
        if (EndianOrder.isNativeBigEndian()) {
            QTUtils.endianFlip(object, n, object2, n2, endianDescriptor);
        }
    }
}

