/*
 * Decompiled with CFR 0.152.
 */
package quicktime.util;

import quicktime.QTException;
import quicktime.QTObject;
import quicktime.QTRuntimeException;
import quicktime.jdirect.InterfaceLib;
import quicktime.jdirect.PrimitivesLib;
import quicktime.jdirect.QTNative;
import quicktime.jdirect.QuickTimeLib;
import quicktime.util.QTUtils;
import quicktime.util.UtilException;

public class QTPointerRef
extends QTObject
implements QuickTimeLib,
PrimitivesLib,
InterfaceLib {
    private static Object linkage = QTNative.linkNativeMethods(class$quicktime$util$QTPointerRef == null ? (class$quicktime$util$QTPointerRef = QTPointerRef.class$("quicktime.util.QTPointerRef")) : class$quicktime$util$QTPointerRef);
    private transient int size;
    static /* synthetic */ Class class$quicktime$util$QTPointerRef;

    protected QTPointerRef(int n, boolean bl) throws QTException {
        this(QTPointerRef.allocate(n, bl), n, null);
        UtilException.checkError(QTPointerRef.MemError());
    }

    protected QTPointerRef(int n, int n2, Object object) {
        super(n, object);
        this.size = n2;
    }

    private static int allocate(int n, boolean bl) throws UtilException {
        int n2;
        int n3 = n2 = bl ? QTPointerRef.NewPtrClear(n) : QTPointerRef.NewPtr(n);
        if (n2 == 0) {
            throw new UtilException(-108);
        }
        return n2;
    }

    public int getSize() {
        return this.size;
    }

    public byte[] getBytes() {
        byte[] byArray = new byte[this.size];
        this.getBytesAt(0, this.size, byArray, 0);
        return byArray;
    }

    protected void getBytesAt(int n, int n2, byte[] byArray, int n3) {
        QTPointerRef.copyPointerToArray(this._ID(), n, byArray, n3, n2);
    }

    protected void setBytesAt(int n, int n2, byte[] byArray, int n3) {
        QTPointerRef.copyArrayToPointer(byArray, n3, this._ID(), n, n2);
    }

    public final void copyToArray(int n, byte[] byArray, int n2, int n3) {
        QTUtils.doBoundsChecks(n, this.size, n3, 1, n2, byArray.length);
        this.getBytesAt(n, n3, byArray, n2);
    }

    public final void copyToArray(int n, short[] sArray, int n2, int n3) {
        QTUtils.doBoundsChecks(n, this.size, n3, 2, n2, sArray.length);
        QTPointerRef.copyPointerToArray(this._ID(), n, sArray, n2 * 2, n3 * 2);
    }

    public final void copyToArray(int n, char[] cArray, int n2, int n3) {
        QTUtils.doBoundsChecks(n, this.size, n3, 2, n2, cArray.length);
        QTPointerRef.copyPointerToArray(this._ID(), n, cArray, n2 * 2, n3 * 2);
    }

    public final void copyToArray(int n, int[] nArray, int n2, int n3) {
        QTUtils.doBoundsChecks(n, this.size, n3, 4, n2, nArray.length);
        QTPointerRef.copyPointerToArray(this._ID(), n, nArray, n2 * 4, n3 * 4);
    }

    public final void copyToArray(int n, float[] fArray, int n2, int n3) {
        QTUtils.doBoundsChecks(n, this.size, n3, 4, n2, fArray.length);
        QTPointerRef.copyPointerToArray(this._ID(), n, fArray, n2 * 4, n3 * 4);
    }

    public final void copyToArray(int n, long[] lArray, int n2, int n3) {
        QTUtils.doBoundsChecks(n, this.size, n3, 8, n2, lArray.length);
        QTPointerRef.copyPointerToArray(this._ID(), n, lArray, n2 * 8, n3 * 8);
    }

    public final void copyToArray(int n, double[] dArray, int n2, int n3) {
        QTUtils.doBoundsChecks(n, this.size, n3, 8, n2, dArray.length);
        QTPointerRef.copyPointerToArray(this._ID(), n, dArray, n2 * 8, n3 * 8);
    }

    public final void copyFromArray(int n, byte[] byArray, int n2, int n3) {
        QTUtils.doBoundsChecks(n, this.size, n3, 1, n2, byArray.length);
        this.setBytesAt(n, n3, byArray, n2);
    }

    public final void copyFromArray(int n, short[] sArray, int n2, int n3) {
        QTUtils.doBoundsChecks(n, this.size, n3, 2, n2, sArray.length);
        QTPointerRef.copyArrayToPointer(sArray, n2 * 2, this._ID(), n, n3 * 2);
    }

    public final void copyFromArray(int n, char[] cArray, int n2, int n3) {
        QTUtils.doBoundsChecks(n, this.size, n3, 2, n2, cArray.length);
        QTPointerRef.copyArrayToPointer(cArray, n2 * 2, this._ID(), n, n3 * 2);
    }

    public final void copyFromArray(int n, int[] nArray, int n2, int n3) {
        QTUtils.doBoundsChecks(n, this.size, n3, 4, n2, nArray.length);
        QTPointerRef.copyArrayToPointer(nArray, n2 * 4, this._ID(), n, n3 * 4);
    }

    public final void copyFromArray(int n, float[] fArray, int n2, int n3) {
        QTUtils.doBoundsChecks(n, this.size, n3, 4, n2, fArray.length);
        QTPointerRef.copyArrayToPointer(fArray, n2 * 4, this._ID(), n, n3 * 4);
    }

    public final void copyFromArray(int n, long[] lArray, int n2, int n3) {
        QTUtils.doBoundsChecks(n, this.size, n3, 8, n2, lArray.length);
        QTPointerRef.copyArrayToPointer(lArray, n2 * 8, this._ID(), n, n3 * 8);
    }

    public final void copyFromArray(int n, double[] dArray, int n2, int n3) {
        QTUtils.doBoundsChecks(n, this.size, n3, 8, n2, dArray.length);
        QTPointerRef.copyArrayToPointer(dArray, n2 * 8, this._ID(), n, n3 * 8);
    }

    public String toString() {
        return super.toString() + "[size=" + this.getSize() + "]";
    }

    protected int makeAndCopyPtr(int n, int n2) {
        int n3 = 0;
        try {
            n3 = QTPointerRef.allocate(n2, false);
        }
        catch (UtilException utilException) {
            throw new QTRuntimeException(utilException);
        }
        QTPointerRef.BlockMove(this._ID() + n, n3, this.size);
        return n3;
    }

    protected byte getByteAt(int n) {
        return QTPointerRef.getByteFromPointer(this._ID(), n);
    }

    protected short getShortAt(int n) {
        return QTPointerRef.getShortFromPointer(this._ID(), n);
    }

    protected int getIntAt(int n) {
        return QTPointerRef.getIntFromPointer(this._ID(), n);
    }

    protected long getLongAt(int n) {
        return QTPointerRef.getLongFromPointer(this._ID(), n);
    }

    protected float getFloatAt(int n) {
        return QTPointerRef.getFloatFromPointer(this._ID(), n);
    }

    protected double getDoubleAt(int n) {
        return QTPointerRef.getDoubleFromPointer(this._ID(), n);
    }

    protected void setByteAt(int n, byte by) {
        QTPointerRef.setByteInPointer(this._ID(), n, by);
    }

    protected void setShortAt(int n, short s) {
        QTPointerRef.setShortInPointer(this._ID(), n, s);
    }

    protected void setIntAt(int n, int n2) {
        QTPointerRef.setIntInPointer(this._ID(), n, n2);
    }

    protected void setLongAt(int n, long l) {
        QTPointerRef.setLongInPointer(this._ID(), n, l);
    }

    protected void setFloatAt(int n, float f) {
        QTPointerRef.setFloatInPointer(this._ID(), n, f);
    }

    protected void setDoubleAt(int n, double d) {
        QTPointerRef.setDoubleInPointer(this._ID(), n, d);
    }

    protected int strlen(int n) {
        int n2 = 0;
        while (this.getByteAt(n++) != 0) {
            ++n2;
        }
        return n2;
    }

    protected String getCStringAt(int n) throws UtilException {
        int n2 = this.strlen(n);
        if (n2 > this.getSize()) {
            throw new UtilException(-50);
        }
        byte[] byArray = new byte[n2];
        this.getBytesAt(n, n2, byArray, 0);
        return new String(byArray);
    }

    protected void setCStringAt(int n, int n2, String string) throws UtilException {
        if ((n2 = Math.min(n2, string.length())) + n > this.getSize()) {
            throw new UtilException(-50);
        }
        byte[] byArray = string.getBytes();
        this.setBytesAt(n, n2, byArray, 0);
        this.setByteAt(n + n2, (byte)0);
    }

    protected String getPStringAt(int n) throws UtilException {
        byte by;
        if ((by = this.getByteAt(n++)) > this.getSize()) {
            throw new UtilException(-50);
        }
        byte[] byArray = new byte[by];
        this.getBytesAt(n, by, byArray, 0);
        return new String(byArray);
    }

    protected void setPStringAt(int n, int n2, String string) throws UtilException {
        if ((n2 = Math.min(Math.min(n2, string.length()), 255)) + n > this.getSize()) {
            throw new UtilException(-50);
        }
        this.setByteAt(n++, (byte)n2);
        byte[] byArray = string.getBytes();
        this.setBytesAt(n, n2, byArray, 0);
    }

    private static native short MemError();

    private static native int NewPtrClear(int var0);

    private static native int NewPtr(int var0);

    private static native void BlockMove(int var0, int var1, int var2);

    private static native void copyPointerToArray(int var0, int var1, byte[] var2, int var3, int var4);

    private static native void copyPointerToArray(int var0, int var1, short[] var2, int var3, int var4);

    private static native void copyPointerToArray(int var0, int var1, char[] var2, int var3, int var4);

    private static native void copyPointerToArray(int var0, int var1, int[] var2, int var3, int var4);

    private static native void copyPointerToArray(int var0, int var1, float[] var2, int var3, int var4);

    private static native void copyPointerToArray(int var0, int var1, long[] var2, int var3, int var4);

    private static native void copyPointerToArray(int var0, int var1, double[] var2, int var3, int var4);

    private static native void copyArrayToPointer(byte[] var0, int var1, int var2, int var3, int var4);

    private static native void copyArrayToPointer(short[] var0, int var1, int var2, int var3, int var4);

    private static native void copyArrayToPointer(char[] var0, int var1, int var2, int var3, int var4);

    private static native void copyArrayToPointer(int[] var0, int var1, int var2, int var3, int var4);

    private static native void copyArrayToPointer(float[] var0, int var1, int var2, int var3, int var4);

    private static native void copyArrayToPointer(long[] var0, int var1, int var2, int var3, int var4);

    private static native void copyArrayToPointer(double[] var0, int var1, int var2, int var3, int var4);

    private static native byte getByteFromPointer(int var0, int var1);

    private static native short getShortFromPointer(int var0, int var1);

    private static native int getIntFromPointer(int var0, int var1);

    private static native long getLongFromPointer(int var0, int var1);

    private static native double getDoubleFromPointer(int var0, int var1);

    private static native float getFloatFromPointer(int var0, int var1);

    private static native void setByteInPointer(int var0, int var1, byte var2);

    private static native void setShortInPointer(int var0, int var1, short var2);

    private static native void setIntInPointer(int var0, int var1, int var2);

    private static native void setLongInPointer(int var0, int var1, long var2);

    private static native void setFloatInPointer(int var0, int var1, float var2);

    private static native void setDoubleInPointer(int var0, int var1, double var2);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

