/*
 * Decompiled with CFR 0.152.
 */
package quicktime.vr;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import quicktime.QTException;
import quicktime.QTRuntimeException;
import quicktime.util.EndianDescriptor;
import quicktime.util.EndianFlipSpec;
import quicktime.vr.QTVRAtom;

public final class QTVRWorldHeader
extends QTVRAtom {
    private static final int kNativeSize = 24;
    static final long serialVersionUID = -8701506970872651584L;
    private static EndianDescriptor ed;

    public QTVRWorldHeader() {
        super(24);
    }

    public QTVRWorldHeader(byte[] byArray) throws QTException {
        super(byArray, 24);
    }

    protected int getNativeSize() {
        return 24;
    }

    protected void readObject(ObjectInputStream objectInputStream) throws IOException {
        this.bytes = new byte[24];
        QTVRWorldHeader qTVRWorldHeader = new QTVRWorldHeader();
        objectInputStream.read(qTVRWorldHeader.getBytes());
        System.arraycopy(qTVRWorldHeader.getBytes(), 0, this.getBytes(), 0, this.bytes.length);
    }

    protected void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        QTVRWorldHeader qTVRWorldHeader = (QTVRWorldHeader)this.clone();
        objectOutputStream.write(qTVRWorldHeader.getBytes());
    }

    public Object clone() {
        try {
            return new QTVRWorldHeader(this.bytes);
        }
        catch (QTException qTException) {
            throw new QTRuntimeException(qTException);
        }
    }

    protected static EndianDescriptor makeED() {
        EndianDescriptor endianDescriptor = new EndianDescriptor(0);
        EndianFlipSpec endianFlipSpec = new EndianFlipSpec(0, 2, 2);
        endianDescriptor.addFlipSpec(endianFlipSpec);
        EndianFlipSpec endianFlipSpec2 = new EndianFlipSpec(4, 4, 5);
        endianDescriptor.addFlipSpec(endianFlipSpec2);
        return endianDescriptor;
    }

    public int getNameAtomID() {
        return this.getIntAt(4);
    }

    public void setNameAtomID(int n) {
        this.setIntAt(4, n);
    }

    public int getDefaultNodeID() {
        return this.getIntAt(8);
    }

    public void setDefaultNodeID(int n) {
        this.setIntAt(8, n);
    }

    public int getVRWorldFlags() {
        return this.getIntAt(12);
    }

    public void setVRWorldFlags(int n) {
        this.setIntAt(12, n);
    }

    public void setReserved1(int n) {
        this.setIntAt(16, n);
    }

    public int getReserved1() {
        return this.getIntAt(16);
    }

    public void setReserved2(int n) {
        this.setIntAt(20, n);
    }

    public int getReserved2() {
        return this.getIntAt(20);
    }

    public String toString() {
        return this.getClass().getName() + "[nameAtomID=" + this.getNameAtomID() + ",defaultNodeID=" + this.getDefaultNodeID() + ",vrWorldFlags=" + this.getVRWorldFlags() + "]";
    }
}

