/*
 * Decompiled with CFR 0.152.
 */
import com.sun.media.util.WindowUtil;
import com.sun.media.vfw.BitMapInfo;
import com.sun.media.vfw.VFWCapture;
import java.awt.Button;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.media.CaptureDeviceInfo;
import javax.media.CaptureDeviceManager;
import javax.media.Format;
import javax.media.MediaLocator;
import javax.media.format.VideoFormat;

public class VFWManual
extends Frame {
    CaptureDeviceInfo[] devices = null;
    int currentID = -1;
    static /* synthetic */ Class array$B;

    public VFWManual() {
        super("Register VFW Caputure Devices");
        this.setLayout(new FlowLayout());
        int n2 = 0;
        this.removeCurrentDevices();
        int n3 = 0;
        while (n3 < 10) {
            String string = VFWCapture.capGetDriverDescriptionName(n3);
            if (string != null && string.length() > 1) {
                Button button = new Button(string);
                this.add(button);
                button.addActionListener(new DBListener(n3));
                ++n2;
            }
            ++n3;
        }
        this.devices = new CaptureDeviceInfo[n2];
        this.pack();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                if (VFWManual.this.currentID != -1) {
                    System.err.println("Need to close other window first");
                    return;
                }
                VFWManual.this.dispose();
                System.exit(0);
            }
        });
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void createDialog(int n2) {
        if (this.currentID == n2) {
            return;
        }
        this.currentID = n2;
        Thread thread = new Thread(new Runnable(){

            public void run() {
                FormatsDialog formatsDialog = new FormatsDialog(VFWManual.this.currentID);
                ((Component)formatsDialog).setVisible(true);
                CaptureDeviceInfo captureDeviceInfo = formatsDialog.getDeviceInfo();
                if (captureDeviceInfo != null) {
                    System.err.println("CaptureDeviceInfo = " + captureDeviceInfo.getName() + " " + captureDeviceInfo.getLocator());
                }
                VFWManual.this.currentID = -1;
            }
        });
        thread.start();
    }

    public static void main(String[] stringArray) {
        VFWManual vFWManual = new VFWManual();
        ((Component)vFWManual).setVisible(true);
    }

    private void removeCurrentDevices() {
        Vector vector = (Vector)CaptureDeviceManager.getDeviceList(null).clone();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            CaptureDeviceInfo captureDeviceInfo = (CaptureDeviceInfo)enumeration.nextElement();
            String string = captureDeviceInfo.getName();
            if (!string.startsWith("vfw:")) continue;
            CaptureDeviceManager.removeDevice(captureDeviceInfo);
        }
    }

    class FormatsDialog
    extends Frame {
        int id;
        Button bVideoFormat;
        Button bDone;
        Button bCancel;
        Vector formats = new Vector();
        Frame capFrame;
        int capHandle;
        Integer lock = new Integer(1);
        boolean finished = false;
        boolean needVideoFormatDialog = false;

        public FormatsDialog(int n2) {
            super(VFWCapture.capGetDriverDescriptionName(n2));
            this.id = n2;
            this.setLayout(new FlowLayout());
            this.bVideoFormat = new Button("VideoFormat Dialog");
            this.bDone = new Button("Done");
            this.bCancel = new Button("Cancel");
            this.capFrame = new Frame("CaptureWindow");
            ((Component)this.capFrame).setBounds(0, 0, 380, 280);
            this.capFrame.addNotify();
            ((Component)this.capFrame).setVisible(false);
            this.capHandle = VFWCapture.capCreateCaptureWindow("Test", WindowUtil.getWindowHandle(this.capFrame), 0, 0, 320, 240, VFWCapture.getNextID());
            if (this.capHandle == 0) {
                this.capFrame.dispose();
                throw new Error("Could not create capture window");
            }
            VFWCapture.capDriverConnect(this.capHandle, n2);
            this.add(this.bVideoFormat);
            this.add(this.bDone);
            this.add(this.bCancel);
            this.pack();
            this.addWindowListener(new WindowAdapter(this){
                private final /* synthetic */ FormatsDialog this$1;
                {
                    this.this$1 = formatsDialog;
                }

                public void windowClosing(WindowEvent windowEvent) {
                    Integer n2 = this.this$1.lock;
                    synchronized (n2) {
                        this.this$1.finished = true;
                        this.this$1.lock.notify();
                    }
                }
            });
            this.bDone.addActionListener(new ActionListener(this){
                private final /* synthetic */ FormatsDialog this$1;
                {
                    this.this$1 = formatsDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    Integer n2 = this.this$1.lock;
                    synchronized (n2) {
                        this.this$1.finished = true;
                        this.this$1.lock.notify();
                    }
                }
            });
            this.bCancel.addActionListener(new ActionListener(this){
                private final /* synthetic */ FormatsDialog this$1;
                {
                    this.this$1 = formatsDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    Integer n2 = this.this$1.lock;
                    synchronized (n2) {
                        this.this$1.finished = true;
                        this.this$1.lock.notify();
                    }
                }
            });
            this.bVideoFormat.addActionListener(new ActionListener(this){
                private final /* synthetic */ FormatsDialog this$1;
                {
                    this.this$1 = formatsDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.needVideoFormatDialog = true;
                    Integer n2 = this.this$1.lock;
                    synchronized (n2) {
                        this.this$1.lock.notify();
                    }
                }
            });
        }

        public void doVideoFormatDialog() {
            VFWCapture.capDlgVideoFormat(this.capHandle);
            BitMapInfo bitMapInfo = new BitMapInfo();
            VFWCapture.capGetVideoFormat(this.capHandle, bitMapInfo);
            VideoFormat videoFormat = bitMapInfo.createVideoFormat(array$B != null ? array$B : (array$B = VFWManual.class$("[B")));
            System.err.println("Format = " + videoFormat);
            Enumeration enumeration = this.formats.elements();
            while (enumeration.hasMoreElements()) {
                Format format = (Format)enumeration.nextElement();
                if (!format.equals(videoFormat)) continue;
                return;
            }
            this.formats.addElement(videoFormat);
        }

        public CaptureDeviceInfo getDeviceInfo() {
            Serializable serializable;
            Object object;
            try {
                while (!this.finished) {
                    object = this.lock;
                    synchronized (object) {
                        this.lock.wait();
                    }
                    if (!this.needVideoFormatDialog) continue;
                    this.needVideoFormatDialog = false;
                    this.doVideoFormatDialog();
                }
            }
            catch (InterruptedException interruptedException) {
                this.mydispose();
                return null;
            }
            object = "vfw:" + VFWCapture.capDriverGetName(this.capHandle) + ":" + this.id;
            String string = "vfw://" + this.id;
            this.mydispose();
            if (this.formats == null || this.formats.size() < 1) {
                return null;
            }
            Format[] formatArray = new Format[this.formats.size()];
            Enumeration enumeration = this.formats.elements();
            int n2 = 0;
            while (enumeration.hasMoreElements()) {
                serializable = (Format)enumeration.nextElement();
                formatArray[n2++] = serializable;
            }
            serializable = new CaptureDeviceInfo((String)object, new MediaLocator(string), formatArray);
            CaptureDeviceManager.addDevice((CaptureDeviceInfo)serializable);
            try {
                CaptureDeviceManager.commit();
                System.err.println("VFWManual: Committed ok");
            }
            catch (IOException iOException) {
                System.err.println("VFWManual: error committing cdm");
            }
            return serializable;
        }

        public void mydispose() {
            VFWCapture.capDriverDisconnect(this.capHandle);
            this.capFrame.dispose();
            this.dispose();
            System.err.println("Disconnected driver");
        }
    }

    class DBListener
    implements ActionListener {
        int id;

        public DBListener(int n2) {
            this.id = n2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            VFWManual.this.createDialog(this.id);
        }
    }
}

