/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.content.rtsp;

import com.sun.media.BasicPlayer;
import com.sun.media.Log;
import com.sun.media.rtsp.RtspAppListener;
import com.sun.media.rtsp.RtspListener;
import com.sun.media.rtsp.RtspManager;
import com.sun.media.rtsp.RtspUrl;
import com.sun.media.rtsp.protocol.CSeqHeader;
import com.sun.media.rtsp.protocol.ContentBaseHeader;
import com.sun.media.rtsp.protocol.Header;
import com.sun.media.rtsp.protocol.Message;
import com.sun.media.rtsp.protocol.OptionsMessage;
import com.sun.media.rtsp.protocol.Request;
import com.sun.media.rtsp.protocol.ResponseMessage;
import com.sun.media.rtsp.protocol.SessionHeader;
import com.sun.media.rtsp.protocol.StatusCode;
import com.sun.media.rtsp.protocol.TransportHeader;
import com.sun.media.sdp.MediaAttribute;
import com.sun.media.sdp.MediaDescription;
import com.sun.media.sdp.SdpParser;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.util.Vector;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.media.rtp.RTPManager;
import javax.media.rtp.ReceiveStreamListener;
import javax.media.rtp.SessionAddress;

public class RtspUtil
implements RtspListener {
    private final int TIMER_1 = 60000;
    private final int TIMER_2 = 30000;
    private RtspManager rtspManager;
    private RTPManager[] mgrs;
    private String[] mediaTypes;
    private long sequenceNumber;
    private int numberOfTracks;
    private String userAgent;
    private RtspUrl rtspUrl;
    private String[] mediaControls;
    private int[] server_ports;
    private int[] client_ports;
    private String[] session_ids;
    private Message message;
    private int connectionId;
    private String url;
    private double startPos;
    private String processError;
    private long duration;
    private Vector listeners;
    private ReceiveStreamListener parent;
    boolean responseReceived;
    boolean dataReceived;
    Object responseSync = new Object();

    public RtspUtil(ReceiveStreamListener receiveStreamListener) {
        this.parent = receiveStreamListener;
        this.listeners = new Vector();
        this.rtspManager = new RtspManager(false);
        this.sequenceNumber = (long)(Math.random() * 1000.0);
        this.userAgent = "User-Agent: JMF RTSP Player " + BasicPlayer.VERSION;
        this.rtspManager.addListener(this);
    }

    private void addDynamicPayload(RTPManager rTPManager, String string, String string2) {
        int n2 = 0;
        while (string2.length() > 0 && string2.charAt(n2) == ' ') {
            ++n2;
        }
        if (n2 > 0) {
            string2 = string2.substring(n2);
        }
        n2 = 0;
        while (string2.length() > 0 && string2.charAt(n2) != ' ') {
            ++n2;
        }
        if (n2 < 0) {
            return;
        }
        String string3 = string2.substring(0, n2);
        string2 = string2.substring(n2);
        Integer n3 = Integer.valueOf(string3);
        if (n3 == null) {
            return;
        }
        int n4 = n3;
        if (n4 < 96 || n4 > 127) {
            return;
        }
        n2 = 0;
        while (string2.length() > 0 && string2.charAt(n2) == ' ') {
            ++n2;
        }
        if (n2 > 0) {
            string2 = string2.substring(n2);
        }
        if (string2.length() == 0) {
            return;
        }
        n2 = 0;
        while (string2.length() > 0 && string2.charAt(n2) != '/') {
            ++n2;
        }
        string3 = n2 > 0 ? string2.substring(0, n2) : string2;
        if (string3.length() == 0) {
            return;
        }
        string3 = String.valueOf(string3.toLowerCase()) + "/rtp";
        if ("video".equalsIgnoreCase(string)) {
            rTPManager.addFormat(new VideoFormat(string3), n4);
            Log.comment("Add RTP dynamic payload for video: " + n4 + " : " + string3);
        }
        if ("audio".equalsIgnoreCase(string)) {
            rTPManager.addFormat(new AudioFormat(string3), n4);
            Log.comment("Add RTP dynamic payload for audio: " + n4 + " : " + string3);
        }
    }

    public void addListener(RtspAppListener rtspAppListener) {
        this.listeners.addElement(rtspAppListener);
    }

    public void closeConnection() {
        this.rtspManager.closeConnection(this.connectionId);
    }

    public boolean createConnection() {
        boolean bl = true;
        try {
            this.rtspUrl = new RtspUrl(this.url);
        }
        catch (MalformedURLException malformedURLException) {
            this.processError = "Invalid RTSP URL: " + this.url;
            return false;
        }
        String string = this.getServerIpAddress();
        if (string == null) {
            Log.error("Invalid server address:" + this.url);
            this.processError = "Invalid Server adress: " + this.url;
            return false;
        }
        this.connectionId = this.rtspManager.createConnection(string, this.rtspUrl.getPort());
        if (this.connectionId < 0) {
            switch (this.connectionId) {
                case -2: {
                    this.processError = "Unknown RTSP Host!";
                    break;
                }
                case -3: {
                    this.processError = "Can't connect to RTSP Server!";
                    break;
                }
                default: {
                    this.processError = "Unknown reason";
                }
            }
            bl = false;
        }
        return bl;
    }

    public RTPManager createSessionManager(int n2) {
        RTPManager rTPManager = RTPManager.newInstance();
        if (rTPManager == null) {
            return null;
        }
        rTPManager.addReceiveStreamListener(this.parent);
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            SessionAddress sessionAddress = new SessionAddress();
            rTPManager.initialize(sessionAddress);
            this.client_ports[n2] = sessionAddress.getDataPort();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        return rTPManager;
    }

    private String getContentBase() {
        String string = "";
        try {
            ResponseMessage responseMessage = (ResponseMessage)this.message.getParameter();
            Header header = responseMessage.getResponse().getHeader(9);
            ContentBaseHeader contentBaseHeader = (ContentBaseHeader)header.parameter;
            string = contentBaseHeader.getContentBase();
        }
        catch (Exception exception) {}
        return string;
    }

    private String getCurMediaType(int n2) {
        String string = null;
        try {
            ResponseMessage responseMessage = (ResponseMessage)this.message.getParameter();
            SdpParser sdpParser = responseMessage.getResponse().sdp;
            MediaDescription mediaDescription = (MediaDescription)sdpParser.getMediaDescriptions().elementAt(n2);
            string = mediaDescription.name;
        }
        catch (Exception exception) {}
        return string;
    }

    public long getDuration() {
        return this.duration;
    }

    public static String getMediaAttribute(MediaDescription mediaDescription, String string) {
        MediaAttribute mediaAttribute;
        String string2 = "";
        if (mediaDescription != null && (mediaAttribute = mediaDescription.getMediaAttribute("control")) != null) {
            string2 = mediaAttribute.getValue();
        }
        return string2;
    }

    private String getMediaAttributeValue(int n2, String string) {
        String string2 = null;
        try {
            ResponseMessage responseMessage = (ResponseMessage)this.message.getParameter();
            SdpParser sdpParser = responseMessage.getResponse().sdp;
            MediaDescription mediaDescription = (MediaDescription)sdpParser.getMediaDescriptions().elementAt(n2);
            MediaAttribute mediaAttribute = mediaDescription.getMediaAttribute(string);
            string2 = mediaAttribute.getValue();
        }
        catch (Exception exception) {}
        return string2;
    }

    private MediaDescription getMediaDescription(String string) {
        MediaDescription mediaDescription = null;
        try {
            ResponseMessage responseMessage = (ResponseMessage)this.message.getParameter();
            SdpParser sdpParser = responseMessage.getResponse().sdp;
            mediaDescription = sdpParser.getMediaDescription(string);
        }
        catch (Exception exception) {}
        return mediaDescription;
    }

    public String getMediaType(int n2) {
        return this.mediaTypes[n2];
    }

    public String[] getMediaTypes() {
        return this.mediaTypes;
    }

    private int getNumTracks() {
        int n2 = 0;
        ResponseMessage responseMessage = (ResponseMessage)this.message.getParameter();
        SdpParser sdpParser = responseMessage.getResponse().sdp;
        if (sdpParser != null) {
            n2 = sdpParser.getMediaDescriptions().size();
        }
        return n2;
    }

    public int getNumberOfTracks() {
        return this.numberOfTracks;
    }

    public String getProcessError() {
        return this.processError;
    }

    public RTPManager getRTPManager(int n2) {
        return this.mgrs[n2];
    }

    public RTPManager[] getRTPManagers() {
        return this.mgrs;
    }

    private int getServerDataPort() {
        int n2 = -1;
        try {
            ResponseMessage responseMessage = (ResponseMessage)this.message.getParameter();
            TransportHeader transportHeader = (TransportHeader)responseMessage.getResponse().getHeader((int)1).parameter;
            n2 = transportHeader.getServerDataPort();
        }
        catch (Exception exception) {}
        return n2;
    }

    public String getServerIpAddress() {
        String string = null;
        try {
            String string2;
            if (this.rtspUrl == null) {
                this.rtspUrl = new RtspUrl(this.url);
            }
            if ((string2 = this.rtspUrl.getHost()) != null) {
                string = InetAddress.getByName(string2).getHostAddress();
            }
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (UnknownHostException unknownHostException) {}
        return string;
    }

    public int[] getServerPorts() {
        return this.server_ports;
    }

    private String getSessionId() {
        String string = null;
        try {
            ResponseMessage responseMessage = (ResponseMessage)this.message.getParameter();
            SessionHeader sessionHeader = (SessionHeader)responseMessage.getResponse().getHeader((int)3).parameter;
            string = sessionHeader.getSessionId();
        }
        catch (Exception exception) {}
        return string;
    }

    public int getStatusCode() {
        int n2 = -1;
        try {
            ResponseMessage responseMessage = (ResponseMessage)this.message.getParameter();
            n2 = responseMessage.getResponse().getStatusLine().getCode();
        }
        catch (Exception exception) {}
        return n2;
    }

    private String getStatusText(int n2) {
        return StatusCode.getStatusText(n2);
    }

    private String getTrackID(String string) {
        String string2 = null;
        try {
            ResponseMessage responseMessage = (ResponseMessage)this.message.getParameter();
            SdpParser sdpParser = responseMessage.getResponse().sdp;
            MediaDescription mediaDescription = sdpParser.getMediaDescription(string);
            MediaAttribute mediaAttribute = mediaDescription.getMediaAttribute("control");
            string2 = mediaAttribute.getValue();
        }
        catch (Exception exception) {}
        return string2;
    }

    private void processRtspRequest(int n2, Message message) {
        if (message.getType() == 4) {
            OptionsMessage optionsMessage = (OptionsMessage)message.getParameter();
            this.sendResponse(n2, optionsMessage.getRequest());
        }
    }

    private void processRtspResponse(int n2, Message message) {
        this.message = message;
        this.responseReceived = true;
        Object object = this.responseSync;
        synchronized (object) {
            this.responseSync.notify();
        }
    }

    public void removeListener(RtspAppListener rtspAppListener) {
        this.listeners.removeElement(rtspAppListener);
    }

    public void removeTrack(int n2) {
        Log.comment("track removed: " + this.mediaTypes[n2]);
        this.mgrs[n2].removeTargets("media track not supported");
        this.mgrs[n2].dispose();
        --this.numberOfTracks;
        if (n2 + 1 > this.mgrs.length) {
            int n3 = this.mgrs.length - n2 - 1;
            System.arraycopy(this.mgrs, n2 + 1, this.mgrs, n2, n3);
        }
    }

    private boolean responseOk() {
        boolean bl = false;
        int n2 = this.getStatusCode();
        if (n2 == 200) {
            bl = true;
        } else {
            this.processError = "Message from RTSP Server - " + this.getStatusText(n2);
        }
        return bl;
    }

    public void rtspConnectionTerminated(int n2) {
    }

    public void rtspMessageIndication(int n2, Message message) {
        if (message.getType() == 12) {
            this.processRtspResponse(n2, message);
        } else {
            this.processRtspRequest(n2, message);
        }
    }

    public boolean rtspSetup() {
        String string = "DESCRIBE rtsp://" + this.rtspUrl.getHost() + "/" + this.rtspUrl.getFile() + " RTSP/1.0\r\n" + "CSeq: " + this.sequenceNumber + "\r\n" + "Accept: application/sdp\r\n" + this.userAgent + "\r\n\r\n";
        this.sendMessage(string);
        boolean bl = this.waitForResponse(60000);
        if (bl) {
            this.sendStatusMessage(3, "Timeout received.");
            return false;
        }
        if (!this.responseOk()) {
            return false;
        }
        this.setDuration();
        this.numberOfTracks = this.getNumTracks();
        this.client_ports = new int[this.numberOfTracks];
        this.mgrs = new RTPManager[this.numberOfTracks];
        this.mediaControls = new String[this.numberOfTracks];
        this.mediaTypes = new String[this.numberOfTracks];
        String[] stringArray = new String[this.numberOfTracks];
        int n2 = 0;
        while (n2 < this.numberOfTracks) {
            this.mgrs[n2] = this.createSessionManager(n2);
            this.mediaTypes[n2] = this.getCurMediaType(n2);
            this.mediaControls[n2] = this.getMediaAttributeValue(n2, "control");
            stringArray[n2] = this.getMediaAttributeValue(n2, "rtpmap");
            if (this.mediaTypes[n2] != null && stringArray[n2] != null) {
                this.addDynamicPayload(this.mgrs[n2], this.mediaTypes[n2], stringArray[n2]);
            }
            ++n2;
        }
        String string2 = this.getContentBase();
        this.session_ids = new String[this.numberOfTracks];
        this.server_ports = new int[this.numberOfTracks];
        int n3 = 0;
        while (n3 < this.numberOfTracks) {
            int n4;
            string = n3 == 0 ? "SETUP " + string2 + this.mediaControls[n3] + " RTSP/1.0\r\n" + "CSeq: " + this.sequenceNumber + "\r\n" + "Transport: RTP/AVP;unicast;client_port=" + this.client_ports[n3] + "-" + (this.client_ports[n3] + 1) + "\r\n" + this.userAgent + "\r\n\r\n" : "SETUP " + string2 + this.mediaControls[n3] + " RTSP/1.0\r\n" + "CSeq: " + this.sequenceNumber + "\r\n" + "Transport: RTP/AVP;unicast;client_port=" + this.client_ports[n3] + "-" + (this.client_ports[n3] + 1) + "\r\n" + "Session: " + this.session_ids[0] + "\r\n" + this.userAgent + "\r\n\r\n";
            this.sendMessage(string);
            bl = this.waitForResponse(30000);
            if (bl) {
                Log.error("ERROR: Timeout received (1).");
                this.processError = "Server is not responding";
                return false;
            }
            if (!this.responseOk()) {
                return false;
            }
            String string3 = this.getSessionId();
            if (string3 == null) {
                this.processError = "Invalid session ID";
                return false;
            }
            this.session_ids[n3] = string3;
            int n5 = this.session_ids[n3].indexOf(59);
            if (n5 > 0) {
                this.session_ids[n3] = this.session_ids[n3].substring(0, n5);
            }
            if ((n4 = this.getServerDataPort()) == -1) {
                this.processError = "Invalid server data port";
                return false;
            }
            this.server_ports[n3] = n4;
            ++n3;
        }
        return true;
    }

    public boolean rtspStart() {
        String string = "PLAY rtsp://" + this.rtspUrl.getHost() + "/" + this.rtspUrl.getFile() + " RTSP/1.0\r\n" + "CSeq: " + this.sequenceNumber + "\r\n" + "Range: npt=" + this.startPos / 1.0E9 + "-\r\n" + "Session: " + this.session_ids[0] + "\r\n" + this.userAgent + "\r\n\r\n";
        this.sendMessage(string);
        boolean bl = this.waitForResponse(30000);
        if (bl) {
            this.processError = "Server is not responding";
            return false;
        }
        int n2 = this.getStatusCode();
        if (n2 == -1) {
            this.processError = "Received invalid status code";
            return false;
        }
        if (this.getStatusCode() == 454) {
            int n3 = 0;
            if (n3 < this.numberOfTracks) {
                this.mgrs[n3].removeTargets("session not found");
                this.mgrs[n3].dispose();
                return false;
            }
        }
        return true;
    }

    public void rtspStop() {
        String string = "PAUSE rtsp://" + this.rtspUrl.getHost() + "/" + this.rtspUrl.getFile() + " RTSP/1.0\r\n" + "CSeq: " + this.sequenceNumber + "\r\n" + "Session: " + this.session_ids[0] + "\r\n" + this.userAgent + "\r\n\r\n";
        this.sendMessage(string);
        boolean bl = this.waitForResponse(30000);
        if (bl) {
            this.sendStatusMessage(3, "Timeout received.");
            return;
        }
    }

    public void rtspTeardown() {
        String string = "TEARDOWN rtsp://" + this.rtspUrl.getHost() + "/" + this.rtspUrl.getFile() + " RTSP/1.0\r\n" + "CSeq: " + this.sequenceNumber + "\r\n" + "Session: " + this.session_ids[0] + "\r\n" + this.userAgent + "\r\n\r\n";
        this.sendMessage(string);
        boolean bl = this.waitForResponse(30000);
        if (bl) {
            this.sendStatusMessage(3, "Timeout received.");
            return;
        }
    }

    private void sendMessage(String string) {
        this.responseReceived = false;
        boolean bl = this.rtspManager.sendMessage(this.connectionId, string);
        if (!bl) {
            String string2 = this.getServerIpAddress();
            this.connectionId = this.rtspManager.createConnection(string2, this.rtspUrl.getPort());
            this.rtspManager.sendMessage(this.connectionId, string);
        }
    }

    private void sendResponse(int n2, Request request) {
        Object var3_3 = null;
        Header header = request.getHeader(2);
        if (header != null) {
            CSeqHeader cSeqHeader = (CSeqHeader)header.parameter;
            String string = "RTSP/1.0 200 OK\r\nCSeq: " + cSeqHeader.getSequenceNumber() + "\r\n\r\n";
            this.sendMessage(string);
        }
    }

    private void sendStatusMessage(int n2, String string) {
        int n3 = 0;
        while (n3 < this.listeners.size()) {
            ((RtspAppListener)this.listeners.elementAt(n3)).postStatusMessage(n2, string);
            ++n3;
        }
    }

    private void setDuration() {
        String string;
        MediaAttribute mediaAttribute;
        this.duration = 0L;
        ResponseMessage responseMessage = (ResponseMessage)this.message.getParameter();
        double d2 = 0.0;
        double d3 = 0.0;
        SdpParser sdpParser = responseMessage.getResponse().sdp;
        if (sdpParser != null && (mediaAttribute = sdpParser.getSessionAttribute("range")) != null && (string = mediaAttribute.getValue()).startsWith("npt")) {
            int n2 = string.indexOf(61) + 1;
            int n3 = string.indexOf(45);
            String string2 = string.substring(n2, n3).trim();
            String string3 = string.substring(n3 + 1).trim();
            d3 = new Double(string3);
            this.duration = (long)(d3 * 1.0E9);
        }
    }

    public void setProcessError(String string) {
        this.processError = string;
    }

    public void setStartPos(double d2) {
        this.startPos = d2;
    }

    public void setUrl(String string) {
        this.url = string;
    }

    private synchronized boolean waitForResponse(int n2) {
        boolean bl = false;
        try {
            Object object = this.responseSync;
            synchronized (object) {
                if (!this.responseReceived) {
                    this.responseSync.wait(n2);
                }
                if (this.responseReceived) {
                    ++this.sequenceNumber;
                } else {
                    bl = true;
                }
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        return bl;
    }
}

