/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtp;

import com.sun.media.rtp.PassiveSSRCInfo;
import com.sun.media.rtp.RTCPAPPPacket;
import com.sun.media.rtp.RTCPBYEPacket;
import com.sun.media.rtp.RTCPCompoundPacket;
import com.sun.media.rtp.RTCPPacket;
import com.sun.media.rtp.RTCPRRPacket;
import com.sun.media.rtp.RTCPRawReceiver;
import com.sun.media.rtp.RTCPReportBlock;
import com.sun.media.rtp.RTCPSDES;
import com.sun.media.rtp.RTCPSDESPacket;
import com.sun.media.rtp.RTCPSRPacket;
import com.sun.media.rtp.RTPSourceInfo;
import com.sun.media.rtp.RecvSSRCInfo;
import com.sun.media.rtp.SSRCCache;
import com.sun.media.rtp.SSRCInfo;
import com.sun.media.rtp.StreamSynch;
import com.sun.media.rtp.util.Packet;
import com.sun.media.rtp.util.PacketConsumer;
import com.sun.media.rtp.util.PacketForwarder;
import com.sun.media.rtp.util.PacketSource;
import com.sun.media.rtp.util.UDPPacket;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.media.rtp.ReceiveStream;
import javax.media.rtp.SessionManager;
import javax.media.rtp.event.ActiveReceiveStreamEvent;
import javax.media.rtp.event.ApplicationEvent;
import javax.media.rtp.event.ByeEvent;
import javax.media.rtp.event.NewParticipantEvent;
import javax.media.rtp.event.RTPEvent;
import javax.media.rtp.event.ReceiveStreamEvent;
import javax.media.rtp.event.ReceiverReportEvent;
import javax.media.rtp.event.SenderReportEvent;
import javax.media.rtp.event.StreamMappedEvent;
import javax.media.rtp.rtcp.ReceiverReport;
import javax.media.rtp.rtcp.SenderReport;

public class RTCPReceiver
implements PacketConsumer {
    private static final int SR = 1;
    private static final int RR = 2;
    private boolean rtcpstarted = false;
    private boolean sentrecvstrmap = false;
    SSRCCache cache;
    private int type = 0;

    public RTCPReceiver(SSRCCache sSRCCache) {
        this.cache = sSRCCache;
        SSRCInfo sSRCInfo = sSRCCache.lookup(sSRCCache.ourssrc.ssrc);
    }

    public RTCPReceiver(SSRCCache sSRCCache, PacketSource packetSource) {
        this(sSRCCache);
        PacketForwarder packetForwarder = new PacketForwarder(packetSource, this);
        packetForwarder.startPF();
    }

    public RTCPReceiver(SSRCCache sSRCCache, DatagramSocket datagramSocket, StreamSynch streamSynch) {
        this(sSRCCache, new RTCPRawReceiver(datagramSocket, sSRCCache.sm.defaultstats, streamSynch));
    }

    public RTCPReceiver(SSRCCache sSRCCache, int n2, String string, StreamSynch streamSynch) throws UnknownHostException, IOException {
        this(sSRCCache, new RTCPRawReceiver(n2 | 1, string, sSRCCache.sm.defaultstats, streamSynch));
    }

    public String consumerString() {
        return "RTCP Packet Receiver/Collector";
    }

    public void closeConsumer() {
    }

    public void sendTo(Packet packet) {
        this.sendTo((RTCPPacket)packet);
    }

    public void sendTo(RTCPPacket rTCPPacket) {
        Object object;
        int n2;
        Object object2;
        SSRCInfo sSRCInfo = null;
        boolean bl = this.cache.sm.isUnicast();
        if (bl) {
            if (!this.rtcpstarted) {
                this.cache.sm.startRTCPReports(((UDPPacket)rTCPPacket.base).remoteAddress);
                this.rtcpstarted = true;
                object2 = this.cache.sm.controladdress.getAddress();
                n2 = object2[3] & 0xFF;
                if ((n2 & 0xFF) == 255) {
                    this.cache.sm.addUnicastAddr(this.cache.sm.controladdress);
                } else {
                    object = null;
                    boolean bl2 = true;
                    try {
                        object = InetAddress.getLocalHost();
                    }
                    catch (UnknownHostException unknownHostException) {
                        bl2 = false;
                    }
                    if (bl2) {
                        this.cache.sm.addUnicastAddr((InetAddress)object);
                    }
                }
            } else if (!this.cache.sm.isSenderDefaultAddr(((UDPPacket)rTCPPacket.base).remoteAddress)) {
                this.cache.sm.addUnicastAddr(((UDPPacket)rTCPPacket.base).remoteAddress);
            }
        }
        switch (rTCPPacket.type) {
            case -1: {
                object2 = (RTCPCompoundPacket)rTCPPacket;
                this.cache.updateavgrtcpsize(((Packet)object2).length);
                n2 = 0;
                while (n2 < ((RTCPCompoundPacket)object2).packets.length) {
                    this.sendTo(((RTCPCompoundPacket)object2).packets[n2]);
                    ++n2;
                }
                if (this.cache.sm.cleaner == null) break;
                this.cache.sm.cleaner.setClean();
                break;
            }
            case 200: {
                RTPEvent rTPEvent;
                object = (RTCPSRPacket)rTCPPacket;
                this.type = 1;
                sSRCInfo = rTCPPacket.base instanceof UDPPacket ? this.cache.get(((RTCPSRPacket)object).ssrc, ((UDPPacket)rTCPPacket.base).remoteAddress, ((UDPPacket)rTCPPacket.base).remotePort, 1) : this.cache.get(((RTCPSRPacket)object).ssrc, null, 0, 1);
                if (sSRCInfo == null) break;
                sSRCInfo.setAlive(true);
                sSRCInfo.lastSRntptimestamp = (((RTCPSRPacket)object).ntptimestampmsw << 32) + ((RTCPSRPacket)object).ntptimestamplsw;
                sSRCInfo.lastSRrtptimestamp = ((RTCPSRPacket)object).rtptimestamp;
                sSRCInfo.lastSRreceiptTime = ((Packet)object).receiptTime;
                sSRCInfo.lastRTCPreceiptTime = ((Packet)object).receiptTime;
                sSRCInfo.lastHeardFrom = ((Packet)object).receiptTime;
                if (sSRCInfo.quiet) {
                    sSRCInfo.quiet = false;
                    ActiveReceiveStreamEvent activeReceiveStreamEvent = null;
                    activeReceiveStreamEvent = sSRCInfo instanceof ReceiveStream ? new ActiveReceiveStreamEvent((SessionManager)this.cache.sm, sSRCInfo.sourceInfo, (ReceiveStream)((Object)sSRCInfo)) : new ActiveReceiveStreamEvent((SessionManager)this.cache.sm, sSRCInfo.sourceInfo, null);
                    this.cache.eventhandler.postEvent(activeReceiveStreamEvent);
                }
                sSRCInfo.lastSRpacketcount = ((RTCPSRPacket)object).packetcount;
                sSRCInfo.lastSRoctetcount = ((RTCPSRPacket)object).octetcount;
                int n3 = 0;
                while (n3 < ((RTCPSRPacket)object).reports.length) {
                    ((RTCPSRPacket)object).reports[n3].receiptTime = ((Packet)object).receiptTime;
                    int n4 = ((RTCPSRPacket)object).reports[n3].ssrc;
                    RTCPReportBlock[] rTCPReportBlockArray = (RTCPReportBlock[])sSRCInfo.reports.get(n4);
                    if (rTCPReportBlockArray == null) {
                        rTCPReportBlockArray = new RTCPReportBlock[2];
                        rTCPReportBlockArray[0] = ((RTCPSRPacket)object).reports[n3];
                        sSRCInfo.reports.put(n4, rTCPReportBlockArray);
                    } else {
                        rTCPReportBlockArray[1] = rTCPReportBlockArray[0];
                        rTCPReportBlockArray[0] = ((RTCPSRPacket)object).reports[n3];
                    }
                    ++n3;
                }
                if (sSRCInfo.probation > 0) break;
                if (!sSRCInfo.newpartsent && sSRCInfo.sourceInfo != null) {
                    rTPEvent = new NewParticipantEvent(this.cache.sm, sSRCInfo.sourceInfo);
                    this.cache.eventhandler.postEvent(rTPEvent);
                    sSRCInfo.newpartsent = true;
                }
                if (!sSRCInfo.recvstrmap && sSRCInfo.sourceInfo != null) {
                    sSRCInfo.recvstrmap = true;
                    rTPEvent = new StreamMappedEvent(this.cache.sm, (ReceiveStream)((Object)sSRCInfo), sSRCInfo.sourceInfo);
                    this.cache.eventhandler.postEvent(rTPEvent);
                }
                rTPEvent = new SenderReportEvent(this.cache.sm, (SenderReport)((Object)sSRCInfo));
                this.cache.eventhandler.postEvent(rTPEvent);
                break;
            }
            case 201: {
                RTCPRRPacket rTCPRRPacket = (RTCPRRPacket)rTCPPacket;
                this.type = 2;
                sSRCInfo = rTCPPacket.base instanceof UDPPacket ? this.cache.get(rTCPRRPacket.ssrc, ((UDPPacket)rTCPPacket.base).remoteAddress, ((UDPPacket)rTCPPacket.base).remotePort, 2) : this.cache.get(rTCPRRPacket.ssrc, null, 0, 2);
                if (sSRCInfo == null) break;
                sSRCInfo.setAlive(true);
                sSRCInfo.lastRTCPreceiptTime = rTCPRRPacket.receiptTime;
                sSRCInfo.lastHeardFrom = rTCPRRPacket.receiptTime;
                if (sSRCInfo.quiet) {
                    sSRCInfo.quiet = false;
                    ActiveReceiveStreamEvent activeReceiveStreamEvent = null;
                    activeReceiveStreamEvent = sSRCInfo instanceof ReceiveStream ? new ActiveReceiveStreamEvent((SessionManager)this.cache.sm, sSRCInfo.sourceInfo, (ReceiveStream)((Object)sSRCInfo)) : new ActiveReceiveStreamEvent((SessionManager)this.cache.sm, sSRCInfo.sourceInfo, null);
                    this.cache.eventhandler.postEvent(activeReceiveStreamEvent);
                }
                int n5 = 0;
                while (n5 < rTCPRRPacket.reports.length) {
                    rTCPRRPacket.reports[n5].receiptTime = rTCPRRPacket.receiptTime;
                    int n6 = rTCPRRPacket.reports[n5].ssrc;
                    RTCPReportBlock[] rTCPReportBlockArray = (RTCPReportBlock[])sSRCInfo.reports.get(n6);
                    if (rTCPReportBlockArray == null) {
                        rTCPReportBlockArray = new RTCPReportBlock[2];
                        rTCPReportBlockArray[0] = rTCPRRPacket.reports[n5];
                        sSRCInfo.reports.put(n6, rTCPReportBlockArray);
                    } else {
                        rTCPReportBlockArray[1] = rTCPReportBlockArray[0];
                        rTCPReportBlockArray[0] = rTCPRRPacket.reports[n5];
                    }
                    ++n5;
                }
                if (!sSRCInfo.newpartsent && sSRCInfo.sourceInfo != null) {
                    NewParticipantEvent newParticipantEvent = new NewParticipantEvent(this.cache.sm, sSRCInfo.sourceInfo);
                    this.cache.eventhandler.postEvent(newParticipantEvent);
                    sSRCInfo.newpartsent = true;
                }
                ReceiverReportEvent receiverReportEvent = new ReceiverReportEvent(this.cache.sm, (ReceiverReport)((Object)sSRCInfo));
                this.cache.eventhandler.postEvent(receiverReportEvent);
                break;
            }
            case 202: {
                Object object3;
                RTCPSDESPacket rTCPSDESPacket = (RTCPSDESPacket)rTCPPacket;
                int n7 = 0;
                while (n7 < rTCPSDESPacket.sdes.length) {
                    object3 = rTCPSDESPacket.sdes[n7];
                    if (this.type == 1) {
                        sSRCInfo = rTCPPacket.base instanceof UDPPacket ? this.cache.get(((RTCPSDES)object3).ssrc, ((UDPPacket)rTCPPacket.base).remoteAddress, ((UDPPacket)rTCPPacket.base).remotePort, 1) : this.cache.get(((RTCPSDES)object3).ssrc, null, 0, 1);
                    }
                    if (this.type == 2) {
                        sSRCInfo = rTCPPacket.base instanceof UDPPacket ? this.cache.get(((RTCPSDES)object3).ssrc, ((UDPPacket)rTCPPacket.base).remoteAddress, ((UDPPacket)rTCPPacket.base).remotePort, 2) : this.cache.get(((RTCPSDES)object3).ssrc, null, 0, 2);
                    }
                    if (sSRCInfo == null) break;
                    sSRCInfo.setAlive(true);
                    sSRCInfo.lastHeardFrom = rTCPSDESPacket.receiptTime;
                    sSRCInfo.addSDESInfo((RTCPSDES)object3);
                    ++n7;
                }
                if (sSRCInfo != null && !sSRCInfo.newpartsent && sSRCInfo.sourceInfo != null) {
                    object3 = new NewParticipantEvent(this.cache.sm, sSRCInfo.sourceInfo);
                    this.cache.eventhandler.postEvent((RTPEvent)object3);
                    sSRCInfo.newpartsent = true;
                }
                if (sSRCInfo != null && !sSRCInfo.recvstrmap && sSRCInfo.sourceInfo != null && sSRCInfo instanceof RecvSSRCInfo) {
                    sSRCInfo.recvstrmap = true;
                    object3 = new StreamMappedEvent(this.cache.sm, (ReceiveStream)((Object)sSRCInfo), sSRCInfo.sourceInfo);
                    this.cache.eventhandler.postEvent((RTPEvent)object3);
                }
                this.type = 0;
                break;
            }
            case 203: {
                RTCPBYEPacket rTCPBYEPacket = (RTCPBYEPacket)rTCPPacket;
                sSRCInfo = rTCPPacket.base instanceof UDPPacket ? this.cache.get(rTCPBYEPacket.ssrc[0], ((UDPPacket)rTCPPacket.base).remoteAddress, ((UDPPacket)rTCPPacket.base).remotePort) : this.cache.get(rTCPBYEPacket.ssrc[0], null, 0);
                int n8 = 0;
                while (n8 < rTCPBYEPacket.ssrc.length) {
                    sSRCInfo = rTCPPacket.base instanceof UDPPacket ? this.cache.get(rTCPBYEPacket.ssrc[n8], ((UDPPacket)rTCPPacket.base).remoteAddress, ((UDPPacket)rTCPPacket.base).remotePort) : this.cache.get(rTCPBYEPacket.ssrc[n8], null, 0);
                    if (sSRCInfo == null) break;
                    if (!this.cache.byestate) {
                        sSRCInfo.setAlive(false);
                        sSRCInfo.byeReceived = true;
                        sSRCInfo.byeTime = rTCPPacket.receiptTime;
                        sSRCInfo.lastHeardFrom = rTCPBYEPacket.receiptTime;
                    }
                    ++n8;
                }
                if (sSRCInfo == null) break;
                if (sSRCInfo.quiet) {
                    sSRCInfo.quiet = false;
                    ActiveReceiveStreamEvent activeReceiveStreamEvent = null;
                    activeReceiveStreamEvent = sSRCInfo instanceof ReceiveStream ? new ActiveReceiveStreamEvent((SessionManager)this.cache.sm, sSRCInfo.sourceInfo, (ReceiveStream)((Object)sSRCInfo)) : new ActiveReceiveStreamEvent((SessionManager)this.cache.sm, sSRCInfo.sourceInfo, null);
                    this.cache.eventhandler.postEvent(activeReceiveStreamEvent);
                }
                sSRCInfo.byereason = new String(rTCPBYEPacket.reason);
                if (sSRCInfo.byeReceived) break;
                boolean bl3 = false;
                RTPSourceInfo rTPSourceInfo = sSRCInfo.sourceInfo;
                if (rTPSourceInfo != null && rTPSourceInfo.getStreamCount() == 0) {
                    bl3 = true;
                }
                ByeEvent byeEvent = null;
                if (sSRCInfo instanceof RecvSSRCInfo) {
                    byeEvent = new ByeEvent(this.cache.sm, sSRCInfo.sourceInfo, (ReceiveStream)((Object)sSRCInfo), new String(rTCPBYEPacket.reason), bl3);
                }
                if (sSRCInfo instanceof PassiveSSRCInfo) {
                    byeEvent = new ByeEvent(this.cache.sm, sSRCInfo.sourceInfo, null, new String(rTCPBYEPacket.reason), bl3);
                }
                this.cache.eventhandler.postEvent(byeEvent);
                break;
            }
            case 204: {
                ReceiveStreamEvent receiveStreamEvent;
                RTCPAPPPacket rTCPAPPPacket = (RTCPAPPPacket)rTCPPacket;
                sSRCInfo = rTCPPacket.base instanceof UDPPacket ? this.cache.get(rTCPAPPPacket.ssrc, ((UDPPacket)rTCPPacket.base).remoteAddress, ((UDPPacket)rTCPPacket.base).remotePort) : this.cache.get(rTCPAPPPacket.ssrc, null, 0);
                if (sSRCInfo == null) break;
                sSRCInfo.lastHeardFrom = rTCPAPPPacket.receiptTime;
                if (sSRCInfo.quiet) {
                    sSRCInfo.quiet = false;
                    receiveStreamEvent = null;
                    receiveStreamEvent = sSRCInfo instanceof ReceiveStream ? new ActiveReceiveStreamEvent((SessionManager)this.cache.sm, sSRCInfo.sourceInfo, (ReceiveStream)((Object)sSRCInfo)) : new ActiveReceiveStreamEvent((SessionManager)this.cache.sm, sSRCInfo.sourceInfo, null);
                    this.cache.eventhandler.postEvent(receiveStreamEvent);
                }
                receiveStreamEvent = null;
                if (sSRCInfo instanceof RecvSSRCInfo) {
                    receiveStreamEvent = new ApplicationEvent(this.cache.sm, sSRCInfo.sourceInfo, (ReceiveStream)((Object)sSRCInfo), rTCPAPPPacket.subtype, null, rTCPAPPPacket.data);
                }
                if (sSRCInfo instanceof PassiveSSRCInfo) {
                    receiveStreamEvent = new ApplicationEvent(this.cache.sm, sSRCInfo.sourceInfo, null, rTCPAPPPacket.subtype, null, rTCPAPPPacket.data);
                }
                this.cache.eventhandler.postEvent(receiveStreamEvent);
            }
        }
    }
}

