/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.util;

import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import com.sun.media.JMFSecurity;
import com.sun.media.JMFSecurityManager;
import com.sun.media.util.jdk12;
import com.sun.media.util.jdk12PropertyAction;
import com.sun.media.util.jdk12ReadFileAction;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.media.Format;

public class Registry {
    private static Hashtable hash;
    private static String filename;
    private static final int versionNumber = 200;
    private static boolean securityPrivelege;
    private static JMFSecurity jmfSecurity;
    private static Method[] m;
    private static Class[] cl;
    private static Object[][] args;
    private static final String CLASSPATH = "java.class.path";
    private static String classpath;
    private static boolean jdkInit;
    private static Method forName3ArgsM;
    private static Method getSystemClassLoaderM;
    private static ClassLoader systemClassLoader;
    private static Method getContextClassLoaderM;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$java$lang$Thread;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Boolean;

    private static String getJMFDir() {
        try {
            String string;
            if (File.separator.equals("/")) {
                string = System.getProperty("user.home", null);
            } else {
                JMFSecurityManager.loadLibrary("jmutil");
                string = Registry.nGetUserHome() + File.separator + "java";
            }
            string = string + File.separator + ".jmfdir";
            File file = new File(string);
            if (file.exists()) {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                String string2 = bufferedReader.readLine();
                bufferedReader.close();
                return string2;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private static native String nGetUserHome();

    public static final synchronized boolean set(String string, Object object) {
        if (string != null && object != null) {
            if (jmfSecurity != null && string.indexOf("secure.") == 0) {
                return false;
            }
            hash.put(string, object);
            return true;
        }
        return false;
    }

    public static final synchronized Object get(String string) {
        if (string != null) {
            return hash.get(string);
        }
        return null;
    }

    public static final synchronized boolean remove(String string) {
        if (string != null && hash.containsKey(string)) {
            hash.remove(string);
            return true;
        }
        return false;
    }

    public static final synchronized void removeGroup(String string) {
        Vector<String> vector = new Vector<String>();
        if (string != null) {
            Enumeration enumeration = hash.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                if (!string2.startsWith(string)) continue;
                vector.addElement(string2);
            }
        }
        int n2 = 0;
        while (n2 < vector.size()) {
            hash.remove(vector.elementAt(n2));
            ++n2;
        }
    }

    public static final synchronized boolean commit() throws IOException {
        if (jmfSecurity != null) {
            throw new SecurityException("commit: Permission denied");
        }
        if (filename == null) {
            throw new IOException("Can't find registry file");
        }
        FileOutputStream fileOutputStream = new FileOutputStream(filename);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
        int n2 = hash.size();
        objectOutputStream.writeInt(n2);
        objectOutputStream.writeInt(200);
        Enumeration enumeration = hash.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object v = hash.get(string);
            objectOutputStream.writeUTF(string);
            objectOutputStream.writeObject(v);
            objectOutputStream.flush();
        }
        objectOutputStream.close();
        return true;
    }

    private static final synchronized InputStream findJMFPropertiesFile() {
        StringTokenizer stringTokenizer = new StringTokenizer(classpath, File.pathSeparator);
        String string = "jmf.properties";
        File file = null;
        FileInputStream fileInputStream = null;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            String string3 = string2.toUpperCase();
            try {
                if (string3.indexOf(".ZIP") > 0 || string3.indexOf(".JAR") > 0) {
                    int n2 = string2.lastIndexOf(File.separator);
                    if (n2 == -1 && !File.separator.equals("/")) {
                        n2 = string2.lastIndexOf("/");
                    }
                    string2 = n2 == -1 ? ((n2 = string2.lastIndexOf(":")) == -1 ? string : string2.substring(0, n2) + ":" + string) : string2.substring(0, n2) + File.separator + string;
                } else {
                    string2 = string2 + File.separator + string;
                }
            }
            catch (Exception exception) {
                string2 = string2 + File.separator + string;
            }
            try {
                file = new File(string2);
                fileInputStream = Registry.getRegistryStream(file);
                if (fileInputStream == null) continue;
                filename = string2;
                break;
            }
            catch (Throwable throwable) {
                filename = null;
                return null;
            }
        }
        try {
            if (filename == null || file == null) {
                return null;
            }
        }
        catch (Throwable throwable) {
            return null;
        }
        return fileInputStream;
    }

    private static FileInputStream getRegistryStream(File file) throws IOException {
        try {
            if (jmfSecurity != null && jmfSecurity.getName().startsWith("jdk12")) {
                Constructor constructor = jdk12ReadFileAction.cons;
                return (FileInputStream)jdk12.doPrivM.invoke((Object)jdk12.ac, constructor.newInstance(file.getPath()));
            }
            if (!file.exists()) {
                return null;
            }
            return new FileInputStream(file.getPath());
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static final synchronized boolean readRegistry(InputStream inputStream) {
        try {
            Object object;
            if (inputStream == null) {
                try {
                    Class<?> clazz = Class.forName("com.sun.media.util.RegistryLib");
                    object = (byte[])clazz.getMethod("getData", null).invoke(clazz, null);
                }
                catch (Exception exception) {
                    return false;
                }
                if (object == null) {
                    return false;
                }
                inputStream = new ByteArrayInputStream((byte[])object);
            }
            object = new ObjectInputStream(inputStream);
            int n2 = ((ObjectInputStream)object).readInt();
            int n3 = ((ObjectInputStream)object).readInt();
            if (n3 > 200) {
                System.err.println("Version number mismatch.\nThere could be errors in reading the registry");
            }
            hash = new Hashtable();
            int n4 = 0;
            while (n4 < n2) {
                String string = ((ObjectInputStream)object).readUTF();
                boolean bl = false;
                try {
                    Object object2 = ((ObjectInputStream)object).readObject();
                    hash.put(string, object2);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    bl = true;
                }
                catch (OptionalDataException optionalDataException) {
                    bl = true;
                }
                ++n4;
            }
            ((ObjectInputStream)object).close();
            inputStream.close();
        }
        catch (IOException iOException) {
            System.err.println("IOException in readRegistry: " + iOException);
        }
        finally {
            return false;
        }
        return true;
    }

    private static boolean checkIfJDK12() {
        if (jdkInit) {
            return forName3ArgsM != null;
        }
        jdkInit = true;
        try {
            forName3ArgsM = (class$java$lang$Class == null ? (class$java$lang$Class = Registry.class$("java.lang.Class")) : class$java$lang$Class).getMethod("forName", class$java$lang$String == null ? (class$java$lang$String = Registry.class$("java.lang.String")) : class$java$lang$String, Boolean.TYPE, class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = Registry.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader);
            getSystemClassLoaderM = (class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = Registry.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader).getMethod("getSystemClassLoader", null);
            systemClassLoader = (ClassLoader)getSystemClassLoaderM.invoke((Object)(class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = Registry.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader), null);
            getContextClassLoaderM = (class$java$lang$Thread == null ? (class$java$lang$Thread = Registry.class$("java.lang.Thread")) : class$java$lang$Thread).getMethod("getContextClassLoader", null);
            return true;
        }
        catch (Throwable throwable) {
            forName3ArgsM = null;
            return false;
        }
    }

    static Class getClassForName(String string) throws ClassNotFoundException {
        block9: {
            try {
                return Class.forName(string);
            }
            catch (Exception exception) {
                if (!Registry.checkIfJDK12()) {
                    throw new ClassNotFoundException(exception.getMessage());
                }
            }
            catch (Error error) {
                if (Registry.checkIfJDK12()) break block9;
                throw error;
            }
        }
        try {
            return (Class)forName3ArgsM.invoke((Object)(class$java$lang$Class == null ? (class$java$lang$Class = Registry.class$("java.lang.Class")) : class$java$lang$Class), string, new Boolean(true), systemClassLoader);
        }
        catch (Throwable throwable) {
            try {
                ClassLoader classLoader = (ClassLoader)getContextClassLoaderM.invoke((Object)Thread.currentThread(), null);
                return (Class)forName3ArgsM.invoke((Object)(class$java$lang$Class == null ? (class$java$lang$Class = Registry.class$("java.lang.Class")) : class$java$lang$Class), string, new Boolean(true), classLoader);
            }
            catch (Exception exception) {
                throw new ClassNotFoundException(exception.getMessage());
            }
            catch (Error error) {
                throw error;
            }
        }
    }

    public static void main(String[] stringArray) {
        Format format = new Format("crap", class$java$lang$Integer == null ? (class$java$lang$Integer = Registry.class$("java.lang.Integer")) : class$java$lang$Integer);
        Integer n2 = new Integer(5);
        try {
            Class<?> clazz = Class.forName("javax.media.format.H261Format");
            n2 = clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("H261Format not found in main()");
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        Format format2 = new Format("crap2", class$java$lang$Boolean == null ? (class$java$lang$Boolean = Registry.class$("java.lang.Boolean")) : class$java$lang$Boolean);
        Registry.set("obj1", format);
        Registry.set("obj2", n2);
        Registry.set("obj3", format2);
        try {
            Registry.commit();
        }
        catch (IOException iOException) {
            System.err.println("main: IO error in commit " + iOException);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Object object;
        hash = null;
        filename = null;
        securityPrivelege = false;
        jmfSecurity = null;
        m = new Method[1];
        cl = new Class[1];
        args = new Object[1][0];
        classpath = null;
        jdkInit = false;
        hash = new Hashtable();
        try {
            jmfSecurity = JMFSecurityManager.getJMFSecurity();
            securityPrivelege = true;
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (jmfSecurity != null) {
            object = null;
            try {
                if (jmfSecurity.getName().startsWith("jmf-security")) {
                    object = "read property";
                    jmfSecurity.requestPermission(m, cl, args, 1);
                    m[0].invoke((Object)cl[0], args[0]);
                    object = "read file";
                    jmfSecurity.requestPermission(m, cl, args, 2);
                    m[0].invoke((Object)cl[0], args[0]);
                } else if (jmfSecurity.getName().startsWith("internet")) {
                    PolicyEngine.checkPermission((PermissionID)PermissionID.PROPERTY);
                    PolicyEngine.checkPermission((PermissionID)PermissionID.FILEIO);
                    PolicyEngine.assertPermission((PermissionID)PermissionID.PROPERTY);
                    PolicyEngine.assertPermission((PermissionID)PermissionID.FILEIO);
                }
            }
            catch (Throwable throwable) {
                securityPrivelege = false;
            }
        }
        if (jmfSecurity != null && jmfSecurity.getName().startsWith("jdk12")) {
            try {
                object = jdk12PropertyAction.cons;
                classpath = (String)jdk12.doPrivM.invoke((Object)jdk12.ac, ((Constructor)object).newInstance(CLASSPATH));
                classpath = classpath + File.pathSeparator + (String)jdk12.doPrivM.invoke((Object)jdk12.ac, ((Constructor)object).newInstance("java.home")) + File.separator + "lib";
            }
            catch (Throwable throwable) {
                securityPrivelege = false;
            }
        } else {
            try {
                if (securityPrivelege) {
                    classpath = System.getProperty(CLASSPATH) + File.pathSeparator + System.getProperty("java.home") + File.separator + "lib";
                }
            }
            catch (Exception exception) {
                filename = null;
                securityPrivelege = false;
            }
        }
        if (classpath == null) {
            securityPrivelege = false;
        }
        object = null;
        String string = Registry.getJMFDir();
        if (string != null) {
            classpath = classpath + File.pathSeparator + string;
        }
        if (securityPrivelege && (object = Registry.findJMFPropertiesFile()) == null) {
            securityPrivelege = false;
        }
        if (!Registry.readRegistry((InputStream)object)) {
            hash = new Hashtable();
        }
    }
}

