/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.util;

import com.sun.media.util.DynamicPlugIn;
import com.sun.media.util.Registry;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.media.CaptureDeviceInfo;
import javax.media.CaptureDeviceManager;
import javax.media.Codec;
import javax.media.Demultiplexer;
import javax.media.Effect;
import javax.media.Format;
import javax.media.Multiplexer;
import javax.media.PlugInManager;
import javax.media.Renderer;

public class RegistryGen {
    static String arname;
    static String pkgname;
    static String destdir;
    static String[] names;
    static DataOutputStream ds;
    static byte[] properties;
    private static String filename;
    private static Format[] emptyFormat;
    static String[] nativePlugins;
    static String[] defaultPlugins;

    static void printUsage() {
        System.err.println("java RegistryGen [-d <destdir>] [-j java] <registrylib> ");
        System.err.println("-j java: all-java");
    }

    static void writeClass() {
        boolean bl = false;
        try {
            ds.writeBytes("/* Generated by RegistryGen.\n   DO NOT EDIT.*/\n\n");
            if (pkgname != null) {
                ds.writeBytes("package ");
                ds.writeBytes(pkgname);
                ds.writeBytes(";\n\n");
            }
            ds.writeBytes("public abstract class ");
            ds.writeBytes(arname);
            ds.writeBytes(" {\n\n");
            if (properties.length > 0) {
                ds.writeBytes("   public static byte[] getData(){\n");
                ds.writeBytes("       int i;\n");
                ds.writeBytes("       byte[] b= new byte[" + properties.length + "];\n");
                ds.writeBytes("       for (i=0;i<b.length;i++)\n");
                ds.writeBytes("          b[i] = (byte)(s.charAt(i)-1);\n");
                ds.writeBytes("       return b;\n");
                ds.writeBytes("    }\n");
            } else {
                ds.writeBytes("   public static byte[] getData(){\n");
                ds.writeBytes("       return null;\n");
                ds.writeBytes("    }\n");
            }
            ds.writeBytes("    private static String s = \n        ");
            ds.writeBytes("\"");
            int n2 = properties.length;
            int n3 = 0;
            while (n3 < n2) {
                ds.writeBytes("\\" + RegistryGen.byte2oct((byte)(1 + properties[n3])));
                if (n3 % 16 == 15) {
                    ds.writeBytes("\"+\n        \"");
                }
                ++n3;
            }
            ds.writeBytes("\";\n\n");
            ds.writeBytes("}\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static String byte2oct(byte by) {
        int n2 = by & 0xFF;
        int n3 = n2 % 8;
        int n4 = n2 / 8 % 8;
        int n5 = n2 / 64;
        return "" + n5 + "" + n4 + "" + n3;
    }

    private static void registerPlugIn(String string) {
        try {
            int n2;
            Class<?> clazz = Class.forName(string);
            Object obj = clazz.newInstance();
            Format[] formatArray = null;
            Format[] formatArray2 = null;
            if (obj instanceof Demultiplexer) {
                n2 = 1;
                formatArray = ((Demultiplexer)obj).getSupportedInputContentDescriptors();
                formatArray2 = emptyFormat;
            } else if (obj instanceof Codec) {
                n2 = 2;
                formatArray = ((Codec)obj).getSupportedInputFormats();
                formatArray2 = ((Codec)obj).getSupportedOutputFormats(null);
            } else if (obj instanceof Renderer) {
                n2 = 4;
                formatArray = ((Renderer)obj).getSupportedInputFormats();
                formatArray2 = emptyFormat;
            } else if (obj instanceof Multiplexer) {
                n2 = 5;
                formatArray = emptyFormat;
                formatArray2 = ((Multiplexer)obj).getSupportedOutputContentDescriptors(null);
            } else if (obj instanceof Effect) {
                n2 = 3;
                formatArray = ((Effect)obj).getSupportedInputFormats();
                formatArray2 = ((Effect)obj).getSupportedOutputFormats(null);
            } else {
                n2 = 0;
            }
            if (obj instanceof DynamicPlugIn) {
                formatArray = ((DynamicPlugIn)obj).getBaseInputFormats();
                formatArray2 = ((DynamicPlugIn)obj).getBaseOutputFormats();
            }
            if (n2 != 0) {
                boolean bl = PlugInManager.addPlugIn(string, formatArray, formatArray2, n2);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (Exception exception) {
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
    }

    private static void deletePlugins(int n2) {
        Vector vector = PlugInManager.getPlugInList(null, null, n2);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            PlugInManager.removePlugIn(string, n2);
        }
    }

    static void registerPlugIns(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        RegistryGen.deletePlugins(1);
        RegistryGen.deletePlugins(2);
        RegistryGen.deletePlugins(4);
        RegistryGen.deletePlugins(5);
        RegistryGen.deletePlugins(3);
        int n2 = 0;
        while (n2 < stringArray.length) {
            RegistryGen.registerPlugIn(stringArray[n2]);
            ++n2;
        }
        try {
            PlugInManager.commit();
        }
        catch (Exception exception) {
            System.err.println("can't commit PlugInManager");
        }
    }

    static void registerCaptureDevices(CaptureDeviceInfo[] captureDeviceInfoArray) {
        int n2 = 0;
        while (n2 < captureDeviceInfoArray.length) {
            CaptureDeviceManager.addDevice(captureDeviceInfoArray[n2]);
            ++n2;
        }
        try {
            CaptureDeviceManager.commit();
        }
        catch (IOException iOException) {
            System.err.println("can't commit CaptureDeviceManager");
        }
    }

    private static boolean readProperties() {
        Object object;
        String string = null;
        try {
            string = System.getProperty("java.class.path") + File.pathSeparator + System.getProperty("java.home") + File.separator + "lib";
        }
        catch (Exception exception) {
            filename = null;
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        String string2 = "jmf.properties";
        File file = null;
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            object = string3.toUpperCase();
            try {
                if (((String)object).indexOf(".ZIP") > 0 || ((String)object).indexOf(".JAR") > 0) {
                    int n2 = string3.lastIndexOf(File.separator);
                    if (n2 == -1 && !File.separator.equals("/")) {
                        n2 = string3.lastIndexOf("/");
                    }
                    string3 = n2 == -1 ? ((n2 = string3.lastIndexOf(":")) == -1 ? string2 : string3.substring(0, n2) + ":" + string2) : string3.substring(0, n2) + File.separator + string2;
                } else {
                    string3 = string3 + File.separator + string2;
                }
            }
            catch (Exception exception) {
                string3 = string3 + File.separator + string2;
            }
            try {
                file = new File(string3);
                if (!file.exists()) continue;
                filename = string3;
                break;
            }
            catch (Throwable throwable) {
                filename = null;
                return false;
            }
        }
        try {
            if (filename == null || file == null) {
                return false;
            }
            if (file.length() == 0L) {
                return false;
            }
        }
        catch (Throwable throwable) {
            return false;
        }
        try {
            object = new FileInputStream(filename);
            DataInputStream dataInputStream = new DataInputStream((InputStream)object);
            int n3 = dataInputStream.available();
            properties = new byte[n3];
            dataInputStream.read(properties, 0, n3);
            dataInputStream.close();
            ((FileInputStream)object).close();
        }
        catch (IOException iOException) {
            System.err.println("IOException in readProperties: " + iOException);
            return false;
        }
        return true;
    }

    public static String[] findAllPlugInList(boolean bl, String[] stringArray, String[] stringArray2) {
        String[] stringArray3;
        if (bl) {
            stringArray3 = stringArray;
        } else {
            int n2 = 0;
            if (System.getProperty("os.name").startsWith("Linux") || System.getProperty("os.name").startsWith("Solaris") || System.getProperty("os.name").startsWith("SunOS")) {
                n2 = 1;
            }
            stringArray3 = new String[stringArray2.length + n2 + stringArray.length];
            int n3 = 0;
            while (n3 < stringArray2.length) {
                stringArray3[n3] = stringArray2[n3];
                ++n3;
            }
            if (n2 == 0) {
                n3 = 0;
                while (n3 < stringArray.length) {
                    stringArray3[n3 + stringArray2.length] = stringArray[n3];
                    ++n3;
                }
            } else {
                int n4 = -1;
                int n5 = 0;
                while (n5 < stringArray.length) {
                    if (stringArray[n5].indexOf("JavaSoundRenderer") >= 0) {
                        n4 = n5;
                        break;
                    }
                    ++n5;
                }
                if (n4 >= 0) {
                    int n6 = 0;
                    while (n6 <= n4) {
                        stringArray3[stringArray2.length + n6] = stringArray[n6];
                        ++n6;
                    }
                    stringArray3[stringArray2.length + n4 + 1] = "com.sun.media.renderer.audio.DirectAudioRenderer";
                    int n7 = n4 + 1;
                    while (n7 < stringArray.length) {
                        stringArray3[stringArray2.length + 1 + n7] = stringArray[n7];
                        ++n7;
                    }
                } else {
                    int n8 = 0;
                    while (n8 < stringArray.length) {
                        stringArray3[stringArray2.length + n8] = stringArray[n8];
                        ++n8;
                    }
                    stringArray3[stringArray2.length + stringArray.length] = "com.sun.media.renderer.audio.DirectAudioRenderer";
                }
            }
        }
        return stringArray3;
    }

    public static void main(String[] stringArray) {
        boolean bl = false;
        names = new String[stringArray.length + 1];
        int n2 = 0;
        int n3 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2].equals("-d")) {
                if (n2++ >= stringArray.length) {
                    RegistryGen.printUsage();
                    return;
                }
                destdir = stringArray[n2];
            } else if (stringArray[n2].equals("-j")) {
                int n4 = n2 + 1;
                if (n4 < stringArray.length && stringArray[n4].equalsIgnoreCase("java")) {
                    bl = true;
                    ++n2;
                } else {
                    bl = false;
                }
            } else {
                RegistryGen.names[n3++] = stringArray[n2];
            }
            ++n2;
        }
        RegistryGen.names[n3] = null;
        if (n3 == 0) {
            RegistryGen.printUsage();
            return;
        }
        n2 = names[0].lastIndexOf(".");
        if (n2 == -1) {
            pkgname = null;
            arname = names[0];
        } else {
            pkgname = names[0].substring(0, n2);
            arname = names[0].substring(n2 + 1);
        }
        String string = null;
        try {
            string = destdir == null ? arname + ".java" : destdir + File.separator + arname + ".java";
            ds = new DataOutputStream(new FileOutputStream(string));
        }
        catch (IOException iOException) {
            System.err.println("Cannot open file: " + string + iOException);
        }
        String[] stringArray2 = null;
        stringArray2 = RegistryGen.findAllPlugInList(bl, defaultPlugins, nativePlugins);
        RegistryGen.registerPlugIns(stringArray2);
        if (!RegistryGen.readProperties()) {
            System.err.println("Cannot read jmf.properties");
            System.exit(0);
        }
        RegistryGen.writeClass();
        System.exit(0);
    }

    static {
        properties = null;
        filename = null;
        emptyFormat = new Format[0];
        String string = System.getProperty("file.separator");
        Registry.set("secure.allowCaching", new Boolean(true));
        Registry.set("secure.maxCacheSizeMB", new Integer(250));
        Registry.set("secure.allowSaveFileFromApplets", new Boolean(false));
        Registry.set("secure.allowCaptureFromApplets", new Boolean(false));
        Registry.set("allowLogging", new Boolean(false));
        try {
            Registry.commit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        nativePlugins = new String[]{"com.ibm.media.codec.video.mpeg.MpegVideo", "com.sun.media.codec.video.cinepak.NativeDecoder", "com.sun.media.codec.video.cinepakpro.NativeEncoder", "com.sun.media.codec.video.h261.NativeDecoder", "com.sun.media.codec.video.vh263.NativeDecoder", "com.sun.media.codec.video.jpeg.NativeDecoder", "com.sun.media.codec.video.vcm.NativeDecoder", "com.sun.media.codec.video.vcm.NativeEncoder", "com.ibm.media.codec.audio.g723.NativeDecoder", "com.ibm.media.codec.audio.gsm.NativeDecoder", "com.ibm.media.codec.audio.gsm.NativeDecoder_ms", "com.ibm.media.codec.audio.ACMCodec", "com.sun.media.codec.video.jpeg.NativeEncoder", "com.ibm.media.codec.video.h263.NativeEncoder", "com.ibm.media.codec.audio.g723.NativeEncoder", "com.ibm.media.codec.audio.gsm.NativeEncoder", "com.sun.media.codec.audio.mpa.NativeDecoder", "com.sun.media.codec.audio.mpa.NativeEncoder", "com.sun.media.codec.video.colorspace.YUVToRGB", "com.sun.media.renderer.video.DDRenderer", "com.sun.media.renderer.video.GDIRenderer", "com.sun.media.renderer.video.SunRayRenderer", "com.sun.media.renderer.video.XILRenderer", "com.sun.media.renderer.video.XLibRenderer"};
        defaultPlugins = new String[]{"com.ibm.media.parser.video.MpegParser", "com.sun.media.parser.audio.WavParser", "com.sun.media.parser.audio.AuParser", "com.sun.media.parser.audio.AiffParser", "com.sun.media.parser.audio.GsmParser", "com.sun.media.parser.RawStreamParser", "com.sun.media.parser.RawBufferParser", "com.sun.media.parser.RawPullStreamParser", "com.sun.media.parser.RawPullBufferParser", "com.sun.media.parser.video.QuicktimeParser", "com.sun.media.parser.video.AviParser", "com.sun.media.codec.audio.mpa.JavaDecoder", "com.sun.media.codec.video.cinepak.JavaDecoder", "com.ibm.media.codec.video.h263.JavaDecoder", "com.sun.media.codec.video.colorspace.JavaRGBConverter", "com.sun.media.codec.video.colorspace.JavaRGBToYUV", "com.ibm.media.codec.audio.PCMToPCM", "com.ibm.media.codec.audio.rc.RCModule", "com.sun.media.codec.audio.rc.RateCvrt", "com.sun.media.codec.audio.msadpcm.JavaDecoder", "com.ibm.media.codec.audio.ulaw.JavaDecoder", "com.ibm.media.codec.audio.alaw.JavaDecoder", "com.ibm.media.codec.audio.dvi.JavaDecoder", "com.ibm.media.codec.audio.g723.JavaDecoder", "com.ibm.media.codec.audio.gsm.JavaDecoder", "com.ibm.media.codec.audio.gsm.JavaDecoder_ms", "com.ibm.media.codec.audio.ima4.JavaDecoder", "com.ibm.media.codec.audio.ima4.JavaDecoder_ms", "com.ibm.media.codec.audio.ulaw.JavaEncoder", "com.ibm.media.codec.audio.dvi.JavaEncoder", "com.ibm.media.codec.audio.gsm.JavaEncoder", "com.ibm.media.codec.audio.gsm.JavaEncoder_ms", "com.ibm.media.codec.audio.ima4.JavaEncoder", "com.ibm.media.codec.audio.ima4.JavaEncoder_ms", "com.sun.media.codec.audio.ulaw.Packetizer", "com.sun.media.codec.audio.ulaw.DePacketizer", "com.sun.media.codec.audio.mpa.Packetizer", "com.sun.media.codec.audio.mpa.DePacketizer", "com.ibm.media.codec.audio.gsm.Packetizer", "com.ibm.media.codec.audio.g723.Packetizer", "com.sun.media.codec.video.jpeg.Packetizer", "com.sun.media.codec.video.jpeg.DePacketizer", "com.sun.media.codec.video.mpeg.Packetizer", "com.sun.media.codec.video.mpeg.DePacketizer", "com.sun.media.renderer.audio.JMFSoundRenderer", "com.sun.media.renderer.audio.SunAudioRenderer", "com.sun.media.renderer.video.AWTRenderer", "com.sun.media.renderer.video.LightWeightRenderer", "com.sun.media.renderer.video.JPEGRenderer", "com.sun.media.multiplexer.RawBufferMux", "com.sun.media.multiplexer.RawSyncBufferMux", "com.sun.media.multiplexer.RTPSyncBufferMux", "com.sun.media.multiplexer.audio.GSMMux", "com.sun.media.multiplexer.audio.MPEGMux", "com.sun.media.multiplexer.audio.WAVMux", "com.sun.media.multiplexer.audio.AIFFMux", "com.sun.media.multiplexer.audio.AUMux", "com.sun.media.multiplexer.video.AVIMux", "com.sun.media.multiplexer.video.QuicktimeMux"};
    }
}

