/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.font;

import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.text.AttributedCharacterIterator;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.Map;
import org.apache.batik.gvt.font.AWTGVTGlyphVector;
import org.apache.batik.gvt.font.GVTFont;
import org.apache.batik.gvt.font.GVTGlyphVector;
import org.apache.batik.gvt.font.GVTLineMetrics;
import org.apache.batik.gvt.text.ArabicTextHandler;

public class AWTGVTFont
implements GVTFont {
    private Font awtFont;
    private float size;
    private float scale;

    public AWTGVTFont(Font font) {
        if (font.getSize2D() < 1.0f) {
            this.size = font.getSize2D();
            this.awtFont = font.deriveFont(10.0f);
        }
        this.scale = this.size / this.awtFont.getSize2D();
    }

    public AWTGVTFont(Font font, float f) {
        if (font.getSize2D() < 1.0f) {
            this.size = font.getSize2D() * f;
            this.awtFont = font.deriveFont(10.0f);
        }
        this.scale = this.size / this.awtFont.getSize2D();
    }

    public AWTGVTFont(Map map) {
        Float f = (Float)map.get(TextAttribute.SIZE);
        if (f != null && f.floatValue() < 1.0f) {
            this.size = f.floatValue();
            map.put(TextAttribute.SIZE, new Float(10.0f));
            this.awtFont = new Font(map);
        } else {
            this.awtFont = new Font(map);
            this.size = this.awtFont.getSize2D();
        }
        this.scale = this.size / this.awtFont.getSize2D();
    }

    public AWTGVTFont(String string, int n, int n2) {
        this.awtFont = new Font(string, n, n2);
        this.size = n2;
        this.scale = 1.0f;
    }

    public boolean canDisplay(char c) {
        return this.awtFont.canDisplay(c);
    }

    public int canDisplayUpTo(char[] cArray, int n, int n2) {
        return this.awtFont.canDisplayUpTo(cArray, n, n2);
    }

    public int canDisplayUpTo(CharacterIterator characterIterator, int n, int n2) {
        return this.awtFont.canDisplayUpTo(characterIterator, n, n2);
    }

    public int canDisplayUpTo(String string) {
        return this.awtFont.canDisplayUpTo(string);
    }

    public GVTGlyphVector createGlyphVector(FontRenderContext fontRenderContext, char[] cArray) {
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(new String(cArray));
        return new AWTGVTGlyphVector(this.awtFont.createGlyphVector(fontRenderContext, cArray), this, this.scale, stringCharacterIterator);
    }

    public GVTGlyphVector createGlyphVector(FontRenderContext fontRenderContext, CharacterIterator characterIterator) {
        AttributedCharacterIterator attributedCharacterIterator;
        if (characterIterator instanceof AttributedCharacterIterator && ArabicTextHandler.containsArabic(attributedCharacterIterator = (AttributedCharacterIterator)characterIterator)) {
            String string = ArabicTextHandler.createSubstituteString(attributedCharacterIterator);
            return this.createGlyphVector(fontRenderContext, string);
        }
        return new AWTGVTGlyphVector(this.awtFont.createGlyphVector(fontRenderContext, characterIterator), this, this.scale, characterIterator);
    }

    public GVTGlyphVector createGlyphVector(FontRenderContext fontRenderContext, int[] nArray, CharacterIterator characterIterator) {
        return new AWTGVTGlyphVector(this.awtFont.createGlyphVector(fontRenderContext, nArray), this, this.scale, characterIterator);
    }

    public GVTGlyphVector createGlyphVector(FontRenderContext fontRenderContext, String string) {
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        return new AWTGVTGlyphVector(this.awtFont.createGlyphVector(fontRenderContext, string), this, this.scale, stringCharacterIterator);
    }

    public GVTFont deriveFont(float f) {
        return new AWTGVTFont(this.awtFont, f / this.size);
    }

    public GVTLineMetrics getLineMetrics(char[] cArray, int n, int n2, FontRenderContext fontRenderContext) {
        return new GVTLineMetrics(this.awtFont.getLineMetrics(cArray, n, n2, fontRenderContext), this.scale);
    }

    public GVTLineMetrics getLineMetrics(CharacterIterator characterIterator, int n, int n2, FontRenderContext fontRenderContext) {
        return new GVTLineMetrics(this.awtFont.getLineMetrics(characterIterator, n, n2, fontRenderContext), this.scale);
    }

    public GVTLineMetrics getLineMetrics(String string, FontRenderContext fontRenderContext) {
        return new GVTLineMetrics(this.awtFont.getLineMetrics(string, fontRenderContext), this.scale);
    }

    public GVTLineMetrics getLineMetrics(String string, int n, int n2, FontRenderContext fontRenderContext) {
        return new GVTLineMetrics(this.awtFont.getLineMetrics(string, n, n2, fontRenderContext), this.scale);
    }

    public float getSize() {
        return this.size;
    }

    public float getHKern(int n, int n2) {
        return 0.0f;
    }

    public float getVKern(int n, int n2) {
        return 0.0f;
    }

    public String toString() {
        return this.awtFont.getFontName();
    }
}

