/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.document;

import java.util.Enumeration;
import net.jxta.document.Attributable;
import net.jxta.document.Attribute;
import net.jxta.document.Element;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;

public final class StructuredDocumentUtils {
    private StructuredDocumentUtils() {
    }

    public static void copyChildren(StructuredDocument intoDoc, Element intoElement, Element from) {
        Enumeration eachChild = from.getChildren();
        while (eachChild.hasMoreElements()) {
            Element aChild = (Element)eachChild.nextElement();
            Element newElement = intoDoc.createElement(aChild.getKey(), aChild.getValue());
            intoElement.appendChild(newElement);
            if (aChild instanceof Attributable && newElement instanceof Attributable) {
                Enumeration eachAttrib = ((Attributable)((Object)aChild)).getAttributes();
                while (eachAttrib.hasMoreElements()) {
                    Attribute anAttrib = (Attribute)eachAttrib.nextElement();
                    ((Attributable)((Object)newElement)).addAttribute(anAttrib.getName(), anAttrib.getValue());
                }
            }
            StructuredDocumentUtils.copyChildren(intoDoc, newElement, aChild);
        }
    }

    public static void copyElements(StructuredDocument intoDoc, Element intoElement, Element from, Object newName) {
        Element newElement = intoDoc.createElement(newName, from.getValue());
        intoElement.appendChild(newElement);
        if (from instanceof Attributable && newElement instanceof Attributable) {
            Enumeration eachAttrib = ((Attributable)((Object)from)).getAttributes();
            while (eachAttrib.hasMoreElements()) {
                Attribute anAttrib = (Attribute)eachAttrib.nextElement();
                ((Attributable)((Object)newElement)).addAttribute(anAttrib.getName(), anAttrib.getValue());
            }
        }
        StructuredDocumentUtils.copyChildren(intoDoc, newElement, from);
    }

    public static void copyElements(StructuredDocument intoDoc, Element intoElement, Element from) {
        StructuredDocumentUtils.copyElements(intoDoc, intoElement, from, from.getKey());
    }

    public static StructuredDocument copyAsDocument(Element from) {
        StructuredDocument result = from.getValue() == null ? StructuredDocumentFactory.newStructuredDocument(from.getRoot().getMimeType(), from.getKey().toString()) : StructuredDocumentFactory.newStructuredDocument(from.getRoot().getMimeType(), from.getKey().toString(), from.getValue().toString());
        if (from instanceof Attributable && result instanceof Attributable) {
            Enumeration eachAttrib = ((Attributable)((Object)from)).getAttributes();
            while (eachAttrib.hasMoreElements()) {
                Attribute anAttrib = (Attribute)eachAttrib.nextElement();
                ((Attributable)((Object)result)).addAttribute(anAttrib.getName(), anAttrib.getValue());
            }
        }
        StructuredDocumentUtils.copyChildren(result, result, from);
        return result;
    }
}

