/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.endpoint;

import java.io.UnsupportedEncodingException;
import java.lang.ref.SoftReference;
import net.jxta.id.ID;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class EndpointAddress
implements Cloneable {
    private static final Logger LOG = Logger.getLogger((String)(class$net$jxta$endpoint$EndpointAddress == null ? (class$net$jxta$endpoint$EndpointAddress = EndpointAddress.class$("net.jxta.endpoint.EndpointAddress")) : class$net$jxta$endpoint$EndpointAddress).getName());
    private boolean hierarchical = true;
    private String protocol = null;
    private String protocolAddress = null;
    private String service = null;
    private String serviceParam = null;
    private volatile transient int modcount = 0;
    private transient int modAtLastHashCalc = -1;
    private transient int cachedHashCode = 0;
    private transient int modAtLastStringCalc = -1;
    private transient SoftReference cachedToString = null;
    static /* synthetic */ Class class$net$jxta$endpoint$EndpointAddress;

    public static EndpointAddress unmodifiableEndpointAddress(EndpointAddress address) {
        return new UnmodifiableEndpointAddress(address);
    }

    public EndpointAddress() {
    }

    public EndpointAddress(String address) {
        if (address == null) {
            throw new IllegalArgumentException("address must not be null");
        }
        this.parseURI(address);
    }

    public EndpointAddress(byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException("bytes must not be null");
        }
        try {
            this.parseURI(new String(bytes, "UTF8"));
        }
        catch (UnsupportedEncodingException ex) {
            throw new UnsupportedOperationException(ex.toString());
        }
    }

    public EndpointAddress(EndpointAddress base, String service, String serviceParam) {
        if (base == null) {
            throw new IllegalArgumentException("base EndpointAddress must not be null");
        }
        this.setProtocolName(base.getProtocolName());
        this.setProtocolAddress(base.getProtocolAddress());
        this.setServiceName(service);
        this.setServiceParameter(serviceParam);
    }

    public EndpointAddress(String protocol, String address, String service, String serviceParam) {
        if (protocol == null) {
            throw new IllegalArgumentException("protocol must not be null");
        }
        if (address == null) {
            throw new IllegalArgumentException("address must not be null");
        }
        this.setProtocolName(protocol);
        this.setProtocolAddress(address);
        this.setServiceName(service);
        this.setServiceParameter(serviceParam);
    }

    public EndpointAddress(ID id, String service, String serviceParam) {
        if (null == id) {
            throw new IllegalArgumentException("id must not be null");
        }
        this.setProtocolName("urn:jxta");
        this.setProtocolAddress(id.getUniqueValue().toString());
        this.setServiceName(service);
        this.setServiceParameter(serviceParam);
    }

    public Object clone() {
        EndpointAddress clone = new EndpointAddress();
        clone.setProtocolName(this.getProtocolName());
        clone.setProtocolAddress(this.getProtocolAddress());
        clone.setServiceName(this.getServiceName());
        clone.setServiceParameter(this.getServiceParameter());
        return clone;
    }

    public boolean equals(Object target) {
        if (this == target) {
            return true;
        }
        if (target instanceof EndpointAddress) {
            EndpointAddress likeMe = (EndpointAddress)target;
            if (null == this.protocol || null == this.protocolAddress) {
                throw new IllegalStateException("Corrupt EndpointAddress, protocol or address is null");
            }
            boolean result = this.hierarchical == likeMe.hierarchical && this.protocol.equalsIgnoreCase(likeMe.protocol) && this.protocolAddress.equalsIgnoreCase(likeMe.protocolAddress) && (this.service != null ? likeMe.service != null && this.service.equals(likeMe.service) : likeMe.service == null) && (this.serviceParam != null ? likeMe.serviceParam != null && this.serviceParam.equals(likeMe.serviceParam) : likeMe.serviceParam == null);
            return result;
        }
        return false;
    }

    public synchronized int hashCode() {
        if (this.modcount != this.modAtLastHashCalc) {
            if (null == this.protocol || null == this.protocolAddress) {
                throw new IllegalStateException("Corrupt EndpointAddress, protocol or address is null");
            }
            this.cachedHashCode = this.protocol.toLowerCase().hashCode();
            this.cachedHashCode += this.protocolAddress.hashCode() * 5741;
            this.cachedHashCode += (this.service != null ? this.service.hashCode() : 1) * 7177;
            this.cachedHashCode += (this.serviceParam != null ? this.serviceParam.hashCode() : 1) * 6733;
            this.cachedHashCode = 0 == this.cachedHashCode ? 1 : this.cachedHashCode;
            this.modAtLastHashCalc = this.modcount;
        }
        return this.cachedHashCode;
    }

    public synchronized String toString() {
        String result;
        if (this.modcount == this.modAtLastStringCalc && null != this.cachedToString && null != (result = (String)this.cachedToString.get())) {
            return result;
        }
        if (null == this.protocol || null == this.protocolAddress) {
            throw new IllegalStateException("Corrupt EndpointAddress, protocol or address is null");
        }
        StringBuffer newResult = new StringBuffer(this.protocol.length() + this.protocolAddress.length() + 64);
        newResult.append(this.protocol);
        if (this.hierarchical) {
            newResult.append("://");
        } else {
            newResult.append(':');
        }
        newResult.append(this.protocolAddress);
        if (null != this.service) {
            if (this.hierarchical) {
                newResult.append('/');
            } else {
                newResult.append('#');
            }
            newResult.append(this.service);
            if (null != this.serviceParam) {
                newResult.append('/');
                newResult.append(this.serviceParam);
            }
        }
        result = newResult.toString();
        this.cachedToString = new SoftReference<String>(result);
        this.modAtLastStringCalc = this.modcount;
        return result;
    }

    public byte[] getBytes() {
        try {
            return this.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new UnsupportedOperationException(ex.toString());
        }
    }

    public String getProtocolName() {
        return this.protocol;
    }

    public String getProtocolAddress() {
        return this.protocolAddress;
    }

    public String getServiceName() {
        return this.service;
    }

    public String getServiceParameter() {
        return this.serviceParam;
    }

    public synchronized void setProtocolName(String name) {
        if (null == name || 0 == name.length()) {
            throw new IllegalArgumentException("name must be non-null and contain at least one character");
        }
        if (-1 != name.indexOf("/")) {
            throw new IllegalArgumentException("name may not contain '/' character");
        }
        int colonAt = name.indexOf(58);
        if (-1 == colonAt) {
            this.hierarchical = true;
        } else {
            if (!"urn".equalsIgnoreCase(name.substring(0, colonAt))) {
                throw new IllegalArgumentException("Only urn may contain colon");
            }
            if (colonAt == name.length() - 1) {
                throw new IllegalArgumentException("empty urn namespace!");
            }
            this.hierarchical = false;
        }
        this.protocol = name;
        ++this.modcount;
        this.cachedToString = null;
    }

    public synchronized void setProtocolAddress(String address) {
        if (null == address || 0 == address.length()) {
            throw new IllegalArgumentException("address must be non-null and contain at least one character");
        }
        if (-1 != address.indexOf("/")) {
            throw new IllegalArgumentException("address may not contain '/' character");
        }
        this.protocolAddress = address;
        ++this.modcount;
        this.cachedToString = null;
    }

    public synchronized void setServiceName(String name) {
        if (null == name) {
            this.service = null;
            ++this.modcount;
            return;
        }
        if (-1 != name.indexOf("/")) {
            throw new IllegalArgumentException("service name may not contain '/' character");
        }
        this.service = name;
        ++this.modcount;
        this.cachedToString = null;
    }

    public synchronized void setServiceParameter(String param) {
        if (null == param) {
            this.serviceParam = null;
            ++this.modcount;
            return;
        }
        this.serviceParam = param;
        ++this.modcount;
        this.cachedToString = null;
    }

    private void parseURI(String addr) {
        int index = addr.indexOf("://");
        if (index == -1) {
            this.parseURN(addr);
        } else {
            this.parseURL(addr);
        }
    }

    private void parseURN(String addr) {
        int protocolEnd = addr.indexOf(58);
        if (-1 == protocolEnd) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Address is not a valid URI: " + addr));
            }
            throw new IllegalArgumentException("Address is not a valid URI: " + addr);
        }
        if (!"urn".equalsIgnoreCase(addr.substring(0, protocolEnd))) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Address is unrecognized URI form: " + addr));
            }
            throw new IllegalArgumentException("Address is unrecognized URI form: " + addr);
        }
        if (addr.length() - 1 == protocolEnd) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Address URN does not have a namespace: " + addr));
            }
            throw new IllegalArgumentException("Address URN does not have a namespace: " + addr);
        }
        int namespaceEnd = addr.indexOf(58, protocolEnd + 1);
        if (-1 == namespaceEnd) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Address URN does not have a namespace: " + addr));
            }
            throw new IllegalArgumentException("Address URN does not have a namespace: " + addr);
        }
        this.setProtocolName(addr.substring(0, namespaceEnd));
        if (addr.length() - 1 == namespaceEnd) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Address URN does not have a NSS portion: " + addr));
            }
            throw new IllegalArgumentException("Address URN does not have a NSS portion: " + addr);
        }
        int nssEnd = addr.indexOf(35, namespaceEnd + 1);
        if (-1 == nssEnd) {
            this.setProtocolAddress(addr.substring(namespaceEnd + 1));
        } else {
            this.setProtocolAddress(addr.substring(namespaceEnd + 1, nssEnd));
            int serviceEnd = addr.indexOf(47, nssEnd + 1);
            if (-1 == serviceEnd) {
                this.setServiceName(addr.substring(nssEnd + 1));
            } else {
                this.setServiceName(addr.substring(nssEnd + 1, serviceEnd));
                this.setServiceParameter(addr.substring(serviceEnd + 1));
            }
        }
    }

    private void parseURL(String addr) {
        String remainder = null;
        int index = addr.indexOf("://");
        if (index == -1) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Address is not in absolute form: " + addr));
            }
            throw new IllegalArgumentException("Address is not in absolute form: " + addr);
        }
        if (0 == index) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Protocol is missing: " + addr));
            }
            throw new IllegalArgumentException("Protocol is missing: " + addr);
        }
        try {
            this.setProtocolName(addr.substring(0, index));
            remainder = addr.substring(index + 3);
        }
        catch (Exception e) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Protocol address is missing: " + addr));
            }
            throw new IllegalArgumentException("Protocol address is missing: " + addr);
        }
        index = remainder.indexOf("/");
        if (index == -1) {
            this.setProtocolAddress(remainder);
            return;
        }
        this.setProtocolAddress(remainder.substring(0, index));
        remainder = remainder.substring(index + 1);
        index = remainder.indexOf("/");
        if (index == -1) {
            this.setServiceName(remainder);
            return;
        }
        this.setServiceName(remainder.substring(0, index));
        remainder = remainder.substring(index + 1);
        this.setServiceParameter(remainder);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class UnmodifiableEndpointAddress
    extends EndpointAddress {
        public UnmodifiableEndpointAddress(EndpointAddress address) {
            super.setProtocolName(address.getProtocolName());
            super.setProtocolAddress(address.getProtocolAddress());
            super.setServiceName(address.getServiceName());
            super.setServiceParameter(address.getServiceParameter());
        }

        public void setProtocolName(String name) {
            throw new UnsupportedOperationException("This EndpointAddress is not modifiable");
        }

        public void setProtocolAddress(String address) {
            throw new UnsupportedOperationException("This EndpointAddress is not modifiable");
        }

        public void setServiceName(String name) {
            throw new UnsupportedOperationException("This EndpointAddress is not modifiable");
        }

        public void setServiceParameter(String param) {
            throw new UnsupportedOperationException("This EndpointAddress is not modifiable");
        }
    }
}

