/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.endpoint;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Vector;
import net.jxta.document.MimeMediaType;
import net.jxta.endpoint.ByteArrayMessageElement;
import net.jxta.endpoint.InputStreamMessageElement;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.MessageElementEnumeration;
import net.jxta.endpoint.StringMessageElement;
import net.jxta.impl.endpoint.MessageElementEnumerationImpl;
import net.jxta.util.StringEnumeration;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class Message {
    private static final transient Logger LOG = Logger.getLogger((String)(class$net$jxta$endpoint$Message == null ? (class$net$jxta$endpoint$Message = Message.class$("net.jxta.endpoint.Message")) : class$net$jxta$endpoint$Message).getName());
    protected static final boolean LOG_MODIFICATIONS = false;
    private static volatile int messagenumber = 1;
    protected String defaultNamespace;
    protected Map namespaces = new HashMap();
    protected List elements = new ArrayList();
    protected Map properties = new HashMap();
    protected transient List lineage = null;
    protected volatile transient int modCount = 0;
    protected transient long cachedByteLength = 0L;
    protected transient int cachedByteLengthModCount = -1;
    public boolean modifiable = true;
    protected List modHistory = null;
    static /* synthetic */ Class class$net$jxta$endpoint$Message;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static int getNextMessageNumber() {
        Class clazz = class$net$jxta$endpoint$Message == null ? (class$net$jxta$endpoint$Message = Message.class$("net.jxta.endpoint.Message")) : class$net$jxta$endpoint$Message;
        synchronized (clazz) {
            return messagenumber++;
        }
    }

    public Message() {
        this("");
    }

    protected Message(String defaultNamespace) {
        this.defaultNamespace = defaultNamespace;
        this.lineage = new ArrayList();
        this.lineage.add(new Integer(Message.getNextMessageNumber()));
    }

    public Object clone() {
        Message clone = new Message(this.getDefaultNamespace());
        clone.lineage.addAll(this.lineage);
        clone.elements.addAll(this.elements);
        clone.namespaces = new HashMap(this.namespaces.size());
        Iterator eachNamespace = this.namespaces.keySet().iterator();
        while (eachNamespace.hasNext()) {
            String aNamespace = (String)eachNamespace.next();
            List namespaceElements = (List)this.namespaces.get(aNamespace);
            ArrayList newNamespaceElements = new ArrayList(namespaceElements.size());
            newNamespaceElements.addAll(namespaceElements);
            clone.namespaces.put(aNamespace, newNamespaceElements);
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Created clone " + clone + " of " + this));
        }
        return clone;
    }

    public boolean equals(Object target) {
        if (this == target) {
            return true;
        }
        if (target instanceof Message) {
            Message likeMe = (Message)target;
            ElementIterator myElements = this.getMessageElements();
            ElementIterator itsElements = likeMe.getMessageElements();
            while (myElements.hasNext()) {
                if (!itsElements.hasNext()) {
                    return false;
                }
                MessageElement mine = (MessageElement)myElements.next();
                MessageElement its = (MessageElement)itsElements.next();
                if (!myElements.getNamespace().equals(itsElements.getNamespace())) {
                    return false;
                }
                if (mine.equals(its)) continue;
                return false;
            }
            return !itsElements.hasNext();
        }
        return false;
    }

    public int hashCode() {
        int result = 0;
        ElementIterator eachElement = this.getMessageElements();
        while (eachElement.hasNext()) {
            MessageElement anElement = (MessageElement)eachElement.next();
            result += anElement.hashCode();
            result *= 6037;
        }
        if (0 == result) {
            result = 1;
        }
        return result;
    }

    public String toString() {
        StringBuffer toString = new StringBuffer(64);
        toString.append(this.getClass().getName());
        toString.append('@');
        toString.append(super.hashCode());
        toString.append('[');
        toString.append(this.modCount);
        toString.append("]{");
        Iterator allLineage = this.getMessageLineage();
        while (allLineage.hasNext()) {
            toString.append(allLineage.next().toString());
            if (!allLineage.hasNext()) continue;
            toString.append(',');
        }
        toString.append('}');
        return toString.toString();
    }

    public static MessageElement newMessageElement(String name, MimeMediaType type, InputStream in) throws IOException {
        String[] nsName = null != name ? MessageElement.parseName(name) : new String[]{"", ""};
        InputStreamMessageElement element2 = new InputStreamMessageElement(nsName[1], type, in, null);
        element2.ns = nsName[0];
        return element2;
    }

    public static MessageElement newMessageElement(String name, MimeMediaType type, InputStream in, int len) throws IOException {
        String[] nsName = null != name ? MessageElement.parseName(name) : new String[]{"", ""};
        InputStreamMessageElement element2 = new InputStreamMessageElement(nsName[1], type, in, len, null);
        element2.ns = nsName[0];
        return element2;
    }

    public static MessageElement newMessageElement(String qname, MimeMediaType type, byte[] b) {
        return Message.newMessageElement(qname, type, b, 0, b.length);
    }

    public static MessageElement newMessageElement(String qname, MimeMediaType type, byte[] b, int offset, int len) {
        String[] nsName = null != qname ? MessageElement.parseName(qname) : new String[]{"", ""};
        ByteArrayMessageElement element2 = new ByteArrayMessageElement(nsName[1], type, b, offset, len, null);
        element2.ns = nsName[0];
        return element2;
    }

    public void addElement(MessageElement element2) {
        String qname = element2.getName();
        String[] names = MessageElement.parseName(qname);
        String namespace = names[0];
        String name = names[1];
        this.replaceMessageElement(namespace, element2);
    }

    public boolean removeElement(MessageElement me) {
        return this.removeMessageElement(me);
    }

    public MessageElement removeElement(String qname) {
        String[] names = MessageElement.parseName(qname);
        String namespace = names[0];
        String name = names[1];
        ElementIterator elems = this.getMessageElements(namespace, name);
        MessageElement me = null;
        while (elems.hasNext()) {
            me = (MessageElement)elems.next();
            this.removeMessageElement(me);
        }
        return me;
    }

    public byte[] getBytes(String qname) {
        MessageElement me = this.getElement(qname);
        if (null == me) {
            return null;
        }
        return me.getBytes(false);
    }

    public void setBytes(String qname, byte[] bytes) {
        this.setBytes(qname, bytes, 0, bytes.length);
    }

    public void setBytes(String qname, byte[] bytes, int offset, int len) {
        MessageElement el = Message.newMessageElement(qname, null, bytes, offset, len);
        this.addElement(el);
    }

    public Enumeration getNamespaces() {
        ArrayList names = new ArrayList();
        Iterator allNames = this.getMessageNamespaces();
        while (allNames.hasNext()) {
            names.add(allNames.next());
        }
        return Collections.enumeration(names);
    }

    public boolean hasElement(String qname) {
        return this.getElement(qname) != null;
    }

    public MessageElement getElement(String qname) {
        String[] names = MessageElement.parseName(qname);
        String namespace = names[0];
        String name = names[1];
        ElementIterator elems = this.getMessageElements(namespace, name);
        if (elems.hasNext()) {
            MessageElement me = (MessageElement)elems.next();
            return me;
        }
        return null;
    }

    public MessageElementEnumeration getElements() {
        return this.getElementsInFifoOrder();
    }

    MessageElementEnumeration getElementsInFifoOrder() {
        ArrayList elems = new ArrayList();
        ElementIterator allElems = this.getMessageElements();
        while (allElems.hasNext()) {
            elems.add(allElems.next());
        }
        return new MessageElementEnumerationImpl(Collections.enumeration(elems));
    }

    public StringEnumeration getNames() {
        return new StringEnumeration(new Enumeration(){
            private Enumeration elements;
            {
                this.elements = Message.this.getElementsInFifoOrder();
            }

            public boolean hasMoreElements() {
                return this.elements.hasMoreElements();
            }

            public Object nextElement() {
                MessageElement element2 = (MessageElement)this.elements.nextElement();
                return element2.getName();
            }
        });
    }

    public MessageElementEnumeration getElements(String namespace) {
        ArrayList elems = new ArrayList();
        ElementIterator allElems = this.getMessageElementsOfNamespace(namespace);
        while (allElems.hasNext()) {
            elems.add(allElems.next());
        }
        return new MessageElementEnumerationImpl(Collections.enumeration(elems));
    }

    public long getRawSize() {
        return this.getByteLength();
    }

    public void setString(String qname, String s) {
        String[] names = MessageElement.parseName(qname);
        String namespace = names[0];
        String name = names[1];
        StringMessageElement element2 = new StringMessageElement(name, s, null);
        element2.ns = names[0];
        this.addElement(element2);
    }

    public String getString(String qname) {
        MessageElement element2 = this.getElement(qname);
        if (null == element2) {
            return null;
        }
        return element2.toString();
    }

    protected String getDefaultNamespace() {
        return this.defaultNamespace;
    }

    public void addMessageElement(MessageElement add) {
        if (null != add.ns) {
            throw new IllegalStateException("Cannot use this deprecated element with this new call");
        }
        this.addMessageElement(null, add);
    }

    public void addMessageElement(String namespace, MessageElement add) {
        if (null == namespace) {
            namespace = this.getDefaultNamespace();
        }
        if (null == add) {
            throw new IllegalArgumentException("Message Element must be non-null");
        }
        if (null != add.ns && !namespace.equals(add.ns)) {
            throw new IllegalStateException("Cannot use this deprecated element with this new call");
        }
        add.qname = 0 == namespace.length() ? add.getElementName() : namespace + ":" + add.getElementName();
        this.elements.add(new element(namespace, add));
        ArrayList<MessageElement> namespaceElements = (ArrayList<MessageElement>)this.namespaces.get(namespace);
        if (null == namespaceElements) {
            namespaceElements = new ArrayList<MessageElement>();
            this.namespaces.put(namespace, namespaceElements);
        }
        namespaceElements.add(add);
        this.incMessageModCount();
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Added " + namespace + "::" + add.getElementName() + "/" + add.getClass().getName() + "@" + add.hashCode() + " to " + this));
        }
    }

    public MessageElement replaceMessageElement(MessageElement replacement) {
        return this.replaceMessageElement(null, replacement);
    }

    public MessageElement replaceMessageElement(String namespace, MessageElement replacement) {
        if (null == namespace) {
            namespace = this.getDefaultNamespace();
        }
        if (null == replacement) {
            throw new IllegalArgumentException("Message Element must be non-null");
        }
        if (null != replacement.ns && !namespace.equals(replacement.ns)) {
            throw new IllegalStateException("Cannot use this deprecated element with this new call");
        }
        MessageElement removed = null;
        ElementIterator allMatching = this.getMessageElements(namespace, replacement.getElementName());
        while (allMatching.hasNext()) {
            MessageElement anElement = (MessageElement)allMatching.next();
            allMatching.remove();
            removed = anElement;
        }
        this.addMessageElement(namespace, replacement);
        return removed;
    }

    public Iterator getMessageNamespaces() {
        return Collections.unmodifiableMap(this.namespaces).keySet().iterator();
    }

    public MessageElement getMessageElement(String name) {
        ListIterator eachElement = this.elements.listIterator();
        while (eachElement.hasNext()) {
            element anElement = (element)eachElement.next();
            if (!name.equals(anElement.element.getElementName())) continue;
            return anElement.element;
        }
        return null;
    }

    public MessageElement getMessageElement(String namespace, String name) {
        List namespaceElements;
        if (null == namespace) {
            namespace = this.getDefaultNamespace();
        }
        if (null == (namespaceElements = (List)this.namespaces.get(namespace))) {
            return null;
        }
        ListIterator eachElement = namespaceElements.listIterator();
        while (eachElement.hasNext()) {
            MessageElement anElement = (MessageElement)eachElement.next();
            if (!name.equals(anElement.getElementName())) continue;
            return anElement;
        }
        return null;
    }

    public ElementIterator getMessageElements() {
        Vector theMsgElements = new Vector(this.elements);
        return new ElementIterator(theMsgElements.listIterator());
    }

    public ElementIterator getMessageElements(String name) {
        ArrayList<element> theMsgElements = new ArrayList<element>(this.elements.size());
        Iterator eachElement = this.elements.iterator();
        while (eachElement.hasNext()) {
            element anElement = (element)eachElement.next();
            if (!name.equals(anElement.element.getElementName())) continue;
            theMsgElements.add(anElement);
        }
        return new ElementIterator(theMsgElements.listIterator());
    }

    public ElementIterator getMessageElementsOfNamespace(String namespace) {
        ArrayList<element> theMsgElements = new ArrayList<element>(this.elements.size());
        if (null == namespace) {
            namespace = this.getDefaultNamespace();
        }
        Iterator eachElement = this.elements.iterator();
        while (eachElement.hasNext()) {
            element anElement = (element)eachElement.next();
            if (!namespace.equals(anElement.namespace)) continue;
            theMsgElements.add(anElement);
        }
        return new ElementIterator(theMsgElements.listIterator());
    }

    public ElementIterator getMessageElements(String namespace, String name) {
        ArrayList<element> theMsgElements = new ArrayList<element>(this.elements.size());
        if (null == namespace) {
            namespace = this.getDefaultNamespace();
        }
        Iterator eachElement = this.elements.iterator();
        while (eachElement.hasNext()) {
            element anElement = (element)eachElement.next();
            if (!namespace.equals(anElement.namespace) || !name.equals(anElement.element.getElementName())) continue;
            theMsgElements.add(anElement);
        }
        return new ElementIterator(theMsgElements.listIterator());
    }

    public ElementIterator getMessageElements(MimeMediaType type) {
        Vector<MessageElement> theMsgElements = new Vector<MessageElement>(this.elements.size());
        ListIterator eachElement = this.elements.listIterator();
        while (eachElement.hasNext()) {
            element anElement = (element)eachElement.next();
            if (!type.equals(anElement.element.getMimeType())) continue;
            theMsgElements.add(anElement.element);
        }
        return new ElementIterator(theMsgElements.listIterator());
    }

    public ElementIterator getMessageElements(String namespace, MimeMediaType type) {
        ArrayList<element> theMsgElements = new ArrayList<element>(this.elements.size());
        if (null == namespace) {
            namespace = this.getDefaultNamespace();
        }
        Iterator eachElement = this.elements.iterator();
        while (eachElement.hasNext()) {
            element anElement = (element)eachElement.next();
            if (!namespace.equals(anElement.namespace) || !type.equals(anElement.element.getMimeType())) continue;
            theMsgElements.add(anElement);
        }
        return new ElementIterator(theMsgElements.listIterator());
    }

    public boolean removeMessageElement(MessageElement remove) {
        ElementIterator eachElement = this.getMessageElements();
        while (eachElement.hasNext()) {
            MessageElement anElement = (MessageElement)eachElement.next();
            if (remove != anElement) continue;
            eachElement.remove();
            return true;
        }
        return false;
    }

    public boolean removeMessageElement(String namespace, MessageElement remove) {
        ElementIterator eachElement = this.getMessageElementsOfNamespace(namespace);
        while (eachElement.hasNext()) {
            MessageElement anElement = (MessageElement)eachElement.next();
            if (remove != anElement) continue;
            eachElement.remove();
            return true;
        }
        return false;
    }

    public void clear() {
        this.elements.clear();
        this.namespaces.clear();
        this.properties.clear();
        this.lineage.retainAll(Collections.singletonList(this.lineage.get(0)));
        this.incMessageModCount();
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Cleared " + this));
        }
    }

    public synchronized long getByteLength() {
        if (this.modCount != this.cachedByteLengthModCount) {
            this.cachedByteLength = 0L;
            ElementIterator eachElement = this.getMessageElements();
            while (eachElement.hasNext()) {
                MessageElement anElement = (MessageElement)eachElement.next();
                this.cachedByteLength += anElement.getByteLength();
            }
            this.cachedByteLengthModCount = this.modCount;
        }
        return this.cachedByteLength;
    }

    public int getMessageModCount() {
        return this.modCount;
    }

    protected synchronized int incMessageModCount() {
        ++this.modCount;
        if (!this.modifiable) {
            IllegalStateException failure = new IllegalStateException("Message should not have been modified");
            if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                LOG.error((Object)failure, (Throwable)failure);
            }
            throw failure;
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Modification to " + this));
        }
        return this.modCount;
    }

    public synchronized String getMessageModHistory() {
        return "Modification history tracking is disabled";
    }

    public int getMessageNumber() {
        return (Integer)this.lineage.get(0);
    }

    public Iterator getMessageLineage() {
        return Collections.unmodifiableList(this.lineage).iterator();
    }

    public Object setMessageProperty(Object key, Object value) {
        return this.properties.put(key, value);
    }

    public Object getMessageProperty(Object key) {
        return this.properties.get(key);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected static class element {
        String namespace;
        MessageElement element;

        element(String namespace, MessageElement element2) {
            this.namespace = namespace;
            this.element = element2;
        }
    }

    public class ElementIterator
    implements ListIterator {
        ListIterator list;
        element current = null;
        transient int origModCount;

        ElementIterator(ListIterator list) {
            this.origModCount = Message.this.getMessageModCount();
            this.list = list;
        }

        public boolean hasNext() {
            if (this.origModCount != Message.this.getMessageModCount()) {
                ConcurrentModificationException failure = new ConcurrentModificationException(Message.this + " concurrently modified. Iterator was made at mod " + this.origModCount);
                if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                    LOG.error((Object)(Message.this + " concurrently modified\n" + Message.this.getMessageModHistory()), (Throwable)failure);
                }
                throw failure;
            }
            return this.list.hasNext();
        }

        public Object next() {
            if (this.origModCount != Message.this.getMessageModCount()) {
                ConcurrentModificationException failure = new ConcurrentModificationException(Message.this + " concurrently modified. Iterator was made at mod " + this.origModCount);
                if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                    LOG.error((Object)(Message.this + " concurrently modified\n" + Message.this.getMessageModHistory()), (Throwable)failure);
                }
                throw failure;
            }
            this.current = (element)this.list.next();
            return this.current.element;
        }

        public int nextIndex() {
            return this.list.nextIndex();
        }

        public boolean hasPrevious() {
            if (this.origModCount != Message.this.getMessageModCount()) {
                ConcurrentModificationException failure = new ConcurrentModificationException(Message.this + " concurrently modified. Iterator was made at mod " + this.origModCount);
                if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                    LOG.error((Object)(Message.this + " concurrently modified\n" + Message.this.getMessageModHistory()), (Throwable)failure);
                }
                throw failure;
            }
            return this.list.hasPrevious();
        }

        public Object previous() {
            if (this.origModCount != Message.this.getMessageModCount()) {
                ConcurrentModificationException failure = new ConcurrentModificationException(Message.this + " concurrently modified. Iterator was made at mod " + this.origModCount);
                if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                    LOG.error((Object)(Message.this + " concurrently modified\n" + Message.this.getMessageModHistory()), (Throwable)failure);
                }
                throw failure;
            }
            this.current = (element)this.list.previous();
            return this.current.element;
        }

        public int previousIndex() {
            return this.list.previousIndex();
        }

        public void add(Object obj) {
            throw new UnsupportedOperationException("add() not supported");
        }

        public void remove() {
            if (this.origModCount != Message.this.getMessageModCount()) {
                ConcurrentModificationException failure = new ConcurrentModificationException(Message.this + " concurrently modified. Iterator was made at mod " + this.origModCount);
                if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                    LOG.error((Object)(Message.this + " concurrently modified\n" + Message.this.getMessageModHistory()), (Throwable)failure);
                }
                throw failure;
            }
            if (null == this.current) {
                throw new IllegalStateException("no current element, call next() or previous()");
            }
            ListIterator elsPosition = Message.this.elements.listIterator();
            ListIterator nsPosition = ((List)Message.this.namespaces.get(this.current.namespace)).listIterator();
            int currentPrevious = this.list.previousIndex();
            while (this.list.previousIndex() >= 0) {
                this.list.previous();
            }
            while (this.list.previousIndex() < currentPrevious) {
                element anElement = (element)this.list.next();
                try {
                    while (anElement != elsPosition.next()) {
                    }
                }
                catch (NoSuchElementException ranOut) {
                    ConcurrentModificationException failure = new ConcurrentModificationException(Message.this + " concurrently modified. Iterator was made at mod " + this.origModCount);
                    if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                        LOG.error((Object)(Message.this + " concurrently modified\n" + Message.this.getMessageModHistory()), (Throwable)failure);
                    }
                    throw failure;
                }
                if (!this.current.namespace.equals(anElement.namespace)) continue;
                nsPosition.next();
            }
            elsPosition.remove();
            nsPosition.remove();
            this.list.remove();
            this.origModCount = Message.this.incMessageModCount();
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Removed " + this.current.namespace + "::" + this.current.element.getElementName() + "/" + this.current.element.getClass().getName() + "@" + this.current.element.hashCode() + " from " + Message.this));
            }
            this.current = null;
        }

        public void set(Object obj) {
            if (this.origModCount != Message.this.getMessageModCount()) {
                ConcurrentModificationException failure = new ConcurrentModificationException(Message.this + " concurrently modified. Iterator was made at mod " + this.origModCount);
                if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                    LOG.error((Object)(Message.this + " concurrently modified\n" + Message.this.getMessageModHistory()), (Throwable)failure);
                }
                throw failure;
            }
            if (!(obj instanceof MessageElement)) {
                throw new IllegalStateException("replacement must be a MessageElement");
            }
            if (null == this.current) {
                throw new IllegalStateException("no current element, call next() or previous()");
            }
            ListIterator<element> elsPosition = Message.this.elements.listIterator();
            ListIterator<Object> nsPosition = ((List)Message.this.namespaces.get(this.current.namespace)).listIterator();
            int currentPrevious = this.list.previousIndex();
            while (this.list.previousIndex() >= 0) {
                this.list.previous();
            }
            while (this.list.previousIndex() < currentPrevious) {
                element anElement = (element)this.list.next();
                try {
                    while (anElement != elsPosition.next()) {
                    }
                }
                catch (NoSuchElementException ranOut) {
                    ConcurrentModificationException failure = new ConcurrentModificationException("Message concurrently modified " + Message.this);
                    if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                        LOG.error((Object)(Message.this + " concurrently modified\n" + Message.this.getMessageModHistory()), (Throwable)failure);
                    }
                    throw failure;
                }
                if (!this.current.namespace.equals(anElement.namespace)) continue;
                nsPosition.next();
            }
            element newCurrent = new element(this.current.namespace, (MessageElement)obj);
            elsPosition.set(newCurrent);
            nsPosition.set(obj);
            this.list.set(newCurrent);
            this.origModCount = Message.this.incMessageModCount();
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Replaced " + this.current.namespace + "::" + this.current.element.getElementName() + "/" + this.current.element.getClass().getName() + "@" + this.current.element.hashCode() + " with " + newCurrent.namespace + "::" + newCurrent.element.getElementName() + "/" + newCurrent.element.getClass().getName() + "@" + newCurrent.element.hashCode() + " in " + Message.this));
            }
            this.current = newCurrent;
        }

        public String getNamespace() {
            if (null == this.current) {
                throw new IllegalStateException("no current element, call next() or previous()");
            }
            return this.current.namespace;
        }
    }
}

