/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.endpoint;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.ref.SoftReference;
import net.jxta.document.MimeMediaType;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.TextMessageElement;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class StringMessageElement
extends TextMessageElement {
    private static final transient Logger LOG = Logger.getLogger((String)(class$net$jxta$endpoint$StringMessageElement == null ? (class$net$jxta$endpoint$StringMessageElement = StringMessageElement.class$("net.jxta.endpoint.StringMessageElement")) : class$net$jxta$endpoint$StringMessageElement).getName());
    protected String data;
    static /* synthetic */ Class class$net$jxta$endpoint$StringMessageElement;

    protected StringMessageElement() {
    }

    public StringMessageElement(String name, String value, MessageElement sig) {
        super(name, null, sig);
        if (null == value) {
            throw new IllegalArgumentException("value must be non-null");
        }
        this.type = MimeMediaType.TEXTUTF8;
        this.data = value;
    }

    public StringMessageElement(String name, String value, String encoding, MessageElement sig) throws UnsupportedEncodingException {
        super(name, null, sig);
        if (null == value) {
            throw new IllegalArgumentException("value must be non-null");
        }
        InputStreamReader getEncoding = null == encoding ? new InputStreamReader(new ByteArrayInputStream(new byte[0])) : new InputStreamReader((InputStream)new ByteArrayInputStream(new byte[0]), encoding);
        encoding = getEncoding.getEncoding();
        try {
            getEncoding.close();
            getEncoding = null;
        }
        catch (IOException ignored) {
            // empty catch block
        }
        this.type = new MimeMediaType(MimeMediaType.TEXT_DEFAULTENCODING, "charset=\"" + encoding + "\"", true);
        this.data = value;
    }

    public boolean equals(Object target) {
        if (this == target) {
            return true;
        }
        if (target instanceof MessageElement) {
            if (!super.equals(target)) {
                return false;
            }
            if (target instanceof StringMessageElement) {
                StringMessageElement likeMe = (StringMessageElement)target;
                return this.data.equals(likeMe.data);
            }
            if (target instanceof TextMessageElement) {
                TextMessageElement likeMe = (TextMessageElement)target;
                try {
                    int its;
                    int mine;
                    Reader myReader = this.getReader();
                    Reader itsReader = likeMe.getReader();
                    do {
                        if ((mine = myReader.read()) == (its = itsReader.read())) continue;
                        return false;
                    } while (-1 != mine && -1 != its);
                    return -1 == mine && -1 == its;
                }
                catch (IOException fatal) {
                    throw new IllegalStateException("MessageElements could not be compared." + fatal);
                }
            }
            MessageElement likeMe = (MessageElement)target;
            try {
                int its;
                int mine;
                InputStream myStream = this.getStream();
                InputStream itsStream = likeMe.getStream();
                do {
                    if ((mine = myStream.read()) == (its = itsStream.read())) continue;
                    return false;
                } while (-1 != mine && -1 != its);
                return -1 == mine && -1 == its;
            }
            catch (IOException fatal) {
                throw new IllegalStateException("MessageElements could not be compared." + fatal);
            }
        }
        return false;
    }

    public int hashCode() {
        int result = super.hashCode() * 6037 + this.data.hashCode();
        return result;
    }

    public String toString() {
        return this.data;
    }

    public synchronized byte[] getBytes(boolean copy) {
        String charset;
        byte[] result = null;
        if (!copy && null != this.cachedGetBytes && null != (result = (byte[])this.cachedGetBytes.get())) {
            return result;
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("creating getBytes of " + this.getClass().getName() + '@' + Integer.toHexString(this.hashCode())));
        }
        if (null == (charset = this.type.getParameter("charset"))) {
            result = this.data.getBytes();
        } else {
            try {
                result = this.data.getBytes(charset);
            }
            catch (UnsupportedEncodingException caught) {
                if (LOG.isEnabledFor((Priority)Level.WARN)) {
                    LOG.warn((Object)"MessageElement Data could not be generated", (Throwable)caught);
                }
                throw new IllegalStateException("MessageElement Data could not be generated due to " + caught.getMessage());
            }
        }
        if (!copy) {
            this.cachedToString = new SoftReference<byte[]>(result);
        }
        return result;
    }

    public long getCharLength() {
        return this.data.length();
    }

    public char[] getChars(boolean copy) {
        char[] result = new char[this.data.length()];
        this.data.getChars(0, this.data.length(), result, 0);
        return result;
    }

    public InputStream getStream() throws IOException {
        return new ByteArrayInputStream(this.getBytes(false));
    }

    public Reader getReader() throws IOException {
        return new StringReader(this.data);
    }

    public void sendToStream(OutputStream sendTo) throws IOException {
        String charset = this.type.getParameter("charset");
        OutputStreamWriter writer = null != charset ? new OutputStreamWriter(sendTo, charset) : new OutputStreamWriter(sendTo);
        writer.write(this.data);
        writer.flush();
    }

    public void sendToWriter(Writer sendTo) throws IOException {
        sendTo.write(this.data);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

