/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.id;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownServiceException;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import net.jxta.codat.CodatID;
import net.jxta.id.ID;
import net.jxta.id.jxta.IDFormat;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.pipe.PipeID;
import net.jxta.platform.ModuleClassID;
import net.jxta.platform.ModuleSpecID;
import net.jxta.util.ClassFactory;
import org.apache.log4j.Logger;
import sun.net.www.protocol.urn.Handler;

public final class IDFactory
extends ClassFactory {
    private static final transient Logger LOG = Logger.getLogger((String)(class$net$jxta$id$IDFactory == null ? (class$net$jxta$id$IDFactory = IDFactory.class$("net.jxta.id.IDFactory")) : class$net$jxta$id$IDFactory).getName());
    private Map idFormats = new HashMap();
    private String idNewInstances = null;
    private static IDFactory factory = new IDFactory();
    static /* synthetic */ Class class$net$jxta$id$IDFactory;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$net$jxta$id$IDFactory$Instantiator;

    private IDFactory() {
        this.registerAssoc("net.jxta.id.jxta.IDFormat");
        this.registerAssoc("net.jxta.impl.id.unknown.IDFormat");
        try {
            ResourceBundle jxtaRsrcs = ResourceBundle.getBundle("net.jxta.impl.config");
            this.idNewInstances = jxtaRsrcs.getString("IDNewInstances").trim();
            this.registerFromResources("net.jxta.impl.config", "IDInstanceTypes");
        }
        catch (MissingResourceException notFound) {
            LOG.error((Object)"Could not find net.jxta.impl.config properties file! reason:", (Throwable)notFound);
        }
    }

    protected Map getAssocTable() {
        return this.idFormats;
    }

    protected Class getClassForKey() {
        return class$java$lang$String == null ? (class$java$lang$String = IDFactory.class$("java.lang.String")) : class$java$lang$String;
    }

    protected Class getClassOfInstantiators() {
        return class$java$lang$Object == null ? (class$java$lang$Object = IDFactory.class$("java.lang.Object")) : class$java$lang$Object;
    }

    public boolean registerAssoc(String className) {
        boolean registeredSomething = false;
        try {
            Field instantiatorField;
            Class<?> idClass;
            try {
                idClass = Class.forName(className);
                if (null == idClass) {
                    throw new ClassNotFoundException("forName() result was null");
                }
            }
            catch (ClassNotFoundException notThere) {
                LOG.error((Object)("Could not find class named : " + className));
                return false;
            }
            catch (NoClassDefFoundError notThere) {
                LOG.error((Object)("Could not find class named : " + className));
                return false;
            }
            try {
                instantiatorField = idClass.getField("INSTANTIATOR");
                if (null == instantiatorField) {
                    throw new NoSuchFieldException("getField() result was null for field 'INSTANTIATOR'");
                }
            }
            catch (NoSuchFieldException notThere) {
                LOG.error((Object)("Could not find INSTANTIATOR field in class named : " + className));
                return false;
            }
            if (!(class$net$jxta$id$IDFactory$Instantiator == null ? (class$net$jxta$id$IDFactory$Instantiator = IDFactory.class$("net.jxta.id.IDFactory$Instantiator")) : class$net$jxta$id$IDFactory$Instantiator).isAssignableFrom(instantiatorField.getType())) {
                throw new ClassCastException("INSTANTIATOR is not of type " + (class$net$jxta$id$IDFactory$Instantiator == null ? (class$net$jxta$id$IDFactory$Instantiator = IDFactory.class$("net.jxta.id.IDFactory$Instantiator")) : class$net$jxta$id$IDFactory$Instantiator).getName());
            }
            Instantiator instantiator = (Instantiator)instantiatorField.get(null);
            if (null == instantiator) {
                LOG.error((Object)("INSTANTIATOR field is null for class  : " + className));
                return false;
            }
            String idType = instantiator.getSupportedIDFormat();
            registeredSomething = this.registerAssoc(idType, instantiator);
        }
        catch (Exception failed) {
            LOG.error((Object)("Failed to register class : " + className), (Throwable)failed);
        }
        return registeredSomething;
    }

    public static String getDefaultIDFormat() {
        return IDFactory.factory.idNewInstances;
    }

    public static ID fromURL(URL source) throws MalformedURLException, UnknownServiceException {
        Instantiator instantiator;
        ID result = null;
        if (!"urn".equalsIgnoreCase(source.getProtocol())) {
            throw new UnknownServiceException("URI protocol type was not as expected.");
        }
        String encoded = source.getFile();
        String decoded = Handler.decodeURN(encoded);
        int colonAt = decoded.indexOf(58);
        if (-1 == colonAt) {
            throw new UnknownServiceException("URN namespace was missing.");
        }
        if (!"jxta".equalsIgnoreCase(decoded.substring(0, colonAt))) {
            throw new UnknownServiceException("URN namespace was not as expected. (jxta!=" + decoded.substring(0, colonAt) + ")");
        }
        int dashAt = (decoded = decoded.substring(colonAt + 1)).indexOf(45);
        if (-1 == dashAt) {
            throw new UnknownServiceException("URN Encodingtype was missing.");
        }
        decoded = decoded.substring(0, dashAt);
        try {
            instantiator = (Instantiator)factory.getInstantiator(decoded);
        }
        catch (NoSuchElementException itsUnknown) {
            instantiator = (Instantiator)factory.getInstantiator("unknown");
        }
        result = instantiator.fromURL(source);
        return result;
    }

    public static CodatID newCodatID(PeerGroupID groupID) {
        String useFormat = groupID.getIDFormat();
        if (IDFormat.INSTANTIATOR.getSupportedIDFormat().equals(useFormat)) {
            useFormat = IDFactory.factory.idNewInstances;
        }
        Instantiator instantiator = (Instantiator)factory.getInstantiator(useFormat);
        return instantiator.newCodatID(groupID);
    }

    public static CodatID newCodatID(PeerGroupID groupID, byte[] seed) {
        String useFormat = groupID.getIDFormat();
        if (IDFormat.INSTANTIATOR.getSupportedIDFormat().equals(useFormat)) {
            useFormat = IDFactory.factory.idNewInstances;
        }
        Instantiator instantiator = (Instantiator)factory.getInstantiator(useFormat);
        return instantiator.newCodatID(groupID, seed);
    }

    public static CodatID newCodatID(PeerGroupID groupID, InputStream in) throws IOException {
        String useFormat = groupID.getIDFormat();
        if (IDFormat.INSTANTIATOR.getSupportedIDFormat().equals(useFormat)) {
            useFormat = IDFactory.factory.idNewInstances;
        }
        Instantiator instantiator = (Instantiator)factory.getInstantiator(useFormat);
        return instantiator.newCodatID(groupID, in);
    }

    public static CodatID newCodatID(PeerGroupID groupID, byte[] seed, InputStream in) throws IOException {
        String useFormat = groupID.getIDFormat();
        if (IDFormat.INSTANTIATOR.getSupportedIDFormat().equals(useFormat)) {
            useFormat = IDFactory.factory.idNewInstances;
        }
        Instantiator instantiator = (Instantiator)factory.getInstantiator(useFormat);
        return instantiator.newCodatID(groupID, seed, in);
    }

    public static PeerID newPeerID(PeerGroupID groupID) {
        String useFormat = groupID.getIDFormat();
        if (IDFormat.INSTANTIATOR.getSupportedIDFormat().equals(useFormat)) {
            useFormat = IDFactory.factory.idNewInstances;
        }
        Instantiator instantiator = (Instantiator)factory.getInstantiator(useFormat);
        return instantiator.newPeerID(groupID);
    }

    public static PeerID newPeerID(PeerGroupID groupID, byte[] seed) {
        String useFormat = groupID.getIDFormat();
        if (IDFormat.INSTANTIATOR.getSupportedIDFormat().equals(useFormat)) {
            useFormat = IDFactory.factory.idNewInstances;
        }
        Instantiator instantiator = (Instantiator)factory.getInstantiator(useFormat);
        return instantiator.newPeerID(groupID, seed);
    }

    public static PeerGroupID newPeerGroupID() {
        return IDFactory.newPeerGroupID(IDFactory.factory.idNewInstances);
    }

    public static PeerGroupID newPeerGroupID(String idformat) {
        Instantiator instantiator = (Instantiator)factory.getInstantiator(idformat);
        return instantiator.newPeerGroupID();
    }

    public static PeerGroupID newPeerGroupID(byte[] seed) {
        return IDFactory.newPeerGroupID(IDFactory.factory.idNewInstances, seed);
    }

    public static PeerGroupID newPeerGroupID(String idformat, byte[] seed) {
        Instantiator instantiator = (Instantiator)factory.getInstantiator(idformat);
        return instantiator.newPeerGroupID(seed);
    }

    public static PeerGroupID newPeerGroupID(PeerGroupID parent) {
        String useFormat = parent.getIDFormat();
        if (IDFormat.INSTANTIATOR.getSupportedIDFormat().equals(useFormat)) {
            useFormat = IDFactory.factory.idNewInstances;
        }
        Instantiator instantiator = (Instantiator)factory.getInstantiator(useFormat);
        return instantiator.newPeerGroupID(parent);
    }

    public static PeerGroupID newPeerGroupID(PeerGroupID parent, byte[] seed) {
        String useFormat = parent.getIDFormat();
        if (IDFormat.INSTANTIATOR.getSupportedIDFormat().equals(useFormat)) {
            useFormat = IDFactory.factory.idNewInstances;
        }
        Instantiator instantiator = (Instantiator)factory.getInstantiator(useFormat);
        return instantiator.newPeerGroupID(parent, seed);
    }

    public static PipeID newPipeID(PeerGroupID groupID) {
        String useFormat = groupID.getIDFormat();
        if (IDFormat.INSTANTIATOR.getSupportedIDFormat().equals(useFormat)) {
            useFormat = IDFactory.factory.idNewInstances;
        }
        Instantiator instantiator = (Instantiator)factory.getInstantiator(useFormat);
        return instantiator.newPipeID(groupID);
    }

    public static PipeID newPipeID(PeerGroupID groupID, byte[] seed) {
        String useFormat = groupID.getIDFormat();
        if (IDFormat.INSTANTIATOR.getSupportedIDFormat().equals(useFormat)) {
            useFormat = IDFactory.factory.idNewInstances;
        }
        Instantiator instantiator = (Instantiator)factory.getInstantiator(useFormat);
        return instantiator.newPipeID(groupID, seed);
    }

    public static ModuleClassID newModuleClassID() {
        return IDFactory.newModuleClassID(IDFactory.factory.idNewInstances);
    }

    public static ModuleClassID newModuleClassID(String idformat) {
        Instantiator instantiator = (Instantiator)factory.getInstantiator(idformat);
        return instantiator.newModuleClassID();
    }

    public static ModuleClassID newModuleClassID(ModuleClassID baseClass) {
        String useFormat = baseClass.getIDFormat();
        if (IDFormat.INSTANTIATOR.getSupportedIDFormat().equals(useFormat)) {
            useFormat = IDFactory.factory.idNewInstances;
        }
        Instantiator instantiator = (Instantiator)factory.getInstantiator(useFormat);
        return instantiator.newModuleClassID(baseClass);
    }

    public static ModuleSpecID newModuleSpecID(ModuleClassID baseClass) {
        String useFormat = baseClass.getIDFormat();
        if (IDFormat.INSTANTIATOR.getSupportedIDFormat().equals(useFormat)) {
            useFormat = IDFactory.factory.idNewInstances;
        }
        Instantiator instantiator = (Instantiator)factory.getInstantiator(useFormat);
        return instantiator.newModuleSpecID(baseClass);
    }

    public static URL jxtaURL(String protocol, String host, String file) throws MalformedURLException {
        return new URL(protocol, host, -1, file, Handler.handler);
    }

    public static URL jxtaURL(String uri) throws MalformedURLException {
        String file = "jxta:";
        URL urlCnxt = IDFactory.jxtaURL("urn", "", "jxta:");
        return new URL(urlCnxt, uri);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static interface Instantiator {
        public String getSupportedIDFormat();

        public ID fromURL(URL var1) throws MalformedURLException, UnknownServiceException;

        public CodatID newCodatID(PeerGroupID var1);

        public CodatID newCodatID(PeerGroupID var1, byte[] var2);

        public CodatID newCodatID(PeerGroupID var1, InputStream var2) throws IOException;

        public CodatID newCodatID(PeerGroupID var1, byte[] var2, InputStream var3) throws IOException;

        public PeerID newPeerID(PeerGroupID var1);

        public PeerID newPeerID(PeerGroupID var1, byte[] var2);

        public PeerGroupID newPeerGroupID();

        public PeerGroupID newPeerGroupID(byte[] var1);

        public PeerGroupID newPeerGroupID(PeerGroupID var1);

        public PeerGroupID newPeerGroupID(PeerGroupID var1, byte[] var2);

        public PipeID newPipeID(PeerGroupID var1);

        public PipeID newPipeID(PeerGroupID var1, byte[] var2);

        public ModuleClassID newModuleClassID();

        public ModuleClassID newModuleClassID(ModuleClassID var1);

        public ModuleSpecID newModuleSpecID(ModuleClassID var1);
    }
}

