/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.cm;

import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownServiceException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import java.util.TreeSet;
import java.util.Vector;
import net.jxta.credential.Credential;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.id.IDFactory;
import net.jxta.impl.cm.SrdiIndex;
import net.jxta.impl.protocol.ResolverSrdiMsgImpl;
import net.jxta.impl.protocol.SrdiMessageImpl;
import net.jxta.impl.util.JxtaHash;
import net.jxta.membership.MembershipService;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.protocol.RdvAdvertisement;
import net.jxta.protocol.ResolverQueryMsg;
import net.jxta.protocol.SrdiMessage;
import net.jxta.rendezvous.RendezvousEvent;
import net.jxta.rendezvous.RendezvousListener;
import net.jxta.resolver.ResolverService;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class Srdi
implements Runnable,
RendezvousListener {
    private static final Logger LOG = Logger.getLogger((String)(class$net$jxta$impl$cm$Srdi == null ? (class$net$jxta$impl$cm$Srdi = Srdi.class$("net.jxta.impl.cm.Srdi")) : class$net$jxta$impl$cm$Srdi).getName());
    private PeerGroup group;
    private String handlername;
    private SrdiInterface srdiService;
    private SrdiIndex srdiIndex;
    private long connectPollInterval;
    private long pushInterval;
    private volatile boolean stop;
    private volatile boolean republish;
    private ResolverService resolver;
    private JxtaHash jxtaHash;
    private StructuredDocument credentialDoc;
    private static Random random = new Random();
    public static final int RPV_REPLICATION_THRESHOLD = 3;
    static /* synthetic */ Class class$net$jxta$impl$cm$Srdi;

    public Srdi(PeerGroup group, String handlername, SrdiInterface srdiService, SrdiIndex srdiIndex, long connectPollInterval, long pushInterval) {
        block2: {
            this.group = null;
            this.handlername = null;
            this.srdiService = null;
            this.connectPollInterval = 0L;
            this.pushInterval = 0L;
            this.stop = false;
            this.republish = true;
            this.jxtaHash = new JxtaHash();
            this.credentialDoc = null;
            this.group = group;
            this.handlername = handlername;
            this.srdiService = srdiService;
            this.srdiIndex = srdiIndex;
            this.connectPollInterval = connectPollInterval;
            this.pushInterval = pushInterval;
            MembershipService membership = group.getMembershipService();
            this.resolver = group.getResolverService();
            group.getRendezVousService().addListener(this);
            try {
                Credential credential = membership.getDefaultCredential();
                this.credentialDoc = credential.getDocument(MimeMediaType.XMLUTF8);
            }
            catch (Exception e) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block2;
                LOG.warn((Object)"failed to get credential", (Throwable)e);
            }
        }
    }

    public synchronized void stop() {
        if (this.stop) {
            return;
        }
        this.stop = true;
        this.group.getRendezVousService().removeListener(this);
        this.notify();
    }

    public void replicateEntries(SrdiMessage srdiMsg) {
        Vector rpv = this.getGlobalPeerView();
        if (srdiMsg.getTTL() < 1 || !this.group.isRendezvous() || rpv.size() < 3) {
            return;
        }
        Vector entries = srdiMsg.getEntries();
        HashMap<PeerID, SrdiMessageImpl> bins = new HashMap<PeerID, SrdiMessageImpl>(rpv.size());
        if (entries != null) {
            int i = 0;
            while (i < entries.size()) {
                SrdiMessage.Entry entry = (SrdiMessage.Entry)entries.get(i);
                PeerID destPeer = this.getReplicaPeer(srdiMsg.getPrimaryKey() + entry.key + entry.value);
                if (destPeer != null && !destPeer.equals(this.group.getPeerID())) {
                    SrdiMessageImpl sm = (SrdiMessageImpl)bins.get(destPeer);
                    if (sm == null) {
                        sm = new SrdiMessageImpl();
                        sm.setPrimaryKey(srdiMsg.getPrimaryKey());
                        sm.setPeerID(srdiMsg.getPeerID());
                        bins.put(destPeer, sm);
                    }
                    sm.addEntry(entry);
                }
                ++i;
            }
        }
        Iterator peers = bins.keySet().iterator();
        while (peers.hasNext()) {
            PeerID destPeer = (PeerID)peers.next();
            SrdiMessageImpl msg = (SrdiMessageImpl)bins.get(destPeer);
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("[" + this.group.getPeerGroupName() + " / " + this.handlername + "] Forwarding replica Srdi to :" + destPeer.toString()));
            }
            this.pushSrdi(destPeer.toString(), msg);
        }
    }

    public void pushSrdi(String peer, SrdiMessage srdi) {
        block2: {
            try {
                ResolverSrdiMsgImpl resSrdi = new ResolverSrdiMsgImpl(this.handlername, this.group, srdi.toString());
                this.resolver.sendSrdi(peer, resSrdi);
            }
            catch (Exception e) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block2;
                LOG.warn((Object)"failed to send", (Throwable)e);
            }
        }
    }

    public void forwardQuery(Object peer, ResolverQueryMsg query) {
        query.incrementHopCount();
        if (query.getHopCount() > 2) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("hopCount exceeded. Not forwarding query " + query.getHopCount()));
            }
            return;
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("[" + this.group.getPeerGroupName() + " / " + this.handlername + "] Forwarding Query to :" + peer + " Destination :" + query.getHandlerName()));
        }
        this.resolver.sendQuery(peer.toString(), query);
    }

    public void forwardQuery(Vector peers, ResolverQueryMsg query) {
        query.incrementHopCount();
        if (query.getHopCount() > 2) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("hopCount exceeded not forwarding query " + query.getHopCount()));
            }
            return;
        }
        int i = 0;
        while (i < peers.size()) {
            PeerID peer = (PeerID)peers.elementAt(i);
            String destPeer = peer.toString();
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("[" + this.group.getPeerGroupName() + " / " + this.handlername + "] Forwarding Query to :" + destPeer + " Destination :" + query.getHandlerName()));
            }
            this.resolver.sendQuery(destPeer, query);
            ++i;
        }
    }

    public void forwardQuery(Vector peers, ResolverQueryMsg query, int threshold) {
        if (query.getHopCount() > 2) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("[" + this.group.getPeerGroupName() + " / " + this.handlername + "] hopCount exceeded not forwarding query " + query.getHopCount()));
            }
            return;
        }
        if (peers.size() <= threshold) {
            this.forwardQuery(peers, query);
        } else {
            Vector newPeers = this.randomResult(peers, threshold);
            this.forwardQuery(newPeers, query);
        }
    }

    protected Vector randomResult(Vector result, int threshold) {
        if (threshold < result.size()) {
            Vector res = new Vector(threshold);
            int i = 0;
            while (i < threshold) {
                int rand = random.nextInt(result.size());
                res.addElement(result.elementAt(rand));
                result.removeElementAt(rand);
                ++i;
            }
            return res;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PeerID getReplicaPeer(String expression) {
        PeerID pid = null;
        Vector rpv = this.getGlobalPeerView();
        if (rpv.size() >= 3) {
            BigInteger digest = null;
            Srdi srdi = this;
            synchronized (srdi) {
                this.jxtaHash.update(expression);
                digest = this.jxtaHash.getDigestInteger().abs();
            }
            BigInteger sizeOfSpace = BigInteger.valueOf(rpv.size());
            BigInteger sizeOfHashSpace = BigInteger.ONE.shiftLeft(8 * digest.toByteArray().length);
            int pos = digest.multiply(sizeOfSpace).divide(sizeOfHashSpace).intValue();
            pid = (PeerID)rpv.elementAt(pos);
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("[" + this.group.getPeerGroupName() + " / " + this.handlername + "] Found a direct peer: " + pid));
            }
            return pid;
        }
        return null;
    }

    public void forwardSrdiMessage(PeerID peerid, PeerID srcPid, String primaryKey, String secondarykey, String value, long expiration) {
        block3: {
            try {
                SrdiMessageImpl srdi = new SrdiMessageImpl(srcPid, 0, primaryKey, secondarykey, value, expiration);
                ResolverSrdiMsgImpl resSrdi = new ResolverSrdiMsgImpl(this.handlername, this.group, srdi.toString());
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("[" + this.group.getPeerGroupName() + " / " + this.handlername + "] Forwarding a SRDI messsage of type " + primaryKey + " to " + peerid));
                }
                this.resolver.sendSrdi(peerid.toString(), resSrdi);
            }
            catch (Exception e) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block3;
                LOG.warn((Object)"Failed forwarding SRDI Message", (Throwable)e);
            }
        }
    }

    public synchronized void rendezvousEvent(RendezvousEvent event) {
        int theEventType = event.getType();
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("[" + this.group.getPeerGroupName() + " / " + this.handlername + "] Processing RDV event : " + theEventType));
        }
        switch (theEventType) {
            case 0: {
                this.republish = true;
                this.notify();
                break;
            }
            case 1: {
                this.notify();
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 4: 
            case 5: {
                this.republish = true;
                break;
            }
            case 6: 
            case 7: 
            case 11: 
            case 12: {
                if (!this.group.isRendezvous() || this.srdiIndex == null) break;
                this.srdiIndex.remove(Srdi.createPeerID(event.getPeer()));
                break;
            }
            default: {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) break;
                LOG.warn((Object)("[" + this.group.getPeerGroupName() + " / " + this.handlername + "] Unexpected RDV event : " + theEventType + " for " + event.getPeer()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void run() {
        try {
            while (true) {
                if (this.stop) {
                    return;
                }
                boolean waitingForRdv = this.group.isRendezvous() || !this.group.getRendezVousService().isConnectedToRendezVous();
                this.republish |= waitingForRdv;
                Srdi srdi = this;
                // MONITORENTER : srdi
                if (waitingForRdv) {
                    try {
                        this.wait(this.connectPollInterval);
                    }
                    catch (InterruptedException e) {
                        Thread.interrupted();
                    }
                    continue;
                }
                if (!this.republish) {
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("[" + this.group.getPeerGroupName() + " / " + this.handlername + "] Sleeping for " + this.pushInterval + "ms before sending deltas."));
                    }
                    try {
                        this.wait(this.pushInterval);
                    }
                    catch (InterruptedException e) {
                        Thread.interrupted();
                        // MONITOREXIT : srdi
                        continue;
                    }
                    if (this.stop) {
                        // MONITOREXIT : srdi
                        return;
                    }
                }
                // MONITOREXIT : srdi
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("[" + this.group.getPeerGroupName() + " / " + this.handlername + "] Pushing " + (this.republish ? "all entries" : "deltas")));
                }
                this.srdiService.pushEntries(this.republish);
                this.republish = false;
            }
        }
        catch (Throwable all) {
            if (!LOG.isEnabledFor((Priority)Level.ERROR)) return;
            LOG.error((Object)("Uncaught Throwable in " + Thread.currentThread().getName() + "[" + this.group.getPeerGroupName() + " / " + this.handlername + "]"), all);
            return;
        }
    }

    protected static PeerID createPeerID(String id) {
        PeerID pid = null;
        try {
            pid = (PeerID)IDFactory.fromURL(IDFactory.jxtaURL(id));
        }
        catch (MalformedURLException badID) {
            throw new IllegalArgumentException("Invalid ID");
        }
        catch (UnknownServiceException badID) {
            throw new IllegalArgumentException("Unusable ID");
        }
        catch (ClassCastException badID) {
            throw new IllegalArgumentException("not a PeerID");
        }
        return pid;
    }

    public Vector getGlobalPeerView() {
        Vector<PeerID> global = new Vector<PeerID>();
        TreeSet<String> set = new TreeSet<String>();
        try {
            Vector rpv = this.group.getRendezVousService().getLocalWalkView();
            int i = 0;
            while (i < rpv.size()) {
                RdvAdvertisement padv = (RdvAdvertisement)rpv.elementAt(i);
                set.add(padv.getPeerID().toString());
                ++i;
            }
            PeerID mid = this.group.getPeerID();
            set.add(mid.toString());
            PeerID id = null;
            Iterator it = set.iterator();
            while (it.hasNext()) {
                try {
                    URL pID = IDFactory.jxtaURL((String)it.next());
                    if (pID == null || (id = (PeerID)IDFactory.fromURL(pID)) == null) continue;
                    global.add(id);
                }
                catch (MalformedURLException badID) {
                    throw new IllegalArgumentException("Bad PeerID ID in advertisement");
                }
                catch (UnknownServiceException badID) {
                    throw new IllegalArgumentException("Unusable ID in advertisement");
                }
                catch (ClassCastException badID) {
                    throw new IllegalArgumentException("ID was not a peerID");
                }
            }
            return global;
        }
        catch (Exception ex) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)"exception generating the global view", (Throwable)ex);
            }
            return global;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static interface SrdiInterface {
        public void pushEntries(boolean var1);
    }
}

