/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.cm;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import net.jxta.impl.cm.Cm;
import net.jxta.impl.cm.Indexer;
import net.jxta.impl.cm.Srdi;
import net.jxta.impl.util.TimeUtils;
import net.jxta.impl.xindice.core.DBException;
import net.jxta.impl.xindice.core.data.Key;
import net.jxta.impl.xindice.core.data.Record;
import net.jxta.impl.xindice.core.data.Value;
import net.jxta.impl.xindice.core.filer.BTreeCallback;
import net.jxta.impl.xindice.core.filer.BTreeFiler;
import net.jxta.impl.xindice.core.indexer.IndexQuery;
import net.jxta.impl.xindice.core.indexer.NameIndexer;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class SrdiIndex
implements Runnable {
    private static final Logger LOG = Logger.getLogger((String)(class$net$jxta$impl$cm$SrdiIndex == null ? (class$net$jxta$impl$cm$SrdiIndex = SrdiIndex.class$("net.jxta.impl.cm.SrdiIndex")) : class$net$jxta$impl$cm$SrdiIndex).getName());
    private Hashtable caches = new Hashtable();
    private long interval = 600000L;
    private volatile boolean stop = false;
    private Indexer srdiIndexer = null;
    private BTreeFiler cacheDB = null;
    private Thread gcThread = null;
    private String indexName;
    static /* synthetic */ Class class$net$jxta$impl$cm$SrdiIndex;

    public SrdiIndex(PeerGroup group, String indexName) {
        this.indexName = indexName;
        try {
            String pgdir = null;
            pgdir = group == null ? "srdi-index" : group.getPeerGroupID().getUniqueValue().toString();
            File rootDir = new File(Cm.RootDirBase, pgdir);
            rootDir = new File(rootDir, "srdi");
            if (!rootDir.exists() && !rootDir.mkdirs()) {
                throw new RuntimeException("Cm cannot create directory " + rootDir);
            }
            this.cacheDB = new BTreeFiler();
            this.cacheDB.setSync(false);
            this.cacheDB.setLocation(rootDir.getCanonicalPath(), indexName);
            if (!this.cacheDB.open()) {
                this.cacheDB.create();
                this.cacheDB.open();
            }
            this.srdiIndexer = new Indexer(false);
            this.srdiIndexer.setLocation(rootDir.getCanonicalPath(), indexName);
            if (!this.srdiIndexer.open()) {
                this.srdiIndexer.create();
                this.srdiIndexer.open();
            }
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)(indexName + " SrdiIndex initialized under group " + (group == null ? "none" : group.getPeerGroupName())));
            }
        }
        catch (DBException de) {
            if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                LOG.fatal((Object)"Unable to Initialize databases", (Throwable)de);
            }
            throw new UndeclaredThrowableException(de, "Unable to Initialize databases");
        }
        catch (Throwable e) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)"Unable to create Cm", e);
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new UndeclaredThrowableException(e, "Unable to create Cm");
        }
    }

    public SrdiIndex(PeerGroup group, String indexName, long interval) {
        this(group, indexName);
        this.interval = interval;
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Starting SrdiIndex thread for " + indexName));
        }
        this.startGC(group, indexName, interval);
    }

    protected void startGC(PeerGroup group, String indexName, long interval) {
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Starting SrdiIndex thread for " + indexName));
        }
        this.gcThread = new Thread(group.getHomeThreadGroup(), this, "SrdiIndex :" + indexName + " GC every " + interval + "ms");
        this.gcThread.setDaemon(true);
        this.gcThread.start();
    }

    public String getIndexName() {
        return this.indexName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void add(String primaryKey, String attribute, String value, PeerID pid, long expiration) {
        block12: {
            try {
                Key key = new Key(primaryKey + attribute + value);
                long expiresin = TimeUtils.toAbsoluteTimeMillis(expiration);
                BTreeFiler bTreeFiler = this.cacheDB;
                synchronized (bTreeFiler) {
                    Record record = this.cacheDB.readRecord(key);
                    ArrayList old = record != null ? SrdiIndex.readRecord(record) : new ArrayList();
                    Entry entry = new Entry(pid, expiresin);
                    if (!old.contains(entry)) {
                        old.add(entry);
                    } else {
                        old.remove(old.indexOf(entry));
                        old.add(entry);
                    }
                    old = SrdiIndex.removeExpired(old);
                    long t0 = System.currentTimeMillis();
                    byte[] data = SrdiIndex.getData(old);
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("Serialized result in:" + (System.currentTimeMillis() - t0)));
                    }
                    if (data == null) {
                        if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                            LOG.error((Object)"Failed to serialize data");
                        }
                        return;
                    }
                    Value recordValue = new Value(data);
                    long pos = this.cacheDB.writeRecord(key, recordValue);
                    Map indexables = this.getIndexMap(primaryKey + attribute, value);
                    this.srdiIndexer.addToIndex(indexables, pos);
                }
            }
            catch (IOException de) {
                if (LOG.isEnabledFor((Priority)Level.WARN)) {
                    LOG.warn((Object)"Failed to add SRDI", (Throwable)de);
                }
            }
            catch (DBException de) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block12;
                LOG.warn((Object)"Failed to add SRDI", (Throwable)de);
            }
        }
    }

    private Map getIndexMap(String primaryKey, String value) {
        if (primaryKey == null) {
            return null;
        }
        if (value == null) {
            value = "";
        }
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put(primaryKey, value.toUpperCase());
        return map;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void remove(PeerID pid) {
        try {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Attempting to remove references to Peer : " + pid.toString()));
            }
            Map map = this.srdiIndexer.getIndexers();
            Iterator it = map.keySet().iterator();
            while (it != null) {
                if (!it.hasNext()) {
                    return;
                }
                String indexName = (String)it.next();
                NameIndexer idxr = (NameIndexer)map.get(indexName);
                idxr.query(null, new PurgePeerCallback(this.cacheDB, pid));
            }
            return;
        }
        catch (Exception ex) {
            if (!LOG.isEnabledFor((Priority)Level.WARN)) return;
            LOG.warn((Object)("Failure during removal of " + pid.toString()), (Throwable)ex);
            return;
        }
    }

    public synchronized Vector query(String primaryKey, String attribute, String value, int threshold) {
        Vector res;
        block6: {
            res = new Vector();
            if (primaryKey == null) {
                return res;
            }
            if (attribute == null) {
                return this.query(primaryKey);
            }
            IndexQuery iq = Cm.getIndexQuery(value);
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Srdi.query starts for pkey: " + primaryKey + " Attribute :" + attribute + " Value :" + value));
            }
            try {
                this.srdiIndexer.search(iq, primaryKey + attribute, new SearchCallback(this.cacheDB, res, threshold));
            }
            catch (Exception ex) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block6;
                LOG.warn((Object)"Exception while searching in index", (Throwable)ex);
            }
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("returning :" + res.size() + " for Srdi.query pkey: " + primaryKey + " Attribute :" + attribute + " Value :" + value));
        }
        return res;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized Vector query(String primaryKey) {
        Vector res = new Vector();
        try {
            Map map = this.srdiIndexer.getIndexers();
            Iterator it = map.keySet().iterator();
            while (it != null) {
                if (!it.hasNext()) {
                    return res;
                }
                String indexName = (String)it.next();
                if (!indexName.startsWith(primaryKey)) continue;
                NameIndexer idxr = (NameIndexer)map.get(indexName);
                idxr.query(null, new SearchCallback(this.cacheDB, res, Integer.MAX_VALUE));
            }
            return res;
        }
        catch (Exception ex) {
            if (!LOG.isEnabledFor((Priority)Level.WARN)) return res;
            LOG.warn((Object)"Exception while searching in index", (Throwable)ex);
            return res;
        }
    }

    private static void copyIntoVector(Vector to, ArrayList from) {
        int i = 0;
        while (i < from.size()) {
            Entry entry = (Entry)from.get(i);
            boolean expired = SrdiIndex.isExpired(entry.expiration);
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Entry peerid :" + entry.peerid + " Expires in :" + entry.expiration));
                LOG.debug((Object)("Entry expired " + expired));
            }
            if (!to.contains(entry.peerid) && !expired) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("adding Entry :" + entry.peerid + "  to list"));
                }
                to.add(entry.peerid);
            } else if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Skipping expired Entry :" + entry.peerid));
            }
            ++i;
        }
    }

    public static byte[] getData(ArrayList list) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            dos.writeInt(list.size());
            int i = 0;
            while (i < list.size()) {
                Entry entry = (Entry)list.get(i);
                dos.writeUTF(entry.peerid.toString());
                dos.writeLong(entry.expiration);
                ++i;
            }
            dos.close();
            return bos.toByteArray();
        }
        catch (IOException ie) {
            block3: {
                if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break block3;
                LOG.debug((Object)"Exception while reading Entry", (Throwable)ie);
            }
            return null;
        }
    }

    public static ArrayList readRecord(Record record) {
        ArrayList<Entry> result;
        block7: {
            result = new ArrayList<Entry>();
            if (record == null) {
                return result;
            }
            if (record.getValue().getLength() <= 0) {
                return result;
            }
            InputStream is = record.getValue().getInputStream();
            try {
                DataInputStream ois = new DataInputStream(is);
                int size = ois.readInt();
                int i = 0;
                while (i < size) {
                    String idstr = ois.readUTF();
                    long exp = ois.readLong();
                    PeerID pid = Srdi.createPeerID(idstr);
                    Entry entry = new Entry(pid, exp);
                    result.add(entry);
                    ++i;
                }
                ois.close();
            }
            catch (EOFException eofe) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)"Empty record", (Throwable)eofe);
                }
            }
            catch (IOException ie) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block7;
                LOG.warn((Object)"Exception while reading Entry", (Throwable)ie);
            }
        }
        return result;
    }

    public synchronized void clear() {
        block2: {
            try {
                this.srdiIndexer.close();
                this.cacheDB.close();
            }
            catch (Exception e) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block2;
                LOG.warn((Object)"failed to close index", (Throwable)e);
            }
        }
    }

    public synchronized void garbageCollect() {
        block3: {
            try {
                Map map = this.srdiIndexer.getIndexers();
                Iterator it = map.keySet().iterator();
                while (it.hasNext()) {
                    String indexName = (String)it.next();
                    NameIndexer idxr = (NameIndexer)map.get(indexName);
                    idxr.query(null, new GcCallback(this.cacheDB));
                }
            }
            catch (Exception ex) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block3;
                LOG.warn((Object)"Failure during SRDI Garbage Collect", (Throwable)ex);
            }
        }
    }

    private static ArrayList removeExpired(ArrayList list) {
        int i = 0;
        while (i < list.size()) {
            Entry entry = (Entry)list.get(i);
            boolean expired = SrdiIndex.isExpired(entry.expiration);
            if (expired) {
                list.remove(i);
                --i;
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("Entry peerid :" + entry.peerid + " Expires in :" + entry.expiration));
                    LOG.debug((Object)("Entry expired " + expired));
                }
            }
            ++i;
        }
        return list;
    }

    public void removeKey(String primaryKey, String secondaryKey) {
        Hashtable caTbl;
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("removing entries of pkey [" + primaryKey + "] skey[" + secondaryKey + "]"));
        }
        if ((caTbl = (Hashtable)this.caches.get(primaryKey)) != null) {
            caTbl.remove(secondaryKey);
        }
    }

    private static boolean isExpired(long expiration) {
        return expiration < System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() {
        block8: {
            block7: {
                this.stop = true;
                try {
                    Thread temp = this.gcThread;
                    if (temp == null) break block7;
                    Thread thread = temp;
                    synchronized (thread) {
                        temp.notify();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            try {
                this.srdiIndexer.close();
                this.cacheDB.close();
            }
            catch (Exception ex) {
                if (!LOG.isEnabledFor((Priority)Level.ERROR)) break block8;
                LOG.error((Object)"Unable to stop the Srdi Indexer", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            try {
                while (!this.stop) {
                    try {
                        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                            LOG.debug((Object)("Waiting for " + this.interval + " before garbage collection"));
                        }
                        SrdiIndex srdiIndex = this;
                        synchronized (srdiIndex) {
                            this.wait(this.interval);
                        }
                    }
                    catch (InterruptedException woken) {
                        Thread.interrupted();
                        continue;
                    }
                    if (!this.stop) {
                        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                            LOG.debug((Object)"Garbage collection started");
                        }
                        this.garbageCollect();
                        if (!LOG.isEnabledFor((Priority)Level.DEBUG)) continue;
                        LOG.debug((Object)"Garbage collection completed");
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable all) {
                if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                    LOG.error((Object)("Uncaught Throwable in thread :" + Thread.currentThread().getName()), all);
                }
                Object var4_5 = null;
                this.gcThread = null;
                return;
            }
            Object var4_4 = null;
            this.gcThread = null;
            return;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.gcThread = null;
            throw throwable;
        }
    }

    public static void clearSrdi(PeerGroup group) {
        block6: {
            try {
                String pgdir = null;
                pgdir = group == null ? "srdi-index" : group.getPeerGroupID().getUniqueValue().toString();
                File rootDir = new File(Cm.RootDirBase, pgdir);
                rootDir = new File(rootDir, "srdi");
                if (rootDir.exists()) {
                    String[] list = rootDir.list();
                    int i = 0;
                    while (i < list.length) {
                        File file;
                        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                            LOG.debug((Object)("Removing : " + list[i]));
                        }
                        if (!(file = new File(rootDir, list[i])).delete() && LOG.isEnabledFor((Priority)Level.WARN)) {
                            LOG.warn((Object)"Unable to delete the file");
                        }
                        ++i;
                    }
                    rootDir.delete();
                }
            }
            catch (Throwable t) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block6;
                LOG.warn((Object)"Unable to clear Srdi", t);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static final class Entry {
        public PeerID peerid;
        public long expiration;

        public Entry(PeerID peerid, long expiration) {
            this.peerid = peerid;
            this.expiration = expiration;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Entry) {
                return this.peerid.equals(((Entry)obj).peerid);
            }
            return false;
        }

        public int hashCode() {
            return this.peerid.hashCode();
        }
    }

    private static final class PurgePeerCallback
    implements BTreeCallback {
        private BTreeFiler cacheDB = null;
        private PeerID peerid = null;

        PurgePeerCallback(BTreeFiler cacheDB, PeerID peerid) {
            this.cacheDB = cacheDB;
            this.peerid = peerid;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean indexInfo(Value val, long pos) {
            Record record = null;
            BTreeFiler bTreeFiler = this.cacheDB;
            synchronized (bTreeFiler) {
                block14: {
                    try {
                        record = this.cacheDB.readRecord(pos);
                    }
                    catch (DBException ex) {
                        if (LOG.isEnabledFor((Priority)Level.WARN)) {
                            LOG.warn((Object)"Exception while reading indexed", (Throwable)ex);
                        }
                        return false;
                    }
                    if (record == null) {
                        return true;
                    }
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("PurgePeerCallback :" + pos));
                    }
                    ArrayList res = SrdiIndex.readRecord(record);
                    boolean changed = false;
                    int i = 0;
                    while (i < res.size()) {
                        Entry entry = (Entry)res.get(i);
                        if (entry.peerid.equals(this.peerid)) {
                            res.remove(i);
                            changed = true;
                            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                                LOG.debug((Object)("Removed position :" + pos));
                            }
                        }
                        ++i;
                    }
                    if (changed) {
                        byte[] data = SrdiIndex.getData(res);
                        Value recordValue = new Value(data);
                        try {
                            this.cacheDB.writeRecord(pos, recordValue);
                        }
                        catch (DBException ex) {
                            if (!LOG.isEnabledFor((Priority)Level.WARN)) break block14;
                            LOG.warn((Object)"Exception while writing back record", (Throwable)ex);
                        }
                    }
                }
            }
            return true;
        }
    }

    private static final class GcCallback
    implements BTreeCallback {
        private BTreeFiler cacheDB = null;

        GcCallback(BTreeFiler cacheDB) {
            this.cacheDB = cacheDB;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean indexInfo(Value val, long pos) {
            Record record = null;
            BTreeFiler bTreeFiler = this.cacheDB;
            synchronized (bTreeFiler) {
                block12: {
                    try {
                        record = this.cacheDB.readRecord(pos);
                    }
                    catch (DBException ex) {
                        if (LOG.isEnabledFor((Priority)Level.WARN)) {
                            LOG.warn((Object)"Exception while reading indexed", (Throwable)ex);
                        }
                        return false;
                    }
                    if (record == null) {
                        return true;
                    }
                    ArrayList res = SrdiIndex.readRecord(record);
                    boolean changed = false;
                    int i = 0;
                    while (i < res.size()) {
                        Entry entry = (Entry)res.get(i);
                        if (SrdiIndex.isExpired(entry.expiration)) {
                            res.remove(i);
                            changed = true;
                        }
                        ++i;
                    }
                    if (changed) {
                        byte[] data = SrdiIndex.getData(res);
                        Value recordValue = new Value(data);
                        try {
                            this.cacheDB.writeRecord(pos, recordValue);
                        }
                        catch (DBException ex) {
                            if (!LOG.isEnabledFor((Priority)Level.WARN)) break block12;
                            LOG.warn((Object)"Exception while writing back record", (Throwable)ex);
                        }
                    }
                }
            }
            return true;
        }
    }

    private static final class SearchCallback
    implements BTreeCallback {
        private BTreeFiler cacheDB = null;
        private int threshold;
        private Vector results;

        SearchCallback(BTreeFiler cacheDB, Vector results, int threshold) {
            this.cacheDB = cacheDB;
            this.threshold = threshold;
            this.results = results;
        }

        public boolean indexInfo(Value val, long pos) {
            if (this.results.size() >= this.threshold) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("SearchCallback.indexInfo reached Threshold :" + this.threshold));
                }
                return false;
            }
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Found " + val.toString()));
            }
            Record record = null;
            try {
                record = this.cacheDB.readRecord(pos);
            }
            catch (DBException ex) {
                if (LOG.isEnabledFor((Priority)Level.WARN)) {
                    LOG.warn((Object)"Exception while reading indexed", (Throwable)ex);
                }
                return false;
            }
            if (record == null) {
                return true;
            }
            long t0 = System.currentTimeMillis();
            ArrayList res = SrdiIndex.readRecord(record);
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Got result back in:" + (System.currentTimeMillis() - t0)));
            }
            SrdiIndex.copyIntoVector(this.results, res);
            return true;
        }
    }
}

