/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.discovery;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import net.jxta.credential.Credential;
import net.jxta.discovery.DiscoveryEvent;
import net.jxta.discovery.DiscoveryListener;
import net.jxta.discovery.DiscoveryService;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredTextDocument;
import net.jxta.endpoint.OutgoingMessageEvent;
import net.jxta.exception.PeerGroupException;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.impl.cm.Cm;
import net.jxta.impl.cm.Srdi;
import net.jxta.impl.cm.SrdiIndex;
import net.jxta.impl.discovery.DiscoveryServiceInterface;
import net.jxta.impl.protocol.DiscoveryQuery;
import net.jxta.impl.protocol.DiscoveryResponse;
import net.jxta.impl.protocol.ResolverQuery;
import net.jxta.impl.protocol.ResolverResponse;
import net.jxta.impl.protocol.SrdiMessageImpl;
import net.jxta.membership.MembershipService;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.protocol.ModuleImplAdvertisement;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.protocol.PeerGroupAdvertisement;
import net.jxta.protocol.ResolverQueryMsg;
import net.jxta.protocol.ResolverResponseMsg;
import net.jxta.protocol.ResolverSrdiMsg;
import net.jxta.protocol.SrdiMessage;
import net.jxta.rendezvous.RendezVousService;
import net.jxta.rendezvous.RendezvousEvent;
import net.jxta.rendezvous.RendezvousListener;
import net.jxta.resolver.QueryHandler;
import net.jxta.resolver.ResolverService;
import net.jxta.resolver.SrdiHandler;
import net.jxta.service.Service;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class DiscoveryServiceImpl
implements DiscoveryService,
QueryHandler,
RendezvousListener,
SrdiHandler,
Srdi.SrdiInterface {
    private static final Logger LOG = Logger.getLogger((String)(class$net$jxta$impl$discovery$DiscoveryServiceImpl == null ? (class$net$jxta$impl$discovery$DiscoveryServiceImpl = DiscoveryServiceImpl.class$("net.jxta.impl.discovery.DiscoveryServiceImpl")) : class$net$jxta$impl$discovery$DiscoveryServiceImpl).getName());
    private static int qid = 0;
    protected Cm cm;
    protected String[] dirname = new String[]{"Peers", "Groups", "Adv"};
    private ResolverService resolver;
    private PeerGroup group = null;
    private String localPeerId = null;
    private Set listeners = new HashSet();
    private Hashtable listenerTable = new Hashtable();
    private ModuleImplAdvertisement implAdvertisement = null;
    private String localPeerAdvStr = null;
    private String handlerName = null;
    private PeerAdvertisement lastPeerAdv = null;
    private int lastModCount = -1;
    private int MaxResponses = 50;
    private boolean isRdv = false;
    private boolean isEdge = false;
    private boolean started = false;
    private MembershipService membership = null;
    private Credential credential = null;
    private StructuredDocument credentialDoc = null;
    private SrdiIndex srdiIndex = null;
    private Srdi srdi = null;
    private Thread srdiThread = null;
    private RendezVousService rendezvous;
    private boolean localonly = false;
    private long initialDelay = 60000L;
    private long runInterval = 30000L;
    private static final String srdiIndexerFileName = "discoverySrdi";
    private DiscoveryService discoveryInterface = null;
    static /* synthetic */ Class class$net$jxta$impl$discovery$DiscoveryServiceImpl;

    private void updatePeerAdvStr() {
        PeerAdvertisement newPadv = this.group.getPeerAdvertisement();
        int newModCount = newPadv.getModCount();
        if (this.lastPeerAdv != newPadv || this.lastModCount != newModCount) {
            this.localPeerAdvStr = this.advToString(newPadv);
            this.lastPeerAdv = newPadv;
            this.lastModCount = newModCount;
        }
    }

    public synchronized Service getInterface() {
        if (this.discoveryInterface == null) {
            this.discoveryInterface = new DiscoveryServiceInterface(this);
        }
        return this.discoveryInterface;
    }

    public Advertisement getImplAdvertisement() {
        return this.implAdvertisement;
    }

    public int getRemoteAdvertisements(String peer, int type, String attribute, String value, int threshold) {
        return this.getRemoteAdvertisements(peer, type, attribute, value, threshold, null);
    }

    public int getRemoteAdvertisements(String peer, int type, String attribute, String value, int threshold, DiscoveryListener listener) {
        if (this.localonly) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"localonly, no network operations performed");
            }
            return DiscoveryServiceImpl.nextQid();
        }
        if (this.resolver == null) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)"resolver has not started yet, query discarded.");
            }
            return DiscoveryServiceImpl.nextQid();
        }
        long t0 = System.currentTimeMillis();
        DiscoveryQuery dquery = new DiscoveryQuery();
        dquery.setDiscoveryType(type);
        dquery.setAttr(attribute);
        dquery.setValue(value);
        dquery.setThreshold(threshold);
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            if (attribute != null && value != null) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("sending query: " + attribute + " = " + value));
                }
            } else if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"sending non-qualified query");
            }
        }
        int myQueryID = DiscoveryServiceImpl.nextQid();
        if (listener != null) {
            this.listenerTable.put(new Integer(myQueryID), listener);
        }
        ResolverQuery query = new ResolverQuery(this.handlerName, this.credentialDoc, this.localPeerId, ((Object)dquery).toString(), myQueryID);
        if (peer == null && this.srdiIndex != null) {
            PeerID destPeer;
            Vector res = this.srdiIndex.query(this.dirname[type], attribute, value, threshold);
            if (res.size() > 0) {
                this.srdi.forwardQuery(res, query, threshold);
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("Srdi forward a query:" + myQueryID + " in :" + (System.currentTimeMillis() - t0)));
                }
                return myQueryID;
            }
            if (this.group.isRendezvous() && attribute != null && value != null && (destPeer = this.srdi.getReplicaPeer(this.dirname[type] + attribute + value)) != null && !destPeer.equals(this.group.getPeerID())) {
                this.srdi.forwardQuery(destPeer, (ResolverQueryMsg)query);
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("Srdi forward:" + myQueryID + " to :" + destPeer + " in :" + (System.currentTimeMillis() - t0)));
                }
                return myQueryID;
            }
        }
        this.resolver.sendQuery(peer, query);
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            if (peer == null) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("Sent a query :" + myQueryID + " in :" + (System.currentTimeMillis() - t0)));
                }
            } else if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Sent a query :" + myQueryID + " to " + peer + " in :" + (System.currentTimeMillis() - t0)));
            }
        }
        return myQueryID;
    }

    public Enumeration getLocalAdvertisements(int type, String attribute, String value) throws IOException {
        if (type > 2 || type < 0) {
            throw new IllegalArgumentException("Unknown Advertisement type");
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("getLocalAdvertisements() of type " + this.dirname[type]));
            if (attribute != null) {
                LOG.debug((Object)("attribute = " + attribute));
            }
            if (value != null) {
                LOG.debug((Object)("value = " + value));
            }
        }
        return this.search(type, attribute, value, Integer.MAX_VALUE, false, null).elements();
    }

    public PeerGroup getGroup() {
        return this.group;
    }

    public int startApp(String[] arg) {
        block8: {
            this.resolver = this.group.getResolverService();
            if (null == this.resolver) {
                return 2;
            }
            this.membership = this.group.getMembershipService();
            this.rendezvous = this.group.getRendezVousService();
            if (!this.localonly) {
                this.resolver.registerHandler(this.handlerName, this);
            }
            if (this.group.isRendezvous()) {
                this.beRendezvous();
            } else {
                this.beEdge();
            }
            if (null != this.rendezvous) {
                this.rendezvous.addListener(this);
            }
            try {
                Enumeration enumeration = this.membership.getCurrentCredentials();
                if (enumeration.hasMoreElements()) {
                    this.credential = (Credential)enumeration.nextElement();
                    this.credentialDoc = this.credential.getDocument(MimeMediaType.XMLUTF8);
                }
            }
            catch (Exception e) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block8;
                LOG.warn((Object)"failed to get credential", (Throwable)e);
            }
        }
        this.started = true;
        return 0;
    }

    public void stopApp() {
        boolean failed = false;
        if (null != this.rendezvous) {
            this.rendezvous.removeListener(this);
        }
        if (this.resolver != null) {
            if (this.resolver.unregisterHandler(this.handlerName) == null) {
                failed = true;
            }
            if (this.group.isRendezvous() && this.resolver.unregisterSrdiHandler(this.handlerName) == null) {
                failed = true;
            }
            if (LOG.isEnabledFor((Priority)Level.DEBUG) && failed) {
                LOG.debug((Object)"failed to unregister discovery from resolver.");
            }
        }
        if (this.srdiThread != null) {
            this.srdi.stop();
            this.srdi = null;
        }
        if (this.cm != null) {
            this.cm.stop();
        }
        this.resolver = null;
        this.group = null;
        this.membership = null;
        this.srdiIndex = null;
        this.srdiThread = null;
        this.rendezvous = null;
    }

    public void init(PeerGroup pg, ID assignedID, Advertisement impl) throws PeerGroupException {
        block11: {
            block10: {
                try {
                    ResourceBundle jxtaRsrcs = ResourceBundle.getBundle("net.jxta.user");
                    String offStr = jxtaRsrcs.getString("impl.discovery.localonly");
                    if (offStr != null) {
                        this.localonly = offStr.equalsIgnoreCase("true");
                    }
                }
                catch (MissingResourceException re) {
                    if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break block10;
                    LOG.debug((Object)"localonly not defined, defaulting to false");
                }
            }
            this.implAdvertisement = (ModuleImplAdvertisement)impl;
            this.group = pg;
            this.handlerName = assignedID.toString();
            this.localPeerId = this.group.getPeerID().toString();
            this.lastPeerAdv = this.group.getPeerAdvertisement();
            this.lastModCount = this.lastPeerAdv.getModCount();
            this.localPeerAdvStr = this.advToString(this.lastPeerAdv);
            try {
                String pgdir = this.group.getPeerGroupID().getUniqueValue().toString();
                this.cm = new Cm(pgdir, true, 3600000L, !this.localonly);
            }
            catch (Exception e) {
                if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                    LOG.error((Object)"Error during creation of local store", (Throwable)e);
                }
                throw new PeerGroupException("Error during creation of local store", e);
            }
            try {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)"publishing local advertisement");
                }
                this.publish(this.group.getPeerAdvertisement(), 0, Long.MAX_VALUE, 0x6DDD00L);
            }
            catch (Exception ignoring) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block11;
                LOG.warn((Object)"Could not publish local peer advertisement: ", (Throwable)ignoring);
            }
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            StringBuffer configInfo = new StringBuffer("Configuring Discovery Service : " + assignedID);
            configInfo.append("\n\tImplementation:");
            configInfo.append("\n\t\tImpl Description: " + this.implAdvertisement.getDescription());
            configInfo.append("\n\t\tImpl URI : " + this.implAdvertisement.getUri());
            configInfo.append("\n\t\tImpl Code : " + this.implAdvertisement.getCode());
            configInfo.append("\n\tGroup Params:");
            configInfo.append("\n\t\tGroup: " + pg.getPeerGroupName());
            configInfo.append("\n\t\tGroup ID: " + pg.getPeerGroupID());
            configInfo.append("\n\t\tPeer ID: " + pg.getPeerID());
            configInfo.append("\n\t\tlocalonly : " + this.localonly);
            LOG.info((Object)configInfo);
        }
    }

    public void flushAdvertisements(String id, int type) throws IOException {
        if (type <= 2 && id != null) {
            ID advID = IDFactory.fromURL(IDFactory.jxtaURL(id));
            String advName = advID.getUniqueValue().toString();
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("flushing adv " + advName + " of type " + this.dirname[type]));
            }
            this.cm.remove(this.dirname[type], advName);
        } else {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("flushing advertisements of type " + this.dirname[type]));
            }
            this.cm.remove(this.dirname[type], null);
        }
    }

    public void flushAdvertisement(Advertisement adv) throws IOException {
        int type = 0;
        type = adv instanceof PeerAdvertisement ? 0 : (adv instanceof PeerGroupAdvertisement ? 1 : 2);
        ID id = adv.getID();
        String advName = null;
        if (id != null && !id.equals(ID.nullID)) {
            advName = id.getUniqueValue().toString();
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("flushing adv " + advName + " of type " + this.dirname[type]));
            }
        } else {
            StructuredDocument doc;
            try {
                doc = (StructuredDocument)adv.getDocument(MimeMediaType.XMLUTF8);
            }
            catch (Exception everything) {
                throw new IOException("Advertisement couldnt be removed because of :" + everything.toString());
            }
            advName = Cm.createTmpName(doc);
        }
        if (advName != null) {
            this.cm.remove(this.dirname[type], advName);
        }
    }

    public void publish(Advertisement adv, int type) throws IOException {
        this.publish(adv, type, 31536000000L, 0x6DDD00L);
    }

    public void publish(Advertisement adv) throws IOException {
        this.publish(adv, 31536000000L, 0x6DDD00L);
    }

    public void publish(Advertisement adv, long lifetime, long expiration) throws IOException {
        int type = -1;
        type = adv instanceof PeerAdvertisement ? 0 : (adv instanceof PeerGroupAdvertisement ? 1 : 2);
        this.publish(adv, type, lifetime, expiration);
    }

    public void publish(Advertisement adv, int type, long lifetime, long expiration) throws IOException {
        ID advID = null;
        String advName = null;
        switch (type) {
            case 0: {
                if (adv instanceof PeerAdvertisement) break;
                throw new IOException("Not a peer advertisement");
            }
            case 1: {
                if (adv instanceof PeerGroupAdvertisement) break;
                throw new IOException("Not a peergroup advertisement");
            }
            case 2: {
                break;
            }
            default: {
                throw new IOException("Unknown advertisement type");
            }
        }
        advID = adv.getID();
        if (null == advID || advID.equals(ID.nullID)) {
            StructuredDocument doc;
            try {
                doc = (StructuredDocument)adv.getDocument(MimeMediaType.XMLUTF8);
            }
            catch (Exception everything) {
                if (LOG.isEnabledFor((Priority)Level.WARN)) {
                    LOG.warn((Object)"Failed to generated document from advertisement", (Throwable)everything);
                }
                throw new IOException("Failed to generated document from advertisement " + everything.toString());
            }
            advName = Cm.createTmpName(doc);
        } else {
            advName = advID.getUniqueValue().toString();
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("publishing " + advName + " in " + this.dirname[type] + " expiration :" + expiration + " lifetime :" + lifetime));
        }
        this.cm.save(this.dirname[type], advName, adv, lifetime, expiration);
    }

    public void remotePublish(Advertisement adv, int type) {
        this.remotePublish(null, adv, type, 0x6DDD00L);
    }

    public void remotePublish(Advertisement adv) {
        this.remotePublish(null, adv, 0x6DDD00L);
    }

    public void remotePublish(Advertisement adv, int type, long timeout) {
        this.remotePublish(null, this.advToString(adv), type, timeout);
    }

    public void remotePublish(Advertisement adv, long timeout) {
        this.remotePublish(null, adv, timeout);
    }

    public void remotePublish(String peerid, Advertisement adv, int type) {
        this.remotePublish(peerid, adv, type, 0x6DDD00L);
    }

    public void remotePublish(String peerid, Advertisement adv) {
        this.remotePublish(peerid, adv, 0x6DDD00L);
    }

    public void remotePublish(String peerid, Advertisement adv, int type, long timeout) {
        if (!this.localonly) {
            this.remotePublish(peerid, this.advToString(adv), type, timeout);
        }
    }

    public void remotePublish(String peerid, Advertisement adv, long timeout) {
        if (this.localonly) {
            return;
        }
        int type = -1;
        type = adv instanceof PeerAdvertisement ? 0 : (adv instanceof PeerGroupAdvertisement ? 1 : 2);
        this.remotePublish(peerid, this.advToString(adv), type, timeout);
    }

    public void processResponse(ResolverResponseMsg response) {
        DiscoveryResponse res;
        long t0 = System.currentTimeMillis();
        try {
            StructuredTextDocument asDoc = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, new StringReader(response.getResponse()));
            res = new DiscoveryResponse(asDoc);
        }
        catch (Exception e) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)"Failed to Read Deiscovery Response", (Throwable)e);
            }
            return;
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)"Processing responses");
        }
        Enumeration enumeration = res.getAdvertisements();
        Enumeration exps = res.getExpirations();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                Advertisement adv = (Advertisement)enumeration.nextElement();
                long exp = (Long)exps.nextElement();
                if (exp <= 0L || adv == null) continue;
                try {
                    this.publish(adv, exp, exp);
                }
                catch (Exception e) {
                    if (!LOG.isEnabledFor((Priority)Level.WARN)) continue;
                    LOG.warn((Object)"Error publishing Advertisement", (Throwable)e);
                }
            }
        } else if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)"Received empty responses");
        }
        DiscoveryEvent newevent = new DiscoveryEvent(this.getInterface(), res, response.getQueryId());
        DiscoveryListener dl = (DiscoveryListener)this.listenerTable.get(new Integer(response.getQueryId()));
        if (dl != null) {
            try {
                dl.discoveryEvent(new DiscoveryEvent(this.getInterface(), res, response.getQueryId()));
            }
            catch (Throwable all) {
                LOG.fatal((Object)("processResponse : Uncaught Throwable in listener :" + Thread.currentThread().getName()), all);
            }
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("processed a response :" + response.getQueryId() + " in :" + (System.currentTimeMillis() - t0)));
        }
        t0 = System.currentTimeMillis();
        DiscoveryListener[] allListeners = this.listeners.toArray(new DiscoveryListener[0]);
        int eachListener = 0;
        while (eachListener < allListeners.length) {
            block18: {
                try {
                    allListeners[eachListener].discoveryEvent(newevent);
                }
                catch (Throwable all) {
                    if (!LOG.isEnabledFor((Priority)Level.WARN)) break block18;
                    LOG.warn((Object)("processResponse : Uncaught Throwable in listener (" + allListeners[eachListener].getClass().getName() + ") :" + Thread.currentThread().getName()), all);
                }
            }
            ++eachListener;
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Called all listenters to :" + response.getQueryId() + " in :" + (System.currentTimeMillis() - t0)));
        }
    }

    public int processQuery(ResolverQueryMsg query) {
        PeerID destPeer;
        Vector res;
        int thresh;
        DiscoveryQuery dq;
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)"processQuery starts");
        }
        Vector results = null;
        Vector<Long> expirations = new Vector<Long>();
        long t0 = System.currentTimeMillis();
        try {
            StructuredTextDocument asDoc = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, new StringReader(query.getQuery()));
            dq = new DiscoveryQuery(asDoc);
        }
        catch (Exception e) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)"Malformed query : ", (Throwable)e);
            }
            return 0;
        }
        if (dq.getThreshold() < 0 || dq.getDiscoveryType() < 0 || dq.getDiscoveryType() > 2) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)"Malformed query");
            }
            return 0;
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Got a " + this.dirname[dq.getDiscoveryType()] + " query QID: " + query.getQueryId() + " query :" + dq.getAttr() + " = " + dq.getValue()));
        }
        int n = thresh = dq.getThreshold() < this.MaxResponses ? dq.getThreshold() : this.MaxResponses;
        if (dq.getDiscoveryType() == 0 && 0 == dq.getThreshold()) {
            results = new Vector();
            this.updatePeerAdvStr();
            results.addElement(this.localPeerAdvStr);
            expirations.addElement(new Long(0x6DDD00L));
            this.respond(query, dq, results, expirations);
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Responding to :" + query.getQueryId() + " in :" + (System.currentTimeMillis() - t0)));
            }
            return 0;
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("start local search query" + dq.getAttr() + " " + dq.getValue()));
        }
        results = this.search(dq.getDiscoveryType(), dq.getAttr(), dq.getValue(), thresh, true, expirations);
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("start local search pruned " + results.size()));
        }
        if (!results.isEmpty()) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Responding  to " + this.dirname[dq.getDiscoveryType()] + " Query : " + dq.getAttr() + " = " + dq.getValue()));
            }
            this.respond(query, dq, results, expirations);
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Responded to :" + query.getQueryId() + " in :" + (System.currentTimeMillis() - t0)));
            }
            return 0;
        }
        if (!this.group.isRendezvous()) {
            return 0;
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Querying SrdiIndex QID :" + query.getQueryId()));
        }
        if ((res = this.srdiIndex.query(this.dirname[dq.getDiscoveryType()], dq.getAttr(), dq.getValue(), thresh)).size() > 0) {
            this.srdi.forwardQuery(res, query, thresh);
            return 0;
        }
        if (query.getHopCount() == 0 && (destPeer = this.srdi.getReplicaPeer(this.dirname[dq.getDiscoveryType()] + dq.getAttr() + dq.getValue())) != null) {
            if (!destPeer.equals(this.group.getPeerID())) {
                this.srdi.forwardQuery(destPeer, query);
                return 0;
            }
            query.incrementHopCount();
        }
        return -1;
    }

    private void respond(ResolverQueryMsg query, DiscoveryQuery dq, Vector results, Vector expirations) {
        if (this.localonly) {
            return;
        }
        DiscoveryResponse dresponse = new DiscoveryResponse(results.size(), dq.getDiscoveryType(), null, dq.getAttr(), dq.getValue(), results, expirations);
        ResolverResponseMsg response = query.makeResponse();
        response.setCredential(this.credentialDoc);
        response.setResponse(dresponse.toString());
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Responding to " + query.getSrc()));
        }
        this.resolver.sendResponse(query.getSrc(), response);
    }

    public synchronized void addDiscoveryListener(DiscoveryListener listener) {
        this.listeners.add(listener);
    }

    public synchronized boolean removeDiscoveryListener(DiscoveryListener listener) {
        Enumeration e = this.listenerTable.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            if (this.listenerTable.get(key) != listener) continue;
            this.listenerTable.remove(key);
        }
        return this.listeners.remove(listener);
    }

    void remotePublish(String peerid, String advString, int type, long timeout) {
        DiscoveryResponse dresponse;
        block7: {
            if (this.localonly) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)"localonly, no network operations performed");
                }
                return;
            }
            if (this.resolver == null) {
                return;
            }
            Vector<String> advert = new Vector<String>(1);
            Vector<Long> expirations = new Vector<Long>(1);
            dresponse = null;
            advert.addElement(advString);
            expirations.addElement(new Long(timeout));
            try {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)"Remote publishing Group");
                }
                dresponse = new DiscoveryResponse(1, type, null, null, null, advert, expirations);
            }
            catch (Exception e) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block7;
                LOG.warn((Object)e, (Throwable)e);
            }
        }
        ResolverResponse pushRes = new ResolverResponse(this.handlerName, this.credentialDoc, 0, dresponse.toString());
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)"remote publishing");
        }
        this.resolver.sendResponse(peerid, pushRes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Vector search(int type, String attr, String value, int threshold, boolean bytes, Vector expirations) {
        Vector results = null;
        if (threshold <= 0) {
            throw new IllegalArgumentException("threshold must be greater than zero");
        }
        if (expirations != null) {
            expirations.clear();
        }
        if (attr != null) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"narrowing down the response.");
            }
            results = this.cm.search(this.dirname[type], attr, value, threshold, expirations);
        } else {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"Returning any entry");
            }
            results = this.cm.getRecords(this.dirname[type], threshold, null, expirations);
        }
        if (results.size() == 0 || bytes) {
            return results;
        }
        Vector<Advertisement> advertisements = new Vector<Advertisement>();
        int i = 0;
        while (i < results.size()) {
            block19: {
                InputStream bis = null;
                bis = (InputStream)results.elementAt(i);
                Advertisement adv = AdvertisementFactory.newAdvertisement(MimeMediaType.XMLUTF8, bis);
                advertisements.addElement(adv);
                Object var13_13 = null;
                try {
                    bis.close();
                }
                catch (IOException closeE) {
                    // empty catch block
                }
                bis = null;
                {
                    break block19;
                    catch (Exception e) {
                        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                            LOG.debug((Object)e, (Throwable)e);
                        }
                        var13_13 = null;
                        try {
                            bis.close();
                        }
                        catch (IOException closeE) {
                            // empty catch block
                        }
                        bis = null;
                    }
                }
                catch (Throwable throwable) {
                    var13_13 = null;
                    try {
                        bis.close();
                    }
                    catch (IOException closeE) {
                        // empty catch block
                    }
                    bis = null;
                    throw throwable;
                }
            }
            ++i;
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Returning " + results.size() + " advertisements"));
        }
        return advertisements;
    }

    public long getAdvExpirationTime(ID id, int type) {
        String advName = null;
        if (id != null && !id.equals(ID.nullID)) {
            advName = id.getUniqueValue().toString();
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("fattempting to getAdvExpirationTime on " + advName + " of type " + this.dirname[type]));
            }
        } else {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"attempting to getAdvExpirationTime of a NullID");
            }
            return -1L;
        }
        return this.cm.getExpirationtime(this.dirname[type], advName);
    }

    public long getAdvLifeTime(ID id, int type) {
        String advName = null;
        if (id != null && !id.equals(ID.nullID)) {
            advName = id.getUniqueValue().toString();
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("attempting to getAdvExpirationTime on " + advName + " of type " + this.dirname[type]));
            }
        } else {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"attempting to getAdvExpirationTime of a NullID");
            }
            return -1L;
        }
        return this.cm.getLifetime(this.dirname[type], advName);
    }

    public long getAdvExpirationTime(Advertisement adv) {
        int type = 0;
        type = adv instanceof PeerAdvertisement ? 0 : (adv instanceof PeerGroupAdvertisement ? 1 : 2);
        String advName = null;
        ID id = adv.getID();
        if (id != null && !id.equals(ID.nullID)) {
            advName = id.getUniqueValue().toString();
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("attempting to getAdvExpirationTime on " + advName + " of type " + this.dirname[type]));
            }
        } else {
            StructuredDocument doc;
            try {
                doc = (StructuredDocument)adv.getDocument(MimeMediaType.XMLUTF8);
            }
            catch (Exception everything) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)"Failed to get document", (Throwable)everything);
                }
                return -1L;
            }
            advName = Cm.createTmpName(doc);
        }
        return this.cm.getExpirationtime(this.dirname[type], advName);
    }

    public long getAdvLifeTime(Advertisement adv) {
        int type = 0;
        type = adv instanceof PeerAdvertisement ? 0 : (adv instanceof PeerGroupAdvertisement ? 1 : 2);
        ID id = adv.getID();
        String advName = null;
        if (id != null && !id.equals(ID.nullID)) {
            advName = id.getUniqueValue().toString();
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("attempting to getAdvLifeTime " + advName + " of type " + this.dirname[type]));
            }
        } else {
            StructuredDocument doc;
            try {
                doc = (StructuredDocument)adv.getDocument(MimeMediaType.XMLUTF8);
            }
            catch (Exception everything) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)"Failed to get document", (Throwable)everything);
                }
                return -1L;
            }
            advName = Cm.createTmpName(doc);
        }
        return this.cm.getLifetime(this.dirname[type], advName);
    }

    private String advToString(Advertisement adv) {
        try {
            return adv.toString();
        }
        catch (Exception all) {
            return null;
        }
    }

    public boolean processSrdi(ResolverSrdiMsg message) {
        SrdiMessageImpl srdiMsg;
        try {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Received a SRDI messsage in group " + this.group.getPeerGroupName()));
            }
            StructuredTextDocument asDoc = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, new StringReader(message.getPayload()));
            srdiMsg = new SrdiMessageImpl(asDoc);
        }
        catch (Exception e) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)e, (Throwable)e);
            }
            return false;
        }
        PeerID pid = srdiMsg.getPeerID();
        Vector entries = srdiMsg.getEntries();
        if (entries != null) {
            int i = 0;
            while (i < entries.size()) {
                SrdiMessage.Entry entry = (SrdiMessage.Entry)entries.elementAt(i);
                if (entry != null && entry.expiration > 0L) {
                    this.srdiIndex.add(srdiMsg.getPrimaryKey(), entry.key, entry.value, pid, entry.expiration);
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("Primary Key [" + srdiMsg.getPrimaryKey() + "] key [" + entry.key + "] value [" + entry.value + "] exp [" + entry.expiration + "]"));
                    }
                }
                ++i;
            }
            this.srdi.replicateEntries(srdiMsg);
        }
        return true;
    }

    public void messageSendFailed(PeerID peerid, OutgoingMessageEvent e) {
        if (this.srdiIndex != null) {
            this.srdiIndex.remove(peerid);
        }
    }

    public void pushEntries(boolean all) {
        this.pushSrdi(null, 0, all);
        this.pushSrdi(null, 1, all);
        this.pushSrdi(null, 2, all);
    }

    protected void pushSrdi(String peer, int type, boolean all) {
        block5: {
            Vector entries = all ? this.cm.getEntries(this.dirname[type]) : this.cm.getDeltas(this.dirname[type]);
            if (entries == null || entries.size() <= 0) break block5;
            try {
                SrdiMessageImpl srdiMsg = new SrdiMessageImpl(this.group.getPeerID(), 1, this.dirname[type], entries);
                if (srdiMsg.getEntries().size() == 0) {
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)"No Deltas to send");
                    }
                    return;
                }
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("Sending a SRDI messsage of [All=" + all + "] of type " + this.dirname[type]));
                }
                this.srdi.pushSrdi(peer, srdiMsg);
            }
            catch (Exception e) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block5;
                LOG.warn((Object)"Exception pushing SRDI Entries", (Throwable)e);
            }
        }
    }

    private static synchronized int nextQid() {
        return qid++;
    }

    private synchronized void beRendezvous() {
        if (this.isRdv && (this.srdi != null || this.srdiIndex != null)) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"Already a RDV No Switch is needed");
            }
            return;
        }
        if (this.group.getPeerGroupID().equals(PeerGroupID.worldPeerGroupID)) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"worldPeerGroup act as an edge peer only");
            }
            this.isRdv = false;
            this.isEdge = true;
            return;
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)"Switching as a Rendezvous peer, Starting SRDI");
        }
        this.isRdv = true;
        this.isEdge = false;
        if (this.srdiIndex == null) {
            this.srdiIndex = new SrdiIndex(this.group, srdiIndexerFileName);
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"srdiIndex created");
            }
        }
        if (this.srdi != null) {
            this.srdi.stop();
            if (this.srdiThread != null) {
                this.srdiThread = null;
            }
            this.srdi = null;
        }
        if (!this.localonly) {
            this.srdi = new Srdi(this.group, this.handlerName, this, this.srdiIndex, this.initialDelay, this.runInterval);
            this.resolver.registerSrdiHandler(this.handlerName, this);
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"srdi created, and registered as an srdi handler ");
            }
        }
    }

    private synchronized void beEdge() {
        if (this.isEdge && this.srdiThread != null) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"Already an Edge No Switch is needed");
            }
            return;
        }
        if (this.group.getPeerGroupID().equals(PeerGroupID.worldPeerGroupID)) {
            this.isRdv = false;
            this.isEdge = true;
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"worldPeerGroup act as an edge peer only");
            }
            return;
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)"Switching as a Edge peer");
        }
        this.isEdge = true;
        this.isRdv = false;
        if (this.srdiIndex != null) {
            this.srdiIndex.stop();
            this.srdiIndex = null;
            this.resolver.unregisterSrdiHandler(this.handlerName);
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"stopped cache and unregistered from resolver");
            }
        }
        if (this.srdi != null) {
            this.srdi.stop();
            if (this.srdiThread != null) {
                this.srdiThread = null;
            }
            this.srdi = null;
        }
        if (!this.localonly) {
            this.srdi = new Srdi(this.group, this.handlerName, this, this.srdiIndex, this.initialDelay, this.runInterval);
            this.srdiThread = new Thread(this.group.getHomeThreadGroup(), this.srdi, "Discovery Srdi Thread");
            this.srdiThread.setDaemon(true);
            this.srdiThread.start();
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"Started SRDIThread");
            }
        }
    }

    public void rendezvousEvent(RendezvousEvent event) {
        this.checkRdvStatus();
    }

    private synchronized void checkRdvStatus() {
        if (!this.started) {
            return;
        }
        if (this.group.isRendezvous()) {
            if (!this.isRdv) {
                this.beRendezvous();
            }
        } else if (!this.isEdge) {
            this.beEdge();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

