/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.document;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.UndeclaredThrowableException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.TextElement;
import net.jxta.impl.document.DOMXMLElement;
import net.jxta.impl.document.TextDocumentCommon;
import net.jxta.impl.document.XMLDocumentCommon;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DOMXMLDocument
extends DOMXMLElement
implements XMLDocumentCommon {
    public static final StructuredDocumentFactory.TextInstantiator INSTANTIATOR = new Instantiator();
    private MimeMediaType mimeType;
    static /* synthetic */ Class class$java$lang$String;

    private DOMXMLDocument(MimeMediaType mimeType, String docType, String value) {
        super(null, null);
        this.root = this;
        this.mimeType = mimeType;
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setNamespaceAware(true);
        docBuilderFactory.setValidating(false);
        try {
            DocumentBuilder dataDocBuilder = docBuilderFactory.newDocumentBuilder();
            DOMImplementation domImpl = dataDocBuilder.getDOMImplementation();
            DocumentType doctypeNode = domImpl.createDocumentType(docType, null, null);
            this.domNode = domImpl.createDocument("http://jxta.org", docType, doctypeNode);
        }
        catch (ParserConfigurationException misconfig) {
            throw new UndeclaredThrowableException(misconfig);
        }
        if (value != null) {
            Text text = ((Document)this.domNode).createTextNode(value);
            ((Document)this.domNode).getDocumentElement().appendChild(text);
        }
    }

    private DOMXMLDocument(MimeMediaType mimeType, String docType) {
        this(mimeType, docType, (String)null);
    }

    private DOMXMLDocument(MimeMediaType mimeType, InputStream stream) throws IOException {
        super(null, null);
        this.root = this;
        this.mimeType = mimeType;
        String charset = mimeType.getParameter("charset");
        InputStreamReader source = charset == null ? new InputStreamReader(stream) : new InputStreamReader(stream, charset);
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setNamespaceAware(true);
        docBuilderFactory.setValidating(false);
        try {
            DocumentBuilder dataDocBuilder = docBuilderFactory.newDocumentBuilder();
            this.domNode = dataDocBuilder.parse(new InputSource(source));
        }
        catch (ParserConfigurationException misconfig) {
            throw new UndeclaredThrowableException(misconfig);
        }
        catch (SAXException parseError) {
            throw new IOException(parseError.toString());
        }
    }

    private DOMXMLDocument(MimeMediaType mimeType, Reader source) throws IOException {
        super(null, null);
        this.root = this;
        this.mimeType = mimeType;
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setNamespaceAware(true);
        docBuilderFactory.setValidating(false);
        try {
            DocumentBuilder dataDocBuilder = docBuilderFactory.newDocumentBuilder();
            this.domNode = dataDocBuilder.parse(new InputSource(source));
        }
        catch (ParserConfigurationException misconfig) {
            throw new UndeclaredThrowableException(misconfig);
        }
        catch (SAXException parseError) {
            throw new IOException(parseError.toString());
        }
    }

    public String toString() {
        try {
            StringWriter stringOut = new StringWriter();
            this.sendToWriter(stringOut);
            stringOut.close();
            return stringOut.toString();
        }
        catch (IOException ex) {
            throw new UndeclaredThrowableException(ex);
        }
    }

    public MimeMediaType getMimeType() {
        return this.mimeType;
    }

    public String getFileExtension() {
        return TextDocumentCommon.Utils.getExtensionForMime(INSTANTIATOR.getSupportedFileExtensions(), this.getMimeType());
    }

    public InputStream getStream() throws IOException {
        String result = this.toString();
        if (null == result) {
            return null;
        }
        String charset = this.mimeType.getParameter("charset");
        if (charset == null) {
            return new ByteArrayInputStream(result.getBytes());
        }
        return new ByteArrayInputStream(result.getBytes(charset));
    }

    public void sendToStream(OutputStream stream) throws IOException {
        String charset = this.mimeType.getParameter("charset");
        OutputStreamWriter osw = charset == null ? new OutputStreamWriter(stream) : new OutputStreamWriter(stream, charset);
        BufferedWriter out = new BufferedWriter(osw);
        this.sendToWriter(out);
        ((Writer)out).flush();
        ((Writer)osw).flush();
    }

    public Reader getReader() {
        String result = this.toString();
        if (null == result) {
            return null;
        }
        return new StringReader(result);
    }

    public void sendToWriter(Writer writer) throws IOException {
        String charset = this.mimeType.getParameter("charset");
        try {
            OutputFormat format = new OutputFormat((Document)this.domNode);
            if (charset != null) {
                format.setEncoding(charset);
            }
            XMLSerializer serial = new XMLSerializer(writer, format);
            serial.asDOMSerializer();
            serial.serialize(((Document)this.domNode).getDocumentElement());
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            if (ex instanceof Error) {
                throw (Error)ex;
            }
            throw new UndeclaredThrowableException(ex);
        }
    }

    public net.jxta.document.Element createElement(Object key) {
        return this.createElement(key, null);
    }

    public net.jxta.document.Element createElement(Object key, Object val) {
        if (!(class$java$lang$String == null ? (class$java$lang$String = DOMXMLDocument.class$("java.lang.String")) : class$java$lang$String).isAssignableFrom(key.getClass())) {
            throw new ClassCastException(key.getClass().getName() + " not supported by createElement.");
        }
        if (null != val && !(class$java$lang$String == null ? (class$java$lang$String = DOMXMLDocument.class$("java.lang.String")) : class$java$lang$String).isAssignableFrom(val.getClass())) {
            throw new ClassCastException(val.getClass().getName() + " not supported by createElement.");
        }
        return this.createElement((String)key, (String)val);
    }

    public TextElement createElement(String name) {
        return new DOMXMLElement(this, ((Document)this.domNode).createElement(name));
    }

    public TextElement createElement(String name, String value) {
        Element root = ((Document)this.domNode).createElement(name);
        if (null != value) {
            root.appendChild(((Document)this.domNode).createTextNode(value));
        }
        return new DOMXMLElement(this, root);
    }

    protected Node getAssocNode() {
        return ((Document)this.domNode).getDocumentElement();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class Instantiator
    implements StructuredDocumentFactory.TextInstantiator {
        private static final MimeMediaType[] myTypes = new MimeMediaType[]{MimeMediaType.XML_DEFAULTENCODING, new MimeMediaType("Application", "Xml")};
        private static final StructuredDocumentFactory.Instantiator.ExtensionMapping[] myExtensions = new StructuredDocumentFactory.Instantiator.ExtensionMapping[]{new StructuredDocumentFactory.Instantiator.ExtensionMapping("xml", myTypes[0]), new StructuredDocumentFactory.Instantiator.ExtensionMapping("xml", null)};

        public MimeMediaType[] getSupportedMimeTypes() {
            return myTypes;
        }

        public StructuredDocumentFactory.Instantiator.ExtensionMapping[] getSupportedFileExtensions() {
            return myExtensions;
        }

        public StructuredDocument newInstance(MimeMediaType mimeType, String doctype) {
            return new DOMXMLDocument(mimeType, doctype);
        }

        public StructuredDocument newInstance(MimeMediaType mimeType, String doctype, String value) {
            return new DOMXMLDocument(mimeType, doctype, value);
        }

        public StructuredDocument newInstance(MimeMediaType mimeType, InputStream source) throws IOException {
            return new DOMXMLDocument(mimeType, source);
        }

        public StructuredDocument newInstance(MimeMediaType mimeType, Reader source) throws IOException {
            return new DOMXMLDocument(mimeType, source);
        }
    }
}

