/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.document;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.UndeclaredThrowableException;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.TextElement;
import net.jxta.impl.document.LiteXMLElement;
import net.jxta.impl.document.TextDocumentCommon;
import net.jxta.impl.document.XMLDocumentCommon;

public class LiteXMLDocument
extends LiteXMLElement
implements XMLDocumentCommon {
    public static final StructuredDocumentFactory.TextInstantiator INSTANTIATOR = new Instantiator();
    StringBuffer docContent = null;
    private MimeMediaType mimeType = null;
    static /* synthetic */ Class class$java$lang$String;

    LiteXMLDocument(MimeMediaType mimeType, String type) {
        this(mimeType, type, "");
    }

    LiteXMLDocument(MimeMediaType mimeType, String type, String textValue) {
        super(null, (LiteXMLElement.tagRange)null);
        if (null == textValue) {
            textValue = "";
        }
        StringBuffer seedDoc = new StringBuffer(textValue.length() + 3 * type.length() + 128);
        seedDoc.append("<?xml version=\"1.0\"");
        String charset = mimeType.getParameter("charset");
        if (charset != null) {
            seedDoc.append(" encoding=\"");
            seedDoc.append(charset);
            seedDoc.append("\"");
        }
        seedDoc.append("?>\n");
        seedDoc.append("<!DOCTYPE ");
        seedDoc.append(type);
        seedDoc.append(">\n");
        seedDoc.append('<');
        seedDoc.append(type);
        seedDoc.append('>');
        seedDoc.append(textValue);
        seedDoc.append("</");
        seedDoc.append(type);
        seedDoc.append('>');
        try {
            this.init(mimeType, new StringReader(seedDoc.toString()));
        }
        catch (IOException caught) {
            throw new UndeclaredThrowableException(caught);
        }
    }

    LiteXMLDocument(MimeMediaType mimeType, InputStream in) throws IOException {
        super(null, (LiteXMLElement.tagRange)null);
        String charset = mimeType.getParameter("charset");
        if (charset == null) {
            this.init(mimeType, new InputStreamReader(in));
        } else {
            this.init(mimeType, new InputStreamReader(in, charset));
        }
    }

    LiteXMLDocument(MimeMediaType mimeType, Reader in) throws IOException {
        super(null, (LiteXMLElement.tagRange)null);
        this.init(mimeType, in);
    }

    public String toString() {
        try {
            StringWriter stringOut = new StringWriter();
            this.sendToWriter(stringOut);
            stringOut.close();
            return stringOut.toString();
        }
        catch (IOException caught) {
            throw new UndeclaredThrowableException(caught);
        }
    }

    public MimeMediaType getMimeType() {
        return this.mimeType;
    }

    public String getFileExtension() {
        return TextDocumentCommon.Utils.getExtensionForMime(INSTANTIATOR.getSupportedFileExtensions(), this.getMimeType());
    }

    public Element createElement(Object key) {
        return this.createElement(key, null);
    }

    public Element createElement(Object key, Object val) {
        if (!(class$java$lang$String == null ? (class$java$lang$String = LiteXMLDocument.class$("java.lang.String")) : class$java$lang$String).isAssignableFrom(key.getClass())) {
            throw new ClassCastException(key.getClass().getName() + " not supported by createElement as key.");
        }
        if (null != val && !(class$java$lang$String == null ? (class$java$lang$String = LiteXMLDocument.class$("java.lang.String")) : class$java$lang$String).isAssignableFrom(val.getClass())) {
            throw new ClassCastException(val.getClass().getName() + " not supported by createElement as value.");
        }
        return this.createElement((String)key, (String)val);
    }

    public TextElement createElement(String name) {
        return new LiteXMLElement(this, name);
    }

    public TextElement createElement(String name, String val) {
        return new LiteXMLElement(this, name, val);
    }

    protected TextElement createElement(LiteXMLElement.tagRange loc) {
        return new LiteXMLElement(this, loc);
    }

    public Reader getReader() {
        return new StringReader(this.toString());
    }

    public InputStream getStream() throws IOException {
        String charset = this.mimeType.getParameter("charset");
        if (charset == null) {
            return new ByteArrayInputStream(this.toString().getBytes());
        }
        return new ByteArrayInputStream(this.toString().getBytes(charset));
    }

    public void sendToWriter(Writer stream) throws IOException {
        String charset = this.mimeType.getParameter("charset");
        if (charset == null) {
            stream.write("<?xml version=\"1.0\"?>\n");
        } else {
            stream.write("<?xml version=\"1.0\" encoding=\"" + charset + "\"?>\n");
        }
        LiteXMLElement.charRange result = this.getDocType(this.docContent, true);
        if (result.isValid()) {
            stream.write(this.docContent.substring(result.start, result.end + 1));
            stream.write(10);
        }
        this.printNice(stream, 0, true);
    }

    public void sendToStream(OutputStream stream) throws IOException {
        String charset = this.mimeType.getParameter("charset");
        OutputStreamWriter osw = charset == null ? new OutputStreamWriter(stream) : new OutputStreamWriter(stream, charset);
        BufferedWriter out = new BufferedWriter(osw);
        this.sendToWriter(out);
        ((Writer)out).flush();
    }

    protected void init(MimeMediaType mimeType, Reader in) throws IOException {
        int readCount;
        this.loc = new LiteXMLElement.tagRange();
        this.doc = this;
        this.parent = this;
        this.mimeType = mimeType;
        this.docContent = new StringBuffer();
        char[] smallBuffer = new char[512];
        while ((readCount = in.read(smallBuffer)) >= 0) {
            if (readCount <= 0) continue;
            this.docContent.append(smallBuffer, 0, readCount);
        }
        this.loc.startTag.start = 0;
        this.loc.startTag.end = this.docContent.indexOf(">");
        this.loc.body.start = this.loc.startTag.end + 1;
        this.loc.endTag.start = this.loc.body.end = this.docContent.length() - 1;
        this.loc.endTag.end = this.loc.body.end;
        LiteXMLElement.charRange docType = this.getDocType(this.doc.docContent, false);
        this.loc = docType.isValid() ? this.getTagRanges(this.doc.docContent, this.docContent.substring(docType.start, docType.end + 1), this.loc.body) : this.getTagRanges(this.doc.docContent, null, this.loc.body);
        if (!this.loc.isValid()) {
            throw new RuntimeException("Parsing error in source document. could not find end of document");
        }
        this.addChildTags(this.loc.body, this);
    }

    protected LiteXMLElement.charRange getDocType(StringBuffer source, boolean wholeElement) {
        String xmldoctype = "!DOCTYPE";
        LiteXMLElement.charRange result = new LiteXMLElement.charRange();
        int start = 0;
        int end = this.doc.docContent.length() - 1;
        LiteXMLElement.tagRange ranges = this.getTagRanges(source, "!DOCTYPE", new LiteXMLElement.charRange(start, end));
        if (-1 == start) {
            return result;
        }
        if (!ranges.startTag.isValid()) {
            return result;
        }
        if (wholeElement) {
            result = ranges.startTag;
        } else {
            result.start = ranges.startTag.start + 1 + "!DOCTYPE".length() - 1 + 1;
            while (result.start < end && -1 != " \t\n\r".indexOf(source.charAt(result.start))) {
                ++result.start;
            }
            result.end = result.start;
            while (result.end + 1 < end && -1 == " \t\n\r/>".indexOf(source.charAt(result.end + 1))) {
                ++result.end;
            }
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Instantiator
    implements StructuredDocumentFactory.TextInstantiator {
        private static final MimeMediaType[] myTypes = new MimeMediaType[]{MimeMediaType.XML_DEFAULTENCODING, new MimeMediaType("Text", "x-Xml"), new MimeMediaType("Application", "Xml"), new MimeMediaType("Application", "x-Xml")};
        private static final StructuredDocumentFactory.Instantiator.ExtensionMapping[] myExtensions = new StructuredDocumentFactory.Instantiator.ExtensionMapping[]{new StructuredDocumentFactory.Instantiator.ExtensionMapping("xml", myTypes[0]), new StructuredDocumentFactory.Instantiator.ExtensionMapping("xml", null)};

        public MimeMediaType[] getSupportedMimeTypes() {
            return myTypes;
        }

        public StructuredDocumentFactory.Instantiator.ExtensionMapping[] getSupportedFileExtensions() {
            return myExtensions;
        }

        public StructuredDocument newInstance(MimeMediaType mimeType, String doctype) {
            return new LiteXMLDocument(mimeType, doctype);
        }

        public StructuredDocument newInstance(MimeMediaType mimeType, String doctype, String value) {
            return new LiteXMLDocument(mimeType, doctype, value);
        }

        public StructuredDocument newInstance(MimeMediaType mimeType, InputStream source) throws IOException {
            return new LiteXMLDocument(mimeType, source);
        }

        public StructuredDocument newInstance(MimeMediaType mimeType, Reader source) throws IOException {
            return new LiteXMLDocument(mimeType, source);
        }
    }
}

