/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.document;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.security.ProviderException;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.TextElement;
import net.jxta.impl.document.PlainTextElement;
import net.jxta.impl.document.TextDocumentCommon;

public class PlainTextDocument
extends PlainTextElement
implements TextDocumentCommon {
    public static final StructuredDocumentFactory.TextInstantiator INSTANTIATOR = new Instantiator();
    private MimeMediaType mimeType = null;
    static /* synthetic */ Class class$java$lang$String;

    public PlainTextDocument(MimeMediaType mimeType, String type) {
        super(null, type);
        this.doc = this;
        this.parent = this;
        this.mimeType = mimeType;
    }

    public PlainTextDocument(MimeMediaType mimeType, String type, String value) {
        super(null, type, value);
        this.doc = this;
        this.parent = this;
        this.mimeType = mimeType;
    }

    public String toString() {
        StringWriter stringOut = new StringWriter();
        try {
            this.printNice(stringOut, 0, true);
            stringOut.close();
        }
        catch (IOException caught) {
            return null;
        }
        return stringOut.toString();
    }

    public MimeMediaType getMimeType() {
        return this.mimeType;
    }

    public String getFileExtension() {
        return TextDocumentCommon.Utils.getExtensionForMime(INSTANTIATOR.getSupportedFileExtensions(), this.getMimeType());
    }

    public Element createElement(Object key) {
        return this.createElement(key, null);
    }

    public Element createElement(Object key, Object val) {
        if (!(class$java$lang$String == null ? (class$java$lang$String = PlainTextDocument.class$("java.lang.String")) : class$java$lang$String).isAssignableFrom(key.getClass())) {
            throw new ClassCastException(key.getClass().getName() + " not supported by createElement.");
        }
        if (null != val && !(class$java$lang$String == null ? (class$java$lang$String = PlainTextDocument.class$("java.lang.String")) : class$java$lang$String).isAssignableFrom(val.getClass())) {
            throw new ClassCastException(val.getClass().getName() + " not supported by createElement.");
        }
        return new PlainTextElement(this, (String)key, (String)val);
    }

    public TextElement createElement(String name) {
        return new PlainTextElement(this, name);
    }

    public TextElement createElement(String name, String val) {
        return new PlainTextElement(this, name, val);
    }

    public InputStream getStream() throws IOException {
        String charset = this.mimeType.getParameter("charset");
        if (charset == null) {
            return new ByteArrayInputStream(this.toString().getBytes());
        }
        return new ByteArrayInputStream(this.toString().getBytes(charset));
    }

    public void sendToStream(OutputStream stream) throws IOException {
        String charset = this.mimeType.getParameter("charset");
        OutputStreamWriter osw = charset == null ? new OutputStreamWriter(stream) : new OutputStreamWriter(stream, charset);
        BufferedWriter out = new BufferedWriter(osw);
        this.sendToWriter(out);
        ((Writer)out).flush();
    }

    public Reader getReader() {
        return new StringReader(this.toString());
    }

    public void sendToWriter(Writer stream) throws IOException {
        this.printNice(stream, 0, true);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class Instantiator
    implements StructuredDocumentFactory.TextInstantiator {
        private static final MimeMediaType[] myTypes = new MimeMediaType[]{MimeMediaType.TEXT_DEFAULTENCODING};
        private static final StructuredDocumentFactory.Instantiator.ExtensionMapping[] myExtensions = new StructuredDocumentFactory.Instantiator.ExtensionMapping[]{new StructuredDocumentFactory.Instantiator.ExtensionMapping("txt", myTypes[0]), new StructuredDocumentFactory.Instantiator.ExtensionMapping("text", myTypes[0]), new StructuredDocumentFactory.Instantiator.ExtensionMapping("txt", null)};

        public MimeMediaType[] getSupportedMimeTypes() {
            return myTypes;
        }

        public StructuredDocumentFactory.Instantiator.ExtensionMapping[] getSupportedFileExtensions() {
            return myExtensions;
        }

        public StructuredDocument newInstance(MimeMediaType mimeType, String doctype) {
            return new PlainTextDocument(mimeType, doctype);
        }

        public StructuredDocument newInstance(MimeMediaType mimeType, String doctype, String value) {
            return new PlainTextDocument(mimeType, doctype, value);
        }

        public StructuredDocument newInstance(MimeMediaType mimeType, InputStream source) throws IOException {
            throw new ProviderException("PlainTextDocument does not support input");
        }

        public StructuredDocument newInstance(MimeMediaType mimeType, Reader source) throws IOException {
            throw new ProviderException("PlainTextDocument does not support input");
        }
    }
}

