/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.UndeclaredThrowableException;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.Messenger;
import net.jxta.endpoint.OutgoingMessageEvent;
import net.jxta.endpoint.OutgoingMessageEventListener;
import net.jxta.impl.endpoint.BlockingMessenger;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class AdaptorBlockingMessenger
extends BlockingMessenger {
    private static final Logger LOG = Logger.getLogger((String)(class$net$jxta$impl$endpoint$AdaptorBlockingMessenger == null ? (class$net$jxta$impl$endpoint$AdaptorBlockingMessenger = AdaptorBlockingMessenger.class$("net.jxta.impl.endpoint.AdaptorBlockingMessenger")) : class$net$jxta$impl$endpoint$AdaptorBlockingMessenger).getName());
    private Messenger wrapped;
    static /* synthetic */ Class class$net$jxta$impl$endpoint$AdaptorBlockingMessenger;

    public static Messenger newBlockingMessenger(Messenger wrapped) {
        if (wrapped.isSynchronous()) {
            return wrapped;
        }
        return new AdaptorBlockingMessenger(wrapped);
    }

    public AdaptorBlockingMessenger(Messenger wrapped) {
        super(wrapped.getDestinationAddress());
        this.wrapped = wrapped;
    }

    public void close() {
        this.wrapped.close();
    }

    public EndpointAddress getLogicalDestinationAddress() {
        return this.wrapped.getLogicalDestinationAddress();
    }

    public boolean isClosed() {
        return this.wrapped.isClosed();
    }

    public boolean isIdle() {
        return this.wrapped.isIdle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendMessage(Message msg, String destService, String destServiceParam) throws IOException {
        LocalOutgoingMsgListener localListener = new LocalOutgoingMsgListener();
        try {
            LocalOutgoingMsgListener localOutgoingMsgListener = localListener;
            synchronized (localOutgoingMsgListener) {
                this.wrapped.sendMessage(msg, destService, destServiceParam, localListener);
                while (null == localListener.saveEvent) {
                    localListener.wait(500L);
                }
            }
        }
        catch (InterruptedException woken) {
            Thread.interrupted();
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)"Was interrupted during message send. Send state unknown.");
            }
            throw new InterruptedIOException("Was interrupted during message send. Send state unknown.");
        }
        if (null == localListener.saveEvent) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)"Send completed without success or failure...");
            }
            throw new IllegalStateException("Send completed without success or failure...");
        }
        if (localListener.failed) {
            Throwable failure = localListener.saveEvent.getFailure();
            if (null == failure) {
                if (LOG.isEnabledFor((Priority)Level.WARN)) {
                    LOG.warn((Object)"Message could not be queued for sending");
                }
                return false;
            }
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)"Message send failed due to ", failure);
            }
            if (failure instanceof IOException) {
                throw (IOException)failure;
            }
            if (failure instanceof RuntimeException) {
                throw (RuntimeException)failure;
            }
            if (failure instanceof Error) {
                throw (Error)failure;
            }
            throw new UndeclaredThrowableException(failure);
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class LocalOutgoingMsgListener
    implements OutgoingMessageEventListener {
        volatile boolean failed = false;
        volatile OutgoingMessageEvent saveEvent;

        private LocalOutgoingMsgListener() {
        }

        public synchronized void messageSendFailed(OutgoingMessageEvent event) {
            this.saveEvent = event;
            this.failed = true;
            this.notify();
        }

        public synchronized void messageSendSucceeded(OutgoingMessageEvent event) {
            this.saveEvent = event;
            this.notify();
        }
    }
}

