/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint;

import java.io.IOException;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.Messenger;
import net.jxta.endpoint.OutgoingMessageEvent;
import net.jxta.endpoint.OutgoingMessageEventListener;
import net.jxta.impl.endpoint.AdaptorBlockingMessenger;
import net.jxta.impl.endpoint.IllegalTransportLoopException;
import net.jxta.impl.endpoint.NonBlockingMessenger;
import net.jxta.impl.endpoint.endpointMeter.OutboundMeter;
import net.jxta.impl.protocol.ResolverQuery;
import net.jxta.impl.rendezvous.RendezVousPropagateMessage;
import net.jxta.impl.util.UnbiasedQueue;
import net.jxta.peergroup.PeerGroupID;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class AdaptorNonBlockingMessenger
extends NonBlockingMessenger
implements Runnable {
    private static final Logger LOG = Logger.getLogger((String)(class$net$jxta$impl$endpoint$AdaptorNonBlockingMessenger == null ? (class$net$jxta$impl$endpoint$AdaptorNonBlockingMessenger = AdaptorNonBlockingMessenger.class$("net.jxta.impl.endpoint.AdaptorNonBlockingMessenger")) : class$net$jxta$impl$endpoint$AdaptorNonBlockingMessenger).getName());
    protected static final long THREAD_IDLE_DIE = 4000L;
    private Messenger wrapped;
    private boolean resolved = false;
    private static final ThreadGroup myThreadGroup = new ThreadGroup("Adaptor Non Blocking Messengers");
    private UnbiasedQueue queue = null;
    private Thread sendThread = null;
    private String defaultServiceName;
    private String defaultServiceParam;
    private EndpointAddress logicalDestAddress;
    private OutboundMeter messengerMeter;
    static /* synthetic */ Class class$net$jxta$impl$endpoint$AdaptorNonBlockingMessenger;

    public static Messenger newNonBlockingMessenger(Messenger wrapped) {
        if (!wrapped.isSynchronous()) {
            return wrapped;
        }
        return new AdaptorBlockingMessenger(wrapped);
    }

    public AdaptorNonBlockingMessenger(Messenger wrapped, int qsize) {
        super(wrapped.getDestinationAddress());
        this.wrapped = wrapped;
        this.queue = UnbiasedQueue.synchronizedQueue(new UnbiasedQueue(qsize, false));
        this.resolved = true;
    }

    protected AdaptorNonBlockingMessenger(EndpointAddress dest, EndpointAddress logicalDest, int qsize, OutboundMeter messengerMeter) {
        super(dest);
        this.defaultServiceName = dest.getServiceName();
        this.defaultServiceParam = dest.getServiceParameter();
        this.messengerMeter = messengerMeter;
        if (logicalDest == null) {
            this.logicalDestAddress = dest;
        } else {
            this.logicalDestAddress = logicalDest;
            this.resolved = true;
        }
        this.wrapped = null;
        this.queue = UnbiasedQueue.synchronizedQueue(new UnbiasedQueue(qsize, false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Messenger toClose = null;
        AdaptorNonBlockingMessenger adaptorNonBlockingMessenger = this;
        synchronized (adaptorNonBlockingMessenger) {
            if (super.isClosed()) {
                return;
            }
            this.queue.close();
            super.close();
            if (this.sendThread != null) {
                return;
            }
            toClose = this.wrapped;
            this.wrapped = null;
        }
        if (toClose != null) {
            toClose.close();
        }
    }

    public EndpointAddress getLogicalDestinationAddress() {
        return this.wrapped == null ? (EndpointAddress)this.logicalDestAddress.clone() : this.wrapped.getLogicalDestinationAddress();
    }

    public synchronized boolean isClosed() {
        return super.isClosed();
    }

    public boolean isIdle() {
        return this.wrapped == null ? super.isIdle() : this.wrapped.isIdle();
    }

    private String getOriginatorPid(Message msg) {
        try {
            String uniqueStr = PeerGroupID.defaultNetPeerGroupID.getUniqueValue().toString();
            String outQueName = uniqueStr + "ORes";
            MessageElement el = msg.getMessageElement("jxta", outQueName);
            if (el != null) {
                ResolverQuery query = new ResolverQuery(el.getStream());
                return query.getSrc();
            }
            String headerName = "RendezVousPropagate" + uniqueStr;
            el = msg.getMessageElement("jxta", headerName);
            if (el != null) {
                RendezVousPropagateMessage propHdr = new RendezVousPropagateMessage(el.getStream());
                return (String)propHdr.getPath().firstElement();
            }
        }
        catch (Exception ee) {}
        return "<not available>";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(Message msg, String destService, String destServiceParam, OutgoingMessageEventListener listener) {
        if (this.isClosed()) {
            IOException failure = new IOException("Messenger was closed, it cannot be used to send messages.");
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)failure, (Throwable)failure);
            }
            if (null != listener) {
                OutgoingMessageEvent notice = new OutgoingMessageEvent(msg, failure);
                listener.messageSendFailed(notice);
            }
            return;
        }
        if (destService == null) {
            destService = this.defaultServiceName;
        }
        if (destServiceParam == null) {
            destServiceParam = this.defaultServiceParam;
        }
        boolean pushed = false;
        AdaptorNonBlockingMessenger adaptorNonBlockingMessenger = this;
        synchronized (adaptorNonBlockingMessenger) {
            try {
                pushed = this.queue.push(new WaitingMessage(msg, destService, destServiceParam, listener), -1L);
            }
            catch (InterruptedException woken) {
                Thread.interrupted();
            }
            if (pushed) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("pushed " + msg));
                }
                if (this.sendThread == null) {
                    this.sendThread = new Thread(myThreadGroup, this, "AdaptorNonBlockingMessenger for " + this.getDestinationAddress());
                    this.sendThread.setDaemon(true);
                    this.sendThread.start();
                }
            }
        }
        if (!pushed) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)("Failed to enqueue " + msg + " to " + this.getDestinationAddress() + " actually from " + this.getOriginatorPid(msg)));
            }
            if (null != listener) {
                OutgoingMessageEvent notice = new OutgoingMessageEvent(msg, null);
                listener.messageSendFailed(notice);
            }
            return;
        }
        Thread.yield();
    }

    protected Messenger getWrapped() {
        return this.wrapped;
    }

    protected void releaseWrapped(Messenger m) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void run() {
        long dequeueTime = 0L;
        boolean noMoreMessengers = false;
        while (true) {
            WaitingMessage sending = null;
            try {
                Messenger wm;
                try {
                    sending = (WaitingMessage)this.queue.pop(4000L);
                }
                catch (InterruptedException woken) {
                    Thread.interrupted();
                }
                if (sending == null) {
                    AdaptorNonBlockingMessenger woken = this;
                    synchronized (woken) {
                        sending = (WaitingMessage)this.queue.pop();
                        if (sending == null) {
                            this.sendThread = null;
                            break;
                        }
                    }
                }
                OutgoingMessageEvent ev = null;
                LocalOutgoingListener localListener = new LocalOutgoingListener();
                while (!noMoreMessengers && (wm = this.getWrapped()) != null) {
                    void var7_9;
                    if (!this.resolved) {
                        this.logicalDestAddress = var7_9.getLogicalDestinationAddress();
                        this.resolved = true;
                    } else if (!this.logicalDestAddress.equals(var7_9.getLogicalDestinationAddress())) {
                        if (LOG.isEnabledFor((Priority)Level.WARN)) {
                            LOG.warn((Object)("Remote Peer ID was: " + this.logicalDestAddress + " and is now: " + var7_9.getLogicalDestinationAddress()));
                        }
                        var7_9.close();
                        wm = null;
                        break;
                    }
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("Sending " + sending.message + " to " + this.getDestinationAddress()));
                    }
                    localListener.reset();
                    wm.sendMessage(sending.message, sending.service, sending.serviceParam, localListener);
                    ev = localListener.waitEvent();
                    this.releaseWrapped(wm);
                    if (ev.getFailure() == null) break;
                    if (ev.getFailure() instanceof IllegalTransportLoopException) {
                        this.close();
                        noMoreMessengers = true;
                        this.wrapped = null;
                        break;
                    }
                    if (ev.getFailure() instanceof RuntimeException) break;
                    if (this.wrapped == null) continue;
                    this.close();
                    this.wrapped = null;
                }
                if (ev == null) {
                    this.close();
                    noMoreMessengers = true;
                    IOException failure = new IOException("Could not get wrapped messenger for : " + this.getDestinationAddress());
                    if (LOG.isEnabledFor((Priority)Level.INFO)) {
                        LOG.info((Object)failure);
                    }
                    ev = new OutgoingMessageEvent(sending.message, failure);
                    localListener.messageSendFailed(ev);
                }
                if (sending.listener != null) {
                    if (localListener.failed) {
                        sending.listener.messageSendFailed(ev);
                    } else {
                        sending.listener.messageSendSucceeded(ev);
                    }
                }
                sending = null;
            }
            catch (Throwable all) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) continue;
                LOG.warn((Object)("Uncaught Throwable in thread :" + Thread.currentThread().getName()), all);
            }
        }
        if (this.isClosed() && this.wrapped != null) {
            this.wrapped.close();
            this.wrapped = null;
        }
        if (LOG.isEnabledFor((Priority)Level.INFO)) {
            LOG.info((Object)("Thread exit " + Thread.currentThread().getName() + "\n\tqueue closed : " + this.queue.isClosed() + "\tnumber in queue : " + this.queue.getCurrentInQueue() + "\tnumber queued : " + this.queue.getNumEnqueued() + "\tnumber dequeued : " + this.queue.getNumDequeued()));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class LocalOutgoingListener
    implements OutgoingMessageEventListener {
        volatile boolean failed = false;
        volatile OutgoingMessageEvent event = null;

        private LocalOutgoingListener() {
        }

        public synchronized void messageSendFailed(OutgoingMessageEvent event) {
            this.event = event;
            this.failed = true;
            this.notifyAll();
        }

        public synchronized void messageSendSucceeded(OutgoingMessageEvent event) {
            this.event = event;
            this.notifyAll();
        }

        synchronized void reset() {
            this.event = null;
            this.failed = false;
        }

        synchronized OutgoingMessageEvent waitEvent() {
            while (this.event == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException i) {
                    Thread.interrupted();
                }
            }
            return this.event;
        }
    }

    private static class WaitingMessage {
        Message message;
        String service;
        String serviceParam;
        long timeAddedToQueue;
        OutgoingMessageEventListener listener;

        public WaitingMessage(Message message, String service, String serviceParam, OutgoingMessageEventListener listener) {
            this.message = message;
            this.service = service;
            this.serviceParam = serviceParam;
            this.listener = listener;
        }
    }
}

